/*:
 * @plugindesc 离线翻译插件
 * @author biyifeifei
 *
 * @param Enable Translation
 * @desc 是否启用翻译
 * @type boolean
 * @default true
 *
 * @param Current Language
 * @desc 当前语言
 * @type select
 * @option 中文
 * @value cn
 * @option 英语
 * @value en
 * @option 日语
 * @value jp
 * @default cn
 *
 * @help
 * 这是一个离线翻译插件，你可以在插件管理器中配置它。
 */

var gl_translate;

(function() {
    
    var enableTranslation = true;
    // 定义翻译函数
    function translate(text) {
		 if(text == "游戏结束"){
			 text = "{游戏结束}"
		 }
		 if(text == "读档"){
			 text = "{读档}"
		 }
		 try{
			var replaceMap = {};
			var startIdx = text.indexOf('{');
			while (startIdx !== -1) {
				var endIdx = text.indexOf('}', startIdx);
				if (endIdx === -1) break;
				var key = text.substring(startIdx + 1, endIdx);
				var currentLanguageMap = languageMap[GL_LANGUAGE];
				if (currentLanguageMap && currentLanguageMap[key]) {
					//console.log("matched "+text + " ,"+currentLanguageMap[key]);
					//text = text.replace('{' + key + '}', currentLanguageMap[key]);
					replaceMap['{' + key + '}']= currentLanguageMap[key];
				}
//\i[5]
				startIdx = text.indexOf('{', endIdx);
			}
			for (var key in replaceMap) {
				var index = text.indexOf(key);
				while(index != -1){
					text = text.replace(key, replaceMap[key]);
					index = text.indexOf(key);
				}
			}
		}catch(e){}
        return text;
    }

	gl_translate = translate;

    // 保存原始的drawText函数
    var originalDrawText = Window_Base.prototype.drawText;

    // 覆盖drawText函数
    Window_Base.prototype.drawText = function(text, x, y, maxWidth, align) {
        // 如果开关打开，就进行翻译
        if (enableTranslation) {
            text = translate(text);
        }
        // 调用原始的drawText函数
        originalDrawText.call(this, text, x, y, maxWidth, align);
    };

    // 保存原始的addCommand函数
    var originalAddCommand = Window_Command.prototype.addCommand;

    // 覆盖addCommand函数
    Window_Command.prototype.addCommand = function(name, symbol, enabled, ext) {
        // 如果开关打开，就进行翻译
        if (enableTranslation) {
            name = translate(name);
        }
        // 调用原始的addCommand函数
        originalAddCommand.call(this, name, symbol, enabled, ext);
    };
	
	// 保存原始的convertEscapeCharacters函数
    var originalConvertEscapeCharacters = Window_Message.prototype.convertEscapeCharacters;

    // 覆盖convertEscapeCharacters函数
    Window_Message.prototype.convertEscapeCharacters = function(text) {
        // 先调用原始的convertEscapeCharacters函数处理转义字符
        text = originalConvertEscapeCharacters.call(this, text);
        // 如果开关打开，就进行翻译
        if (enableTranslation) {
            text = translate(text);
        }
        return text;
    };
	
	var originalStart = Scene_Boot.prototype.start;
    Scene_Boot.prototype.start = function() {
        originalStart.call(this);
        if (enableTranslation) {
            translateAllItemNotes();
        }
    };
	 // 定义翻译所有道具note字段的函数
    function translateAllItemNotes() {
		console.log("metea oookk");
        $dataItems.forEach(function(item) {
            if (item && item.meta["SG説明"]) {
                //item.note = translate(item.note);
				
				item.meta["SG説明"] = translate(item.meta["SG説明"]);
            }
        });
    }	
	
	    // 保存原始的DataManager.onLoad函数
    var originalOnLoad = DataManager.onLoad;

    // 覆盖DataManager.onLoad函数
    DataManager.onLoad = function(object) {
        originalOnLoad.call(this, object);

        // 如果开关打开，就进行翻译
        if (enableTranslation && object === $dataItems) {
            translateAllItemNotes();
        }
    };

    // 定义翻译所有道具note字段的函数
    function translateAllItemNotes() {
        $dataItems.forEach(function(item) {
            if (item && item.note) {
                item.note = translate(item.note);
            }
        });
    }
	
	Window_Status.prototype.drawExpInfo = function(x, y) {
		var lineHeight = this.lineHeight();
		var expTotal = gl_translate(TextManager.expTotal).format(TextManager.exp);
		var expNext = gl_translate(TextManager.expNext).format(TextManager.level);
		var value1 = this._actor.currentExp();
		var value2 = this._actor.nextRequiredExp();
		if (this._actor.isMaxLevel()) {
			value1 = '-------';
			value2 = '-------';
		}
		this.changeTextColor(this.systemColor());
		this.drawText(expTotal , x, y + lineHeight * 0, 270);
		this.drawText(expNext, x, y + lineHeight * 2, 270);
		this.resetTextColor();
		this.drawText(value1, x, y + lineHeight * 1, 270, 'right');
		this.drawText(value2, x, y + lineHeight * 3, 270, 'right');
	};
	
	Scene_Save.prototype.helpWindowText = function() {
		return gl_translate(TextManager.saveMessage);
	};
	
	Scene_Load.prototype.helpWindowText = function() {
		return gl_translate(TextManager.loadMessage);
	};
	
	//队伍提示
	Game_Party.prototype.name = function() {
		var numBattleMembers = this.battleMembers().length;
		if (numBattleMembers === 0) {
			return '';
		} else if (numBattleMembers === 1) {
			return this.leader().name();
		} else {
			return gl_translate(TextManager.partyName).format(this.leader().name());
		}
	};
	
	//出现提示
	BattleManager.displayStartMessages = function() {
		$gameTroop.enemyNames().forEach(function(name) {
			$gameMessage.add(gl_translate(TextManager.emerge).format(name));
		});
		if (this._preemptive) {
			$gameMessage.add(gl_translate(TextManager.preemptive).format($gameParty.name()));
		} else if (this._surprise) {
			$gameMessage.add(gl_translate(TextManager.surprise).format($gameParty.name()));
		}
	};
	
	
	BattleManager.displayEscapeSuccessMessage = function() {
		$gameMessage.add(gl_translate(TextManager.escapeStart).format($gameParty.name()));
	};

	BattleManager.displayEscapeFailureMessage = function() {
		$gameMessage.add(gl_translate(TextManager.escapeStart).format($gameParty.name()));
		$gameMessage.add('\\.' + gl_translate(TextManager.escapeFailure));
	};

	BattleManager.displayVictoryMessage = function() {
		$gameMessage.add(gl_translate(TextManager.victory).format($gameParty.name()));
	};
	
	BattleManager.displayDefeatMessage = function() {
		$gameMessage.add(gl_translate(TextManager.defeat).format($gameParty.name()));
	};
	Game_Actor.prototype.displayLevelUp = function(newSkills) {
		var text = gl_translate(TextManager.levelUp).format(this._name, gl_translate(TextManager.level), this._level);
		$gameMessage.newPage();
		$gameMessage.add(text);
		newSkills.forEach(function(skill) {
			$gameMessage.add(gl_translate(TextManager.obtainSkill).format(skill.name));
		});
	};
	
	BattleManager.displayExp = function() {
		var exp = this._rewards.exp;
		if (exp > 0) {
			var text = gl_translate(TextManager.obtainExp).format(exp, gl_translate(TextManager.exp));
			$gameMessage.add('\\.' + text);
		}
	};
		

BattleManager.displayGold = function() {
    var gold = this._rewards.gold;
    if (gold > 0) {
        $gameMessage.add('\\.' + gl_translate(TextManager.obtainGold).format(gold));
    }
};

BattleManager.displayDropItems = function() {
    var items = this._rewards.items;
    if (items.length > 0) {
        $gameMessage.newPage();
        items.forEach(function(item) {
            $gameMessage.add(gl_translate(TextManager.obtainItem).format(item.name));
        });
    }
};

Window_BattleLog.prototype.displayAction = function(subject, item) {
    var numMethods = this._methods.length;
    if (DataManager.isSkill(item)) {
        if (item.message1) {
            this.push('addText', subject.name() + item.message1.format(item.name));
        }
        if (item.message2) {
            this.push('addText', item.message2.format(item.name));
        }
    } else {
        this.push('addText', gl_translate(TextManager.useItem).format(subject.name(), item.name));
    }
    if (this._methods.length === numMethods) {
        this.push('wait');
    }
};

Window_BattleLog.prototype.displayCritical = function(target) {
    if (target.result().critical) {
        if (target.isActor()) {
            this.push('addText', gl_translate(TextManager.criticalToActor));
        } else {
            this.push('addText', gl_translate(TextManager.criticalToEnemy));
        }
    }
};


Window_BattleLog.prototype.makeHpDamageText = function(target) {
    var result = target.result();
    var damage = result.hpDamage;
    var isActor = target.isActor();
    var fmt;
    if (damage > 0 && result.drain) {
        fmt = isActor ? gl_translate(TextManager.actorDrain) : gl_translate(TextManager.enemyDrain);
        return fmt.format(target.name(), gl_translate(TextManager.hp), damage);
    } else if (damage > 0) {
        fmt = isActor ? gl_translate(TextManager.actorDamage) : gl_translate(TextManager.enemyDamage);
        return fmt.format(target.name(), damage);
    } else if (damage < 0) {
        fmt = isActor ? gl_translate(TextManager.actorRecovery) : gl_translate(TextManager.enemyRecovery);
        return fmt.format(target.name(), gl_translate(TextManager.hp), -damage);
    } else {
        fmt = isActor ? gl_translate(TextManager.actorNoDamage) : gl_translate(TextManager.enemyNoDamage);
        return fmt.format(target.name());
    }
};

Window_BattleLog.prototype.makeMpDamageText = function(target) {
    var result = target.result();
    var damage = result.mpDamage;
    var isActor = target.isActor();
    var fmt;
    if (damage > 0 && result.drain) {
        fmt = isActor ? gl_translate(TextManager.actorDrain) : gl_translate(TextManager.enemyDrain);
        return fmt.format(target.name(), gl_translate(TextManager.mp), damage);
    } else if (damage > 0) {
        fmt = isActor ? gl_translate(TextManager.actorLoss) : gl_translate(TextManager.enemyLoss);
        return fmt.format(target.name(), gl_translate(TextManager.mp), damage);
    } else if (damage < 0) {
        fmt = isActor ? gl_translate(TextManager.actorRecovery) : gl_translate(TextManager.enemyRecovery);
        return fmt.format(target.name(), gl_translate(TextManager.mp), -damage);
    } else {
        return '';
    }
};

Window_BattleLog.prototype.makeTpDamageText = function(target) {
    var result = target.result();
    var damage = result.tpDamage;
    var isActor = target.isActor();
    var fmt;
    if (damage > 0) {
        fmt = isActor ? gl_translate(TextManager.actorLoss) : gl_translate(TextManager.enemyLoss);
        return fmt.format(target.name(), gl_translate(TextManager.tp), damage);
    } else if (damage < 0) {
        fmt = isActor ? gl_translate(TextManager.actorGain) : gl_translate(TextManager.enemyGain);
        return fmt.format(target.name(), gl_translate(TextManager.tp), -damage);
    } else {
        return '';
    }
};

Window_BattleLog.prototype.displayMiss = function(target) {
    var fmt;
    if (target.result().physical) {
        fmt = target.isActor() ? gl_translate(TextManager.actorNoHit) : gl_translate(TextManager.enemyNoHit);
        this.push('performMiss', target);
    } else {
        fmt = gl_translate(TextManager.actionFailure);
    }
    this.push('addText', fmt.format(target.name()));
};


Window_BattleLog.prototype.displayEvasion = function(target) {
    var fmt;
    if (target.result().physical) {
        fmt = gl_translate(TextManager.evasion);
        this.push('performEvasion', target);
    } else {
        fmt = gl_translate(TextManager.magicEvasion);
        this.push('performMagicEvasion', target);
    }
    this.push('addText', fmt.format(target.name()));
};


Window_BattleLog.prototype.displayReflection = function(target) {
    this.push('performReflection', target);
    this.push('addText', gl_translate(TextManager.magicReflection).format(target.name()));
};

Window_BattleLog.prototype.displayCounter = function(target) {
    this.push('performCounter', target);
    this.push('addText', gl_translate(TextManager.counterAttack).format(target.name()));
};

Window_BattleLog.prototype.displaySubstitute = function(substitute, target) {
    var substName = substitute.name();
    this.push('performSubstitute', substitute, target);
    this.push('addText', gl_translate(TextManager.substitute).format(substName, target.name()));
};

Window_BattleLog.prototype.displayChangedBuffs = function(target) {
    var result = target.result();
    this.displayBuffs(target, result.addedBuffs, gl_translate(TextManager.buffAdd));
    this.displayBuffs(target, result.addedDebuffs, gl_translate(TextManager.debuffAdd));
    this.displayBuffs(target, result.removedBuffs, gl_translate(TextManager.buffRemove));
};

Window_BattleLog.prototype.displayFailure = function(target) {
    if (target.result().isHit() && !target.result().success) {
        this.push('addText', gl_translate(TextManager.actionFailure).format(target.name()));
    }
};

Window_BattleLog.prototype.displayBuffs = function(target, buffs, fmt) {
    buffs.forEach(function(paramId) {
        this.push('popBaseLine');
        this.push('pushBaseLine');
        this.push('addText', fmt.format(target.name(), gl_translate(TextManager.param(paramId))));
    }, this);
};

// 保存原始 addText
var originalAddText = Window_BattleLog.prototype.addText;

// 覆盖 addText，在添加前翻译
Window_BattleLog.prototype.addText = function(text) {
    if (enableTranslation) {
        text = translate(text);  // 或 gl_translate(text)
    }
    originalAddText.call(this, text);
};


// 保存原始的 String.prototype.format 方法（RPG Maker MV 核心定义的）
var _String_prototype_format = String.prototype.format;

String.prototype.format = function() {
    // this 是模板字符串，例如 TextManager.actorDamage 的值 "{0} suffered {1} damage."
    var template = this;

    // 在进行任何 {0},{1} 替换前，先进行 {key} 翻译
    if (enableTranslation) {
        template = translate(template);  // 这里替换 {actorDamage} 等，但不会动 {0}{1}
    }

    // 现在用翻译后的模板执行原来的 format 替换
    // 将 template 作为 this 调用原始 format（避免无限递归）
    return _String_prototype_format.call(template, ...arguments);
};


// ===== 新增：拦截技能描述、帮助窗口描述等，确保 {key} 翻译生效 =====

// 保存原始的 drawTextEx 方法（用于显示带转义字符的文本，如技能描述）
var _Window_Base_drawTextEx = Window_Base.prototype.drawTextEx;

Window_Base.prototype.drawTextEx = function(text, x, y) {
    if (text) {
        // 先进行 {key} 翻译（确保在转义字符处理前完成）
        if (enableTranslation) {
            text = translate(text);  // 或 gl_translate(text)
        }
        
        // 再处理转义字符（如 \I[1]、\C[3] 等）和绘制
        // 注意：drawTextEx 内部会调用 this.convertEscapeCharacters(text)
        // 但我们已经在外面翻译好了，所以内部的 convertEscapeCharacters 不需要再翻译
    }
    
    // 调用原始方法进行绘制
    return _Window_Base_drawTextEx.call(this, text, x, y);
};

})();