//=================================================================================================
// Ui_Window.js
//=================================================================================================
/*:
* @plugindesc 精灵窗口。
* @author 芯☆淡茹水
* @help
* 物品(道具/武器/防具)名字颜色备注：
*     在物品备注里写 => <NameColor:n>
*     n :颜色序号。
*     未备注的默认为 白色 。
*/
//=================================================================================================
//=================================================================================================
function Ui_Window() {
    this.initialize.apply(this, arguments);
}
Ui_Window.prototype = Object.create(Window_Base.prototype);
Ui_Window.prototype.constructor = Ui_Window;
Ui_Window.prototype.initialize = function(x, y, rect, uiName) {
    this._rect = rect;
    this._uiName = uiName;
    this.initBaseData();
    Window_Base.prototype.initialize.call(this, x, y, rect.width, rect.height);
    this.setupUiFace();
    this.createButtons();
    this.addCursor();
};
Ui_Window.prototype.initBaseData = function() {
    this._handlers = {};
    this._buttons = [];
    this._index = 0;
    this._page = 0;
    this._maxPage = 1;
};
Ui_Window.prototype.standardFontSize = function() {
    return 18;
};
Ui_Window.prototype.standardPadding = function() {
    return 0;
};
Ui_Window.prototype.lineHeight = function() {
    return 24;
};
Ui_Window.prototype.loadUi = function(uiName) {
    uiName = uiName || this._uiName;
    return ImageManager.loadUi(uiName, 0);
};
Ui_Window.prototype.blankBitmap = function() {
    return new Bitmap(this._rect.width,this._rect.height);
};
Ui_Window.prototype.setupUiFace = function() {
    this.opacity = 0;
    this._uiSprite = new Sprite();
    this._uiSprite.bitmap = this._uiName ? this.loadUi() : this.blankBitmap();
    this.refreshUiFrame();
    !this._uiName && this.drawBackground();
    this.addChildToBack(this._uiSprite);
};
Ui_Window.prototype.createButtons = function() {
};
Ui_Window.prototype.createPageButtons = function(lx, ly, rx, ry, bh) {
    bh = bh || 60;
    var bw = 32 * (bh / 60);
    this._pageL = new Ui_Button(lx, ly, new Rectangle(0,0,bw,bh), 'Ui_Menu1');
    this._pageR = new Ui_Button(rx, ry, new Rectangle(0,0,bw,bh), 'Ui_Menu1');
    this._pageL.setSmollStyle(new Rectangle(1390, 420, 32, 60));
    this._pageR.setSmollStyle(new Rectangle(1422, 420, 32, 60));
    this.addChild(this._pageL);
    this.addChild(this._pageR);
};
Ui_Window.prototype.addCursor = function() {
};
Ui_Window.prototype.clearUi = function() {
    this._uiSprite.bitmap.clear();
};
Ui_Window.prototype.drawBackground = function() {
};
Ui_Window.prototype.drawBackgroundUi = function(rect, x, y, w, h, uiName) {
    var rw = rect.width;
    var rh = rect.height;
    w = w || rw;
    h = h || rh;
    var bitmap = this.loadUi(uiName);
    bitmap.addLoadListener(function() {
        this._uiSprite.bitmap.blt(bitmap, rect.x, rect.y, rw, rh, x, y, w, h);
    }.bind(this));
};
Ui_Window.prototype.refreshUiFrame = function() {
    this._uiSprite.setFrame(this._rect.x,this._rect.y,this._rect.width,this._rect.height);
};
Ui_Window.prototype.bltUi = function(rect, uiName, x, y, w, h) {
    var rw = rect.width;
    var rh = rect.height;
    w = w || rw;
    h = h || rh;
    var bitmap = this.loadUi(uiName);
    bitmap.addLoadListener(function() {
        this.contents.blt(bitmap, rect.x, rect.y, rw, rh, x, y, w, h);
    }.bind(this));
};
Ui_Window.prototype.setPosition = function(x, y) {
    this._x = x;
    this._y = y;
};
Ui_Window.prototype.setRect = function(rect) {
    var lastRect = this._rect;
    this._rect = rect;
    lastRect !== this._rect && this.refreshUiFrame();
};
Ui_Window.prototype.setHandler = function(sym, method) {
    this._handlers[sym] = method;
};
Ui_Window.prototype.hasHandler = function(sym) {
    return !!this._handlers[sym];
};
Ui_Window.prototype.callHandler = function(sym) {
    this.hasHandler(sym) && this._handlers[sym]();
};
Ui_Window.prototype.isValid = function() {
    if (!this.hasHandler('valid')) return true;
    return this._handlers['valid']();
};
Ui_Window.prototype.callOkHandler = function() {
    if (!this.hasHandler('ok')) return;
    if (!this.isValid()) {
        SoundManager.playBuzzer();
        return;
    }
    SoundManager.playOk();
    this._clickIndex = this._index;
    this.deactivate();
    this.callHandler('ok');
};
Ui_Window.prototype.callCancelHandler = function() {
    if (!this.hasHandler('cancel')) return;
    SoundManager.playCancel();
    this._clickIndex = this._index;
    this.deactivate();
    this.callHandler('cancel');
};
Ui_Window.prototype.clearRect = function() {
    var rect = arguments.length === 1 ? arguments[0] : null;
    var x = rect ? rect.x : arguments[0];
    var y = rect ? rect.y : arguments[1];
    var w = rect ? rect.width  : arguments[2];
    var h = rect ? rect.height : arguments[3];
    this.contents.clearRect(x, y, w, h);
};
Ui_Window.prototype.changeFontSize = function(size) {
    this.contents.fontSize = size || 24;
};
Ui_Window.prototype.changeFontColor = function(n) {
    this.changeTextColor(this.textColor(n || 0));
};
Ui_Window.prototype.changeOutLineColor = function(color) {
    this.contents.outlineColor = color || 'rgba(0, 0, 0, 0.5)';
};
Ui_Window.prototype.setupWait = function() {
    this._waitCount = 8;
};
Ui_Window.prototype.activate = function(index) {
    Window_Base.prototype.activate.call(this);
    this._cursor && this._cursor.show();
    this.setupWait();
};
Ui_Window.prototype.deactivate = function() {
    Window_Base.prototype.deactivate.call(this);
    this._cursor && this._cursor.hide();
    this.setupWait();
};
Ui_Window.prototype.isOpenAndActive = function() {
    return this.isOpen() && this.active && this.visible && !this._waitCount;
};
Ui_Window.prototype.index = function() {
    return this._index;
};
Ui_Window.prototype.clickIndex = function() {
    return this._clickIndex;
};
Ui_Window.prototype.select = function(index, silent) {
    var lastIndex = this._index;
    this._index = index;
    if (lastIndex !== this._index) {
        !silent && SoundManager.playCursor();
        this.refreshIndexChanged();
    }
};
Ui_Window.prototype.rollIndex = function(kind) {
    var index = (this._index + (kind ? 1 : this.maxItems() - 1)) % this.maxItems();
    this.select(index);
};
Ui_Window.prototype.turnPage = function(kind) {
    var lastPage = this._page;
    this._page = (this._page + (kind ? 1 : this._maxPage - 1)) % this._maxPage;
    if (lastPage !== this._page) {
        SoundManager.playOk();
        this.refreshPageChanged();
    }
};
Ui_Window.prototype.maxItems = function() {
    return 0;
};
Ui_Window.prototype.items = function() {
    return [];
};
Ui_Window.prototype.pageItems = function() {
    var n = this.maxItems();
    return this.items().slice(this._page*n, (this._page+1)*n);
};
Ui_Window.prototype.item = function() {
    return this.pageItems()[this._index];
};
Ui_Window.prototype.refresh = function() {
    this.contents.clear();
    this.refreshPageData();
    this.drawOther();
    this.drawPage();
    this.drawItems();
};
Ui_Window.prototype.refreshPageData = function() {
    this._page = 0;
    this._maxPage = Math.ceil(this.items().length / this.maxItems());
    this._maxPage = Math.max(this._maxPage, 1);
};
Ui_Window.prototype.refreshIndexChanged = function() {
    this.refreshCursorLocation();
};
Ui_Window.prototype.refreshPageChanged = function() {
    this.drawPage();
    this.drawItems();
};
Ui_Window.prototype.refreshCursorLocation = function() {
    if (this._cursor) this._cursor.visible = (this._index >= 0);
};
Ui_Window.prototype.localX = function() {
    var x = 0;
    var obj = this;
    while (obj) {
        x += obj.x;
        obj = obj.parent;
    }
    return x;
};
Ui_Window.prototype.localY = function() {
    var y = 0;
    var obj = this;
    while (obj) {
        y += obj.y;
        obj = obj.parent;
    }
    return y;
};
Ui_Window.prototype.itemRect = function(index) {
    return null;
};
Ui_Window.prototype.itemsRect = function() {
    var rect = this.itemRect(0);
    if (!rect) return null;
    rect.height = 26 * this.maxItems();
    return rect;
};
Ui_Window.prototype.itemLocalRect = function(index) {
    if (!this.itemRect(index)) return null;
    var x = this.localX();
    var y = this.localY();
    var rect = this.itemRect(index);
    return new Rectangle(rect.x + x, rect.y + y, rect.width, rect.height);
};
Ui_Window.prototype.drawOther = function() {
};
Ui_Window.prototype.drawItems = function() {
    this.itemsRect() && this.clearRect(this.itemsRect());
    for (var i=0;i<this.maxItems();i++) this.drawItem(i);
};
Ui_Window.prototype.drawItem = function(index) {
};
Ui_Window.prototype.drawPage = function() {
};
Ui_Window.prototype.drawItemName = function(item, x, y, width, size) {
    if (!size) return Window_Base.prototype.drawItemName.call(this, item, x, y, width);
    this.zoomOutIcon(x, y, item.iconIndex, size);
    var iconBoxWidth = size + 4;
    var n = item.note.match(/<NameColor:(\d+)>/) ? +RegExp.$1 : 0;
    this.changeFontColor(n);
    this.drawText(item.name, x + iconBoxWidth, y, width - iconBoxWidth); 
    this.changeFontColor();
};
Ui_Window.prototype.zoomOutIcon = function(x, y, iconIndex, size) {
    var bitmap = ImageManager.loadSystem('IconSet');
    var pw = Window_Base._iconWidth;
    var ph = Window_Base._iconHeight;
    var sx = iconIndex % 16 * pw;
    var sy = Math.floor(iconIndex / 16) * ph;
    this.contents.blt(bitmap, sx, sy, pw, ph, x, y, size, size);
};
Ui_Window.prototype.drawPageMessage = function(x, y) {
    this.contents.clearRect(x, y, 64, 20);
    this.contents.fillRect(x, y, 64, 20);
    var lastSize = this.contents.fontSize;
    var lastColor = this.contents.textColor;
    this.contents.fontSize = 16;
    this.contents.textColor = 'rgb(0,200,0)';
    var text = ''+(this._page+1)+'/'+this._maxPage;
    this.contents.drawText(text, x, y, 64, 20, 'center');
    this.contents.fontSize = lastSize;
    this.contents.textColor = lastColor;
};
Ui_Window.prototype.drawItemBigPicture = function(item, x, y, size) {
    if (!item) return;
    if (!item.note.match(/<BP:(\S+)>/)) return this.zoomOutIcon(x, y, item.iconIndex, size);
    var bitmap = ImageManager.loadUi(RegExp.$1);
    bitmap.addLoadListener(function() {
        this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, x, y, size, size);
    }.bind(this));
};
Ui_Window.prototype.redrawItem = function(index) {
    this.clearRect(this.itemRect(index));
    this.drawItem(index);
};
Ui_Window.prototype.isSomeCanceled = function() {
    return TouchInput.isCancelled() || Input.isTriggered('menu');
};
Ui_Window.prototype.update = function() {
    Window_Base.prototype.update.call(this);
    this.updateWaitCount();
    this.updateInput();
    this.updateTouch();
};
Ui_Window.prototype.updateWaitCount = function() {
    if (this._waitCount) this._waitCount--;
};
Ui_Window.prototype.updateInput = function() {
    if (!this.isOpenAndActive())       return false;
    if (Input.isTriggered('up'))       return this.inputOnKeyUp();
    if (Input.isTriggered('left'))     return this.inputOnKeyLeft();
    if (Input.isTriggered('down'))     return this.inputOnKeyDown();
    if (Input.isTriggered('right'))    return this.inputOnKeyRight();
    if (Input.isTriggered('pageup'))   return this.inputOnPageup();
    if (Input.isTriggered('pagedown')) return this.inputOnPagedown();
    if (Input.isTriggered('ok'))       return this.inputOnOk();
    if (this.isSomeCanceled())         return this.inputOnCancel();
};
Ui_Window.prototype.updateTouch = function() {
    if (!this.isOpenAndActive())   return false;
    if (!TouchInput.isTriggered()) return false;
    if (this.maxItems() === 0)     return false;
    this.touchItemAction();
};
Ui_Window.prototype.inputOnOk = function() {
    this.callOkHandler();
};
Ui_Window.prototype.inputOnCancel = function() {
    this.callCancelHandler();
};
Ui_Window.prototype.inputOnKeyUp = function() {
};
Ui_Window.prototype.inputOnKeyLeft = function() {
};
Ui_Window.prototype.inputOnKeyDown = function() {
};
Ui_Window.prototype.inputOnKeyRight = function() {
};
Ui_Window.prototype.inputOnPageup = function() {
    this.turnPage(0);
};
Ui_Window.prototype.inputOnPagedown = function() {
    this.turnPage(1);
};
Ui_Window.prototype.touchInItemRect = function(index) {
    var rect = this.itemLocalRect(index);
    return rect ? TouchInput.inRect(rect) : false;
};
Ui_Window.prototype.getTouchIndex = function() {
    for (var i=0;i<this.maxItems();i++) {
        if (this.touchInItemRect(i)) return i;
    }
    return null;
};
Ui_Window.prototype.touchItemAction = function() {
    var index = this.getTouchIndex();
    if (index !== null) {
        index === this._index ? this.inputOnOk() : this.select(index);
    }
};
Ui_Window.prototype.playSe = function(seName) {
    seName && AudioManager.playSe({"name":seName,"volume":100,"pitch":100,"pan":0});
};
Ui_Window.prototype.textExWidth = function() {
    return null;
};
Ui_Window.prototype.processNormalCharacter = function(textState) {
    if (this.textExWidth()) {
        var w = this.textWidth(textState.text[textState.index+1]);
        (textState.x + w) > this.textExWidth() && this.processNewLine(textState, true);
    }
    Window_Base.prototype.processNormalCharacter.call(this, textState);
};
Ui_Window.prototype.processNewLine = function(textState, keep) {
    textState.x = textState.left;
    textState.y += textState.height;
    textState.height = this.calcTextHeight(textState, false);
    if (!keep) textState.index++;
};
//=================================================================================================
function Ui_Button() {
    this.initialize.apply(this, arguments);
}
Ui_Button.prototype = Object.create(Sprite.prototype);
Ui_Button.prototype.constructor = Ui_Button;
Ui_Button.prototype.initialize = function(x, y, rect, uiName) {
    Sprite.prototype.initialize.call(this);
    this._rect = rect;
    this._uiName = uiName;
    this.setupImage();
    this.initBaseData();
    this.move(x, y);
};
Ui_Button.prototype.setupImage = function() {
    this.bitmap = ImageManager.loadUi(this._uiName);
    this.setFrame(this._rect.x,this._rect.y,this._rect.width,this._rect.height);
    this.anchor = new Point(0.5, 0.5);
};
Ui_Button.prototype.setSmollStyle = function(rect) {
    this.bitmap = new Bitmap(this._rect.width, this._rect.height);
    var bitmap = ImageManager.loadUi(this._uiName);
    bitmap.addLoadListener(function(){
        var bw = this.bitmap.width;
        var bh = this.bitmap.height;
        this.bitmap.blt(bitmap, rect.x, rect.y, rect.width, rect.height, 0, 0, bw, bh);
    }.bind(this));
};
Ui_Button.prototype.initBaseData = function() {
    this._pressCount = 0;
};
Ui_Button.prototype.setPressMethod = function(method) {
    this._pressMethod = method;
};
Ui_Button.prototype.hide = function() {
    this.visible = false;
};
Ui_Button.prototype.show = function() {
    this.visible = true;
};
Ui_Button.prototype.localX = function() {
    var x = 0;
    var obj = this;
    while (obj) {
        x += obj.x;
        obj = obj.parent;
    }
    return x;
};
Ui_Button.prototype.localY = function() {
    var y = 0;
    var obj = this;
    while (obj) {
        y += obj.y;
        obj = obj.parent;
    }
    return y;
};
Ui_Button.prototype.callPressMethod = function() {
    this._pressMethod && this._pressMethod();
};
Ui_Button.prototype.press = function() {
    if (!this.isActive()) return;
    SoundManager.playOk();
    this.scale = new Point(0.9, 0.9);
    this._pressCount = 8;
    this.callPressMethod();
};
Ui_Button.prototype.restore = function() {
    this.scale = new Point(1, 1);
};
Ui_Button.prototype.isPressed = function() {
    return this._pressCount > 0;
};
Ui_Button.prototype.isActive = function() {
    if (this.isPressed()) return false;
    return this.visible && (!this.parent || this.parent.isOpenAndActive());
};
Ui_Button.prototype.update = function() {
    Sprite.prototype.update.call(this);
    this.updatePressed();
    this.updateTouch();
};
Ui_Button.prototype.updatePressed = function() {
    if (!this.isPressed()) return;
    this._pressCount--;
    !this.isPressed() && this.restore();
};
Ui_Button.prototype.updateTouch = function() {
    if (!TouchInput.isTriggered() || !this.isActive()) return;
    this.onTouch() && this.press();
};
Ui_Button.prototype.onTouch = function() {
    var x = this.localX() - this._rect.width * this.anchor.x;
    var y = this.localY() - this._rect.height * this.anchor.y;
    return TouchInput.inRect(new Rectangle(x,y,this._rect.width,this._rect.height));
};
//=================================================================================================
function Ui_Cursor() {
    this.initialize.apply(this, arguments);
}
Ui_Cursor.prototype = Object.create(Sprite.prototype);
Ui_Cursor.prototype.constructor = Ui_Cursor;
Ui_Cursor.prototype.initialize = function() {
    Sprite.prototype.initialize.call(this);
    this.setupImage();
    this.clearActionData();
};
Ui_Cursor.prototype.uiName = function() {
    return 'Ui_Menu1';
};
Ui_Cursor.prototype.frameRect = function() {
    return new Rectangle(910, 512, 30, 26);
};
Ui_Cursor.prototype.setupImage = function() {
    this.bitmap = ImageManager.loadUi(this.uiName(), 0);
    var rect = this.frameRect();
    this.setFrame(rect.x, rect.y, rect.width, rect.height);
};
Ui_Cursor.prototype.clearActionData = function() {
    this._actionCount = 0;
};
Ui_Cursor.prototype.move = function(x, y) {
    Sprite.prototype.move.call(this, x, y);
    this.clearActionData();
};
Ui_Cursor.prototype.hide = function() {
    this.visible = false;
};
Ui_Cursor.prototype.show = function() {
    this.visible = true;
};
Ui_Cursor.prototype.update = function() {
    Sprite.prototype.update.call(this);
    this.updateAction();
};
Ui_Cursor.prototype.updateAction = function() {
    if (!this.visible) return;
    this._actionCount = (this._actionCount + 1) % 20;
    this.x += this._actionCount >= 10 ? -0.5 : 0.5;
};
//=================================================================================================
function Ui_MessageBase() {
    this.initialize.apply(this, arguments);
}
Ui_MessageBase.prototype = Object.create(Ui_Window.prototype);
Ui_MessageBase.prototype.constructor = Ui_MessageBase;
Ui_MessageBase.prototype.initialize = function(titleText) {
    this._titleText = titleText;
    var w = this.windowWidth();
    var h = this.windowHeight();
    var x = (Graphics.width - w) / 2;
    var y = (Graphics.height - h) / 2;
    Ui_Window.prototype.initialize.call(this,x,y,new Rectangle(0,0,w,h));
    this.refresh();
};
Ui_MessageBase.prototype.windowWidth = function() {
    var bitmap = new Bitmap(32,32);
    bitmap.fontSize = 22;
    var cw = bitmap.measureTextWidth(this._titleText);
    return Math.max(cw+60, 240);
};
Ui_MessageBase.prototype.windowHeight = function() {
    return 82;
};
Ui_MessageBase.prototype.drawBackground = function() {
    var x = 670, y = 1104;
    var w = this.windowWidth();
    this.drawBackgroundUi(new Rectangle(x,y,20,82),0,0,20,82,'Ui_Menu1');
    this.drawBackgroundUi(new Rectangle(x+240,y,20,82),w-20,0,20,82,'Ui_Menu1');
    this.drawBackgroundUi(new Rectangle(x+20,y,40,82),20,0,w-40,82,'Ui_Menu1');
};
Ui_MessageBase.prototype.isSomeInput = function() {
    return Input.isTriggered('ok') || TouchInput.isTriggered() ||
    this.isSomeCanceled();
};
//=================================================================================================
function Ui_Remind() {
    this.initialize.apply(this, arguments);
}
Ui_Remind.prototype = Object.create(Ui_MessageBase.prototype);
Ui_Remind.prototype.constructor = Ui_Remind;
Ui_Remind.prototype.initialize = function(titleText) {
    Ui_MessageBase.prototype.initialize.call(this,titleText);
    this._standingCount = 180;
};
Ui_Remind.prototype.drawOther = function() {
    this.changeFontSize(22);
    this.changeFontColor(XdRsData.weMenu.getColor('rmColor'));
    var w = this.contents.width;
    var h = this.contents.height;
    this.contents.drawText(this._titleText, 0, 0, w, h, 'center');
};
Ui_Remind.prototype.callOkHandler = function() {
    if (!this._standingCount) return;
    this._standingCount = 0;
    Ui_MessageBase.prototype.callOkHandler.call(this);
};
Ui_Remind.prototype.update = function() {
    Ui_MessageBase.prototype.update.call(this);
    this.updateStandingCount();
};
Ui_Remind.prototype.updateInput = function() {
    Ui_MessageBase.prototype.updateInput.call(this);
    this.isSomeInput() && this.callOkHandler();
};
Ui_Remind.prototype.updateStandingCount = function() {
    if (!this._standingCount) return;
    this._standingCount--;
    !this._standingCount && this.callHandler('ok');
};
//=================================================================================================
function Ui_Select() {
    this.initialize.apply(this, arguments);
}
Ui_Select.prototype = Object.create(Ui_MessageBase.prototype);
Ui_Select.prototype.constructor = Ui_Select;
Ui_Select.prototype.initialize = function(titleText, s1, s2) {
    this._selectText = [s1, s2];
    Ui_MessageBase.prototype.initialize.call(this,titleText);
};
Ui_Select.prototype.maxItems = function() {
    return 2;
};
Ui_Select.prototype.addCursor = function() {
    this.select(1, true);
    this._cursor = new Ui_Cursor();
    this.refreshCursorLocation();
    this.addChild(this._cursor);
};
Ui_Select.prototype.itemRect = function(index) {
    var h = (this.contents.height - 10) / 2;
    var w = (this.contents.width - 40) / 2;
    return new Rectangle(index*w+20, h, w, h);
};
Ui_Select.prototype.refreshCursorLocation = function() {
    Ui_MessageBase.prototype.refreshCursorLocation.call(this);
    this.changeFontSize(18);
    if (!this._cursor) return;
    var rect = this.itemRect(this._index);
    this._cursor.move(rect.x, rect.y+2);
};
Ui_Select.prototype.drawItems = function() {};
Ui_Select.prototype.drawOther = function() {
    this.changeFontColor();
    var w = this.contents.width;
    var h = (this.contents.height - 10) / 2;
    var sw = (this.contents.width - 40) / 2;
    this.contents.drawText(this._titleText, 0, 5, w, h, 'center');
    this.contents.drawText(this._selectText[0], 20, h, sw, h, 'center');
    this.contents.drawText(this._selectText[1], 20+sw, h, sw, h, 'center');
};
Ui_Select.prototype.callOkHandler = function() {
    if (this._index === 0) return this.onSelectionOk();
    if (this._index === 1) return this.onSelectionCancel();
};
Ui_Select.prototype.onSelectionOk = function() {
    if (!this.isValid()) {
        SoundManager.playBuzzer();
        return;
    }
    SoundManager.playOk();
    this.callHandler('sOk');
};
Ui_Select.prototype.onSelectionCancel = function() {
    SoundManager.playCancel();
    this.callHandler('sCancel');
};
Ui_Select.prototype.inputOnKeyLeft = function() {
    this.rollIndex(0);
};
Ui_Select.prototype.inputOnKeyRight = function() {
    this.rollIndex(1);
};
//=================================================================================================
function XdRs_AnmSprite() {
    this.initialize.apply(this, arguments);
}
XdRs_AnmSprite.prototype = Object.create(Sprite_Base.prototype);
XdRs_AnmSprite.prototype.constructor = XdRs_AnmSprite;
XdRs_AnmSprite.prototype.initialize = function(anm, addCount) {
    Sprite_Base.prototype.initialize.call(this);
    this.width = Graphics.width;
    this.height = Graphics.height;
    this.playAnm(anm, addCount);
};
XdRs_AnmSprite.prototype.setRemoveMethod = function(method) {
    this._removeMethod = method;
};
XdRs_AnmSprite.prototype.playAnm = function(anm, addCount) {
    addCount = addCount || 10;
    this._anmCount = anm.frames.length * 4 + addCount;
    var sprite = new Sprite_Animation();
    sprite.setup(this, anm, false, false);
    this.addChild(sprite);
    this._animationSprites.push(sprite);
};
XdRs_AnmSprite.prototype.remove = function() {
    this._removeMethod && this._removeMethod();
};
XdRs_AnmSprite.prototype.update = function(anm) {
    Sprite_Base.prototype.update.call(this);
    this.updateAnmCount();
};
XdRs_AnmSprite.prototype.updateAnmCount = function(anm) {
    if (!this._anmCount) return;
    this._anmCount--;
    !this._anmCount && this.remove();
};
//=================================================================================================
Scene_Base.prototype.willPlayAnm = function(anmId, addCount) {
    if (!$dataAnimations[anmId]) return this.removeAnmSprite();
    this._anmSprite = new XdRs_AnmSprite($dataAnimations[anmId], addCount);
    this._anmSprite.setRemoveMethod(this.removeAnmSprite.bind(this));
    this.addChild(this._anmSprite);
};
Scene_Base.prototype.removeAnmSprite = function() {
    if (!this._anmSprite) return;
    this.removeChild(this._anmSprite);
    this._anmSprite = null;
};
Scene_Base.prototype.startRemind = function(text) {
    if (!text) return;
    this._remindWindow = new Ui_Remind(text);
    this._remindWindow.setHandler('ok', this.commandRemindOk.bind(this));
    this.addChild(this._remindWindow);
};
Scene_Base.prototype.startSelect = function(text, s1, s2) {
    this._selectWindow = new Ui_Select(text, s1, s2);
    this._selectWindow.setHandler('sOk',     this.commandSelectionOk.bind(this));
    this._selectWindow.setHandler('cancel',  this.commandSelectionCancel.bind(this));
    this._selectWindow.setHandler('sCancel', this.commandSelectionCancel.bind(this));
    this.addChild(this._selectWindow);
};
Scene_Base.prototype.removeMessageWindow = function(sym) {
    var window = sym === 'rm' ? this._remindWindow : this._selectWindow;
    if (!window) return;
    this.removeChild(window);
    if (sym === 'rm') this._remindWindow = null;
    if (sym === 'sl') this._selectWindow = null;
};
Scene_Base.prototype.commandRemindOk = function() {
    this.removeMessageWindow('rm');
};
Scene_Base.prototype.commandSelectionOk = function() {
    this.removeMessageWindow('sl');
};
Scene_Base.prototype.commandSelectionCancel = function() {
    this.removeMessageWindow('sl');
};
//=================================================================================================
// end
//=================================================================================================