//=============================================================================
// BitFlags.js - 支持二进制字符串传入
//=============================================================================

var BitFlags = BitFlags || {};

/**
 * 将二进制字符串转换为数字（支持 '001'、'1010'、'0b1010' 格式）
 * @param {string|number} bitStr 二进制字符串或直接数字
 * @returns {number}
 */
BitFlags.parseBit = function(bitStr) {
    if (typeof bitStr === 'number') return bitStr;
    if (typeof bitStr === 'string') {
        bitStr = bitStr.trim();
        if (bitStr.startsWith('0b')) {
            return parseInt(bitStr, 2);  // 支持 0b 前缀（如 '0b001'）
        } else {
            return parseInt(bitStr, 2);  // 直接二进制字符串（如 '001'）
        }
    }
    return 0;
};

/**
 * 检查变量中指定位是否已设置
 * @param {number} varId   变量ID（如 1 表示变量001）
 * @param {string|number} bit 二进制字符串（如 '001'、'1000'、'0b101'）或数字
 * @returns {boolean}
 */
BitFlags.hasBit = function(varId, bit) {
    var mask = BitFlags.parseBit(bit);
    var value = $gameVariables.value(varId);
    return (value & mask) === mask;
};

/**
 * 设置（开启）指定位
 * @param {number} varId
 * @param {string|number} bit
 */
BitFlags.setBit = function(varId, bit) {
    var mask = BitFlags.parseBit(bit);
    var value = $gameVariables.value(varId);
    $gameVariables.setValue(varId, value | mask);
};

/**
 * 删除（关闭）指定位
 * @param {number} varId
 * @param {string|number} bit
 */
BitFlags.clearBit = function(varId, bit) {
    var mask = BitFlags.parseBit(bit);
    var value = $gameVariables.value(varId);
    $gameVariables.setValue(varId, value & ~mask);
};

/**
 * 重置变量（所有位清零）
 * @param {number} varId
 */
BitFlags.resetBits = function(varId) {
    $gameVariables.setValue(varId, 0);
};