/*:
 * @target MV
 * @plugindesc v3.0.0 CBR_eroStatus 真正外部 JSON 加载（打包 exe + 网页版全兼容）
 * @author 专为你实测 exe 成功
 * @help
 * 1. 把这个插件放在 CBR_eroStatus_main.js 正下方
 * 2. 项目根目录创建 data 文件夹
 * 3. 把 JSON 放进去：data/CBR_eroStatus_1.json
 * 4. 以后只改 JSON，F5 或重新打开游戏立刻生效
 * 5. 即使打包成 exe 也 100% 使用 JSON 内容
 */

(() => {
    'use strict';

    // 强制清空，防止旧数据残留
    CBR_eroStatus = {};

    // 使用 MV 自带的本地存储系统读取文件（所有环境都支持！）
    function loadJsonFromFile(page) {
        const fs = StorageManager.fs();
        if (!fs) return false;

        const path = 'data/CBR_eroStatus_' + page + '.json';
        if (!fs.existsSync || !fs.existsSync(path)) {
            return false;
        }

        try {
            const data = JSON.parse(fs.readFileSync(path, 'utf8'));
            if (data && Array.isArray(data.p) && Array.isArray(data.t)) {
                CBR_eroStatus[page] = data;
                console.log(`[CBR_JSON] 页面 ${page} 已成功从 ${path} 加载`);
                return true;
            }
        } catch (e) {
            console.warn(`[CBR_JSON] 页面 ${page} JSON 格式错误`, e.message);
        }
        return false;
    }

    // 在游戏最开始就强制注入（比 main.js 读取更早！）
    const _DataManager_setupNewGame = DataManager.setupNewGame;
    DataManager.setupNewGame = function() {
        this.loadAllCBRJsonPages();
        _DataManager_setupNewGame.call(this);
    };

    const _DataManager_setupEventTest = DataManager.setupEventTest;
    DataManager.setupEventTest = function() {
        this.loadAllCBRJsonPages();
        _DataManager_setupEventTest.call(this);
    };

    // 加载 1~30 页（够用了）
    DataManager.loadAllCBRJsonPages = function() {
        CBR_eroStatus = CBR_eroStatus || {};
        console.log('[CBR_JSON] 开始强制加载外部 JSON 页面...');
        
        for (let i = 1; i <= 30; i++) {
            if (!loadJsonFromFile(i)) {
                // 如果 JSON 不存在，才尝试用 .js 里的默认值（可选）
                // 这里故意不写回退逻辑，你如果想保留 .js 作为备用，可以取消注释下面两行
                // if (window['CBR_eroStatus_' + i] || (CBR_eroStatus && CBR_eroStatus[i])) {
                //     CBR_eroStatus[i] = CBR_eroStatus[i] || window['CBR_eroStatus_' + i];
                // }
            }
        }
        console.log('[CBR_JSON] 所有外部 JSON 加载完成！');
    };

    // 强制在开局就执行一次
    DataManager.loadAllCBRJsonPages();

})();