/*:
 * @plugindesc 敌人AI拦截器 - 可强制普通攻击
 * @help
 * 这个插件为敌人AI添加了一个可被拦截的钩子函数：
 * Game_Enemy.prototype.canProceedWithNormalAI()
 *
 * 默认返回 true，保持原版AI行为。
 * 如果返回 false，则强制该敌人本次所有行动都使用“普通攻击”。
 *
 * 其他插件可以通过标准alias方式扩展这个函数，例如：
 * var _alias = Game_Enemy.prototype.canProceedWithNormalAI;
 * Game_Enemy.prototype.canProceedWithNormalAI = function() {
 *     return _alias.call(this) && !this.isStateAffected(10); // 例：中了状态10就强制普攻
 * };
 */

(function() {

    // 新增可拦截函数，默认返回 true（允许正常AI）
    Game_Enemy.prototype.canProceedWithNormalAI = function() {
        return true;
    };

    // Alias 原版 makeActions
    var _Game_Enemy_makeActions = Game_Enemy.prototype.makeActions;
    Game_Enemy.prototype.makeActions = function() {
		 // 返回 true → 使用原版AI逻辑
        _Game_Enemy_makeActions.call(this);
        // 先调用可拦截函数进行判断
        if (!this.canProceedWithNormalAI()) {
            // 返回 false → 强制普通攻击
            this.clearActions();
            var action = new Game_Action(this);
			action.setAttack();  // 等同于 setSkill(1)
			this._actions.push(action);
            this.setActionState('waiting');
            //return;
        }

       
    };

})();