/*:
 * @plugindesc  特定等级后升级经验值倍增插件
 * @author 小狼
 *
 * @param startLevel
 * @desc 从这个等级开始，下一级所需经验变为原来的 X 倍（不含本级）
 * @type number
 * @min 1
 * @default 50
 *
 * @param expMultiplier
 * @desc 经验值倍率（倍）
 * @type number
 * @decimals 1
 * @min 1.0
 * @default 2.0
 */

(function() {
    const parameters = PluginManager.parameters('LevelUpExpDoubleAfterCertainLv');
    const START_LEVEL = Number(parameters['startLevel'] || 50);
    const EXP_MULTIPLIER = Number(parameters['expMultiplier'] || 2.0);

    // 保存原始的 nextRequiredExp 计算方式
    const _Game_Actor_expForLevel = Game_Actor.prototype.expForLevel;
    
    Game_Actor.prototype.expForLevel = function(level) {
        // level 是「要达到的下一级」
        if (level <= START_LEVEL) {
            return _Game_Actor_expForLevel.call(this, level);
        }
        
        // 已经超过开始等级 → 从 START_LEVEL 级往后的每一级都乘倍率
        // 先算出原本到 START_LEVEL 所需的总经验
        const baseToStart = _Game_Actor_expForLevel.call(this, START_LEVEL);
        
        // 再把 START_LEVEL 之后的每一级所需经验 × 倍率
        let extraExp = 0;
        for (let i = START_LEVEL + 1; i <= level; i++) {
            // 原本这一级需要的经验量
            const originalThisLevel = _Game_Actor_expForLevel.call(this, i) - 
                                     _Game_Actor_expForLevel.call(this, i - 1);
            
            extraExp += originalThisLevel * EXP_MULTIPLIER;
        }
        
        return baseToStart + extraExp;
    };

    // 如果你使用的是 累积经验值显示（很多人都改过），建议同时覆写这个方法
    const _Game_Actor_nextRequiredExp = Game_Actor.prototype.nextRequiredExp;
    Game_Actor.prototype.nextRequiredExp = function() {
        if (this.level >= this.maxLevel()) {
            return 0;
        }
        
        const nextLv = this.level + 1;
        
        // 满级了就按原版逻辑
        if (nextLv > this.maxLevel()) {
            return 0;
        }
        
        // 正常计算下一级还需多少经验
        const totalNext = this.expForLevel(nextLv);
        return Math.max(totalNext - this.currentExp(), 0);
    };

})();