/*:
 * @plugindesc  物品·武器·防具 持有上限个别修改 v1.2
 * @author 河豚
 *
 * @help
 * 在物品/武器/防具的「备注」栏里写上以下任一格式即可修改该物品的最大持有数
 * （没写就保持引擎默认的99）
 *
 * <limit:500>
 * <最大持有数:999>
 * <上限:120>
 *
 * 注意：只接受正整数，写0或负数会自动当作99处理
 */

(function() {

    const _DataManager_onLoad = DataManager.onLoad;
    DataManager.onLoad = function(object) {
        _DataManager_onLoad.call(this, object);
        
        if (object === $dataItems || object === $dataWeapons || object === $dataArmors) {
            for (let i = 1; i < object.length; i++) {
                const item = object[i];
                if (!item) continue;
                
                item.maxCount = this.getMaxCountFromNote(item.note);
            }
        }
    };

    DataManager.getMaxCountFromNote = function(note) {
        if (!note) return 99;
        
        const limitPatterns = [
            /<limit\s*:\s*(\d+)>/i,
            /<最大持有数\s*:\s*(\d+)>/,
            /<上限\s*:\s*(\d+)>/,
            /<MaxCount\s*:\s*(\d+)>/i
        ];

        for (const pattern of limitPatterns) {
            const match = note.match(pattern);
            if (match && match[1]) {
                const value = parseInt(match[1], 10);
                return isNaN(value) || value < 1 ? 99 : value;
            }
        }
        
        return 99;
    };

    // 核心修改 - 持有数上限判定
    const _Game_Party_maxItems = Game_Party.prototype.maxItems;
    Game_Party.prototype.maxItems = function(item) {
        if (!item) return 99;
        // item.maxCount 在数据库加载时已经写入
        return item.maxCount !== undefined ? item.maxCount : _Game_Party_maxItems.call(this, item);
    };

    // 兼容一些老插件可能直接读$gameParty.maxItems(item)
    // 顺便把 maxItems(item) 也处理一下
    const _Game_Party_maxItems_old = Game_Party.prototype.maxItems;
    Game_Party.prototype.maxItems = function(item) {
        if (item && item.maxCount !== undefined) {
            return item.maxCount;
        }
        return _Game_Party_maxItems_old.call(this, item);
    };

})();