/*:
 * @plugindesc 等级压制伤害脚本 v1.3（10级差封顶 + 治疗排除 + 地狱模式）
 * @help
 * 在敌人的备注栏中写入 <level:xxx> 来设置敌人的固定等级，例如 <level:30>
 * 玩家角色使用自身等级。
 * 伤害倍率：每级差 5%，最高 +50%（高10级封顶），最低 30%（低10级封顶）。
 * 治疗技能（HP恢复）完全不受等级压制影响。
 * 
 * 【地狱模式】
 * 通过插件参数设置开关ID，开启时敌人的等级 = 原等级 * 1.3（向上取整）
 * 例如：原30级 → 39级（Math.ceil(30*1.3)=39）
 * 日志输出到控制台（F12），方便调试。
 * 
 * @param HellSwitchId
 * @text 地狱模式开关ID
 * @desc 开关ID开启地狱模式（敌人等级*1.3向上取整），0=禁用
 * @type switch
 * @default 1
 * @min 0
 */

(function() {

    // 插件参数
    var parameters = PluginManager.parameters('等级压制伤害脚本 v1.3（10级差封顶 + 治疗排除 + 地狱模式）');
    var hellSwitchId = Number(parameters['HellSwitchId'] || 0);

    // 参数：每级差 5%，10级差封顶
    var LEVEL_DIFF_RATE = 0.015;
    var MAX_BONUS = 0.75;   // 最大 +50%
    var MIN_PENALTY = -0.75; // 最小 -70%（剩30%）

    // 从敌人备注中读取等级，并应用地狱模式
    var _Game_Enemy_level = Game_Enemy.prototype.level;
    Game_Enemy.prototype.level = function() {
        if (this._customLevel === undefined) {
            var note = this.enemy().note;
            var match = note.match(/<level:\s*(\d+)>/i);
            var baseLevel = match ? Number(match[1]) : 1;

            // 地狱模式检查
            if (hellSwitchId > 0 && $gameSwitches.value(hellSwitchId)) {
                this._customLevel = Math.ceil($gameParty.leader().level + 5	);
                console.log("[地狱模式] 开启！敌人 " + this.name() + " (ID:" + this.enemyId() + ") 基础等级: " + baseLevel + " → 调整后: " + this._customLevel);
            } else {
                this._customLevel = baseLevel;
                console.log("[等级压制] 敌人 " + this.name() + " (ID:" + this.enemyId() + ") 读取等级: " + this._customLevel + " (地狱模式未开启)");
            }
        }
        return this._customLevel;
    };

    // 钩入伤害计算
    var _Game_Action_makeDamageValue = Game_Action.prototype.makeDamageValue;
    Game_Action.prototype.makeDamageValue = function(target, critical) {
        var baseValue = _Game_Action_makeDamageValue.call(this, target, critical);
        var value = baseValue;

        var a = this.subject(); // 施放者
        var b = target;         // 目标

        var item = this.item(); // 当前技能/物品

        // 地狱模式状态日志（只在伤害计算时输出一次）
        if (hellSwitchId > 0 && $gameSwitches.value(hellSwitchId)) {
            console.log("[地狱模式] 当前战斗中生效！");
        }

        console.log("[等级压制] 技能: " + item.name + " (ID:" + item.id + ")");

        // 判断是否为治疗技能（HP恢复）
        if (this.isHpRecover()) {
            console.log("[等级压制] 检测到治疗技能 → 不应用等级压制，伤害值保持原样: " + value);
            return value; // 直接返回原始值
        }

        // 非治疗技能，且是造成伤害的才应用压制
        if (this.isDamage()) {
            // 获取双方等级（敌人已自动应用地狱模式）
            var attackerLevel = a.isActor() ? a.level : a.level();
            var defenderLevel = b.isActor() ? b.level : b.level();

            var levelDiff = attackerLevel - defenderLevel;

            console.log("[等级压制] 施放者: " + a.name() + " (Lv." + attackerLevel + ") → 目标: " + b.name() + " (Lv." + defenderLevel + ")");
            console.log("[等级压制] 等级差 (施放者-目标): " + levelDiff);

            var rateAdjust = levelDiff * LEVEL_DIFF_RATE;
            rateAdjust = Math.max(rateAdjust, MIN_PENALTY);
            rateAdjust = Math.min(rateAdjust, MAX_BONUS);

            var multiplier = 1 + rateAdjust;

            console.log("[等级压制] 倍率调整: " + (rateAdjust * 100).toFixed(1) + "% → 最终倍率: " + multiplier.toFixed(3));
            console.log("[等级压制] 原始伤害: " + baseValue + " → 调整后伤害: " + Math.round(value * multiplier));

            value = Math.round(value * multiplier);

            console.log("[等级压制] 最终伤害值: " + value + "\n");
        } else {
            console.log("[等级压制] 非伤害技能 → 不应用压制\n");
        }

        return value;
    };

})();