/*:
 * @plugindesc 地图事件私有随机数（极致节省变量空间版）
 *
 * @help MapEventPrivateRandom.js
 *
 * 【设计目的】
 * 完全不占用任何全局开关或变量！
 * 每个事件的随机数仅存储在当前地图的临时内存中，
 * 切换地图、读档、标题画面返回时自动彻底清除。
 *
 * 【脚本调用】
 *
 * 1. 生成/重新生成随机数（推荐放在事件的自启动或并行页面最前面）
 *    $gameMap.setPrivateRandom(eventId, min, max)
 *    示例：$gameMap.setPrivateRandom(this._eventId, 0, 4)
 *
 * 2. 读取该事件的随机数值（不存在时返回 0）
 *    $gameMap.getPrivateRandom(eventId)
 *    示例：$gameMap.getPrivateRandom(this._eventId) === 3
 *
 * 【使用示例】
 * 事件ID=6 的宝箱事件（自启动页面）：
 * ◆脚本：
 *   $gameMap.setPrivateRandom(this._eventId, 0, 4);
 *
 * 然后在事件页条件分支判断内容：
 * ◆条件分支：脚本：$gameMap.getPrivateRandom(6) === 0
 *   ◆获得物品：药水 ×1
 * ◆条件分支：脚本：$gameMap.getPrivateRandom(6) === 1
 *   ◆获得物品：高阶药水 ×1
 * ◆条件分支：脚本：$gameMap.getPrivateRandom(6) === 4
 *   ◆获得物品：金币 ×500
 * （其他值可作为“空宝箱”等）
 *
 * 【优势】
 * - 零占用开关/变量资源
 * - 每个事件完全独立，互不干扰
 * - 切换地图自动清理（重新进入可重新随机）
 * - 读档安全（随机结果不会跨存档继承）
 * - 默认返回 0，条件判断安全
 */

(function() {
    // 初始化时为每张地图创建一个独立的临时存储对象（不存档）
    var _Game_Map_initialize = Game_Map.prototype.initialize;
    Game_Map.prototype.initialize = function() {
        _Game_Map_initialize.call(this);
        this._privateRandoms = {};  // 格式: { eventId: number }
    };

    // 设置（或重新生成）私有随机数
    Game_Map.prototype.setPrivateRandom = function(eventId, min, max) {
        if (!eventId || eventId <= 0) return;
        if (min == null || max == null || min > max) return;

        var value = Math.floor(Math.random() * (max - min + 1)) + min;
        this._privateRandoms[eventId] = value;
    };

    // 获取私有随机数（不存在返回 0）
    Game_Map.prototype.getPrivateRandom = function(eventId) {
        if (!eventId || eventId <= 0) return 0;
        return this._privateRandoms[eventId] || 0;
    };

    // 清除当前地图所有私有随机数
    Game_Map.prototype.clearPrivateRandoms = function() {
        this._privateRandoms = {};
    };

    // 切换地图时自动清理旧地图的数据
    var _Game_Map_setup = Game_Map.prototype.setup;
    Game_Map.prototype.setup = function(mapId) {
        if (this._mapId && this._mapId !== mapId) {
            // 离开旧地图，清除其临时随机数据
            this.clearPrivateRandoms();
        }
        _Game_Map_setup.call(this, mapId);
    };

    // 读档后也确保清理（防止极端情况残留）
    var _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function(contents) {
        _DataManager_extractSaveContents.call(this, contents);
        if ($gameMap) {
            $gameMap.clearPrivateRandoms();
        }
    };

})();	