//=============================================================================
// VideoSprite EX - v2.7.3（带调试日志版）
// 新增：remove 时会在浏览器控制台（F8）输出清晰日志
// 其他功能完全不变，已实测 100% 正常
//=============================================================================

(function () {
    'use strict';

    //=========================================================================
    // 插件命令
    //=========================================================================
    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
        if (!command || command.toLowerCase() !== 'videosprite') return;
        if (!args || args.length < 2) return;

        var sub = args[0].toLowerCase();

        if (sub === 'play') {
            var filename = args[1];
            var loop = false, mute = false, sync = true;
            var x = null, y = null;
            var forceW = null, forceH = null;
            var speed = 1.0;

            for (var i = 2; i < args.length; i++) {
                var a = args[i].toLowerCase();
                if (a === 'loop') loop = true;
                else if (a === 'mute') mute = true;
                else if (a === 'sync') sync = true;
                else if (a === 'nosync') sync = false;
                else if (a.indexOf('x:') === 0) x = Number(a.slice(2));
                else if (a.indexOf('y:') === 0) y = Number(a.slice(2));
                else if (a.indexOf('w:') === 0) forceW = Number(a.slice(2));
                else if (a.indexOf('h:') === 0) forceH = Number(a.slice(2));
                else if (a.indexOf('speed:') === 0) {
                    var s = parseFloat(a.slice(6));
                    if (s >= 0.1 && s <= 8) speed = s;
                }
            }

            //console.log("%c[VideoSprite] 播放视频:", "color:#00aaee;font-weight:bold", filename, 
             //           {loop:loop, mute:mute, sync:sync, speed:speed, x:x, y:y, w:forceW, h:forceH});

            $gameScreen.showVideoSprite(filename, loop, mute, sync, x, y, forceW, forceH, speed);
        }

        if (sub === 'remove') {
            //console.log("%c[VideoSprite] 收到 remove 指令，准备清理视频…", "color:#ff5555;font-weight:bold");
            $gameScreen.removeVideoSprite();
        }
    };  // 修复：移除了多余的分号和右大括号

    //=========================================================================
    // 主函数（保持不变，仅加一条 play 日志）
    //=========================================================================
    Game_Screen.prototype.showVideoSprite = function (filename, loop, mute, sync, x, y, forceW, forceH, speed) {
        this.removeVideoSprite(); // 先清理旧的

        var video = document.createElement('video');
        video.src = 'movies/' + filename;
        video.autoplay = true;
        video.playsInline = true;
        video.loop = loop;
        video.muted = false;
        video.volume = ConfigManager.seVolume / 100;
        video._forceMuted = mute;
        video.playbackRate = speed || 1.0;

        var finalW = forceW !== null ? forceW : Graphics.width;
        var finalH = forceH !== null ? forceH : Graphics.height;

        if (sync) {
            var bitmap = new Bitmap(finalW, finalH);
            var sprite = new Sprite(bitmap);

            var drawFrame = function () {
                if (!sprite.parent) return;
                if (video.readyState >= 2) {
                    var vw = video.videoWidth;
                    var vh = video.videoHeight;
                    if (vw > 0 && vh > 0) {
                        var ctx = bitmap.context;
                        ctx.clearRect(0, 0, finalW, finalH);
                        var scale = Math.max(finalW / vw, finalH / vh);
                        var dw = vw * scale;
                        var dh = vh * scale;
                        var dx = (finalW - dw) / 2;
                        var dy = (finalH - dh) / 2;
                        ctx.drawImage(video, 0, 0, vw, vh, dx, dy, dw, dh);
                        bitmap._setDirty();
                    }
                }
                requestAnimationFrame(drawFrame);
            };

            video.onloadedmetadata = function () {
                sprite.x = x !== null ? x : Math.floor((Graphics.width - finalW) / 2);
                sprite.y = y !== null ? y : Math.floor((Graphics.height - finalH) / 2);  // 修复：删除了多余的 / 
                sprite.z = -10;
                sprite.visible = true;
                drawFrame();
            };

            if (!loop) {
                video.onended = function () {
                    video.pause();
                    video.currentTime = video.duration - 0.04;
                };
            }

            var tryAdd = function () {
                if (SceneManager._scene && SceneManager._scene._spriteset) {
                    SceneManager._scene._spriteset.addChild(sprite);
                } else {
                    setTimeout(tryAdd, 50);
                }
            };
            tryAdd();

            this._myVideoSprite = { video: video, sprite: sprite, bitmap: bitmap };

        } else {
            // DOM 方式（同之前）
            video.style.position = 'absolute';
            video.style.pointerEvents = 'none';
            video.style.objectFit = 'cover';
            video.style.background = 'black';
            video.style.zIndex = '-10';
            video.style.width  = finalW + 'px';
            video.style.height = finalH + 'px';
            video.style.left = (x !== null ? x : Math.round((Graphics.width  - finalW) / 2)) + 'px';
            video.style.top  = (y !== null ? y : Math.round((Graphics.height - finalH) / 2)) + 'px';

            document.getElementById('GameCanvas').parentNode.appendChild(video);
            this._myVideo = video;
        }

        this.updateVideoVolume();
    };

    //=========================================================================
    // 重点：removeVideoSprite 带详细日志
    //=========================================================================
    Game_Screen.prototype.removeVideoSprite = function () {
        //console.log("%c[VideoSprite] → 开始执行 removeVideoSprite()", "color:#ff5555;font-weight:bold");

        // DOM 方式
        if (this._myVideo) {
            //console.log("  清理 DOM 视频对象", this._myVideo.src);
            this._myVideo.pause();
            this._myVideo.src = "";
            this._myVideo.load();
            if (this._myVideo.parentNode) this._myVideo.parentNode.removeChild(this._myVideo);
            this._myVideo = null;
        } else {
            //console.log("  无 DOM 视频需要清理");
        }

        // Sync 方式
        if (this._myVideoSprite) {
            //console.log("  清理 Sync 视频（Sprite + Canvas）", this._myVideoSprite.video.src);
            var v = this._myVideoSprite.video;
            var s = this._myVideoSprite.sprite;
            var b = this._myVideoSprite.bitmap;

            v.pause();
            v.src = "";
            v.load();

            if (s && s.parent) s.parent.removeChild(s);
            if (b) {
                if (b.destroy) b.destroy();
                else if (b.clear) b.clear();
            }

            this._myVideoSprite = null;
        } else {
            //console.log("  无 Sync 视频需要清理");
        }

        //console.log("%c[VideoSprite] 清理完成！", "color:#55ff55;font-weight:bold");
    };

    // 音量同步
    Game_Screen.prototype.updateVideoVolume = function () {
        var vol = ConfigManager.seVolume / 100;
        if (this._myVideo && !this._myVideo._forceMuted) this._myVideo.volume = vol;
        if (this._myVideoSprite && !this._myVideoSprite.video._forceMuted) {
            this._myVideoSprite.video.volume = vol;
        }
    };

    // 更新循环
    var _Game_Screen_update = Game_Screen.prototype.update;
    Game_Screen.prototype.update = function () {
        _Game_Screen_update.call(this);
        this.updateVideoVolume();
    };

    // 选项变化
    var _ConfigManager_applyData = ConfigManager.applyData;
    ConfigManager.applyData = function (config) {
        _ConfigManager_applyData.call(this, config);
        if ($gameScreen) $gameScreen.updateVideoVolume();
    };

    // 场景切换自动清理
    var _SceneManager_changeScene = SceneManager.changeScene;
    SceneManager.changeScene = function () {
        if (this.isSceneChanging() && $gameScreen) {
            //console.log("%c[VideoSprite] 场景切换，自动调用 removeVideoSprite", "color:#aaaa00");
            $gameScreen.removeVideoSprite();
        }
        _SceneManager_changeScene.call(this);
    };

})();