/**
 * 检查当前地图注释是否包含指定的标签
 * @param {Array<string>} tagNames - 标签数组，例如 ['escape', 'forbidden_esc']
 * @returns {Object} - 返回对象，键为标签名（小写），值为布尔（是否包含）
 * 示例使用：
 * var result = checkMapTags(['escape', 'forbidden_esc']);
 * if (result.escape) { $gameMessage.add('允许脱离！'); }
 * if (result['forbidden_esc']) { $gameMessage.add('禁止脱离！'); }
 */
function gl_checkMapTags(tagNames) {
    if (!$dataMap || !$dataMap.note) {
        return {};  // 无地图注释，返回空对象
    }
    
    var notes = $dataMap.note.toLowerCase();  // 转为小写忽略大小写
    var result = {};
    
    for (var i = 0; i < tagNames.length; i++) {
        var tag = tagNames[i].toLowerCase().trim();
        // 正则匹配 <tag> 或 < tag > 等（忽略前后空格）
        var regex = new RegExp('< *' + tag + ' *>', 'i');
        result[tag] = regex.test($dataMap.note);
    }
    
    return result;
}

function gl_containsMapTags(tagName){
	let mapNote = gl_checkMapTags([tagName]);
	return (tagName in mapNote) && true == mapNote[tagName];	
}

function gl_getItemNum(id) {
	let item = $dataItems[id];
	if (!item) return 0;
	return $gameParty.numItems(item);
};

function gl_getWeaponNum(id) {
	let item = $dataWeapons[id];
	if (!item) return 0;
	return $gameParty.numItems(item);
};

function gl_getArmorNum(id) {
	let item = $dataArmors[id];
	if (!item) return 0;
	return $gameParty.numItems(item);
};

function gl_isEnoughItem(id, num = 1) {
	let item = $dataItems[id];
	if (!item) return false;
	return $gameParty.numItems(item) >= num;
};

function gl_isEnoughWeapon(id, num = 1) {
	let item = $dataWeapons[id];
	if (!item) return false;
	return $gameParty.numItems(item) >= num;
};

function gl_isEnoughArmor(id, num = 1) {
	let item = $dataArmors[id];
	if (!item) return false;
	return $gameParty.numItems(item) >= num;
};

var _Scene_Map_onMapLoaded = Scene_Map.prototype.onMapLoaded;
Scene_Map.prototype.onMapLoaded = function() {
    _Scene_Map_onMapLoaded.call(this);
    // 地图完全加载完毕后立即执行公共事件ID=2
    SafeExecutor.try(function() {
		
		//alert($dataMap.note);	
		//if(!gl_containsMapTags('escape'))
		//{
			//$gameVariables.setValue(43, 0); 
			//	;
		//}
		$gameSwitches.setValue(21, true	); 
	});
};
// 覆盖Scene_Load的onLoadSuccess（读档成功后执行）
var _Scene_Load_onLoadSuccess = Scene_Load.prototype.onLoadSuccess;
Scene_Load.prototype.onLoadSuccess = function() {
    _Scene_Load_onLoadSuccess.call(this);
    // 读档成功后立即执行公共事件ID=50
    gl_taskTip={};
};	

