/*:
 * @target MZ
 * @plugindesc タイトル画面の「コンティニュー」で指定したセーブファイルを自動ロード（存在チェック付き）します。
 * @author ChatGPT
 * 
 * @param saveSlotId
 * @text ロードするスロット番号
 * @desc どのセーブスロットを読み込むか（0が1番目、1が2番目…）
 * @type number
 * @default 0
 */

(() => {
  const parameters = PluginManager.parameters("AutoLoadFromTitle");
  const slotId = Number(parameters["saveSlotId"] || 0);

  const Scene_Load_start = Scene_Load.prototype.start;
  Scene_Load.prototype.start = function() {
    Scene_Load_start.call(this);

    // セーブファイルが存在するか確認
    const savefileId = slotId + 1; // savefileId は 1 から始まる（Save01 = 1）
    if (StorageManager.exists(savefileId)) {
      // 存在する場合、自動ロード
      DataManager.loadGame(savefileId)
        .then(success => {
          if (success) {
            this.onLoadSuccess();
          } else {
            this.onLoadFailure();
          }
        })
        .catch(() => {
          this.onLoadFailure();
        });
    } else {
      // 存在しない場合、ロード失敗処理へ
      this.onLoadFailure();
    }
  };

  Scene_Load.prototype.onLoadSuccess = function() {
    SoundManager.playLoad();
    this.fadeOutAll();
    SceneManager.goto(Scene_Map);
    $gameSystem.onAfterLoad();
  };

  Scene_Load.prototype.onLoadFailure = function() {
    SoundManager.playBuzzer();
    SceneManager.goto(Scene_Title);
  };
})();
