/*:
 * @plugindesc MV/MZ両対応 - カスタムウィンドウ生成プラグイン
 * @target MZ
 * @author Onmoremind
 * @url 
 *
 * @help
 *
 * 利用規約：
 *  プラグイン作者に無断で使用、改変、再配布は不可。
 * 
 * 突貫製作の為、バグ等あるかもしれません。
 * ============================================================================
 * プラグインコマンド（MV用）
 * ============================================================================
 * 
 * CustomWindow show ウィンドウID
 *   指定したウィンドウIDのウィンドウを追加表示します
 *   例: CustomWindow show 1
 *
 * CustomWindow hide [ウィンドウID]
 *   ウィンドウを非表示にします（ID省略で全ウィンドウ）
 *
 * CustomWindow close [ウィンドウID]
 *   ウィンドウを閉じます（ID省略で全ウィンドウ、データもクリア）
 *
 * CustomWindow addImage 画像名 リストID
 *   ウィンドウに画像を追加します
 *   例: CustomWindow addImage icon_sword 1
 *
 * CustomWindow clearImages [リストID]
 *   ウィンドウの画像リストをクリアします（0または省略で全クリア）
 *
 * CustomWindow showItem アイテムウィンドウID
 *   アイテム連携ウィンドウを表示します
 *   例: CustomWindow showItem 1
 *
 * CustomWindow hideItem [アイテムウィンドウID]
 *   アイテム連携ウィンドウを非表示にします（ID省略で全ウィンドウ）
 *
 * CustomWindow closeItem [アイテムウィンドウID]
 *   アイテム連携ウィンドウを閉じます（ID省略で全ウィンドウ）
 *
 * CustomWindow showSkillTree スキルツリーID [アクターID]
 *   スキルツリーウィンドウを表示します
 *   アクターIDを省略するとパラメーターで設定したアクターIDを使用
 *   例: CustomWindow showSkillTree skillTree1
 *   例: CustomWindow showSkillTree skillTree1 1 （アクター1番を指定）
 *
 * CustomWindow hideSkillTree [スキルツリーID]
 *   スキルツリーウィンドウを非表示にします（ID省略で全ウィンドウ）
 *
 * CustomWindow closeSkillTree [スキルツリーID]
 *   スキルツリーウィンドウを閉じます（ID省略で全ウィンドウ）
 *
 * CustomWindow loadSharedState
 *   保存されている共通スイッチ・変数を現在のゲームに適用します
 *   「はじめから」選択後のコモンイベント等で使用してください
 *
 * CustomWindow saveSharedState
 *   現在の共通スイッチ・変数をconfig.jsonに保存します
 *
 * ============================================================================
 * セーブ/ロード画面 スロットテキスト要素
 * ============================================================================
 * 
 * スロットテンプレートの「テキスト要素」で使用できる置換文字：
 * 
 *   %s - スロット番号（1, 2, 3...）
 *   %v - 変数ID で指定した変数の値（セーブデータから読み取り）
 * 
 * 設定例：
 *   テキスト: "ファイル %s"  → 「ファイル 1」「ファイル 2」...
 *   テキスト: "セーブ%s"     → 「セーブ1」「セーブ2」...
 *   テキスト: "Lv.%v" + 変数ID: 5 → 「Lv.10」（変数5の値を表示）
 *   テキスト: "No.%s - %v" + 変数ID: 10 → 「No.1 - 勇者」（変数10に名前等）
 * 
 * ※変数の値はセーブ時にglobalInfoに保存されます。
 *   このプラグイン導入後に保存したデータでのみ変数が表示されます。
 *
 * ============================================================================
 * プラグインコマンド（MZ用）
 * ============================================================================
 * 
 * プラグインコマンドを使用してください。
 *
 * ============================================================================
 *
 * @command showWindow
 * @text ウィンドウ表示
 * @desc 指定したウィンドウIDのウィンドウを表示します
 *
 * @arg windowId
 * @text ウィンドウID
 * @type number
 * @min 1
 * @default 1
 * @desc 表示するウィンドウのID（ウィンドウ設定リストの番号）
 *
 * @command hideWindow
 * @text ウィンドウ非表示
 * @desc ウィンドウを非表示にします
 *
 * @arg windowId
 * @text ウィンドウID
 * @type number
 * @min 0
 * @default 0
 * @desc 非表示にするウィンドウのID（0で全ウィンドウ）
 *
 * @command closeWindow
 * @text ウィンドウ閉じる
 * @desc ウィンドウを閉じます（データもクリア）
 *
 * @arg windowId
 * @text ウィンドウID
 * @type number
 * @min 0
 * @default 0
 * @desc 閉じるウィンドウのID（0で全ウィンドウ）
 *
 * @command addImage
 * @text 画像追加
 * @desc ウィンドウに画像を追加します
 *
 * @arg imageName
 * @text 画像名
 * @type file
 * @dir img/pictures
 * @default 
 * @desc 追加する画像のファイル名
 *
 * @arg listId
 * @text リストID
 * @type number
 * @min 1
 * @default 1
 * @desc 追加先の画像リストID
 *
 * @command clearImages
 * @text 画像クリア
 * @desc ウィンドウの画像リストをクリアします
 *
 * @arg listId
 * @text リストID
 * @type number
 * @min 0
 * @default 0
 * @desc クリアする画像リストID（0で全リストクリア）
 *
 * @command showItemWindow
 * @text アイテム連携ウィンドウ表示
 * @desc アイテム連携ウィンドウを表示します
 *
 * @arg windowId
 * @text アイテムウィンドウID
 * @type number
 * @min 1
 * @default 1
 * @desc 表示するアイテム連携ウィンドウのID
 *
 * @command hideItemWindow
 * @text アイテム連携ウィンドウ非表示
 * @desc アイテム連携ウィンドウを非表示にします
 *
 * @arg windowId
 * @text アイテムウィンドウID
 * @type number
 * @min 0
 * @default 0
 * @desc 非表示にするアイテム連携ウィンドウのID（0で全ウィンドウ）
 *
 * @command closeItemWindow
 * @text アイテム連携ウィンドウ閉じる
 * @desc アイテム連携ウィンドウを閉じます（データもクリア）
 *
 * @arg windowId
 * @text アイテムウィンドウID
 * @type number
 * @min 0
 * @default 0
 * @desc 閉じるアイテム連携ウィンドウのID（0で全ウィンドウ）
 *
 * @command showSkillTree
 * @text スキルツリー表示
 * @desc スキルツリーウィンドウを表示します
 *
 * @arg windowId
 * @text ウィンドウID
 * @type text
 * @default skillTree1
 * @desc 表示するスキルツリーウィンドウのID
 *
 * @arg actorId
 * @text アクターID
 * @type actor
 * @default 0
 * @desc 対象アクターのID（0でパラメーター設定を使用）
 *
 * @command hideSkillTree
 * @text スキルツリー非表示
 * @desc スキルツリーウィンドウを非表示にします
 *
 * @arg windowId
 * @text ウィンドウID
 * @type text
 * @default 
 * @desc 非表示にするスキルツリーウィンドウのID（空欄で全て）
 *
 * @command closeSkillTree
 * @text スキルツリー閉じる
 * @desc スキルツリーウィンドウを閉じます（データもクリア）
 *
 * @arg windowId
 * @text ウィンドウID
 * @type text
 * @default 
 * @desc 閉じるスキルツリーウィンドウのID（空欄で全て）
 *
 * @command openSaveScreen
 * @text セーブ画面を開く
 * @desc セーブ画面を開きます
 *
 * @command openLoadScreen
 * @text ロード画面を開く
 * @desc ロード画面を開きます
 *
 * @command registerBasePreset
 * @text 基本プリセット登録
 * @desc ウィンドウ基本プリセットを動的に登録します
 *
 * @arg preset
 * @text プリセット設定
 * @type struct<WindowBasePreset>
 * @default {}
 * @desc 登録する基本プリセットの設定
 *
 * @command registerWindowSettings
 * @text ウィンドウ設定登録
 * @desc ウィンドウ設定リストの項目を動的に登録します
 *
 * @arg windowId
 * @text ウィンドウID
 * @type number
 * @min 1
 * @default 1
 * @desc 登録するウィンドウのID
 *
 * @arg settings
 * @text ウィンドウ設定
 * @type struct<WindowSettings>
 * @default {}
 * @desc ウィンドウ設定リストと同じ形式の設定
 *
 * @command suspendWindow
 * @text ウィンドウ一時停止
 * @desc ウィンドウをフェードアウトして透明化します（イベント呼び出し用）
 *
 * @arg windowId
 * @text ウィンドウID
 * @type number
 * @min 0
 * @default 0
 * @desc 一時停止するウィンドウのID（0で全ウィンドウ）
 *
 * @arg transitionId
 * @text トランジションID
 * @type text
 * @default 
 * @desc 使用するトランジション効果のID（空欄で即時透明化）
 *
 * @command resumeWindow
 * @text ウィンドウ再開
 * @desc 一時停止したウィンドウをフェードインで復帰します
 *
 * @arg windowId
 * @text ウィンドウID
 * @type number
 * @min 0
 * @default 0
 * @desc 再開するウィンドウのID（0で全ウィンドウ）
 *
 * @arg transitionId
 * @text トランジションID
 * @type text
 * @default 
 * @desc 使用するトランジション効果のID（空欄で即時復帰）
 *
 * @command loadSharedState
 * @text 共通スイッチ・変数読み込み
 * @desc 保存されている共通スイッチ・変数を現在のゲームに適用します
 *
 * @command saveSharedState
 * @text 共通スイッチ・変数保存
 * @desc 現在の共通スイッチ・変数をconfig.jsonに保存します
 *
 * @param WindowConfigCategory
 * @text 【各ウィンドウ設定】
 * @desc ウィンドウの設定をまとめたカテゴリ
 *
 * @param WindowBasePresetList
 * @text ウィンドウ基本プリセットリスト
 * @parent WindowConfigCategory
 * @type struct<WindowBasePreset>[]
 * @default []
 * @desc ウィンドウの基本設定（座標、サイズ、背景、余白）のプリセットリスト
 *
 * @param WindowSettingsList
 * @text ウィンドウ設定リスト
 * @parent WindowConfigCategory
 * @type struct<WindowSettings>[]
 * @default []
 * @desc ウィンドウの設定リスト（配列番号がウィンドウIDになります）
 *
 * @param ItemWindowSettingsList
 * @text アイテム連携ウィンドウ設定リスト
 * @parent WindowConfigCategory
 * @type struct<ItemWindowSettings>[]
 * @default []
 * @desc アイテム所持数と連携するウィンドウの設定リスト
 *
 * @param SkillTreeWindowList
 * @text スキルツリーウィンドウリスト
 * @parent WindowConfigCategory
 * @type struct<SkillTreeWindowSettings>[]
 * @default []
 * @desc スキルツリーウィンドウの設定リスト
 *
 * @param SaveLoadCategory
 * @text 【セーブ＆ロード画面設定】
 * @desc セーブ/ロード画面のカスタム設定
 *
 * @param screenshotQuality
 * @text スクリーンショット画質
 * @parent SaveLoadCategory
 * @type number
 * @min 0.1
 * @max 1.0
 * @decimals 2
 * @default 0.92
 * @desc スクリーンショットの保存画質（0.1〜1.0、高いほど高画質だがサイズ大）
 *
 * @param screenshotFormat
 * @text スクリーンショット形式
 * @parent SaveLoadCategory
 * @type select
 * @option JPEG（小サイズ）
 * @value jpeg
 * @option PNG（高画質）
 * @value png
 * @default jpeg
 * @desc スクリーンショットの保存形式
 *
 * @param CommonSlotTemplate
 * @text 共通スロット設定
 * @parent SaveLoadCategory
 * @type struct<SlotTemplate>
 * @default {}
 * @desc セーブ/ロード共通のスロットテンプレート設定
 *
 * @param SaveScreenSettings
 * @text セーブ画面設定
 * @parent SaveLoadCategory
 * @type struct<SaveScreenSettings>
 * @default {"enabled":"false","sceneBackgroundImage":"","x":"0","y":"0","width":"816","height":"624","windowImage":"","useImageSize":"true","windowPaddingTop":"0","windowPaddingBottom":"0","windowPaddingLeft":"0","windowPaddingRight":"0","hideDefaultWindows":"false","scrollBarId":"","textElements":"[]","buttonElements":"[]"}
 * @desc セーブ画面のカスタム設定（背景、位置、テキスト、ボタン）
 *
 * @param LoadScreenSettings
 * @text ロード画面設定（メニューから）
 * @parent SaveLoadCategory
 * @type struct<LoadScreenSettings>
 * @default {"enabled":"false","sceneBackgroundImage":"","x":"0","y":"0","width":"816","height":"624","windowImage":"","useImageSize":"true","windowPaddingTop":"0","windowPaddingBottom":"0","windowPaddingLeft":"0","windowPaddingRight":"0","hideDefaultWindows":"false","scrollBarId":"","textElements":"[]","buttonElements":"[]"}
 * @desc メニューからのロード画面のカスタム設定
 *
 * @param TitleLoadScreenSettings
 * @text ロード画面設定（タイトルから）
 * @parent SaveLoadCategory
 * @type struct<LoadScreenSettings>
 * @default {"enabled":"false","sceneBackgroundImage":"","x":"0","y":"0","width":"816","height":"624","windowImage":"","useImageSize":"true","windowPaddingTop":"0","windowPaddingBottom":"0","windowPaddingLeft":"0","windowPaddingRight":"0","hideDefaultWindows":"false","scrollBarId":"","textElements":"[]","buttonElements":"[]"}
 * @desc タイトル画面からのロード画面のカスタム設定
 *
 * @param SharedDataCategory
 * @text 【共有スイッチ・変数】
 * @desc セーブデータ間で共有する変数・スイッチの設定
 *
 * @param SharedVariableStartId
 * @text 共有変数ID(開始)
 * @parent SharedDataCategory
 * @type variable
 * @default 0
 * @desc 範囲で共有する変数の開始ID
 *
 * @param SharedVariableEndId
 * @text 共有変数ID(終了)
 * @parent SharedDataCategory
 * @type variable
 * @default 0
 * @desc 範囲で共有する変数の終了ID
 *
 * @param SharedVariableList
 * @text 共有変数リスト
 * @parent SharedDataCategory
 * @type variable[]
 * @default []
 * @desc 個別に共有したい変数IDのリスト
 *
 * @param SharedSwitchStartId
 * @text 共有スイッチID(開始)
 * @parent SharedDataCategory
 * @type switch
 * @default 0
 * @desc 範囲で共有するスイッチの開始ID
 *
 * @param SharedSwitchEndId
 * @text 共有スイッチID(終了)
 * @parent SharedDataCategory
 * @type switch
 * @default 0
 * @desc 範囲で共有するスイッチの終了ID
 *
 * @param SharedSwitchList
 * @text 共有スイッチリスト
 * @parent SharedDataCategory
 * @type switch[]
 * @default []
 * @desc 個別に共有したいスイッチIDのリスト
 *
 * @param ButtonEffectSettings
 * @text ホバー＆クリック時
 * @desc ボタンのホバー・クリック時のエフェクト設定
 *
 * @param HoverScaleX
 * @text ホバー時スケールX
 * @parent ButtonEffectSettings
 * @type number
 * @decimals 2
 * @min 0.01
 * @default 1.00
 * @desc ホバー時のX方向スケール（1.00=等倍、1.10=110%）
 *
 * @param HoverScaleY
 * @text ホバー時スケールY
 * @parent ButtonEffectSettings
 * @type number
 * @decimals 2
 * @min 0.01
 * @default 1.00
 * @desc ホバー時のY方向スケール（1.00=等倍、1.10=110%）
 *
 * @param HoverOffsetX
 * @text ホバー時オフセットX
 * @parent ButtonEffectSettings
 * @type number
 * @min -9999
 * @default 0
 * @desc ホバー時のX座標オフセット
 *
 * @param HoverOffsetY
 * @text ホバー時オフセットY
 * @parent ButtonEffectSettings
 * @type number
 * @min -9999
 * @default 0
 * @desc ホバー時のY座標オフセット
 *
 * @param PressScaleX
 * @text クリック時スケールX
 * @parent ButtonEffectSettings
 * @type number
 * @decimals 2
 * @min 0.01
 * @default 0.95
 * @desc クリック押下時のX方向スケール（1.00=等倍、0.95=95%）
 *
 * @param PressScaleY
 * @text クリック時スケールY
 * @parent ButtonEffectSettings
 * @type number
 * @decimals 2
 * @min 0.01
 * @default 0.95
 * @desc クリック押下時のY方向スケール（1.00=等倍、0.95=95%）
 *
 * @param PressOffsetX
 * @text クリック時オフセットX
 * @parent ButtonEffectSettings
 * @type number
 * @min -9999
 * @default 0
 * @desc クリック押下時のX座標オフセット
 *
 * @param PressOffsetY
 * @text クリック時オフセットY
 * @parent ButtonEffectSettings
 * @type number
 * @min -9999
 * @default 2
 * @desc クリック押下時のY座標オフセット
 *
 * @param UseEasing
 * @text イージング有効
 * @parent ButtonEffectSettings
 * @type boolean
 * @default true
 * @desc エフェクトにイージングアニメーションを使用するか
 *
 * @param EasingDuration
 * @text イージング時間
 * @parent ButtonEffectSettings
 * @type number
 * @min 1
 * @max 60
 * @default 8
 * @desc イージングにかかるフレーム数（1-60）
 *
 * @param EasingType
 * @text イージングタイプ
 * @parent ButtonEffectSettings
 * @type select
 * @option リニア（等速）
 * @value linear
 * @option イーズアウト（減速）
 * @value easeOut
 * @option イーズイン（加速）
 * @value easeIn
 * @option イーズインアウト（加減速）
 * @value easeInOut
 * @option バウンス
 * @value bounce
 * @option エラスティック（弾性）
 * @value elastic
 * @default easeOut
 * @desc イージングの種類
 *
 * @param ScrollSettings
 * @text 【スクロール設定】
 * @desc スクロールの共通設定
 *
 * @param ScrollBarSettingsList
 * @text スクロールバー設定リスト
 * @parent ScrollSettings
 * @type struct<ScrollBarSettings>[]
 * @default []
 * @desc スクロールバーの設定リスト（IDで各ウィンドウから参照）
 *
 * @param ScrollSpeed
 * @text スクロール速度
 * @parent ScrollSettings
 * @type number
 * @min 1
 * @default 20
 * @desc スクロール速度（ピクセル/フレーム）
 *
 * @param WindowAppearance
 * @text ウィンドウ外観
 * @desc ウィンドウの外観設定
 *
 * @param WindowOpacity
 * @text 不透明度
 * @parent WindowAppearance
 * @type number
 * @min 0
 * @max 255
 * @default 255
 * @desc ウィンドウの不透明度（0-255）
 *
 * @param BackOpacity
 * @text 背景不透明度
 * @parent WindowAppearance
 * @type number
 * @min 0
 * @max 255
 * @default 192
 * @desc ウィンドウ背景の不透明度（0-255）
 *
 * @param FontSettings
 * @text 【フォント設定】
 * @desc カスタムフォントの登録設定
 *
 * @param TextPresets
 * @text テキストプリセットリスト
 * @parent FontSettings
 * @type struct<TextPreset>[]
 * @default []
 * @desc テキスト表示のプリセット設定（フォント、サイズ、配置をまとめて設定）
 *
 * @param TransitionSettings
 * @text シーン変遷設定
 * @desc シーン変遷時のトランジション効果の登録
 *
 * @param TransitionList
 * @text トランジションリスト
 * @parent TransitionSettings
 * @type struct<TransitionEffect>[]
 * @default []
 * @desc 使用するトランジション効果を登録
 *
 */

/*~struct~WindowSettings:
 * @param basePresetId
 * @text 基本プリセットID
 * @type text
 * @default 
 * @desc 使用するウィンドウ基本プリセットのID（必須）
 *
 * @param textElements
 * @text テキスト要素リスト
 * @type struct<WindowTextElement>[]
 * @default []
 * @desc ウィンドウに表示するテキスト要素リスト（複数のテキストを個別位置に表示可能）
 *
 * @param imageList
 * @text 画像リスト
 * @type struct<ImageColumn>[]
 * @default []
 * @desc 表示する画像リスト（各要素が1列として表示）
 *
 * @param imageOffsetX
 * @text 画像Xオフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc 画像リストのX座標オフセット
 *
 * @param imageOffsetY
 * @text 画像Yオフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc 画像リストのY座標オフセット
 *
 * @param imageSpacingX
 * @text 列間余白（横）
 * @type number
 * @min 0
 * @default 4
 * @desc リスト間（列方向）の余白（ピクセル）
 *
 * @param imageSpacingY
 * @text 行間余白（縦）
 * @type number
 * @min 0
 * @default 4
 * @desc リスト内の画像間（縦方向）の余白（ピクセル）
 *
 * @param useDisabledImages
 * @text 条件不成立画像を使用
 * @type boolean
 * @default true
 * @desc ONで条件不成立画像を使用、OFFで黒フィルターを適用
 *
 * @param disabledFilterOpacity
 * @text 黒フィルター不透明度
 * @type number
 * @min 0
 * @max 255
 * @default 128
 * @desc 条件不成立時の黒フィルターの不透明度（0-255）
 *
 * @param closeSettings
 * @text 終了設定
 * @type struct<CloseSettings>
 * @default {"closeButtonImage":"","closeButtonX":"0","closeButtonY":"0","showConfirmation":"false","confirmBackgroundImage":"","confirmYesImage":"","confirmYesHoverImage":"","confirmYesX":"0","confirmYesY":"0","confirmNoImage":"","confirmNoHoverImage":"","confirmNoX":"0","confirmNoY":"0"}
 * @desc ウィンドウを閉じるボタンと確認の設定
 *
 * @param scrollBarId
 * @text スクロールバーID
 * @type text
 * @default 
 * @desc 使用するスクロールバー設定のID（空欄でデフォルト設定を使用）
 *
 * @param transitionId
 * @text トランジションID
 * @type text
 * @default 
 * @desc 使用するトランジション効果のID名（空欄で即時表示）
 *
 * @param allowPlayerMovement
 * @text プレイヤー操作許可
 * @type boolean
 * @on 許可
 * @off 禁止
 * @default false
 * @desc ウィンドウ表示中にプレイヤーの移動やイベント起動を許可するか
 */

/*~struct~WindowBasePreset:
 * @param id
 * @text プリセットID
 * @type text
 * @default preset1
 * @desc このプリセットを識別するID（他の設定から参照用）
 *
 * @param x
 * @text X座標
 * @type number
 * @min 0
 * @default 100
 * @desc ウィンドウのX座標
 *
 * @param y
 * @text Y座標
 * @type number
 * @min 0
 * @default 100
 * @desc ウィンドウのY座標
 *
 * @param width
 * @text 幅
 * @type number
 * @min 1
 * @default 300
 * @desc ウィンドウの幅（背景画像指定時は自動計算可）
 *
 * @param height
 * @text 高さ
 * @type number
 * @min 1
 * @default 150
 * @desc ウィンドウの高さ（背景画像指定時は自動計算可）
 *
 * @param backgroundImage
 * @text 背景画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ウィンドウ背景に使用する画像
 *
 * @param useImageSize
 * @text 画像サイズを使用
 * @type boolean
 * @on 使用する
 * @off 使用しない
 * @default true
 * @desc 背景画像のサイズをウィンドウサイズとして使用する
 *
 * @param paddingTop
 * @text 余白（上）
 * @type number
 * @min 0
 * @default 18
 * @desc ウィンドウ上部の余白
 *
 * @param paddingBottom
 * @text 余白（下）
 * @type number
 * @min 0
 * @default 18
 * @desc ウィンドウ下部の余白
 *
 * @param paddingLeft
 * @text 余白（左）
 * @type number
 * @min 0
 * @default 18
 * @desc ウィンドウ左側の余白
 *
 * @param paddingRight
 * @text 余白（右）
 * @type number
 * @min 0
 * @default 18
 * @desc ウィンドウ右側の余白
 *
 * @param sceneBackgroundImage
 * @text シーン背景画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ウィンドウの後ろに表示する背景画像（画面全体に表示）
 *
 * @param priorityType
 * @text プライオリティタイプ
 * @type select
 * @option フェードより上（デフォルト）
 * @value aboveFade
 * @option ピクチャと同じ
 * @value samePicture
 * @default aboveFade
 * @desc ウィンドウの表示優先度
 *
 * @param pictureId
 * @text ピクチャID
 * @type number
 * @min 1
 * @max 100
 * @default 50
 * @desc プライオリティタイプが「ピクチャと同じ」の時に使用するID
 *
 * @param hoverSE
 * @text 選択時SE
 * @type file
 * @dir audio/se
 * @default 
 * @desc ボタンにホバー（マウスオーバーまたはキーボード選択）した時に再生するSE
 *
 * @param hoverSEVolume
 * @text 選択時SE音量
 * @type number
 * @min 0
 * @max 100
 * @default 90
 * @desc 選択時SEの音量（0-100）
 *
 * @param hoverSEPitch
 * @text 選択時SEピッチ
 * @type number
 * @min 50
 * @max 150
 * @default 100
 * @desc 選択時SEのピッチ（50-150）
 *
 * @param clickSE
 * @text 決定時SE
 * @type file
 * @dir audio/se
 * @default 
 * @desc ボタンをクリック（決定）した時に再生するSE
 *
 * @param clickSEVolume
 * @text 決定時SE音量
 * @type number
 * @min 0
 * @max 100
 * @default 90
 * @desc 決定時SEの音量（0-100）
 *
 * @param clickSEPitch
 * @text 決定時SEピッチ
 * @type number
 * @min 50
 * @max 150
 * @default 100
 * @desc 決定時SEのピッチ（50-150）
 *
 * @param disabledSE
 * @text 条件不成立SE
 * @type file
 * @dir audio/se
 * @default 
 * @desc 条件不成立のボタンをクリックした時に再生するSE（空欄でブザーSE）
 *
 * @param disabledSEVolume
 * @text 条件不成立SE音量
 * @type number
 * @min 0
 * @max 100
 * @default 90
 * @desc 条件不成立SEの音量（0-100）
 *
 * @param disabledSEPitch
 * @text 条件不成立SEピッチ
 * @type number
 * @min 50
 * @max 150
 * @default 100
 * @desc 条件不成立SEのピッチ（50-150）
 */

/*~struct~WindowTextElement:
 * @param text
 * @text テキスト
 * @type multiline_string
 * @default 
 * @desc 表示するテキスト（制御文字使用可能）
 *
 * @param x
 * @text X座標
 * @type number
 * @min -9999
 * @default 0
 * @desc テキストのX座標
 *
 * @param y
 * @text Y座標
 * @type number
 * @min -9999
 * @default 0
 * @desc テキストのY座標
 *
 * @param width
 * @text 幅
 * @type number
 * @min 0
 * @default 200
 * @desc テキスト描画エリアの幅（0で自動）
 *
 * @param textAlign
 * @text 文字揃え
 * @type select
 * @option 左揃え
 * @value left
 * @option 中央揃え
 * @value center
 * @option 右揃え
 * @value right
 * @default left
 * @desc テキストの配置
 *
 * @param textPresetId
 * @text テキストプリセットID
 * @type text
 * @default 
 * @desc 使用するテキストプリセットのID（空欄で個別設定を使用）
 *
 * @param fontSize
 * @text フォントサイズ（個別）
 * @type number
 * @min 0
 * @default 0
 * @desc 個別のフォントサイズ（0でプリセット/ウィンドウ設定を使用）
 *
 * @param textColor
 * @text 文字色（個別）
 * @type text
 * @default 
 * @desc テキストの色（空欄でプリセット/ウィンドウ設定を使用、#RRGGBB形式）
 *
 * @param outlineColor
 * @text 縁取り色（個別）
 * @type text
 * @default 
 * @desc テキスト縁取りの色（空欄でプリセット/ウィンドウ設定を使用、#RRGGBB形式）
 *
 * @param outlineWidth
 * @text 縁取り幅（個別）
 * @type number
 * @min -1
 * @max 20
 * @default -1
 * @desc テキスト縁取りの幅（-1でプリセット/ウィンドウ設定を使用）
 *
 * @param variableId
 * @text 変数ID
 * @type variable
 * @default 0
 * @desc テキスト内の%vを置き換える変数ID（0で使用しない）
 */

/*~struct~ImageColumn:
 * @param items
 * @text 画像アイテムリスト
 * @type struct<ImageItem>[]
 * @default []
 * @desc この列に表示する画像アイテム（上から下へ）
 */

/*~struct~ImageItem:
 * @param baseSettings
 * @text 土台設定
 * @type struct<BaseImageSettings>
 * @default {"baseImage":"","baseImageDisabled":"","condition":"{\"switchId\":\"0\",\"switchValue\":\"true\",\"variableConditions\":\"[]\"}"}
 * @desc 土台画像と条件の設定
 *
 * @param overlaySettings
 * @text 追加画像設定
 * @type struct<OverlayImageSettings>
 * @default {"overlayImage":"","overlayImageDisabled":"","condition":"{\"switchId\":\"0\",\"switchValue\":\"true\",\"variableConditions\":\"[]\"}"}
 * @desc 追加画像と条件の設定
 *
 * @param buttonSettings
 * @text ボタン設定
 * @type struct<ButtonImageSettings>
 * @default {"buttonImage":"","buttonImageDisabled":"","buttonHoverImage":"","buttonOffsetX":"0","buttonOffsetY":"0","commonEventId":"0","condition":"{\"switchId\":\"0\",\"switchValue\":\"true\",\"variableConditions\":\"[]\"}"}
 * @desc ボタン画像と条件の設定
 *
 * @param textList
 * @text 表示テキストリスト
 * @type struct<TextItem>[]
 * @default []
 * @desc この画像アイテムに表示するテキスト
 */

/*~struct~TextItem:
 * @param text
 * @text テキスト内容
 * @type multiline_string
 * @default 
 * @desc 表示するテキスト（制御文字使用可能）
 *
 * @param x
 * @text X座標
 * @type number
 * @min -9999
 * @default 0
 * @desc テキストのX座標（土台画像からの相対位置）
 *
 * @param y
 * @text Y座標
 * @type number
 * @min -9999
 * @default 0
 * @desc テキストのY座標（土台画像からの相対位置）
 *
 * @param width
 * @text 幅
 * @type number
 * @min 1
 * @default 200
 * @desc テキスト描画エリアの幅
 *
 * @param align
 * @text 揃え
 * @type select
 * @option 左揃え
 * @value left
 * @option 中央揃え
 * @value center
 * @option 右揃え
 * @value right
 * @default left
 * @desc テキストの揃え方向
 *
 * @param fontSize
 * @text フォントサイズ
 * @type number
 * @min 1
 * @default 26
 * @desc フォントサイズ（0でデフォルト）
 *
 * @param textColor
 * @text テキスト色
 * @type text
 * @default #ffffff
 * @desc テキストの色（CSS色指定）
 *
 * @param outlineColor
 * @text 縁取り色
 * @type text
 * @default #000000
 * @desc 縁取りの色（CSS色指定）
 *
 * @param outlineWidth
 * @text 縁取り幅
 * @type number
 * @min 0
 * @default 4
 * @desc 縁取りの幅（0で縁取りなし）
 *
 * @param condition
 * @text 条件設定
 * @type struct<ConditionSettings>
 * @default {"switchId":"0","switchValue":"true","variableConditions":"[]"}
 * @desc このテキストの表示条件
 */

/*~struct~CustomFont:
 * @param fontName
 * @text フォント名
 * @type text
 * @default CustomFont1
 * @desc ウィンドウ設定で指定する際のフォント識別名
 *
 * @param fontFile
 * @text フォントファイル
 * @type text
 * @default myfont.ttf
 * @desc fonts/フォルダ内のフォントファイル名（.ttf, .otf, .woff等）
 */

/*~struct~TextPreset:
 * @param presetId
 * @text プリセットID
 * @type text
 * @default preset1
 * @desc このテキストプリセットの識別名
 *
 * @param fontName
 * @text 使用フォント
 * @type text
 * @default 
 * @desc カスタムフォントリストで登録したフォント名（空欄でデフォルト）
 *
 * @param fontSize
 * @text フォントサイズ
 * @type number
 * @min 1
 * @max 200
 * @default 26
 * @desc テキストのフォントサイズ
 *
 * @param textColor
 * @text 文字色
 * @type text
 * @default #ffffff
 * @desc テキストの色（#RRGGBB形式）
 *
 * @param outlineColor
 * @text 縁取り色
 * @type text
 * @default #000000
 * @desc テキスト縁取りの色（#RRGGBB形式）
 *
 * @param outlineWidth
 * @text 縁取り幅
 * @type number
 * @min 0
 * @max 20
 * @default 4
 * @desc テキスト縁取りの幅（0で縁取りなし）
 */

/*~struct~TransitionEffect:
 * @param transitionId
 * @text トランジションID
 * @type text
 * @default transition1
 * @desc このトランジション効果の識別名
 *
 * @param transitionImage
 * @text トランジション画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc トランジション効果に使用する画像（空欄でフェードのみ）
 *
 * @param fadeOutDuration
 * @text フェードアウト時間
 * @type number
 * @min 1
 * @max 300
 * @default 30
 * @desc フェードアウトにかかるフレーム数（60=1秒）
 *
 * @param fadeInDuration
 * @text フェードイン時間
 * @type number
 * @min 1
 * @max 300
 * @default 30
 * @desc フェードインにかかるフレーム数（60=1秒）
 *
 * @param fadeOutReverse
 * @text フェードアウト反転
 * @type boolean
 * @on 明→暗（反転）
 * @off 暗→明（通常）
 * @default false
 * @desc ONで明るい部分から先に黒くなる、OFFで暗い部分から先に黒くなる
 *
 * @param fadeInReverse
 * @text フェードイン反転
 * @type boolean
 * @on 暗→明（反転）
 * @off 明→暗（通常）
 * @default false
 * @desc ONで暗い部分から先に明るくなる、OFFで明るい部分から先に明るくなる
 *
 * @param fadeColor
 * @text フェード色
 * @type text
 * @default #000000
 * @desc フェード時の色（#RRGGBB形式）
 */

/*~struct~ScrollBarSettings:
 * @param id
 * @text スクロールバーID
 * @type text
 * @default scrollbar1
 * @desc このスクロールバー設定の識別ID
 *
 * @param width
 * @text バー幅
 * @type number
 * @min 4
 * @default 12
 * @desc スクロールバーの幅（ピクセル）
 *
 * @param color
 * @text バー色
 * @type text
 * @default #ffffff
 * @desc スクロールバーの色（スキン画像未設定時）
 *
 * @param bgColor
 * @text 背景色
 * @type text
 * @default #000000
 * @desc スクロールバー背景の色（スキン画像未設定時）
 *
 * @param skinTop
 * @text 上部画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc スクロールバーの上部画像
 *
 * @param skinMiddle
 * @text 中央画像（伸縮）
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc スクロールバーの中央部分（縦に伸縮される）
 *
 * @param skinBottom
 * @text 下部画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc スクロールバーの下部画像
 *
 * @param skinBg
 * @text 背景画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc スクロールバーの背景画像（縦に伸縮される）
 *
 * @param offsetX
 * @text Xオフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc スクロールバーのX座標オフセット
 */

/*~struct~SaveScreenSettings:
 * @param enabled
 * @text 有効
 * @type boolean
 * @on 有効
 * @off 無効
 * @default false
 * @desc このカスタムセーブ画面を有効にするか
 *
 * @param sceneBackgroundImage
 * @text シーン背景画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 画面全体の背景画像（省略でデフォルト背景）
 *
 * @param x
 * @text ウィンドウX座標
 * @type number
 * @min -9999
 * @default 0
 * @desc ウィンドウのX座標
 *
 * @param y
 * @text ウィンドウY座標
 * @type number
 * @min -9999
 * @default 0
 * @desc ウィンドウのY座標
 *
 * @param width
 * @text ウィンドウ幅
 * @type number
 * @min 1
 * @default 816
 * @desc ウィンドウの幅（ウィンドウ画像使用時は自動）
 *
 * @param height
 * @text ウィンドウ高さ
 * @type number
 * @min 1
 * @default 624
 * @desc ウィンドウの高さ（ウィンドウ画像使用時は自動）
 *
 * @param windowImage
 * @text ウィンドウ画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ウィンドウの背景画像
 *
 * @param useImageSize
 * @text 画像サイズを使用
 * @type boolean
 * @on 使用する
 * @off 使用しない
 * @default true
 * @desc ウィンドウ画像のサイズをウィンドウサイズとして使用する
 *
 * @param windowPaddingTop
 * @text 余白（上）
 * @type number
 * @min 0
 * @default 0
 * @desc ウィンドウ内の上余白
 *
 * @param windowPaddingBottom
 * @text 余白（下）
 * @type number
 * @min 0
 * @default 0
 * @desc ウィンドウ内の下余白
 *
 * @param windowPaddingLeft
 * @text 余白（左）
 * @type number
 * @min 0
 * @default 0
 * @desc ウィンドウ内の左余白
 *
 * @param windowPaddingRight
 * @text 余白（右）
 * @type number
 * @min 0
 * @default 0
 * @desc ウィンドウ内の右余白
 *
 * @param hideDefaultWindows
 * @text 標準ウィンドウ非表示
 * @type boolean
 * @on 非表示
 * @off 表示
 * @default false
 * @desc 標準のセーブ/ロードウィンドウを非表示にするか
 *
 * @param scrollBarId
 * @text スクロールバーID
 * @type text
 * @default 
 * @desc 使用するスクロールバー設定のID（空欄でデフォルト設定を使用）
 *
 * @param textElements
 * @text テキスト要素
 * @type struct<SaveLoadTextElement>[]
 * @default []
 * @desc 表示するテキスト要素（タイトル等）
 *
 * @param buttonElements
 * @text ボタン要素
 * @type struct<SaveLoadButtonElement>[]
 * @default []
 * @desc 表示するボタン要素
 */

/*~struct~LoadScreenSettings:
 * @param enabled
 * @text 有効
 * @type boolean
 * @on 有効
 * @off 無効
 * @default false
 * @desc このカスタムロード画面を有効にするか
 *
 * @param sceneBackgroundImage
 * @text シーン背景画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 画面全体の背景画像（省略でデフォルト背景）
 *
 * @param x
 * @text ウィンドウX座標
 * @type number
 * @min -9999
 * @default 0
 * @desc ウィンドウのX座標
 *
 * @param y
 * @text ウィンドウY座標
 * @type number
 * @min -9999
 * @default 0
 * @desc ウィンドウのY座標
 *
 * @param width
 * @text ウィンドウ幅
 * @type number
 * @min 1
 * @default 816
 * @desc ウィンドウの幅（ウィンドウ画像使用時は自動）
 *
 * @param height
 * @text ウィンドウ高さ
 * @type number
 * @min 1
 * @default 624
 * @desc ウィンドウの高さ（ウィンドウ画像使用時は自動）
 *
 * @param windowImage
 * @text ウィンドウ画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ウィンドウの背景画像
 *
 * @param useImageSize
 * @text 画像サイズを使用
 * @type boolean
 * @on 使用する
 * @off 使用しない
 * @default true
 * @desc ウィンドウ画像のサイズをウィンドウサイズとして使用する
 *
 * @param windowPaddingTop
 * @text 余白（上）
 * @type number
 * @min 0
 * @default 0
 * @desc ウィンドウ内の上余白
 *
 * @param windowPaddingBottom
 * @text 余白（下）
 * @type number
 * @min 0
 * @default 0
 * @desc ウィンドウ内の下余白
 *
 * @param windowPaddingLeft
 * @text 余白（左）
 * @type number
 * @min 0
 * @default 0
 * @desc ウィンドウ内の左余白
 *
 * @param windowPaddingRight
 * @text 余白（右）
 * @type number
 * @min 0
 * @default 0
 * @desc ウィンドウ内の右余白
 *
 * @param hideDefaultWindows
 * @text 標準ウィンドウ非表示
 * @type boolean
 * @on 非表示
 * @off 表示
 * @default false
 * @desc 標準のセーブ/ロードウィンドウを非表示にするか
 *
 * @param scrollBarId
 * @text スクロールバーID
 * @type text
 * @default 
 * @desc 使用するスクロールバー設定のID（空欄でデフォルト設定を使用）
 *
 * @param textElements
 * @text テキスト要素
 * @type struct<SaveLoadTextElement>[]
 * @default []
 * @desc 表示するテキスト要素（タイトル等）
 *
 * @param buttonElements
 * @text ボタン要素
 * @type struct<SaveLoadButtonElement>[]
 * @default []
 * @desc 表示するボタン要素
 */

/*~struct~SlotTemplate:
 * @param slotCount
 * @text スロット数
 * @type number
 * @min 1
 * @default 20
 * @desc 表示するセーブスロットの数
 *
 * @param startSlotId
 * @text 開始スロット番号
 * @type number
 * @min 1
 * @default 1
 * @desc 最初のスロット番号（通常は1）
 *
 * @param columns
 * @text 列数
 * @type number
 * @min 1
 * @default 1
 * @desc スロットを並べる列数（1=縦一列、2=2列並び）
 *
 * @param x
 * @text 開始X座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 最初のスロットのX座標
 *
 * @param y
 * @text 開始Y座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 最初のスロットのY座標
 *
 * @param offsetX
 * @text Xオフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc 次のスロットへのX方向オフセット（列が変わる時）
 *
 * @param offsetY
 * @text スロット間隔
 * @type number
 * @min 0
 * @default 10
 * @desc スロット同士の縦方向の間隔（ピクセル）
 *
 * @param width
 * @text スロット幅
 * @type number
 * @min 1
 * @default 300
 * @desc 各スロットの幅
 *
 * @param height
 * @text スロット高さ
 * @type number
 * @min 1
 * @default 80
 * @desc 各スロットの高さ
 *
 * @param backgroundImage
 * @text 背景画像（空）
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 未使用スロットの背景画像
 *
 * @param backgroundImageUsed
 * @text 背景画像（使用中）
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 使用中スロットの背景画像
 *
 * @param backgroundImageSelected
 * @text 背景画像（選択中）
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 選択中スロットの背景画像
 *
 * @param selectionFrameImage
 * @text 選択フレーム画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 選択中スロットに表示するフレーム画像（背景画像の上に表示）
 *
 * @param selectionFrameOffsetX
 * @text 選択フレームX座標オフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc 選択フレーム画像のX座標オフセット
 *
 * @param selectionFrameOffsetY
 * @text 選択フレームY座標オフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc 選択フレーム画像のY座標オフセット
 *
 * @param showPlaytime
 * @text プレイ時間表示
 * @type boolean
 * @on 表示
 * @off 非表示
 * @default true
 * @desc プレイ時間を表示するか
 *
 * @param playtimeX
 * @text プレイ時間X座標
 * @type number
 * @min -9999
 * @default 10
 * @desc プレイ時間のX座標（スロット内相対）
 *
 * @param playtimeY
 * @text プレイ時間Y座標
 * @type number
 * @min -9999
 * @default 10
 * @desc プレイ時間のY座標（スロット内相対）
 *
 * @param playtimeScaleX
 * @text プレイ時間横幅スケール
 * @type number
 * @decimals 2
 * @min 0.1
 * @max 10.0
 * @default 1.0
 * @desc プレイ時間テキストの横幅倍率（1.0=通常、1.5=1.5倍に横伸び）
 *
 * @param showTimestamp
 * @text タイムスタンプ表示
 * @type boolean
 * @on 表示
 * @off 非表示
 * @default true
 * @desc セーブ日時を表示するか
 *
 * @param timestampX
 * @text タイムスタンプX座標
 * @type number
 * @min -9999
 * @default 10
 * @desc タイムスタンプのX座標（スロット内相対）
 *
 * @param timestampY
 * @text タイムスタンプY座標
 * @type number
 * @min -9999
 * @default 30
 * @desc タイムスタンプのY座標（スロット内相対）
 *
 * @param timestampScaleX
 * @text タイムスタンプ横幅スケール
 * @type number
 * @decimals 2
 * @min 0.1
 * @max 10.0
 * @default 1.0
 * @desc タイムスタンプテキストの横幅倍率（1.0=通常、1.5=1.5倍に横伸び）
 *
 * @param timestampSplit
 * @text タイムスタンプ2段表示
 * @type boolean
 * @on 2段表示
 * @off 1段表示
 * @default false
 * @desc タイムスタンプを年月日と時間の2段に分けて表示
 *
 * @param timestampLineHeight
 * @text タイムスタンプ行間
 * @type number
 * @min 0
 * @default 24
 * @desc 2段表示時の行間（ピクセル）
 *
 * @param showScreenshot
 * @text スクリーンショット表示
 * @type boolean
 * @on 表示
 * @off 非表示
 * @default false
 * @desc セーブ時のスクリーンショットを表示するか
 *
 * @param screenshotX
 * @text スクリーンショットX座標
 * @type number
 * @min -9999
 * @default 0
 * @desc スクリーンショットのX座標（スロット内相対）
 *
 * @param screenshotY
 * @text スクリーンショットY座標
 * @type number
 * @min -9999
 * @default 0
 * @desc スクリーンショットのY座標（スロット内相対）
 *
 * @param screenshotWidth
 * @text スクリーンショット幅
 * @type number
 * @min 1
 * @default 144
 * @desc スクリーンショットの表示幅
 *
 * @param screenshotHeight
 * @text スクリーンショット高さ
 * @type number
 * @min 1
 * @default 81
 * @desc スクリーンショットの表示高さ
 *
 * @param textPresetId
 * @text テキストプリセットID
 * @type text
 * @default 
 * @desc 使用するテキストプリセットのID
 *
 * @param textElements
 * @text テキスト要素リスト
 * @type struct<SlotTextElement>[]
 * @default []
 * @desc スロット内に表示するテキスト要素（セーブデータの変数も表示可能）
 *
 * @param gaugeElements
 * @text ゲージ要素リスト
 * @type struct<SlotGaugeElement>[]
 * @default []
 * @desc スロット内に表示するゲージ（セーブデータの変数から値を取得）
 */

/*~struct~SlotGaugeElement:
 * @param x
 * @text X座標
 * @type number
 * @min -9999
 * @default 0
 * @desc ゲージのX座標（スロット内相対）
 *
 * @param y
 * @text Y座標
 * @type number
 * @min -9999
 * @default 0
 * @desc ゲージのY座標（スロット内相対）
 *
 * @param backgroundImage
 * @text ゲージ下地画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ゲージの下地画像（img/customwindow/）
 *
 * @param gaugeImage
 * @text ゲージ画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ゲージ本体の画像（img/customwindow/）
 *
 * @param currentVariableId
 * @text 現在値変数ID
 * @type variable
 * @default 1
 * @desc 現在値を格納している変数ID
 *
 * @param maxVariableId
 * @text 最大値変数ID
 * @type variable
 * @default 2
 * @desc 最大値を格納している変数ID
 *
 * @param direction
 * @text 伸縮方向
 * @type select
 * @option 左から右
 * @value horizontal
 * @option 下から上
 * @value vertical
 * @default horizontal
 * @desc ゲージの伸縮方向
 *
 * @param overlayImage
 * @text 装飾画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ゲージの上に重ねる装飾画像（img/customwindow/）
 *
 * @param overlayOffsetX
 * @text 装飾画像Xオフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc 装飾画像のX座標オフセット（ゲージ位置からの相対値）
 *
 * @param overlayOffsetY
 * @text 装飾画像Yオフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc 装飾画像のY座標オフセット（ゲージ位置からの相対値）
 */

/*~struct~SlotTextElement:
 * @param text
 * @text テキスト
 * @type text
 * @default 
 * @desc 表示するテキスト。置換文字: %s=スロット番号, %v=変数値
 *
 * @param x
 * @text X座標
 * @type number
 * @min -9999
 * @default 0
 * @desc テキストのX座標（スロット内相対）
 *
 * @param y
 * @text Y座標
 * @type number
 * @min -9999
 * @default 0
 * @desc テキストのY座標（スロット内相対）
 *
 * @param width
 * @text 幅
 * @type number
 * @min 0
 * @default 200
 * @desc テキスト描画エリアの幅（0で自動）
 *
 * @param textAlign
 * @text 文字揃え
 * @type select
 * @option 左揃え
 * @value left
 * @option 中央揃え
 * @value center
 * @option 右揃え
 * @value right
 * @default left
 * @desc テキストの配置
 *
 * @param textPresetId
 * @text テキストプリセットID
 * @type text
 * @default 
 * @desc 使用するテキストプリセットのID
 *
 * @param fontSize
 * @text フォントサイズ（個別）
 * @type number
 * @min 0
 * @default 0
 * @desc 個別のフォントサイズ（0でプリセット設定を使用）
 *
 * @param variableId
 * @text 変数ID
 * @type variable
 * @default 0
 * @desc セーブデータから読み取る変数ID（%vで値を表示）
 *
 * @param scaleX
 * @text 横幅スケール
 * @type number
 * @decimals 2
 * @min 0.1
 * @max 10.0
 * @default 1.0
 * @desc テキストの横幅倍率（1.0=通常、1.5=1.5倍に横伸び、2.0=2倍）
 */

/*~struct~SaveLoadTextElement:
 * @param text
 * @text テキスト
 * @type text
 * @default 
 * @desc 表示するテキスト
 *
 * @param x
 * @text X座標
 * @type number
 * @min -9999
 * @default 0
 * @desc テキストのX座標
 *
 * @param y
 * @text Y座標
 * @type number
 * @min -9999
 * @default 0
 * @desc テキストのY座標
 *
 * @param width
 * @text 幅
 * @type number
 * @min 1
 * @default 200
 * @desc テキスト描画エリアの幅
 *
 * @param textAlign
 * @text 文字揃え
 * @type select
 * @option 左揃え
 * @value left
 * @option 中央揃え
 * @value center
 * @option 右揃え
 * @value right
 * @default left
 * @desc テキストの配置
 *
 * @param textPresetId
 * @text テキストプリセットID
 * @type text
 * @default 
 * @desc 使用するテキストプリセットのID
 */

/*~struct~SaveLoadButtonElement:
 * @param buttonId
 * @text ボタンID
 * @type text
 * @default button1
 * @desc ボタンの識別名
 *
 * @param x
 * @text X座標
 * @type number
 * @min -9999
 * @default 0
 * @desc ボタンのX座標
 *
 * @param y
 * @text Y座標
 * @type number
 * @min -9999
 * @default 0
 * @desc ボタンのY座標
 *
 * @param useScreenCoordinates
 * @text 画面座標を使用
 * @type boolean
 * @on 画面座標
 * @off ウィンドウ基準
 * @default false
 * @desc ONで画面左上(0,0)基準、OFFでウィンドウ左上基準
 *
 * @param image
 * @text 画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ボタン画像
 *
 * @param imageHover
 * @text ホバー時画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ホバー時のボタン画像
 *
 * @param imagePressed
 * @text 押下時画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 押下時のボタン画像
 *
 * @param action
 * @text アクション
 * @type select
 * @option 戻る（キャンセル）
 * @value back
 * @option 決定（セーブ/ロード実行）
 * @value confirm
 * @option 前のスロット
 * @value prevSlot
 * @option 次のスロット
 * @value nextSlot
 * @option セーブ画面へ移動
 * @value gotoSave
 * @option ロード画面へ移動
 * @value gotoLoad
 * @default back
 * @desc ボタンクリック時のアクション
 *
 * @param clickSE
 * @text クリック時SE
 * @type file
 * @dir audio/se
 * @default 
 * @desc クリック時に再生するSE
 */

/*~struct~SkillTreeWindowSettings:
 * @param windowId
 * @text ウィンドウID
 * @type text
 * @default skillTree1
 * @desc このスキルツリーウィンドウの識別名
 *
 * @param actorId
 * @text アクターID
 * @type actor
 * @default 0
 * @desc 対象アクターID（0でパーティ先頭）
 *
 * @param x
 * @text X座標
 * @type number
 * @min 0
 * @default 100
 * @desc ウィンドウのX座標
 *
 * @param y
 * @text Y座標
 * @type number
 * @min 0
 * @default 100
 * @desc ウィンドウのY座標
 *
 * @param width
 * @text 幅
 * @type number
 * @min 1
 * @default 600
 * @desc ウィンドウの幅（背景画像指定時は自動計算可）
 *
 * @param height
 * @text 高さ
 * @type number
 * @min 1
 * @default 400
 * @desc ウィンドウの高さ（背景画像指定時は自動計算可）
 *
 * @param backgroundImage
 * @text 背景画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ウィンドウ背景に使用する画像
 *
 * @param useImageSize
 * @text 画像サイズを使用
 * @type boolean
 * @on 使用する
 * @off 使用しない
 * @default true
 * @desc 背景画像のサイズをウィンドウサイズとして使用する
 *
 * @param skillNodes
 * @text スキルノードリスト
 * @type struct<SkillNode>[]
 * @default []
 * @desc スキルツリーに配置するスキルノードの設定
 *
 * @param unlearnedFilterOpacity
 * @text 未習得フィルター不透明度
 * @type number
 * @min 0
 * @max 255
 * @default 128
 * @desc 未習得スキルの黒フィルター不透明度（0-255）
 *
 * @param skillPointVariable
 * @text スキルポイント変数
 * @type variable
 * @default 0
 * @desc スキルポイントを管理する変数ID（0で無制限）
 *
 * @param showSkillPointDisplay
 * @text スキルポイント表示
 * @type boolean
 * @on 表示する
 * @off 表示しない
 * @default true
 * @desc スキルポイントをウィンドウに表示するか
 *
 * @param skillPointDisplaySettings
 * @text スキルポイント表示設定
 * @type struct<SkillPointDisplay>
 * @default {"x":"10","y":"10","width":"200","format":"SP: %1","textPresetId":"","fontSize":"24","textColor":"#ffffff","outlineColor":"#000000","outlineWidth":"4","textAlign":"left"}
 * @desc スキルポイント表示の詳細設定
 *
 * @param showConfirmWindow
 * @text 確認ウィンドウ表示
 * @type boolean
 * @on 表示する
 * @off 表示しない
 * @default true
 * @desc スキル習得時に確認ウィンドウを表示するか
 *
 * @param confirmWindowSettings
 * @text 確認ウィンドウ設定
 * @type struct<SkillTreeConfirmWindow>
 * @default {"width":"300","height":"150","backgroundImage":"","confirmText":"習得しますか？","yesText":"はい","noText":"いいえ","textColor":"#ffffff","fontSize":"24"}
 * @desc 確認ウィンドウの詳細設定
 *
 * @param cursorSettings
 * @text カーソル設定
 * @type struct<SkillTreeCursor>
 * @default {"cursorImage":"","cursorOffsetX":"0","cursorOffsetY":"0","selectSE":"","selectSEVolume":"90","selectSEPitch":"100","selectSEPan":"0"}
 * @desc ノード選択カーソルの設定
 *
 * @param allowPlayerMovement
 * @text プレイヤー操作許可
 * @type boolean
 * @on 許可
 * @off 禁止
 * @default false
 * @desc ウィンドウ表示中にプレイヤーの移動やイベント起動を許可するか
 *
 * @param transitionId
 * @text トランジションID
 * @type text
 * @default 
 * @desc 使用するトランジション効果のID名（空欄で即時表示）
 */

/*~struct~SkillTreeCursor:
 * @param cursorImage
 * @text カーソル画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ノード選択時に表示するカーソル画像
 *
 * @param cursorOffsetX
 * @text カーソルXオフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc カーソル画像のX座標オフセット（ノード位置からの相対座標）
 *
 * @param cursorOffsetY
 * @text カーソルYオフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc カーソル画像のY座標オフセット（ノード位置からの相対座標）
 *
 * @param selectSE
 * @text 選択時SE
 * @type file
 * @dir audio/se
 * @default 
 * @desc ノード選択時に再生するSE（空欄でデフォルトカーソルSE）
 *
 * @param selectSEVolume
 * @text SE音量
 * @type number
 * @min 0
 * @max 100
 * @default 90
 * @desc SEの音量
 *
 * @param selectSEPitch
 * @text SEピッチ
 * @type number
 * @min 50
 * @max 150
 * @default 100
 * @desc SEのピッチ
 *
 * @param selectSEPan
 * @text SE位相
 * @type number
 * @min -100
 * @max 100
 * @default 0
 * @desc SEの位相（左右バランス）
 *
 * @param upUseConnection
 * @text 上キー：つながり優先
 * @type boolean
 * @default false
 * @desc ONにすると上キーでノードの前提条件（親）を辿って移動します
 *
 * @param downUseConnection
 * @text 下キー：つながり優先
 * @type boolean
 * @default false
 * @desc ONにすると下キーでノードの前提条件（子）を辿って移動します
 *
 * @param leftUseConnection
 * @text 左キー：つながり優先
 * @type boolean
 * @default true
 * @desc ONにすると左キーでノードの前提条件（親）を辿って移動します
 *
 * @param rightUseConnection
 * @text 右キー：つながり優先
 * @type boolean
 * @default true
 * @desc ONにすると右キーでノードの前提条件（子）を辿って移動します
 */

/*~struct~SkillNode:
 * @param skillId
 * @text スキルID
 * @type skill
 * @default 1
 * @desc ノードに紐づけるスキルのID
 *
 * @param requiredSP
 * @text 必要スキルポイント
 * @type number
 * @min 0
 * @default 1
 * @desc このスキルの習得に必要なスキルポイント
 *
 * @param nodeImage
 * @text ノード画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ノードに表示する画像（空欄でスキルのアイコンを使用）
 *
 * @param nodeImageLearned
 * @text 習得済みオーバーレイ画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 習得済み時にノード画像の上に重ねる画像（空欄で重ねなし）
 *
 * @param nodeImageDisabled
 * @text 習得不可オーバーレイ画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 習得不可時にノード画像の上に重ねる画像（空欄で重ねなし）
 *
 * @param descriptionImageSettings
 * @text 選択時解説画像
 * @type struct<DescriptionImageSettings>
 * @default {"imageDisabled":"","imageLearnable":"","imageLearned":"","x":"0","y":"0"}
 * @desc ノード選択時に表示する解説画像の設定
 *
 * @param nodeX
 * @text ノードX座標
 * @type number
 * @min 0
 * @default 0
 * @desc ノードのX座標（ウィンドウ内相対座標）
 *
 * @param nodeY
 * @text ノードY座標
 * @type number
 * @min 0
 * @default 0
 * @desc ノードのY座標（ウィンドウ内相対座標）
 *
 * @param nodeWidth
 * @text ノード幅
 * @type number
 * @min 1
 * @default 48
 * @desc ノードの幅（アイコン使用時のサイズ）
 *
 * @param nodeHeight
 * @text ノード高さ
 * @type number
 * @min 1
 * @default 48
 * @desc ノードの高さ（アイコン使用時のサイズ）
 *
 * @param filterOpacity
 * @text フィルター不透明度（個別）
 * @type number
 * @min -1
 * @max 255
 * @default -1
 * @desc このノードの黒フィルター不透明度（-1でウィンドウ設定を使用）
 *
 * @param learnCondition
 * @text 習得条件
 * @type struct<SkillNodeCondition>
 * @default {"requiredSkills":"[]","switchConditions":"[]","variableConditions":"[]"}
 * @desc このスキルを習得するための条件設定
 *
 * @param connectionImages
 * @text 習得時接続画像
 * @type struct<ConnectionImage>[]
 * @default []
 * @desc スキル習得時に表示する接続画像（線など）のリスト
 */

/*~struct~DescriptionImageSettings:
 * @param imageDisabled
 * @text 習得不可時説明画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 習得不可時に表示する説明画像（空欄で表示なし）
 *
 * @param imageLearnable
 * @text 習得可能時説明画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 習得可能状態になった時に表示する説明画像（空欄で表示なし）
 *
 * @param imageLearned
 * @text 習得済み時説明画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 習得済み時に表示する説明画像（空欄で習得可能時の画像を使用）
 *
 * @param x
 * @text 説明画像X座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 説明画像の表示位置X座標
 *
 * @param y
 * @text 説明画像Y座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 説明画像の表示位置Y座標
 */

/*~struct~ConnectionImage:
 * @param image
 * @text 画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 表示する画像ファイル
 *
 * @param x
 * @text X座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 画像のX座標（ウィンドウ内相対座標）
 *
 * @param y
 * @text Y座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 画像のY座標（ウィンドウ内相対座標）
 */

/*~struct~SkillNodeCondition:
 * @param requiredSkills
 * @text 前提スキル
 * @type skill[]
 * @default []
 * @desc 習得に必要な前提スキルのリスト（全て習得済みで条件成立）
 *
 * @param switchConditions
 * @text スイッチ条件
 * @type struct<SwitchCondition>[]
 * @default []
 * @desc スイッチによる条件（複数設定可、全て満たす必要あり）
 *
 * @param variableConditions
 * @text 変数条件
 * @type struct<VariableCondition>[]
 * @default []
 * @desc 変数による条件（複数設定可、全て満たす必要あり）
 */

/*~struct~SwitchCondition:
 * @param switchId
 * @text スイッチID
 * @type switch
 * @default 0
 * @desc 条件に使用するスイッチID
 *
 * @param switchValue
 * @text スイッチ状態
 * @type boolean
 * @on ON
 * @off OFF
 * @default true
 * @desc 条件となるスイッチの状態（ONまたはOFF）
 */

/*~struct~VariableCondition:
 * @param variableId
 * @text 変数ID
 * @type variable
 * @default 0
 * @desc 条件に使用する変数ID
 *
 * @param comparison
 * @text 比較演算子
 * @type select
 * @option 以上 (>=)
 * @value gte
 * @option より大きい (>)
 * @value gt
 * @option 以下 (<=)
 * @value lte
 * @option より小さい (<)
 * @value lt
 * @option 等しい (==)
 * @value eq
 * @option 等しくない (!=)
 * @value neq
 * @default gte
 * @desc 比較の方法
 *
 * @param value
 * @text 比較値
 * @type number
 * @min -9999999
 * @max 9999999
 * @default 0
 * @desc 比較する値
 */

/*~struct~SkillTreeConfirmWindow:
 * @param width
 * @text 幅
 * @type number
 * @min 100
 * @default 300
 * @desc 確認ウィンドウの幅
 *
 * @param height
 * @text 高さ
 * @type number
 * @min 100
 * @default 150
 * @desc 確認ウィンドウの高さ
 *
 * @param backgroundImage
 * @text 背景画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 確認ウィンドウの背景画像（空欄でデフォルトウィンドウ）
 *
 * @param confirmText
 * @text 確認テキスト
 * @type text
 * @default 習得しますか？
 * @desc 確認ウィンドウに表示するテキスト（%1でスキル名、%2で必要SP）
 *
 * @param yesText
 * @text はいテキスト
 * @type text
 * @default はい
 * @desc 「はい」ボタンのテキスト
 *
 * @param noText
 * @text いいえテキスト
 * @type text
 * @default いいえ
 * @desc 「いいえ」ボタンのテキスト
 *
 * @param textColor
 * @text テキスト色
 * @type text
 * @default #ffffff
 * @desc テキストの色
 *
 * @param fontSize
 * @text フォントサイズ
 * @type number
 * @min 10
 * @max 72
 * @default 24
 * @desc テキストのフォントサイズ
 *
 * @param buttonLayout
 * @text ボタンレイアウト
 * @type select
 * @option 横並び
 * @value horizontal
 * @option 縦並び
 * @value vertical
 * @default horizontal
 * @desc 「はい」「いいえ」ボタンの配置
 */

/*~struct~SkillPointDisplay:
 * @param x
 * @text X座標
 * @type number
 * @min 0
 * @default 10
 * @desc スキルポイント表示のX座標
 *
 * @param y
 * @text Y座標
 * @type number
 * @min 0
 * @default 10
 * @desc スキルポイント表示のY座標
 *
 * @param width
 * @text 幅
 * @type number
 * @min 50
 * @default 200
 * @desc スキルポイント表示の幅
 *
 * @param format
 * @text 表示フォーマット
 * @type text
 * @default SP: %1
 * @desc スキルポイントの表示形式（%1で現在のSP値）
 *
 * @param textPresetId
 * @text テキストプリセットID
 * @type text
 * @default 
 * @desc 使用するテキストプリセットのID（空欄で個別設定を使用）
 *
 * @param fontSize
 * @text フォントサイズ
 * @type number
 * @min 10
 * @max 72
 * @default 24
 * @desc テキストのフォントサイズ
 *
 * @param textColor
 * @text テキスト色
 * @type text
 * @default #ffffff
 * @desc テキストの色
 *
 * @param outlineColor
 * @text 縁取り色
 * @type text
 * @default #000000
 * @desc テキストの縁取り色
 *
 * @param outlineWidth
 * @text 縁取り太さ
 * @type number
 * @min 0
 * @max 10
 * @default 4
 * @desc テキストの縁取りの太さ
 *
 * @param textAlign
 * @text 文字揃え
 * @type select
 * @option 左揃え
 * @value left
 * @option 中央揃え
 * @value center
 * @option 右揃え
 * @value right
 * @default left
 * @desc テキストの配置
 *
 * @param useSpriteSheet
 * @text スプライトシート使用
 * @type boolean
 * @on 使用する
 * @off 使用しない
 * @default false
 * @desc 数字表示にスプライトシート画像を使用するか
 *
 * @param spriteSheetImage
 * @text スプライトシート画像
 * @type file
 * @dir img/system
 * @default 
 * @desc 0～9の数字が横に並んだスプライトシート画像（幅と高さは自動計算）
 *
 * @param digitSpacing
 * @text 数字間隔
 * @type number
 * @min 0
 * @default 0
 * @desc 数字と数字の間の間隔（ピクセル）
 *
 * @param decorationImage
 * @text 装飾画像
 * @type file
 * @dir img/system
 * @default 
 * @desc 数字の隣に表示する装飾画像（円、Pなど）
 *
 * @param decorationOffsetX
 * @text 装飾画像オフセットX
 * @type number
 * @min -9999
 * @default 0
 * @desc 装飾画像のX座標オフセット（数字の右端から）
 *
 * @param decorationOffsetY
 * @text 装飾画像オフセットY
 * @type number
 * @min -9999
 * @default 0
 * @desc 装飾画像のY座標オフセット
 */

/*~struct~BaseImageSettings:
 * @param baseImage
 * @text 土台画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 土台として表示する画像
 *
 * @param baseImageDisabled
 * @text 土台画像（条件不成立）
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 条件を満たさない時の土台画像（空欄で変化なし）
 *
 * @param condition
 * @text 条件設定
 * @type struct<ConditionSettings>
 * @default {"switchId":"0","switchValue":"true","variableConditions":"[]"}
 * @desc 土台画像の表示条件
 */

/*~struct~OverlayImageSettings:
 * @param overlayImage
 * @text 追加画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 土台の上に重ねて表示する画像
 *
 * @param overlayImageDisabled
 * @text 追加画像（条件不成立）
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 条件を満たさない時の追加画像（空欄で変化なし）
 *
 * @param condition
 * @text 条件設定
 * @type struct<ConditionSettings>
 * @default {"switchId":"0","switchValue":"true","variableConditions":"[]"}
 * @desc 追加画像の表示条件
 */

/*~struct~CloseSettings:
 * @param closeButtonImage
 * @text 閉じるボタン画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ウィンドウを閉じるためのボタン画像
 *
 * @param closeButtonHoverImage
 * @text 閉じるボタンホバー画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 閉じるボタンにマウスオーバー時の画像
 *
 * @param closeButtonX
 * @text 閉じるボタンX座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 閉じるボタンのX座標
 *
 * @param closeButtonY
 * @text 閉じるボタンY座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 閉じるボタンのY座標
 *
 * @param useCancelKey
 * @text キャンセルキーで閉じる
 * @type boolean
 * @on 有効
 * @off 無効
 * @default false
 * @desc ONにするとキャンセルキー（Esc/X）でウィンドウを閉じる
 *
 * @param useRightClick
 * @text 右クリックで閉じる
 * @type boolean
 * @on 有効
 * @off 無効
 * @default false
 * @desc ONにすると右クリックでウィンドウを閉じる
 *
 * @param showConfirmation
 * @text 確認を表示
 * @type boolean
 * @on 表示する
 * @off 表示しない
 * @default false
 * @desc ONにすると閉じる前に確認画面を表示
 *
 * @param confirmBackgroundImage
 * @text 確認背景画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 確認画面の背景画像
 *
 * @param confirmYesImage
 * @text はいボタン画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 確認画面の「はい」ボタン画像
 *
 * @param confirmYesHoverImage
 * @text はいボタンホバー画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 「はい」ボタンにマウスオーバー時の画像
 *
 * @param confirmYesX
 * @text はいボタンX座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 「はい」ボタンのX座標（背景画像からの相対位置）
 *
 * @param confirmYesY
 * @text はいボタンY座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 「はい」ボタンのY座標（背景画像からの相対位置）
 *
 * @param confirmNoImage
 * @text いいえボタン画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 確認画面の「いいえ」ボタン画像
 *
 * @param confirmNoHoverImage
 * @text いいえボタンホバー画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 「いいえ」ボタンにマウスオーバー時の画像
 *
 * @param confirmNoX
 * @text いいえボタンX座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 「いいえ」ボタンのX座標（背景画像からの相対位置）
 *
 * @param confirmNoY
 * @text いいえボタンY座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 「いいえ」ボタンのY座標（背景画像からの相対位置）
 *
 * @param returnToTitle
 * @text タイトルに戻る
 * @type boolean
 * @on 戻る
 * @off 戻らない
 * @default false
 * @desc ONにするとウィンドウを閉じた時にタイトル画面に戻る
 */

/*~struct~ButtonImageSettings:
 * @param buttonImage
 * @text ボタン画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc クリック可能なボタン画像
 *
 * @param buttonImageDisabled
 * @text ボタン画像（条件不成立）
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc 条件を満たさない時のボタン画像（空欄で非表示）
 *
 * @param buttonHoverImage
 * @text ボタンホバー画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ボタンにマウスオーバー時の画像
 *
 * @param buttonOffsetX
 * @text ボタンXオフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc ボタン画像のX座標オフセット
 *
 * @param buttonOffsetY
 * @text ボタンYオフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc ボタン画像のY座標オフセット
 *
 * @param commonEventId
 * @text コモンイベントID
 * @type common_event
 * @default 0
 * @desc ボタンクリック時に呼び出すコモンイベント
 *
 * @param disabledDarken
 * @text 条件不成立時暗くする
 * @type boolean
 * @on 暗くする
 * @off そのまま
 * @default true
 * @desc 条件不成立時にボタン画像を暗くするか
 *
 * @param disabledDarkenOpacity
 * @text 暗くする不透明度
 * @type number
 * @min 0
 * @max 255
 * @default 128
 * @desc 条件不成立時の黒フィルター不透明度（0-255）
 *
 * @param condition
 * @text 条件設定
 * @type struct<ConditionSettings>
 * @default {"switchId":"0","switchValue":"true","variableConditions":"[]"}
 * @desc ボタンの有効/無効条件
 */

/*~struct~ConditionSettings:
 * @param switchId
 * @text スイッチID
 * @type switch
 * @default 0
 * @desc 条件に使用するスイッチ（0で無効）
 *
 * @param switchValue
 * @text スイッチ条件
 * @type boolean
 * @on ONで有効
 * @off OFFで有効
 * @default true
 * @desc スイッチがこの状態の時に条件成立
 *
 * @param variableConditions
 * @text 変数条件リスト
 * @type struct<VariableCondition>[]
 * @default []
 * @desc 変数による条件（複数設定可能、全て満たす必要あり）
 */

/*~struct~VariableCondition:
 * @param variableId
 * @text 変数ID
 * @type variable
 * @default 1
 * @desc 条件に使用する変数
 *
 * @param operator
 * @text 比較演算子
 * @type select
 * @option = （等しい）
 * @value eq
 * @option != （等しくない）
 * @value ne
 * @option >= （以上）
 * @value ge
 * @option > （より大きい）
 * @value gt
 * @option <= （以下）
 * @value le
 * @option < （より小さい）
 * @value lt
 * @default ge
 * @desc 比較演算子
 *
 * @param value
 * @text 比較値
 * @type number
 * @min -99999999
 * @default 1
 * @desc この値と比較する
 */

/*~struct~ItemWindowSettings:
 * @param x
 * @text X座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 表示位置のX座標（背景画像がある場合は背景画像の座標）
 *
 * @param y
 * @text Y座標
 * @type number
 * @min -9999
 * @default 0
 * @desc 表示位置のY座標（背景画像がある場合は背景画像の座標）
 *
 * @param backgroundImage
 * @text 背景画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ウィンドウの後ろに表示する土台画像
 *
 * @param windowBackgroundImage
 * @text ウィンドウ背景画像
 * @type file
 * @dir img/customwindow
 * @default 
 * @desc ウィンドウ自体の背景画像（土台より前、アイテムより後ろ）
 *
 * @param useWindowImageSize
 * @text 画像サイズを使用
 * @type boolean
 * @default false
 * @desc ONにするとウィンドウ背景画像のサイズをウィンドウサイズとして使用
 *
 * @param windowOffsetX
 * @text ウィンドウXオフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc 背景画像に対するウィンドウのX方向オフセット
 *
 * @param windowOffsetY
 * @text ウィンドウYオフセット
 * @type number
 * @min -9999
 * @default 0
 * @desc 背景画像に対するウィンドウのY方向オフセット
 *
 * @param itemWidth
 * @text アイテム幅
 * @type number
 * @min 1
 * @default 48
 * @desc 1アイテムあたりの幅（画像使用時は最大画像幅として使用）
 *
 * @param itemHeight
 * @text アイテム高さ
 * @type number
 * @min 1
 * @default 48
 * @desc 1アイテムあたりの高さ（画像使用時は最大画像高さとして使用）
 *
 * @param columns
 * @text 列数（横）
 * @type number
 * @min 1
 * @default 4
 * @desc 横に並べるアイテム数
 *
 * @param maxRows
 * @text 最大行数（縦）
 * @type number
 * @min 1
 * @default 3
 * @desc スクロールなしで表示する最大行数（これを超えるとスクロールバー表示）
 *
 * @param spacingX
 * @text 列間余白（横）
 * @type number
 * @min 0
 * @default 4
 * @desc アイテム間の横方向余白（ピクセル）
 *
 * @param spacingY
 * @text 行間余白（縦）
 * @type number
 * @min 0
 * @default 4
 * @desc アイテム間の縦方向余白（ピクセル）
 *
 * @param paddingLeft
 * @text 左余白
 * @type number
 * @min 0
 * @default 18
 * @desc ウィンドウ左側の内側余白（ピクセル）
 *
 * @param paddingRight
 * @text 右余白
 * @type number
 * @min 0
 * @default 18
 * @desc ウィンドウ右側の内側余白（ピクセル）
 *
 * @param paddingTop
 * @text 上余白
 * @type number
 * @min 0
 * @default 18
 * @desc ウィンドウ上側の内側余白（ピクセル）
 *
 * @param paddingBottom
 * @text 下余白
 * @type number
 * @min 0
 * @default 18
 * @desc ウィンドウ下側の内側余白（ピクセル）
 *
 * @param itemImages
 * @text アイテム画像リスト
 * @type struct<ItemImageSettings>[]
 * @default []
 * @desc 表示するアイテムの画像設定リスト（所持しているアイテムのみ表示）
 *
 * @param clickItemIdVariable
 * @text クリックアイテムID変数
 * @type variable
 * @default 0
 * @desc クリックしたアイテムのIDを格納する変数
 *
 * @param useHoverEffect
 * @text ホバーエフェクト使用
 * @type boolean
 * @default true
 * @desc このウィンドウでホバーエフェクトを使用するかどうか
 *
 * @param useDisabledImages
 * @text 条件不成立画像を使用
 * @type boolean
 * @default true
 * @desc ONで条件不成立画像を使用、OFFで黒フィルターを適用
 *
 * @param disabledFilterOpacity
 * @text 黒フィルター不透明度
 * @type number
 * @min 0
 * @max 255
 * @default 128
 * @desc 条件不成立時の黒フィルターの不透明度（0-255）
 *
 * @param scrollBarId
 * @text スクロールバーID
 * @type text
 * @default 
 * @desc 使用するスクロールバー設定のID（空欄でデフォルト設定を使用）
 *
 * @param closeSettings
 * @text 終了設定
 * @type struct<CloseSettings>
 * @default {"closeButtonImage":"","closeButtonX":"0","closeButtonY":"0","showConfirmation":"false","confirmBackgroundImage":"","confirmYesImage":"","confirmYesHoverImage":"","confirmYesX":"0","confirmYesY":"0","confirmNoImage":"","confirmNoHoverImage":"","confirmNoX":"0","confirmNoY":"0"}
 * @desc ウィンドウを閉じるボタンと確認の設定
 *
 * @param transitionId
 * @text トランジションID
 * @type text
 * @default 
 * @desc 使用するトランジション効果のID名（空欄で即時表示）
 *
 * @param allowPlayerMovement
 * @text プレイヤー操作許可
 * @type boolean
 * @on 許可
 * @off 禁止
 * @default false
 * @desc ウィンドウ表示中にプレイヤーの移動やイベント起動を許可するか
 */

/*~struct~ItemImageSettings:
 * @param itemId
 * @text アイテムID
 * @type item
 * @default 1
 * @desc このボタンに対応するアイテムID
 *
 * @param baseSettings
 * @text 土台設定
 * @type struct<BaseImageSettings>
 * @default {"baseImage":"","baseImageDisabled":"","condition":"{\"switchId\":\"0\",\"switchValue\":\"true\",\"variableConditions\":\"[]\"}"}
 * @desc 土台画像と条件の設定
 *
 * @param buttonSettings
 * @text ボタン設定
 * @type struct<ButtonImageSettings>
 * @default {"buttonImage":"","buttonImageDisabled":"","buttonHoverImage":"","buttonOffsetX":"0","buttonOffsetY":"0","commonEventId":"0","condition":"{\"switchId\":\"0\",\"switchValue\":\"true\",\"variableConditions\":\"[]\"}"}
 * @desc ボタン画像と条件の設定
 */

(function() {
    'use strict';

    var parseConditionSettings = function(conditionStr) {
        try {
            var cond = typeof conditionStr === 'string' ? JSON.parse(conditionStr) : conditionStr;
            if (!cond) {
                return { switchId: 0, switchValue: true, variableConditions: [] };
            }
            
            var varConditions = [];
            if (cond.variableConditions) {
                var varCondArray = typeof cond.variableConditions === 'string' 
                    ? JSON.parse(cond.variableConditions) 
                    : cond.variableConditions;
                for (var i = 0; i < varCondArray.length; i++) {
                    var vc = typeof varCondArray[i] === 'string' ? JSON.parse(varCondArray[i]) : varCondArray[i];
                    varConditions.push({
                        variableId: Number(vc.variableId || 1),
                        operator: String(vc.operator || 'ge'),
                        value: Number(vc.value || 1)
                    });
                }
            }
            
            return {
                switchId: Number(cond.switchId || 0),
                switchValue: cond.switchValue === 'true' || cond.switchValue === true,
                variableConditions: varConditions
            };
        } catch (e) {
            return { switchId: 0, switchValue: true, variableConditions: [] };
        }
    };

    var parseBaseSettings = function(settingsStr) {
        try {
            var s = typeof settingsStr === 'string' ? JSON.parse(settingsStr) : settingsStr;
            if (!s) return { baseImage: '', baseImageDisabled: '', condition: null };
            return {
                baseImage: String(s.baseImage || ''),
                baseImageDisabled: String(s.baseImageDisabled || ''),
                condition: parseConditionSettings(s.condition)
            };
        } catch (e) {
            return { baseImage: '', baseImageDisabled: '', condition: null };
        }
    };

    var parseOverlaySettings = function(settingsStr) {
        try {
            var s = typeof settingsStr === 'string' ? JSON.parse(settingsStr) : settingsStr;
            if (!s) return { overlayImage: '', overlayImageDisabled: '', condition: null };
            return {
                overlayImage: String(s.overlayImage || ''),
                overlayImageDisabled: String(s.overlayImageDisabled || ''),
                condition: parseConditionSettings(s.condition)
            };
        } catch (e) {
            return { overlayImage: '', overlayImageDisabled: '', condition: null };
        }
    };

    var parseButtonSettings = function(settingsStr) {
        try {
            var s = typeof settingsStr === 'string' ? JSON.parse(settingsStr) : settingsStr;
            if (!s) return { 
                buttonImage: '', buttonImageDisabled: '', buttonHoverImage: '',
                buttonOffsetX: 0, buttonOffsetY: 0, commonEventId: 0, condition: null,
                disabledDarken: true, disabledDarkenOpacity: 128
            };
            return {
                buttonImage: String(s.buttonImage || ''),
                buttonImageDisabled: String(s.buttonImageDisabled || ''),
                buttonHoverImage: String(s.buttonHoverImage || ''),
                buttonOffsetX: Number(s.buttonOffsetX || 0),
                buttonOffsetY: Number(s.buttonOffsetY || 0),
                commonEventId: Number(s.commonEventId || 0),
                condition: parseConditionSettings(s.condition),
                disabledDarken: s.disabledDarken !== 'false' && s.disabledDarken !== false,
                disabledDarkenOpacity: Number(s.disabledDarkenOpacity !== undefined ? s.disabledDarkenOpacity : 128)
            };
        } catch (e) {
            return { 
                buttonImage: '', buttonImageDisabled: '', buttonHoverImage: '',
                buttonOffsetX: 0, buttonOffsetY: 0, commonEventId: 0, condition: null,
                disabledDarken: true, disabledDarkenOpacity: 128
            };
        }
    };

    var parseCloseSettings = function(settingsStr) {
        try {
            var s = typeof settingsStr === 'string' ? JSON.parse(settingsStr) : settingsStr;
            if (!s) return {
                closeButtonImage: '', closeButtonHoverImage: '',
                closeButtonX: 0, closeButtonY: 0,
                useCancelKey: false,
                useRightClick: false,
                showConfirmation: false,
                confirmBackgroundImage: '',
                confirmYesImage: '', confirmYesHoverImage: '',
                confirmYesX: 0, confirmYesY: 0,
                confirmNoImage: '', confirmNoHoverImage: '',
                confirmNoX: 0, confirmNoY: 0,
                returnToTitle: false
            };
            return {
                closeButtonImage: String(s.closeButtonImage || ''),
                closeButtonHoverImage: String(s.closeButtonHoverImage || ''),
                closeButtonX: Number(s.closeButtonX || 0),
                closeButtonY: Number(s.closeButtonY || 0),
                useCancelKey: s.useCancelKey === 'true' || s.useCancelKey === true,
                useRightClick: s.useRightClick === 'true' || s.useRightClick === true,
                showConfirmation: s.showConfirmation === 'true' || s.showConfirmation === true,
                confirmBackgroundImage: String(s.confirmBackgroundImage || ''),
                confirmYesImage: String(s.confirmYesImage || ''),
                confirmYesHoverImage: String(s.confirmYesHoverImage || ''),
                confirmYesX: Number(s.confirmYesX || 0),
                confirmYesY: Number(s.confirmYesY || 0),
                confirmNoImage: String(s.confirmNoImage || ''),
                confirmNoHoverImage: String(s.confirmNoHoverImage || ''),
                confirmNoX: Number(s.confirmNoX || 0),
                confirmNoY: Number(s.confirmNoY || 0),
                returnToTitle: s.returnToTitle === 'true' || s.returnToTitle === true
            };
        } catch (e) {
            return {
                closeButtonImage: '', closeButtonHoverImage: '',
                closeButtonX: 0, closeButtonY: 0,
                useCancelKey: false,
                useRightClick: false,
                showConfirmation: false,
                confirmBackgroundImage: '',
                confirmYesImage: '', confirmYesHoverImage: '',
                confirmYesX: 0, confirmYesY: 0,
                confirmNoImage: '', confirmNoHoverImage: '',
                confirmNoX: 0, confirmNoY: 0,
                returnToTitle: false
            };
        }
    };

    var parseTextItem = function(textStr) {
        try {
            var t = typeof textStr === 'string' ? JSON.parse(textStr) : textStr;
            if (!t) return null;
            return {
                text: String(t.text || ''),
                x: Number(t.x || 0),
                y: Number(t.y || 0),
                width: Number(t.width || 200),
                align: String(t.align || 'left'),
                fontSize: Number(t.fontSize || 0),
                textColor: String(t.textColor || ''),
                outlineColor: String(t.outlineColor || ''),
                outlineWidth: Number(t.outlineWidth || -1),
                condition: parseConditionSettings(t.condition)
            };
        } catch (e) {
            return null;
        }
    };

    var parseTextList = function(textListStr) {
        var textList = [];
        try {
            if (!textListStr) return textList;
            var arr = typeof textListStr === 'string' ? JSON.parse(textListStr) : textListStr;
            if (!Array.isArray(arr)) return textList;
            for (var i = 0; i < arr.length; i++) {
                var textItem = parseTextItem(arr[i]);
                if (textItem) {
                    textList.push(textItem);
                }
            }
        } catch (e) {
        }
        return textList;
    };

    var parseImageItem = function(itemStr) {
        try {
            var item = typeof itemStr === 'string' ? JSON.parse(itemStr) : itemStr;
            
            var baseSettings = parseBaseSettings(item.baseSettings);
            var overlaySettings = parseOverlaySettings(item.overlaySettings);
            var buttonSettings = parseButtonSettings(item.buttonSettings);
            var textList = parseTextList(item.textList);
            
            return {
                baseImage: baseSettings.baseImage,
                baseImageDisabled: baseSettings.baseImageDisabled,
                baseCondition: baseSettings.condition,
                overlayImage: overlaySettings.overlayImage,
                overlayImageDisabled: overlaySettings.overlayImageDisabled,
                overlayCondition: overlaySettings.condition,
                buttonImage: buttonSettings.buttonImage,
                buttonImageDisabled: buttonSettings.buttonImageDisabled,
                buttonHoverImage: buttonSettings.buttonHoverImage,
                buttonOffsetX: buttonSettings.buttonOffsetX,
                buttonOffsetY: buttonSettings.buttonOffsetY,
                commonEventId: buttonSettings.commonEventId,
                buttonCondition: buttonSettings.condition,
                textList: textList
            };
        } catch (e) {
            return null;
        }
    };

    var evaluateCondition = function(condition) {
        if (!condition) return true;
        
        if (condition.switchId > 0) {
            var switchState = $gameSwitches.value(condition.switchId);
            if (switchState !== condition.switchValue) {
                return false;
            }
        }
        
        if (condition.variableConditions && condition.variableConditions.length > 0) {
            for (var i = 0; i < condition.variableConditions.length; i++) {
                var vc = condition.variableConditions[i];
                var varValue = $gameVariables.value(vc.variableId);
                var compareValue = vc.value;
                var result = false;
                
                switch (vc.operator) {
                    case 'eq':
                        result = varValue === compareValue;
                        break;
                    case 'ne':
                        result = varValue !== compareValue;
                        break;
                    case 'ge':
                        result = varValue >= compareValue;
                        break;
                    case 'gt':
                        result = varValue > compareValue;
                        break;
                    case 'le':
                        result = varValue <= compareValue;
                        break;
                    case 'lt':
                        result = varValue < compareValue;
                        break;
                    default:
                        result = true;
                }
                
                if (!result) return false;
            }
        }
        
        return true;
    };

    var checkBaseCondition = function(imageItem) {
        if (!imageItem) return true;
        return evaluateCondition(imageItem.baseCondition);
    };

    var checkOverlayCondition = function(imageItem) {
        if (!imageItem) return true;
        return evaluateCondition(imageItem.overlayCondition);
    };

    var checkButtonCondition = function(imageItem) {
        if (!imageItem) return true;
        return evaluateCondition(imageItem.buttonCondition);
    };

    var checkCondition = function(imageItem) {
        if (!imageItem) return true;
        return checkButtonCondition(imageItem);
    };

    var parseImageColumnList = function(jsonStr) {
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return {};
            
            var result = {};
            for (var i = 0; i < parsed.length; i++) {
                var listId = i + 1;
                var column = parsed[i];
                var items = [];
                
                if (typeof column === 'string') {
                    try {
                        var columnData = JSON.parse(column);
                        var itemsArray = JSON.parse(columnData.items || '[]');
                        for (var j = 0; j < itemsArray.length; j++) {
                            var imageItem = parseImageItem(itemsArray[j]);
                            if (imageItem && (imageItem.baseImage || imageItem.overlayImage || imageItem.buttonImage)) {
                                items.push(imageItem);
                            }
                        }
                    } catch (e) {
                    }
                } else if (column && column.items !== undefined) {
                    var itemsArray = Array.isArray(column.items) ? column.items : JSON.parse(column.items || '[]');
                    for (var j = 0; j < itemsArray.length; j++) {
                        var imageItem = parseImageItem(itemsArray[j]);
                        if (imageItem && (imageItem.baseImage || imageItem.overlayImage || imageItem.buttonImage)) {
                            items.push(imageItem);
                        }
                    }
                }
                
                if (items.length > 0) {
                    result[listId] = items;
                }
            }
            return result;
        } catch (e) {
            console.error('CustomWindow: ImageList parse error', e);
            return {};
        }
    };

    var parseWindowTextElements = function(jsonStr) {
        try {
            var parsed = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            if (!Array.isArray(parsed)) return [];
            var result = [];
            for (var i = 0; i < parsed.length; i++) {
                var textData = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                result.push({
                    text: String(textData.text || ''),
                    x: Number(textData.x || 0),
                    y: Number(textData.y || 0),
                    width: Number(textData.width || 200),
                    textAlign: String(textData.textAlign || 'left'),
                    textPresetId: String(textData.textPresetId || ''),
                    fontSize: Number(textData.fontSize || 0),
                    textColor: String(textData.textColor || ''),
                    outlineColor: String(textData.outlineColor || ''),
                    outlineWidth: Number(textData.outlineWidth !== undefined ? textData.outlineWidth : -1),
                    variableId: Number(textData.variableId || 0)
                });
            }
            return result;
        } catch (e) {
            return [];
        }
    };

    var parseWindowBasePresetList = function(jsonStr) {
        var result = {};
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return result;
            
            for (var i = 0; i < parsed.length; i++) {
                var item = parsed[i];
                var preset = {};
                
                if (typeof item === 'string') {
                    try {
                        preset = JSON.parse(item);
                    } catch (e) {
                        continue;
                    }
                } else if (item) {
                    preset = item;
                } else {
                    continue;
                }
                
                var id = String(preset.id || '');
                if (!id) continue;
                
                result[id] = {
                    id: id,
                    x: Number(preset.x || 100),
                    y: Number(preset.y || 100),
                    width: Number(preset.width || 300),
                    height: Number(preset.height || 150),
                    backgroundImage: String(preset.backgroundImage || ''),
                    useImageSize: preset.useImageSize !== 'false' && preset.useImageSize !== false,
                    paddingTop: Number(preset.paddingTop !== undefined ? preset.paddingTop : 18),
                    paddingBottom: Number(preset.paddingBottom !== undefined ? preset.paddingBottom : 18),
                    paddingLeft: Number(preset.paddingLeft !== undefined ? preset.paddingLeft : 18),
                    paddingRight: Number(preset.paddingRight !== undefined ? preset.paddingRight : 18),
                    sceneBackgroundImage: String(preset.sceneBackgroundImage || ''),
                    priorityType: String(preset.priorityType || 'aboveFade'),
                    pictureId: Number(preset.pictureId || 50),
                    hoverSE: String(preset.hoverSE || ''),
                    hoverSEVolume: Number(preset.hoverSEVolume !== undefined ? preset.hoverSEVolume : 90),
                    hoverSEPitch: Number(preset.hoverSEPitch !== undefined ? preset.hoverSEPitch : 100),
                    clickSE: String(preset.clickSE || ''),
                    clickSEVolume: Number(preset.clickSEVolume !== undefined ? preset.clickSEVolume : 90),
                    clickSEPitch: Number(preset.clickSEPitch !== undefined ? preset.clickSEPitch : 100),
                    disabledSE: String(preset.disabledSE || ''),
                    disabledSEVolume: Number(preset.disabledSEVolume !== undefined ? preset.disabledSEVolume : 90),
                    disabledSEPitch: Number(preset.disabledSEPitch !== undefined ? preset.disabledSEPitch : 100)
                };
            }
        } catch (e) {
            console.error('CustomWindow: WindowBasePreset parse error', e);
        }
        return result;
    };

    var parseSingleWindowBasePreset = function(jsonStr) {
        try {
            var preset;
            if (typeof jsonStr === 'string') {
                preset = JSON.parse(jsonStr);
            } else {
                preset = jsonStr;
            }
            
            if (!preset) return null;
            
            var id = String(preset.id || '');
            if (!id) return null;
            
            return {
                id: id,
                x: Number(preset.x || 100),
                y: Number(preset.y || 100),
                width: Number(preset.width || 300),
                height: Number(preset.height || 150),
                backgroundImage: String(preset.backgroundImage || ''),
                useImageSize: preset.useImageSize !== 'false' && preset.useImageSize !== false,
                paddingTop: Number(preset.paddingTop !== undefined ? preset.paddingTop : 18),
                paddingBottom: Number(preset.paddingBottom !== undefined ? preset.paddingBottom : 18),
                paddingLeft: Number(preset.paddingLeft !== undefined ? preset.paddingLeft : 18),
                paddingRight: Number(preset.paddingRight !== undefined ? preset.paddingRight : 18),
                sceneBackgroundImage: String(preset.sceneBackgroundImage || ''),
                priorityType: String(preset.priorityType || 'aboveFade'),
                pictureId: Number(preset.pictureId || 50),
                hoverSE: String(preset.hoverSE || ''),
                hoverSEVolume: Number(preset.hoverSEVolume !== undefined ? preset.hoverSEVolume : 90),
                hoverSEPitch: Number(preset.hoverSEPitch !== undefined ? preset.hoverSEPitch : 100),
                clickSE: String(preset.clickSE || ''),
                clickSEVolume: Number(preset.clickSEVolume !== undefined ? preset.clickSEVolume : 90),
                clickSEPitch: Number(preset.clickSEPitch !== undefined ? preset.clickSEPitch : 100),
                disabledSE: String(preset.disabledSE || ''),
                disabledSEVolume: Number(preset.disabledSEVolume !== undefined ? preset.disabledSEVolume : 90),
                disabledSEPitch: Number(preset.disabledSEPitch !== undefined ? preset.disabledSEPitch : 100)
            };
        } catch (e) {
            console.error('CustomWindow: SingleWindowBasePreset parse error', e);
            return null;
        }
    };

    var _windowBasePresets = {};

    var getWindowBasePreset = function(presetId) {
        return _windowBasePresets[presetId] || null;
    };

    var parseSingleWindowSettings = function(jsonStr) {
        try {
            var settings;
            if (typeof jsonStr === 'string') {
                settings = JSON.parse(jsonStr);
            } else {
                settings = jsonStr;
            }
            
            if (!settings) return null;
            
            var basePresetId = String(settings.basePresetId || '');
            var basePreset = getWindowBasePreset(basePresetId);
            var x = basePreset ? basePreset.x : 100;
            var y = basePreset ? basePreset.y : 100;
            var width = basePreset ? basePreset.width : 300;
            var height = basePreset ? basePreset.height : 150;
            var backgroundImage = basePreset ? basePreset.backgroundImage : '';
            var useImageSize = basePreset ? basePreset.useImageSize : true;
            var paddingTop = basePreset ? basePreset.paddingTop : 18;
            var paddingBottom = basePreset ? basePreset.paddingBottom : 18;
            var paddingLeft = basePreset ? basePreset.paddingLeft : 18;
            var paddingRight = basePreset ? basePreset.paddingRight : 18;
            var sceneBackgroundImage = basePreset ? basePreset.sceneBackgroundImage : '';
            var priorityType = basePreset ? basePreset.priorityType : 'aboveFade';
            var pictureId = basePreset ? basePreset.pictureId : 50;
            
            
            var hoverSE = basePreset ? basePreset.hoverSE : '';
            var hoverSEVolume = basePreset ? basePreset.hoverSEVolume : 90;
            var hoverSEPitch = basePreset ? basePreset.hoverSEPitch : 100;
            var clickSE = basePreset ? basePreset.clickSE : '';
            var clickSEVolume = basePreset ? basePreset.clickSEVolume : 90;
            var clickSEPitch = basePreset ? basePreset.clickSEPitch : 100;
            var disabledSE = basePreset ? basePreset.disabledSE : '';
            var disabledSEVolume = basePreset ? basePreset.disabledSEVolume : 90;
            var disabledSEPitch = basePreset ? basePreset.disabledSEPitch : 100;
            
            return {
                basePresetId: basePresetId,
                x: x,
                y: y,
                width: width,
                height: height,
                backgroundImage: backgroundImage,
                useImageSize: useImageSize,
                paddingTop: paddingTop,
                paddingBottom: paddingBottom,
                paddingLeft: paddingLeft,
                paddingRight: paddingRight,
                sceneBackgroundImage: sceneBackgroundImage,
                priorityType: priorityType,
                pictureId: pictureId,
                hoverSE: hoverSE,
                hoverSEVolume: hoverSEVolume,
                hoverSEPitch: hoverSEPitch,
                clickSE: clickSE,
                clickSEVolume: clickSEVolume,
                clickSEPitch: clickSEPitch,
                disabledSE: disabledSE,
                disabledSEVolume: disabledSEVolume,
                disabledSEPitch: disabledSEPitch,
                textElements: parseWindowTextElements(settings.textElements || '[]'),
                imageList: parseImageColumnList(settings.imageList || '[]'),
                imageOffsetX: Number(settings.imageOffsetX || 0),
                imageOffsetY: Number(settings.imageOffsetY || 0),
                imageSpacingX: Number(settings.imageSpacingX || 4),
                imageSpacingY: Number(settings.imageSpacingY || 4),
                useDisabledImages: settings.useDisabledImages !== 'false' && settings.useDisabledImages !== false,
                disabledFilterOpacity: Number(settings.disabledFilterOpacity !== undefined ? settings.disabledFilterOpacity : 128),
                closeSettings: parseCloseSettings(settings.closeSettings),
                scrollBarId: String(settings.scrollBarId || ''),
                transitionId: String(settings.transitionId || ''),
                allowPlayerMovement: settings.allowPlayerMovement === 'true' || settings.allowPlayerMovement === true
            };
        } catch (e) {
            console.error('CustomWindow: SingleWindowSettings parse error', e);
            return null;
        }
    };

    var parseWindowSettings = function(jsonStr) {
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return {};
            
            var result = {};
            for (var i = 0; i < parsed.length; i++) {
                var windowId = i + 1;
                var item = parsed[i];
                var settings = {};
                
                if (typeof item === 'string') {
                    try {
                        settings = JSON.parse(item);
                    } catch (e) {
                        continue;
                    }
                } else if (item) {
                    settings = item;
                } else {
                    continue;
                }
                
                var basePresetId = String(settings.basePresetId || '');
                var basePreset = getWindowBasePreset(basePresetId);
                var x = basePreset ? basePreset.x : 100;
                var y = basePreset ? basePreset.y : 100;
                var width = basePreset ? basePreset.width : 300;
                var height = basePreset ? basePreset.height : 150;
                var backgroundImage = basePreset ? basePreset.backgroundImage : '';
                var useImageSize = basePreset ? basePreset.useImageSize : true;
                var paddingTop = basePreset ? basePreset.paddingTop : 18;
                var paddingBottom = basePreset ? basePreset.paddingBottom : 18;
                var paddingLeft = basePreset ? basePreset.paddingLeft : 18;
                var paddingRight = basePreset ? basePreset.paddingRight : 18;
                var sceneBackgroundImage = basePreset ? basePreset.sceneBackgroundImage : '';
                var priorityType = basePreset ? basePreset.priorityType : 'aboveFade';
                var pictureId = basePreset ? basePreset.pictureId : 50;
                
                
                var hoverSE = basePreset ? basePreset.hoverSE : '';
                var hoverSEVolume = basePreset ? basePreset.hoverSEVolume : 90;
                var hoverSEPitch = basePreset ? basePreset.hoverSEPitch : 100;
                var clickSE = basePreset ? basePreset.clickSE : '';
                var clickSEVolume = basePreset ? basePreset.clickSEVolume : 90;
                var clickSEPitch = basePreset ? basePreset.clickSEPitch : 100;
                var disabledSE = basePreset ? basePreset.disabledSE : '';
                var disabledSEVolume = basePreset ? basePreset.disabledSEVolume : 90;
                var disabledSEPitch = basePreset ? basePreset.disabledSEPitch : 100;
                
                result[windowId] = {
                    basePresetId: basePresetId,
                    x: x,
                    y: y,
                    width: width,
                    height: height,
                    backgroundImage: backgroundImage,
                    useImageSize: useImageSize,
                    paddingTop: paddingTop,
                    paddingBottom: paddingBottom,
                    paddingLeft: paddingLeft,
                    paddingRight: paddingRight,
                    sceneBackgroundImage: sceneBackgroundImage,
                    priorityType: priorityType,
                    pictureId: pictureId,
                    hoverSE: hoverSE,
                    hoverSEVolume: hoverSEVolume,
                    hoverSEPitch: hoverSEPitch,
                    clickSE: clickSE,
                    clickSEVolume: clickSEVolume,
                    clickSEPitch: clickSEPitch,
                    disabledSE: disabledSE,
                    disabledSEVolume: disabledSEVolume,
                    disabledSEPitch: disabledSEPitch,
                    textElements: parseWindowTextElements(settings.textElements || '[]'),
                    imageList: parseImageColumnList(settings.imageList || '[]'),
                    imageOffsetX: Number(settings.imageOffsetX || 0),
                    imageOffsetY: Number(settings.imageOffsetY || 0),
                    imageSpacingX: Number(settings.imageSpacingX || 4),
                    imageSpacingY: Number(settings.imageSpacingY || 4),
                    useDisabledImages: settings.useDisabledImages !== 'false' && settings.useDisabledImages !== false,
                    disabledFilterOpacity: Number(settings.disabledFilterOpacity !== undefined ? settings.disabledFilterOpacity : 128),
                    closeSettings: parseCloseSettings(settings.closeSettings),
                    scrollBarId: String(settings.scrollBarId || ''),
                    transitionId: String(settings.transitionId || '')
                };
            }
            return result;
        } catch (e) {
            console.error('CustomWindow: WindowSettings parse error', e);
            return {};
        }
    };

    var parseItemWindowSettings = function(jsonStr) {
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return {};
            
            var result = {};
            for (var i = 0; i < parsed.length; i++) {
                var itemWindowId = i + 1;
                var item = parsed[i];
                var settings = {};
                
                if (typeof item === 'string') {
                    try {
                        settings = JSON.parse(item);
                    } catch (e) {
                        continue;
                    }
                } else if (item) {
                    settings = item;
                } else {
                    continue;
                }
                
                var itemImages = [];
                if (settings.itemImages) {
                    var imgList = typeof settings.itemImages === 'string' 
                        ? JSON.parse(settings.itemImages) 
                        : settings.itemImages;
                    if (Array.isArray(imgList)) {
                        for (var j = 0; j < imgList.length; j++) {
                            var imgData = imgList[j];
                            if (typeof imgData === 'string') {
                                try {
                                    imgData = JSON.parse(imgData);
                                } catch (e) {
                                    continue;
                                }
                            }
                            if (imgData) {
                                var baseSettings = parseBaseSettings(imgData.baseSettings);
                                var buttonSettings = parseButtonSettings(imgData.buttonSettings);
                                
                                itemImages.push({
                                    itemId: Number(imgData.itemId || 1),
                                    baseImage: baseSettings.baseImage,
                                    baseImageDisabled: baseSettings.baseImageDisabled,
                                    baseCondition: baseSettings.condition,
                                    buttonImage: buttonSettings.buttonImage,
                                    buttonImageDisabled: buttonSettings.buttonImageDisabled,
                                    buttonHoverImage: buttonSettings.buttonHoverImage,
                                    buttonOffsetX: buttonSettings.buttonOffsetX,
                                    buttonOffsetY: buttonSettings.buttonOffsetY,
                                    commonEventId: buttonSettings.commonEventId,
                                    buttonCondition: buttonSettings.condition
                                });
                            }
                        }
                    }
                }
                
                result[itemWindowId] = {
                    x: Number(settings.x || 0),
                    y: Number(settings.y || 0),
                    backgroundImage: String(settings.backgroundImage || ''),
                    windowBackgroundImage: String(settings.windowBackgroundImage || ''),
                    useWindowImageSize: settings.useWindowImageSize === 'true' || settings.useWindowImageSize === true,
                    windowOffsetX: Number(settings.windowOffsetX || 0),
                    windowOffsetY: Number(settings.windowOffsetY || 0),
                    itemWidth: Number(settings.itemWidth || 48),
                    itemHeight: Number(settings.itemHeight || 48),
                    columns: Number(settings.columns || 4),
                    maxRows: Number(settings.maxRows || 3),
                    spacingX: Number(settings.spacingX || 4),
                    spacingY: Number(settings.spacingY || 4),
                    paddingLeft: Number(settings.paddingLeft !== undefined ? settings.paddingLeft : (settings.padding !== undefined ? settings.padding : 18)),
                    paddingRight: Number(settings.paddingRight !== undefined ? settings.paddingRight : (settings.padding !== undefined ? settings.padding : 18)),
                    paddingTop: Number(settings.paddingTop !== undefined ? settings.paddingTop : (settings.padding !== undefined ? settings.padding : 18)),
                    paddingBottom: Number(settings.paddingBottom !== undefined ? settings.paddingBottom : (settings.padding !== undefined ? settings.padding : 18)),
                    itemImages: itemImages,
                    clickItemIdVariable: Number(settings.clickItemIdVariable || 0),
                    useHoverEffect: settings.useHoverEffect !== 'false' && settings.useHoverEffect !== false,
                    useDisabledImages: settings.useDisabledImages !== 'false' && settings.useDisabledImages !== false,
                    disabledFilterOpacity: Number(settings.disabledFilterOpacity !== undefined ? settings.disabledFilterOpacity : 128),
                    closeSettings: parseCloseSettings(settings.closeSettings),
                    scrollBarId: String(settings.scrollBarId || ''),
                    transitionId: String(settings.transitionId || ''),
                    allowPlayerMovement: settings.allowPlayerMovement === 'true' || settings.allowPlayerMovement === true
                };
            }
            return result;
        } catch (e) {
            console.error('CustomWindow: ItemWindowSettings parse error', e);
            return {};
        }
    };

    var pluginName = 'CustomWindow';
    
    var getPluginParameters = function() {
        var scripts = document.getElementsByTagName('script');
        for (var i = 0; i < scripts.length; i++) {
            var src = scripts[i].src;
            if (src.indexOf(pluginName) >= 0) {
                var scriptName = src.substring(src.lastIndexOf('/') + 1);
                scriptName = scriptName.replace('.js', '');
                return PluginManager.parameters(scriptName);
            }
        }
        return PluginManager.parameters(pluginName);
    };

    var parameters = getPluginParameters();
    
    var parseCustomFonts = function(jsonStr) {
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return {};
            var result = {};
            for (var i = 0; i < parsed.length; i++) {
                var fontData = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                if (fontData && fontData.fontName && fontData.fontFile) {
                    result[fontData.fontName] = fontData.fontFile;
                }
            }
            return result;
        } catch (e) {
            return {};
        }
    };

    var parseTextPresets = function(jsonStr) {
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return {};
            var result = {};
            for (var i = 0; i < parsed.length; i++) {
                var presetData = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                if (presetData && presetData.presetId) {
                    result[presetData.presetId] = {
                        fontName: String(presetData.fontName || ''),
                        fontSize: Number(presetData.fontSize || 26),
                        textColor: String(presetData.textColor || '#ffffff'),
                        outlineColor: String(presetData.outlineColor || '#000000'),
                        outlineWidth: Number(presetData.outlineWidth || 4)
                    };
                }
            }
            return result;
        } catch (e) {
            return {};
        }
    };

    var parseTransitionEffects = function(jsonStr) {
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return {};
            var result = {};
            for (var i = 0; i < parsed.length; i++) {
                var transData = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                if (transData && transData.transitionId) {
                    result[transData.transitionId] = {
                        transitionImage: String(transData.transitionImage || ''),
                        fadeOutDuration: Number(transData.fadeOutDuration || 30),
                        fadeInDuration: Number(transData.fadeInDuration || 30),
                        fadeOutReverse: transData.fadeOutReverse === 'true' || transData.fadeOutReverse === true,
                        fadeInReverse: transData.fadeInReverse === 'true' || transData.fadeInReverse === true,
                        fadeColor: String(transData.fadeColor || '#000000')
                    };
                }
            }
            return result;
        } catch (e) {
            return {};
        }
    };

    var parseSwitchConditions = function(jsonStr) {
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return [];
            var result = [];
            for (var i = 0; i < parsed.length; i++) {
                var data = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                if (data && data.switchId) {
                    result.push({
                        switchId: Number(data.switchId || 0),
                        switchValue: data.switchValue === 'true' || data.switchValue === true
                    });
                }
            }
            return result;
        } catch (e) {
            return [];
        }
    };

    var parseVariableConditions = function(jsonStr) {
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return [];
            var result = [];
            for (var i = 0; i < parsed.length; i++) {
                var data = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                if (data && data.variableId) {
                    result.push({
                        variableId: Number(data.variableId || 0),
                        comparison: String(data.comparison || 'gte'),
                        value: Number(data.value || 0)
                    });
                }
            }
            return result;
        } catch (e) {
            return [];
        }
    };

    var parseRequiredSkills = function(jsonStr) {
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return [];
            var result = [];
            for (var i = 0; i < parsed.length; i++) {
                var skillId = Number(parsed[i]);
                if (skillId > 0) {
                    result.push(skillId);
                }
            }
            return result;
        } catch (e) {
            return [];
        }
    };

    var parseSkillNodeCondition = function(jsonStr) {
        try {
            var data = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            return {
                requiredSkills: parseRequiredSkills(data.requiredSkills || '[]'),
                switchConditions: parseSwitchConditions(data.switchConditions || '[]'),
                variableConditions: parseVariableConditions(data.variableConditions || '[]')
            };
        } catch (e) {
            return {
                requiredSkills: [],
                switchConditions: [],
                variableConditions: []
            };
        }
    };

    var parseDescriptionImageSettings = function(jsonStr) {
        try {
            var data = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            return {
                imageDisabled: String(data.imageDisabled || ''),
                imageLearnable: String(data.imageLearnable || ''),
                imageLearned: String(data.imageLearned || ''),
                x: Number(data.x || 0),
                y: Number(data.y || 0)
            };
        } catch (e) {
            return {
                imageDisabled: '',
                imageLearnable: '',
                imageLearned: '',
                x: 0,
                y: 0
            };
        }
    };

    var parseConnectionImages = function(jsonStr) {
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return [];
            var result = [];
            for (var i = 0; i < parsed.length; i++) {
                var data = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                if (data && data.image) {
                    result.push({
                        image: String(data.image || ''),
                        x: Number(data.x || 0),
                        y: Number(data.y || 0)
                    });
                }
            }
            return result;
        } catch (e) {
            return [];
        }
    };

    var parseSkillNodes = function(jsonStr) {
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return [];
            var result = [];
            for (var i = 0; i < parsed.length; i++) {
                var nodeData = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                if (nodeData) {
                    result.push({
                        skillId: Number(nodeData.skillId || 1),
                        requiredSP: Number(nodeData.requiredSP || 1),
                        nodeImage: String(nodeData.nodeImage || ''),
                        nodeImageLearned: String(nodeData.nodeImageLearned || ''),
                        nodeImageDisabled: String(nodeData.nodeImageDisabled || ''),
                        descriptionImageSettings: parseDescriptionImageSettings(nodeData.descriptionImageSettings || '{}'),
                        nodeX: Number(nodeData.nodeX || 0),
                        nodeY: Number(nodeData.nodeY || 0),
                        nodeWidth: Number(nodeData.nodeWidth || 48),
                        nodeHeight: Number(nodeData.nodeHeight || 48),
                        filterOpacity: nodeData.filterOpacity !== undefined ? Number(nodeData.filterOpacity) : -1,
                        learnCondition: parseSkillNodeCondition(nodeData.learnCondition || '{}'),
                        connectionImages: parseConnectionImages(nodeData.connectionImages || '[]')
                    });
                }
            }
            return result;
        } catch (e) {
            return [];
        }
    };

    var parseCursorSettings = function(jsonStr) {
        try {
            var data = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            return {
                cursorImage: String(data.cursorImage || ''),
                cursorOffsetX: Number(data.cursorOffsetX || 0),
                cursorOffsetY: Number(data.cursorOffsetY || 0),
                selectSE: String(data.selectSE || ''),
                selectSEVolume: Number(data.selectSEVolume || 90),
                selectSEPitch: Number(data.selectSEPitch || 100),
                selectSEPan: Number(data.selectSEPan || 0),
                upUseConnection: data.upUseConnection === 'true' || data.upUseConnection === true,
                downUseConnection: data.downUseConnection === 'true' || data.downUseConnection === true,
                leftUseConnection: data.leftUseConnection !== 'false' && data.leftUseConnection !== false,
                rightUseConnection: data.rightUseConnection !== 'false' && data.rightUseConnection !== false
            };
        } catch (e) {
            return {
                cursorImage: '',
                cursorOffsetX: 0,
                cursorOffsetY: 0,
                selectSE: '',
                selectSEVolume: 90,
                selectSEPitch: 100,
                selectSEPan: 0,
                upUseConnection: false,
                downUseConnection: false,
                leftUseConnection: true,
                rightUseConnection: true
            };
        }
    };

    var parseConfirmWindowSettings = function(jsonStr) {
        try {
            var data = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            return {
                width: Number(data.width || 300),
                height: Number(data.height || 150),
                backgroundImage: String(data.backgroundImage || ''),
                confirmText: String(data.confirmText || '習得しますか？'),
                yesText: String(data.yesText || 'はい'),
                noText: String(data.noText || 'いいえ'),
                textColor: String(data.textColor || '#ffffff'),
                fontSize: Number(data.fontSize || 24),
                buttonLayout: String(data.buttonLayout || 'horizontal')
            };
        } catch (e) {
            return {
                width: 300,
                height: 150,
                backgroundImage: '',
                confirmText: '習得しますか？',
                yesText: 'はい',
                noText: 'いいえ',
                textColor: '#ffffff',
                fontSize: 24,
                buttonLayout: 'horizontal'
            };
        }
    };

    var parseSkillPointDisplaySettings = function(jsonStr) {
        try {
            var data = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            return {
                x: Number(data.x || 10),
                y: Number(data.y || 10),
                width: Number(data.width || 200),
                format: String(data.format || 'SP: %1'),
                textPresetId: String(data.textPresetId || ''),
                fontSize: Number(data.fontSize || 24),
                textColor: String(data.textColor || '#ffffff'),
                outlineColor: String(data.outlineColor || '#000000'),
                outlineWidth: Number(data.outlineWidth || 4),
                textAlign: String(data.textAlign || 'left'),
                useSpriteSheet: data.useSpriteSheet === 'true' || data.useSpriteSheet === true,
                spriteSheetImage: String(data.spriteSheetImage || ''),
                digitSpacing: Number(data.digitSpacing || 0),
                decorationImage: String(data.decorationImage || ''),
                decorationOffsetX: Number(data.decorationOffsetX || 0),
                decorationOffsetY: Number(data.decorationOffsetY || 0)
            };
        } catch (e) {
            return {
                x: 10,
                y: 10,
                width: 200,
                format: 'SP: %1',
                textPresetId: '',
                fontSize: 24,
                textColor: '#ffffff',
                outlineColor: '#000000',
                outlineWidth: 4,
                textAlign: 'left',
                useSpriteSheet: false,
                spriteSheetImage: '',
                digitSpacing: 0,
                decorationImage: '',
                decorationOffsetX: 0,
                decorationOffsetY: 0
            };
        }
    };

    var parseSkillTreeWindowSettings = function(jsonStr) {
        try {
            var parsed = JSON.parse(jsonStr);
            if (!Array.isArray(parsed)) return {};
            var result = {};
            for (var i = 0; i < parsed.length; i++) {
                var windowData = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                if (windowData && windowData.windowId) {
                    result[windowData.windowId] = {
                        windowId: String(windowData.windowId),
                        actorId: Number(windowData.actorId || 0),
                        x: Number(windowData.x || 100),
                        y: Number(windowData.y || 100),
                        width: Number(windowData.width || 600),
                        height: Number(windowData.height || 400),
                        backgroundImage: String(windowData.backgroundImage || ''),
                        useImageSize: windowData.useImageSize === 'true' || windowData.useImageSize === true,
                        skillNodes: parseSkillNodes(windowData.skillNodes || '[]'),
                        unlearnedFilterOpacity: windowData.unlearnedFilterOpacity !== undefined ? Number(windowData.unlearnedFilterOpacity) : 128,
                        skillPointVariable: Number(windowData.skillPointVariable || 0),
                        showSkillPointDisplay: windowData.showSkillPointDisplay !== 'false' && windowData.showSkillPointDisplay !== false,
                        skillPointDisplaySettings: parseSkillPointDisplaySettings(windowData.skillPointDisplaySettings || '{}'),
                        showConfirmWindow: windowData.showConfirmWindow === 'true' || windowData.showConfirmWindow === true,
                        confirmWindowSettings: parseConfirmWindowSettings(windowData.confirmWindowSettings || '{}'),
                        cursorSettings: parseCursorSettings(windowData.cursorSettings || '{}'),
                        allowPlayerMovement: windowData.allowPlayerMovement === 'true' || windowData.allowPlayerMovement === true,
                        transitionId: String(windowData.transitionId || '')
                    };
                }
            }
            return result;
        } catch (e) {
            return {};
        }
    };

    var customFonts = {};
    var textPresets = parseTextPresets(parameters['TextPresets'] || '[]');
    var transitionEffects = parseTransitionEffects(parameters['TransitionList'] || '[]');
    var skillTreeWindowSettings = parseSkillTreeWindowSettings(parameters['SkillTreeWindowList'] || '[]');
    
    var parseSlotTemplate = function(jsonStr) {
        try {
            var data = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            return {
                slotCount: Number(data.slotCount || 20),
                startSlotId: Number(data.startSlotId || 1),
                columns: Number(data.columns || 1),
                x: Number(data.x || 0),
                y: Number(data.y || 0),
                offsetX: data.offsetX !== undefined ? Number(data.offsetX) : 0,
                offsetY: data.offsetY !== undefined ? Number(data.offsetY) : 10,
                width: Number(data.width || 300),
                height: Number(data.height || 80),
                backgroundImage: String(data.backgroundImage || ''),
                backgroundImageUsed: String(data.backgroundImageUsed || ''),
                backgroundImageSelected: String(data.backgroundImageSelected || ''),
                selectionFrameImage: String(data.selectionFrameImage || ''),
                selectionFrameOffsetX: Number(data.selectionFrameOffsetX || 0),
                selectionFrameOffsetY: Number(data.selectionFrameOffsetY || 0),
                showPlaytime: data.showPlaytime !== 'false' && data.showPlaytime !== false,
                playtimeX: Number(data.playtimeX || 10),
                playtimeY: Number(data.playtimeY || 10),
                playtimeScaleX: Number(data.playtimeScaleX || 1.0),
                showTimestamp: data.showTimestamp !== 'false' && data.showTimestamp !== false,
                timestampX: Number(data.timestampX || 10),
                timestampY: Number(data.timestampY || 30),
                timestampScaleX: Number(data.timestampScaleX || 1.0),
                timestampSplit: data.timestampSplit === 'true' || data.timestampSplit === true,
                timestampLineHeight: Number(data.timestampLineHeight || 24),
                showScreenshot: data.showScreenshot === 'true' || data.showScreenshot === true,
                screenshotX: Number(data.screenshotX || 0),
                screenshotY: Number(data.screenshotY || 0),
                screenshotWidth: Number(data.screenshotWidth || 144),
                screenshotHeight: Number(data.screenshotHeight || 81),
                textPresetId: String(data.textPresetId || ''),
                textElements: parseSlotTextElements(data.textElements || '[]'),
                gaugeElements: parseSlotGaugeElements(data.gaugeElements || '[]')
            };
        } catch (e) {
            return {
                slotCount: 20,
                startSlotId: 1,
                columns: 1,
                x: 0,
                y: 0,
                offsetX: 0,
                offsetY: 90,
                width: 300,
                height: 80,
                backgroundImage: '',
                backgroundImageUsed: '',
                backgroundImageSelected: '',
                selectionFrameImage: '',
                selectionFrameOffsetX: 0,
                selectionFrameOffsetY: 0,
                showPlaytime: true,
                playtimeX: 10,
                playtimeY: 10,
                playtimeScaleX: 1.0,
                showTimestamp: true,
                timestampX: 10,
                timestampY: 30,
                timestampScaleX: 1.0,
                timestampSplit: false,
                timestampLineHeight: 24,
                showScreenshot: false,
                screenshotX: 0,
                screenshotY: 0,
                screenshotWidth: 144,
                screenshotHeight: 81,
                textPresetId: '',
                textElements: [],
                gaugeElements: []
            };
        }
    };

    var parseSlotGaugeElements = function(jsonStr) {
        try {
            var parsed = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            if (!Array.isArray(parsed)) return [];
            var result = [];
            for (var i = 0; i < parsed.length; i++) {
                var gaugeData = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                result.push({
                    x: Number(gaugeData.x || 0),
                    y: Number(gaugeData.y || 0),
                    backgroundImage: String(gaugeData.backgroundImage || ''),
                    gaugeImage: String(gaugeData.gaugeImage || ''),
                    currentVariableId: Number(gaugeData.currentVariableId || 1),
                    maxVariableId: Number(gaugeData.maxVariableId || 2),
                    direction: String(gaugeData.direction || 'horizontal'),
                    overlayImage: String(gaugeData.overlayImage || ''),
                    overlayOffsetX: Number(gaugeData.overlayOffsetX || 0),
                    overlayOffsetY: Number(gaugeData.overlayOffsetY || 0)
                });
            }
            return result;
        } catch (e) {
            return [];
        }
    };

    var parseSlotTextElements = function(jsonStr) {
        try {
            var parsed = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            if (!Array.isArray(parsed)) return [];
            var result = [];
            for (var i = 0; i < parsed.length; i++) {
                var textData = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                result.push({
                    text: String(textData.text || ''),
                    x: Number(textData.x || 0),
                    y: Number(textData.y || 0),
                    width: Number(textData.width || 200),
                    textAlign: String(textData.textAlign || 'left'),
                    fontSize: Number(textData.fontSize || 0),
                    textColor: String(textData.textColor || '#ffffff'),
                    outlineColor: String(textData.outlineColor || '#000000'),
                    outlineWidth: Number(textData.outlineWidth !== undefined ? textData.outlineWidth : 4),
                    showOnEmpty: textData.showOnEmpty === 'true' || textData.showOnEmpty === true,
                    textPresetId: String(textData.textPresetId || ''),
                    variableId: Number(textData.variableId || 0),
                    scaleX: Number(textData.scaleX || 1.0)
                });
            }
            return result;
        } catch (e) {
            return [];
        }
    };

    var parseSaveLoadTextElements = function(jsonStr) {
        try {
            var parsed = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            if (!Array.isArray(parsed)) return [];
            var result = [];
            for (var i = 0; i < parsed.length; i++) {
                var textData = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                result.push({
                    text: String(textData.text || ''),
                    x: Number(textData.x || 0),
                    y: Number(textData.y || 0),
                    width: Number(textData.width || 200),
                    textAlign: String(textData.textAlign || 'left'),
                    textPresetId: String(textData.textPresetId || '')
                });
            }
            return result;
        } catch (e) {
            return [];
        }
    };

    var parseSaveLoadButtonElements = function(jsonStr) {
        try {
            var parsed = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            if (!Array.isArray(parsed)) return [];
            var result = [];
            for (var i = 0; i < parsed.length; i++) {
                var buttonData = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                result.push({
                    buttonId: String(buttonData.buttonId || 'button1'),
                    x: Number(buttonData.x || 0),
                    y: Number(buttonData.y || 0),
                    useScreenCoordinates: buttonData.useScreenCoordinates === 'true' || buttonData.useScreenCoordinates === true,
                    image: String(buttonData.image || ''),
                    imageHover: String(buttonData.imageHover || ''),
                    imagePressed: String(buttonData.imagePressed || ''),
                    action: String(buttonData.action || 'back'),
                    clickSE: String(buttonData.clickSE || '')
                });
            }
            return result;
        } catch (e) {
            return [];
        }
    };

    var parseSaveScreenSettings = function(jsonStr) {
        try {
            var data = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            return {
                enabled: data.enabled === 'true' || data.enabled === true,
                sceneBackgroundImage: String(data.sceneBackgroundImage || ''),
                x: Number(data.x || 0),
                y: Number(data.y || 0),
                width: Number(data.width || 816),
                height: Number(data.height || 624),
                windowImage: String(data.windowImage || ''),
                useImageSize: data.useImageSize === 'true' || data.useImageSize === true,
                windowPaddingTop: Number(data.windowPaddingTop || 0),
                windowPaddingBottom: Number(data.windowPaddingBottom || 0),
                windowPaddingLeft: Number(data.windowPaddingLeft || 0),
                windowPaddingRight: Number(data.windowPaddingRight || 0),
                hideDefaultWindows: data.hideDefaultWindows === 'true' || data.hideDefaultWindows === true,
                scrollBarId: String(data.scrollBarId || ''),
                slotTemplate: parseSlotTemplate(data.slotTemplate || '{}'),
                textElements: parseSaveLoadTextElements(data.textElements || '[]'),
                buttonElements: parseSaveLoadButtonElements(data.buttonElements || '[]')
            };
        } catch (e) {
            return {
                enabled: false,
                sceneBackgroundImage: '',
                x: 0,
                y: 0,
                width: 816,
                height: 624,
                windowImage: '',
                useImageSize: true,
                windowPaddingTop: 0,
                windowPaddingBottom: 0,
                windowPaddingLeft: 0,
                windowPaddingRight: 0,
                hideDefaultWindows: false,
                scrollBarId: '',
                slotTemplate: parseSlotTemplate('{}'),
                textElements: [],
                buttonElements: []
            };
        }
    };

    var parseIdArray = function(value) {
        try {
            var arr = typeof value === 'string' ? JSON.parse(value) : value;
            if (!Array.isArray(arr)) return [];
            return arr.map(function(v) { return Number(v || 0); }).filter(function(v) { return v > 0; });
        } catch (e) {
            return [];
        }
    };

    var parseScrollBarSettingsList = function(jsonStr) {
        try {
            var parsed = typeof jsonStr === 'string' ? JSON.parse(jsonStr) : jsonStr;
            if (!Array.isArray(parsed)) return {};
            var result = {};
            for (var i = 0; i < parsed.length; i++) {
                var data = typeof parsed[i] === 'string' ? JSON.parse(parsed[i]) : parsed[i];
                var id = String(data.id || 'scrollbar' + i);
                var skinTop = String(data.skinTop || '');
                var skinMiddle = String(data.skinMiddle || '');
                var skinBottom = String(data.skinBottom || '');
                var skinBg = String(data.skinBg || '');
                var useSkin = !!(skinTop || skinMiddle || skinBottom || skinBg);
                result[id] = {
                    id: id,
                    width: Number(data.width || 12),
                    color: String(data.color || '#ffffff'),
                    bgColor: String(data.bgColor || '#000000'),
                    useSkin: useSkin,
                    skinTop: skinTop,
                    skinMiddle: skinMiddle,
                    skinBottom: skinBottom,
                    skinBg: skinBg,
                    offsetX: Number(data.offsetX || 0)
                };
            }
            return result;
        } catch (e) {
            return {};
        }
    };

    var sharedVariableStartId = Number(parameters['SharedVariableStartId'] || 0);
    var sharedVariableEndId = Number(parameters['SharedVariableEndId'] || 0);
    var sharedVariableList = parseIdArray(parameters['SharedVariableList'] || '[]');
    var sharedSwitchStartId = Number(parameters['SharedSwitchStartId'] || 0);
    var sharedSwitchEndId = Number(parameters['SharedSwitchEndId'] || 0);
    var sharedSwitchList = parseIdArray(parameters['SharedSwitchList'] || '[]');

    var scrollBarSettings = parseScrollBarSettingsList(parameters['ScrollBarSettingsList'] || '[]');
    var commonSlotTemplate = parseSlotTemplate(parameters['CommonSlotTemplate'] || '{}');
    var saveScreenSettings = parseSaveScreenSettings(parameters['SaveScreenSettings'] || '{}');
    var loadScreenSettings = parseSaveScreenSettings(parameters['LoadScreenSettings'] || '{}');
    var titleLoadScreenSettings = parseSaveScreenSettings(parameters['TitleLoadScreenSettings'] || '{}');
    
    if (saveScreenSettings.enabled) {
        saveScreenSettings.slotTemplate = commonSlotTemplate;
    }
    if (loadScreenSettings.enabled) {
        loadScreenSettings.slotTemplate = commonSlotTemplate;
    }
    if (titleLoadScreenSettings.enabled) {
        titleLoadScreenSettings.slotTemplate = commonSlotTemplate;
    }

    var windowBasePresets = parseWindowBasePresetList(parameters['WindowBasePresetList'] || '[]');
    _windowBasePresets = windowBasePresets;

    var params = {
        windowBasePresets: windowBasePresets,
        windowSettings: parseWindowSettings(parameters['WindowSettingsList'] || '[]'),
        itemWindowSettings: parseItemWindowSettings(parameters['ItemWindowSettingsList'] || '[]'),
        skillTreeWindowSettings: skillTreeWindowSettings,
        scrollBarSettings: scrollBarSettings,
        commonSlotTemplate: commonSlotTemplate,
        saveScreenSettings: saveScreenSettings,
        loadScreenSettings: loadScreenSettings,
        titleLoadScreenSettings: titleLoadScreenSettings,
        customFonts: customFonts,
        textPresets: textPresets,
        transitionEffects: transitionEffects,
        screenshotQuality: Number(parameters['screenshotQuality'] || 0.92),
        screenshotFormat: String(parameters['screenshotFormat'] || 'jpeg'),
        hoverScaleX: Number(parameters['HoverScaleX'] || 1.00),
        hoverScaleY: Number(parameters['HoverScaleY'] || 1.00),
        hoverOffsetX: Number(parameters['HoverOffsetX'] || 0),
        hoverOffsetY: Number(parameters['HoverOffsetY'] || 0),
        pressScaleX: Number(parameters['PressScaleX'] || 0.95),
        pressScaleY: Number(parameters['PressScaleY'] || 0.95),
        pressOffsetX: Number(parameters['PressOffsetX'] || 0),
        pressOffsetY: Number(parameters['PressOffsetY'] || 2),
        useEasing: parameters['UseEasing'] !== 'false',
        easingDuration: Number(parameters['EasingDuration'] || 8),
        easingType: String(parameters['EasingType'] || 'easeOut'),
        scrollSpeed: Number(parameters['ScrollSpeed'] || 20),
        windowOpacity: Number(parameters['WindowOpacity'] || 255),
        backOpacity: Number(parameters['BackOpacity'] || 192),
        sharedVariableStartId: sharedVariableStartId,
        sharedVariableEndId: sharedVariableEndId,
        sharedVariableList: sharedVariableList,
        sharedSwitchStartId: sharedSwitchStartId,
        sharedSwitchEndId: sharedSwitchEndId,
        sharedSwitchList: sharedSwitchList
    };

    var _cwUniquePush = function(list, value) {
        if (value > 0 && list.indexOf(value) === -1) {
            list.push(value);
        }
    };

    var _cwGetSharedVariableIds = function() {
        var ids = [];
        var start = params.sharedVariableStartId || 0;
        var end = params.sharedVariableEndId || 0;
        if (start > 0 && end >= start) {
            for (var i = start; i <= end; i++) {
                _cwUniquePush(ids, i);
            }
        }
        for (var j = 0; j < params.sharedVariableList.length; j++) {
            _cwUniquePush(ids, params.sharedVariableList[j]);
        }
        return ids;
    };

    var _cwGetSharedSwitchIds = function() {
        var ids = [];
        var start = params.sharedSwitchStartId || 0;
        var end = params.sharedSwitchEndId || 0;
        if (start > 0 && end >= start) {
            for (var i = start; i <= end; i++) {
                _cwUniquePush(ids, i);
            }
        }
        for (var j = 0; j < params.sharedSwitchList.length; j++) {
            _cwUniquePush(ids, params.sharedSwitchList[j]);
        }
        return ids;
    };

    var _cwCollectSharedVariables = function() {
        if (!_cwGetSharedVariableIds().length || !$gameVariables) return {};
        var map = {};
        var ids = _cwGetSharedVariableIds();
        for (var i = 0; i < ids.length; i++) {
            var id = ids[i];
            map[id] = $gameVariables.value(id);
        }
        return map;
    };

    var _cwCollectSharedSwitches = function() {
        if (!_cwGetSharedSwitchIds().length || !$gameSwitches) return {};
        var map = {};
        var ids = _cwGetSharedSwitchIds();
        for (var i = 0; i < ids.length; i++) {
            var id = ids[i];
            map[id] = !!$gameSwitches.value(id);
        }
        return map;
    };

    var _cwApplySharedVariables = function(map) {
        if (!map || !_cwGetSharedVariableIds().length || !$gameVariables) return;
        var ids = _cwGetSharedVariableIds();
        for (var i = 0; i < ids.length; i++) {
            var id = ids[i];
            var key = Object.prototype.hasOwnProperty.call(map, id) ? id : String(id);
            if (Object.prototype.hasOwnProperty.call(map, key)) {
                $gameVariables.setValue(id, map[key]);
            }
        }
    };

    var _cwApplySharedSwitches = function(map) {
        if (!map || !_cwGetSharedSwitchIds().length || !$gameSwitches) return;
        var ids = _cwGetSharedSwitchIds();
        for (var i = 0; i < ids.length; i++) {
            var id = ids[i];
            var key = Object.prototype.hasOwnProperty.call(map, id) ? id : String(id);
            if (Object.prototype.hasOwnProperty.call(map, key)) {
                $gameSwitches.setValue(id, !!map[key]);
            }
        }
    };

    var _cw_ConfigManager_makeData = ConfigManager.makeData;
    ConfigManager.makeData = function() {
        var config = _cw_ConfigManager_makeData.apply(this, arguments);
        config.cwSharedVariables = this._cwSharedVariables;
        config.cwSharedSwitches = this._cwSharedSwitches;
        return config;
    };

    var _cw_ConfigManager_applyData = ConfigManager.applyData;
    ConfigManager.applyData = function(config) {
        _cw_ConfigManager_applyData.apply(this, arguments);
        config = config || {};
        this._cwSharedVariables = config.cwSharedVariables || null;
        this._cwSharedSwitches = config.cwSharedSwitches || null;
    };

    ConfigManager.saveCwSharedState = function() {
        if (!_cwGetSharedVariableIds().length && !_cwGetSharedSwitchIds().length) return;
        
        var newVariables = _cwCollectSharedVariables();
        var newSwitches = _cwCollectSharedSwitches();
        
        
        if (this._cwSharedSwitches) {
            for (var key in this._cwSharedSwitches) {
                if (this._cwSharedSwitches[key] === true) {
                    newSwitches[key] = true; 
                }
            }
        }
        
        
        if (this._cwSharedVariables) {
            for (var key in this._cwSharedVariables) {
                var existingVal = this._cwSharedVariables[key];
                var newVal = newVariables[key];
                
                if ((newVal === 0 || newVal === undefined || newVal === '') && existingVal) {
                    newVariables[key] = existingVal;
                }
            }
        }
        
        this._cwSharedVariables = newVariables;
        this._cwSharedSwitches = newSwitches;
        console.log('[CustomWindow] saveCwSharedState - Variables:', this._cwSharedVariables);
        console.log('[CustomWindow] saveCwSharedState - Switches:', this._cwSharedSwitches);
        this.save();
    };

    ConfigManager.loadCwSharedState = function() {
        console.log('[CustomWindow] loadCwSharedState called');
        console.log('[CustomWindow] _cwSharedVariables:', this._cwSharedVariables);
        console.log('[CustomWindow] _cwSharedSwitches:', this._cwSharedSwitches);
        console.log('[CustomWindow] SharedSwitchIds:', _cwGetSharedSwitchIds());
        console.log('[CustomWindow] $gameSwitches exists:', !!$gameSwitches);
        _cwApplySharedVariables(this._cwSharedVariables);
        _cwApplySharedSwitches(this._cwSharedSwitches);
    };

    
    var _cw_DataManager_setupNewGame = DataManager.setupNewGame;
    DataManager.setupNewGame = function() {
        _cw_DataManager_setupNewGame.apply(this, arguments);
        if (ConfigManager.loadCwSharedState) {
            ConfigManager.loadCwSharedState();
        }
    };

    var _cw_DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function(contents) {
        _cw_DataManager_extractSaveContents.apply(this, arguments);
        if (ConfigManager.loadCwSharedState) {
            ConfigManager.loadCwSharedState();
        }
    };

    var _cw_DataManager_saveGame = DataManager.saveGame;
    DataManager.saveGame = function(savefileId) {
        var result = _cw_DataManager_saveGame.apply(this, arguments);
        if (result && typeof result.then === 'function') {
            return result.then(function(value) {
                if (ConfigManager.saveCwSharedState) {
                    ConfigManager.saveCwSharedState();
                }
                return value;
            });
        } else if (result) {
            if (ConfigManager.saveCwSharedState) {
                ConfigManager.saveCwSharedState();
            }
        }
        return result;
    };

    
    var _Game_Temp_reserveCommonEvent = Game_Temp.prototype.reserveCommonEvent;
    Game_Temp.prototype.reserveCommonEvent = function(commonEventId) {
        console.log('reserveCommonEvent called with ID: ' + commonEventId);
        console.trace('Call stack:');
        _Game_Temp_reserveCommonEvent.call(this, commonEventId);
    };

    ImageManager.loadCustomWindowPicture = function(filename, hue) {
        return this.loadBitmap('img/customwindow/', filename, hue, true);
    };

    var DEFAULT_SCROLLBAR_SETTINGS = {
        id: '',
        width: 12,
        color: '#ffffff',
        bgColor: '#000000',
        useSkin: false,
        skinTop: '',
        skinMiddle: '',
        skinBottom: '',
        skinBg: '',
        offsetX: 0
    };

    var getScrollBarSettingsById = function(scrollBarId) {
        if (scrollBarId && params.scrollBarSettings[scrollBarId]) {
            return params.scrollBarSettings[scrollBarId];
        }
        return DEFAULT_SCROLLBAR_SETTINGS;
    };

    var loadCustomFonts = function() {
        for (var fontName in customFonts) {
            var fontFile = customFonts[fontName];
            var fontUrl = 'fonts/' + fontFile;
            
            if (document.fonts && typeof FontFace !== 'undefined') {
                var fontFace = new FontFace(fontName, 'url(' + fontUrl + ')');
                fontFace.load().then(function(loadedFace) {
                    document.fonts.add(loadedFace);
                }).catch(function(error) {
                    console.warn('CustomWindow: Font load failed - ' + fontName);
                });
            } else {
                var style = document.createElement('style');
                style.textContent = '@font-face { font-family: "' + fontName + '"; src: url("' + fontUrl + '"); }';
                document.head.appendChild(style);
            }
        }
    };

    var collectFontsFromPresets = function() {
        for (var presetId in textPresets) {
            var preset = textPresets[presetId];
            if (preset.fontName) {
                var fontName = preset.fontName;
                var fontFile = fontName;
                
                fontName = fontName.replace(/\.(ttf|otf|woff|woff2)$/i, '');
                
                if (!customFonts[fontName]) {
                    if (!/\.(ttf|otf|woff|woff2)$/i.test(fontFile)) {
                        fontFile = fontFile + '.ttf';
                    }
                    customFonts[fontName] = fontFile;
                }
            }
        }
    };
    
    collectFontsFromPresets();
    
    loadCustomFonts();

    var preloadItemWindowImages = function() {
        for (var itemWindowId in params.itemWindowSettings) {
            var settings = params.itemWindowSettings[itemWindowId];
            if (settings.windowBackgroundImage) {
                ImageManager.loadCustomWindowPicture(settings.windowBackgroundImage);
            }
            if (settings.backgroundImage) {
                ImageManager.loadCustomWindowPicture(settings.backgroundImage);
            }
        }
    };
    preloadItemWindowImages();

    var _customWindowMouseX = 0;
    var _customWindowMouseY = 0;

    document.addEventListener('mousemove', function(event) {
        if (Graphics && Graphics.pageToCanvasX) {
            _customWindowMouseX = Graphics.pageToCanvasX(event.pageX);
            _customWindowMouseY = Graphics.pageToCanvasY(event.pageY);
        }
    });

    var _imageCache = {};

    var loadPictureSize = function(filename, callback) {
        if (!filename) {
            callback(null);
            return;
        }
        
        if (_imageCache[filename]) {
            callback(_imageCache[filename]);
            return;
        }

        var bitmap;
        if (isMZ) {
            bitmap = ImageManager.loadCustomWindowPicture(filename);
        } else {
            bitmap = ImageManager.loadCustomWindowPicture(filename);
        }

        if (bitmap.isReady()) {
            _imageCache[filename] = { width: bitmap.width, height: bitmap.height };
            callback(_imageCache[filename]);
        } else {
            bitmap.addLoadListener(function() {
                _imageCache[filename] = { width: bitmap.width, height: bitmap.height };
                callback(_imageCache[filename]);
            });
        }
    };

    var getPictureSizeSync = function(filename) {
        return _imageCache[filename] || null;
    };

    var isMZ = Utils.RPGMAKER_NAME === 'MZ';

    var _Game_System_initialize = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function() {
        _Game_System_initialize.call(this);
        this._displayedWindowIds = [];
        this._customWindowImageLists = {};
    };

    Game_System.prototype.addDisplayedWindow = function(windowId) {
        if (!this._displayedWindowIds) this._displayedWindowIds = [];
        this.removeDisplayedWindow(windowId);
        this._displayedWindowIds.push(windowId);
    };

    Game_System.prototype.removeDisplayedWindow = function(windowId) {
        if (!this._displayedWindowIds) return;
        var index = this._displayedWindowIds.indexOf(windowId);
        if (index >= 0) {
            this._displayedWindowIds.splice(index, 1);
        }
        if (this._customWindowImageLists && this._customWindowImageLists[windowId]) {
            delete this._customWindowImageLists[windowId];
        }
    };

    Game_System.prototype.getDisplayedWindowIds = function() {
        return this._displayedWindowIds || [];
    };

    Game_System.prototype.clearCustomWindowData = function() {
        this._displayedWindowIds = [];
        this._customWindowImageLists = {};
    };

    Game_System.prototype.clearCustomWindowDataById = function(windowId) {
        this.removeDisplayedWindow(windowId);
    };

    Game_System.prototype.addCustomWindowImage = function(windowId, imageName, listId) {
        if (!this._customWindowImageLists) {
            this._customWindowImageLists = {};
        }
        windowId = windowId || 1;
        listId = listId || 1;
        
        if (!this._customWindowImageLists[windowId]) {
            this._customWindowImageLists[windowId] = {};
        }
        if (!this._customWindowImageLists[windowId][listId]) {
            this._customWindowImageLists[windowId][listId] = [];
        }
        this._customWindowImageLists[windowId][listId].push(imageName);
    };

    Game_System.prototype.getCustomWindowImageLists = function(windowId) {
        if (!this._customWindowImageLists) return {};
        return this._customWindowImageLists[windowId] || {};
    };

    Game_System.prototype.getCustomWindowImageList = function(windowId, listId) {
        if (!this._customWindowImageLists) return [];
        if (!this._customWindowImageLists[windowId]) return [];
        return this._customWindowImageLists[windowId][listId] || [];
    };

    Game_System.prototype.clearCustomWindowImageList = function(windowId, listId) {
        if (!this._customWindowImageLists) {
            this._customWindowImageLists = {};
            return;
        }
        if (!windowId) {
            this._customWindowImageLists = {};
        } else if (listId === 0 || listId === undefined) {
            delete this._customWindowImageLists[windowId];
        } else {
            if (this._customWindowImageLists[windowId]) {
                delete this._customWindowImageLists[windowId][listId];
            }
        }
    };

    function Window_Custom() {
        this.initialize.apply(this, arguments);
    }

    Window_Custom.prototype = Object.create(Window_Base.prototype);
    Window_Custom.prototype.constructor = Window_Custom;

    Window_Custom.prototype.initialize = function(rect, windowSettings, opacity, backOpacity, imageLists, windowId) {
        if (isMZ) {
            Window_Base.prototype.initialize.call(this, rect);
        } else {
            Window_Base.prototype.initialize.call(this, rect.x, rect.y, rect.width, rect.height);
        }
        
        this._windowId = windowId || 0;
        this._touchEnabled = true;
        
        this._selectedIndex = -1;
        this._selectableItems = [];
        this._inputMode = 'keyboard';
        this._initialHoverApplied = false;
        this._skipInitialHoverSE = true;  
        
        this._windowSettings = windowSettings || {};
        this._text = windowSettings.text || '';
        this._bgImageName = windowSettings.backgroundImage || '';
        this._bgSprite = null;
        this._imageLists = imageLists || {};
        this._imageSprites = [];
        this._scrollY = 0;
        this._maxScrollY = 0;
        this._contentHeight = 0;
        this._imageContainer = null;
        this._scrollBar = null;
        this._scrollBarBg = null;
        this._isDraggingScrollBar = false;
        this._dragStartY = 0;
        this._dragStartScrollY = 0;
        this._wasPressed = false;
        this._needsPositionUpdate = false;
        this._pressedButtonContainer = null;
        this.opacity = opacity !== undefined ? opacity : 255;
        this.backOpacity = backOpacity !== undefined ? backOpacity : 192;
        this._paddingTop = windowSettings.paddingTop !== undefined ? windowSettings.paddingTop : 18;
        this._paddingBottom = windowSettings.paddingBottom !== undefined ? windowSettings.paddingBottom : 18;
        this._paddingLeft = windowSettings.paddingLeft !== undefined ? windowSettings.paddingLeft : 18;
        this._paddingRight = windowSettings.paddingRight !== undefined ? windowSettings.paddingRight : 18;
        
        if (this._bgImageName) {
            this.createBackgroundSprite();
        }
        
        this.createImageContainer();
        
        if (Object.keys(this._imageLists).length > 0) {
            this.createImageListSprites();
        }
        
        this.createScrollBar();
        
        this.createCloseButton();
        
        this._confirmationVisible = false;
        this._confirmationContainer = null;
        
        this.refresh();
    };

    Window_Custom.prototype.getPaddingTop = function() {
        return this._paddingTop !== undefined ? this._paddingTop : (this.padding || 18);
    };

    Window_Custom.prototype.getPaddingBottom = function() {
        return this._paddingBottom !== undefined ? this._paddingBottom : (this.padding || 18);
    };

    Window_Custom.prototype.getPaddingLeft = function() {
        return this._paddingLeft !== undefined ? this._paddingLeft : (this.padding || 18);
    };

    Window_Custom.prototype.getPaddingRight = function() {
        return this._paddingRight !== undefined ? this._paddingRight : (this.padding || 18);
    };

    Window_Custom.prototype._getScrollBarSettings = function() {
        var scrollBarId = this._windowSettings.scrollBarId || '';
        return getScrollBarSettingsById(scrollBarId);
    };

    Window_Custom.prototype.createImageContainer = function() {
        var paddingLeft = this.getPaddingLeft();
        var paddingRight = this.getPaddingRight();
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var sbSettings = this._getScrollBarSettings();
        var scrollBarWidth = sbSettings.width || 12;
        var innerWidth = this.width - paddingLeft - paddingRight - scrollBarWidth;
        var innerHeight = this.height - paddingTop - paddingBottom;
        
        this._imageContainer = new PIXI.Container();
        this._imageContainer.x = paddingLeft;
        this._imageContainer.y = paddingTop;
        
        var mask = new PIXI.Graphics();
        mask.beginFill(0xffffff);
        mask.drawRect(0, 0, innerWidth, innerHeight);
        mask.endFill();
        mask.x = paddingLeft;
        mask.y = paddingTop;
        
        this.addChild(mask);
        this.addChild(this._imageContainer);
        this._imageContainer.mask = mask;
        this._containerMask = mask;
    };

    Window_Custom.prototype.createScrollBar = function() {
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var paddingRight = this.getPaddingRight();
        var sbSettings = this._getScrollBarSettings();
        this._scrollBarConfig = sbSettings;
        var scrollBarWidth = sbSettings.width || 12;
        var scrollBarX = this.width - paddingRight - scrollBarWidth;
        var scrollBarHeight = this.height - paddingTop - paddingBottom;
        
        if (sbSettings.useSkin) {
            this.createScrollBarSkin();
            return;
        }
        
        this._scrollBarBg = new PIXI.Graphics();
        this._scrollBarBg.beginFill(this.hexToNumber(sbSettings.bgColor || '#000000'), 0.5);
        this._scrollBarBg.drawRect(0, 0, scrollBarWidth, scrollBarHeight);
        this._scrollBarBg.endFill();
        this._scrollBarBg.x = scrollBarX;
        this._scrollBarBg.y = paddingTop;
        this.addChild(this._scrollBarBg);
        
        this._scrollBar = new PIXI.Graphics();
        this._scrollBar.x = scrollBarX;
        this._scrollBar.y = paddingTop;
        this.addChild(this._scrollBar);
        
        this.updateScrollBar();
    };

    Window_Custom.prototype.createScrollBarSkin = function() {
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var paddingRight = this.getPaddingRight();
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var scrollBarWidth = sbSettings.width || 12;
        var offsetX = sbSettings.offsetX || 0;
        var scrollBarCenterX = this.width - paddingRight - scrollBarWidth / 2 + offsetX;
        var scrollBarHeight = this.height - paddingTop - paddingBottom;
        
        this._scrollBarSkinContainer = new PIXI.Container();
        this._scrollBarSkinContainer.x = scrollBarCenterX;
        this._scrollBarSkinContainer.y = paddingTop;
        this.addChild(this._scrollBarSkinContainer);
        
        if (sbSettings.skinBg) {
            this._scrollBarBgSprite = new Sprite(ImageManager.loadCustomWindowPicture(sbSettings.skinBg));
            this._scrollBarBgSprite.anchor.x = 0.5;
            this._scrollBarBgSprite.x = 0;
            this._scrollBarBgSprite.y = 0;
            this._scrollBarSkinContainer.addChild(this._scrollBarBgSprite);
            
            var self = this;
            this._scrollBarBgSprite.bitmap.addLoadListener(function() {
                self.updateScrollBarSkinBgSize();
            });
        }
        
        this._scrollBarContainer = new PIXI.Container();
        this._scrollBarSkinContainer.addChild(this._scrollBarContainer);
        
        this._scrollBarTopSprite = null;
        if (sbSettings.skinTop) {
            this._scrollBarTopSprite = new Sprite(ImageManager.loadCustomWindowPicture(sbSettings.skinTop));
            this._scrollBarTopSprite.anchor.x = 0.5;
            this._scrollBarContainer.addChild(this._scrollBarTopSprite);
        }
        
        this._scrollBarMiddleSprite = null;
        if (sbSettings.skinMiddle) {
            this._scrollBarMiddleSprite = new Sprite(ImageManager.loadCustomWindowPicture(sbSettings.skinMiddle));
            this._scrollBarMiddleSprite.anchor.x = 0.5;
            this._scrollBarContainer.addChild(this._scrollBarMiddleSprite);
        }
        
        this._scrollBarBottomSprite = null;
        if (sbSettings.skinBottom) {
            this._scrollBarBottomSprite = new Sprite(ImageManager.loadCustomWindowPicture(sbSettings.skinBottom));
            this._scrollBarBottomSprite.anchor.x = 0.5;
            this._scrollBarContainer.addChild(this._scrollBarBottomSprite);
        }
        
        var self = this;
        this.preloadScrollBarSkinImages(function() {
            self.updateScrollBar();
        });
        
        this._scrollBar = this._scrollBarContainer;
        this._scrollBarBg = this._scrollBarSkinContainer;
    };

    Window_Custom.prototype.preloadScrollBarSkinImages = function(callback) {
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var images = [];
        if (sbSettings.skinTop) images.push(sbSettings.skinTop);
        if (sbSettings.skinMiddle) images.push(sbSettings.skinMiddle);
        if (sbSettings.skinBottom) images.push(sbSettings.skinBottom);
        if (sbSettings.skinBg) images.push(sbSettings.skinBg);
        
        if (images.length === 0) {
            callback();
            return;
        }
        
        var loadedCount = 0;
        for (var i = 0; i < images.length; i++) {
            var bitmap = ImageManager.loadCustomWindowPicture(images[i]);
            if (bitmap.isReady()) {
                loadedCount++;
                if (loadedCount >= images.length) callback();
            } else {
                bitmap.addLoadListener(function() {
                    loadedCount++;
                    if (loadedCount >= images.length) callback();
                });
            }
        }
    };

    Window_Custom.prototype.updateScrollBarSkinBgSize = function() {
        if (!this._scrollBarBgSprite || !this._scrollBarBgSprite.bitmap.isReady()) return;
        
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var scrollBarHeight = this.height - paddingTop - paddingBottom;
        var bitmap = this._scrollBarBgSprite.bitmap;
        
        this._scrollBarBgSprite.scale.y = scrollBarHeight / bitmap.height;
    };

    Window_Custom.prototype.hexToNumber = function(hex) {
        if (typeof hex === 'number') return hex;
        hex = hex.replace('#', '');
        return parseInt(hex, 16);
    };

    Window_Custom.prototype.createCloseButton = function() {
        var closeSettings = this._windowSettings.closeSettings;
        if (!closeSettings || !closeSettings.closeButtonImage) return;
        
        this._closeButtonSprite = new Sprite(ImageManager.loadCustomWindowPicture(closeSettings.closeButtonImage));
        this._closeButtonSprite.x = closeSettings.closeButtonX;
        this._closeButtonSprite.y = closeSettings.closeButtonY;
        this._closeButtonSprite._isCloseButton = true;
        this.addChild(this._closeButtonSprite);
        
        if (closeSettings.closeButtonHoverImage) {
            this._closeButtonHoverSprite = new Sprite(ImageManager.loadCustomWindowPicture(closeSettings.closeButtonHoverImage));
            this._closeButtonHoverSprite.x = closeSettings.closeButtonX;
            this._closeButtonHoverSprite.y = closeSettings.closeButtonY;
            this._closeButtonHoverSprite.visible = false;
            this.addChild(this._closeButtonHoverSprite);
        }
        
        this._closeButtonHovered = false;
    };
    
    Window_Custom.prototype.updateCloseButtonHover = function(touchX, touchY) {
        if (!this._closeButtonSprite) return false;
        
        var sprite = this._closeButtonSprite;
        var bitmap = sprite.bitmap;
        if (!bitmap || !bitmap.isReady()) return false;
        
        var localX = touchX - this.x - sprite.x;
        var localY = touchY - this.y - sprite.y;
        
        var isHovered = localX >= 0 && localX < bitmap.width && localY >= 0 && localY < bitmap.height;
        
        if (isHovered !== this._closeButtonHovered) {
            this._closeButtonHovered = isHovered;
            if (this._closeButtonHoverSprite) {
                this._closeButtonHoverSprite.visible = isHovered;
                this._closeButtonSprite.visible = !isHovered;
            }
        }
        
        return isHovered;
    };
    
    Window_Custom.prototype.isCloseButtonClicked = function(touchX, touchY) {
        if (!this._closeButtonSprite) return false;
        
        var sprite = this._closeButtonSprite;
        var bitmap = sprite.bitmap;
        if (!bitmap || !bitmap.isReady()) return false;
        
        var localX = touchX - this.x - sprite.x;
        var localY = touchY - this.y - sprite.y;
        
        return localX >= 0 && localX < bitmap.width && localY >= 0 && localY < bitmap.height;
    };
    
    Window_Custom.prototype.showConfirmation = function() {
        var closeSettings = this._windowSettings.closeSettings;
        if (!closeSettings || !closeSettings.showConfirmation) {
            this.closeWindow();
            return;
        }
        
        if (this._confirmationVisible) return;
        
        this._confirmationVisible = true;
        this.createConfirmationWindow();
    };
    
    Window_Custom.prototype.createConfirmationWindow = function() {
        var closeSettings = this._windowSettings.closeSettings;
        if (!closeSettings) return;
        
        this._confirmationContainer = new PIXI.Container();
        
        if (closeSettings.confirmBackgroundImage) {
            var bgSprite = new Sprite(ImageManager.loadCustomWindowPicture(closeSettings.confirmBackgroundImage));
            bgSprite.x = 0;
            bgSprite.y = 0;
            this._confirmationContainer.addChild(bgSprite);
            this._confirmBgSprite = bgSprite;
        }
        
        if (closeSettings.confirmYesImage) {
            var yesSprite = new Sprite(ImageManager.loadCustomWindowPicture(closeSettings.confirmYesImage));
            yesSprite.x = closeSettings.confirmYesX;
            yesSprite.y = closeSettings.confirmYesY;
            yesSprite._isYesButton = true;
            this._confirmationContainer.addChild(yesSprite);
            this._confirmYesSprite = yesSprite;
            
            if (closeSettings.confirmYesHoverImage) {
                var yesHoverSprite = new Sprite(ImageManager.loadCustomWindowPicture(closeSettings.confirmYesHoverImage));
                yesHoverSprite.x = closeSettings.confirmYesX;
                yesHoverSprite.y = closeSettings.confirmYesY;
                yesHoverSprite.visible = false;
                this._confirmationContainer.addChild(yesHoverSprite);
                this._confirmYesHoverSprite = yesHoverSprite;
            }
        }
        
        if (closeSettings.confirmNoImage) {
            var noSprite = new Sprite(ImageManager.loadCustomWindowPicture(closeSettings.confirmNoImage));
            noSprite.x = closeSettings.confirmNoX;
            noSprite.y = closeSettings.confirmNoY;
            noSprite._isNoButton = true;
            this._confirmationContainer.addChild(noSprite);
            this._confirmNoSprite = noSprite;
            
            if (closeSettings.confirmNoHoverImage) {
                var noHoverSprite = new Sprite(ImageManager.loadCustomWindowPicture(closeSettings.confirmNoHoverImage));
                noHoverSprite.x = closeSettings.confirmNoX;
                noHoverSprite.y = closeSettings.confirmNoY;
                noHoverSprite.visible = false;
                this._confirmationContainer.addChild(noHoverSprite);
                this._confirmNoHoverSprite = noHoverSprite;
            }
        }
        
        if (this._confirmBgSprite && this._confirmBgSprite.bitmap) {
            var self = this;
            this._confirmBgSprite.bitmap.addLoadListener(function() {
                self._confirmationContainer.x = (Graphics.width - self._confirmBgSprite.bitmap.width) / 2;
                self._confirmationContainer.y = (Graphics.height - self._confirmBgSprite.bitmap.height) / 2;
            });
        }
        
        var scene = SceneManager._scene;
        if (scene) {
            scene.addChild(this._confirmationContainer);
        }
        
        this._confirmYesHovered = false;
        this._confirmNoHovered = false;
    };
    
    Window_Custom.prototype.hideConfirmation = function() {
        if (!this._confirmationVisible) return;
        
        this._confirmationVisible = false;
        
        if (this._confirmationContainer) {
            var scene = SceneManager._scene;
            if (scene && this._confirmationContainer.parent) {
                scene.removeChild(this._confirmationContainer);
            }
            this._confirmationContainer = null;
            this._confirmBgSprite = null;
            this._confirmYesSprite = null;
            this._confirmYesHoverSprite = null;
            this._confirmNoSprite = null;
            this._confirmNoHoverSprite = null;
        }
    };
    
    Window_Custom.prototype.updateConfirmation = function() {
        if (!this._confirmationVisible || !this._confirmationContainer) return;
        
        var closeSettings = this._windowSettings.closeSettings;
        var touchX = TouchInput.x;
        var touchY = TouchInput.y;
        
        if (closeSettings && closeSettings.useCancelKey && Input.isTriggered('cancel')) {
            this.hideConfirmation();
            return;
        }
        
        if (closeSettings && closeSettings.useRightClick && TouchInput.isCancelled()) {
            this.hideConfirmation();
            return;
        }
        
        if (this._confirmYesSprite && this._confirmYesSprite.bitmap && this._confirmYesSprite.bitmap.isReady()) {
            var yesLocalX = touchX - this._confirmationContainer.x - this._confirmYesSprite.x;
            var yesLocalY = touchY - this._confirmationContainer.y - this._confirmYesSprite.y;
            var yesHovered = yesLocalX >= 0 && yesLocalX < this._confirmYesSprite.bitmap.width &&
                             yesLocalY >= 0 && yesLocalY < this._confirmYesSprite.bitmap.height;
            
            if (yesHovered !== this._confirmYesHovered) {
                this._confirmYesHovered = yesHovered;
                if (this._confirmYesHoverSprite) {
                    this._confirmYesHoverSprite.visible = yesHovered;
                    this._confirmYesSprite.visible = !yesHovered;
                }
            }
            
            if (yesHovered && TouchInput.isTriggered()) {
                this.hideConfirmation();
                this.closeWindow();
                return;
            }
        }
        
        if (this._confirmNoSprite && this._confirmNoSprite.bitmap && this._confirmNoSprite.bitmap.isReady()) {
            var noLocalX = touchX - this._confirmationContainer.x - this._confirmNoSprite.x;
            var noLocalY = touchY - this._confirmationContainer.y - this._confirmNoSprite.y;
            var noHovered = noLocalX >= 0 && noLocalX < this._confirmNoSprite.bitmap.width &&
                            noLocalY >= 0 && noLocalY < this._confirmNoSprite.bitmap.height;
            
            if (noHovered !== this._confirmNoHovered) {
                this._confirmNoHovered = noHovered;
                if (this._confirmNoHoverSprite) {
                    this._confirmNoHoverSprite.visible = noHovered;
                    this._confirmNoSprite.visible = !noHovered;
                }
            }
            
            if (noHovered && TouchInput.isTriggered()) {
                this.hideConfirmation();
                return;
            }
        }
    };
    
    Window_Custom.prototype.closeWindow = function() {
        var scene = SceneManager._scene;
        if (!scene) return;
        
        
        var closeSettings = this._windowSettings ? this._windowSettings.closeSettings : null;
        var returnToTitle = closeSettings && closeSettings.returnToTitle;
        
        if (this._itemWindowId) {
            if (scene.closeItemWindow) {
                scene.closeItemWindow(this._itemWindowId);
            }
            
            if (returnToTitle) {
                SceneManager.goto(Scene_Title);
            }
        } else if (this._windowId) {
            if (returnToTitle) {
                
                if (scene.closeCustomWindowAndGotoTitle) {
                    scene.closeCustomWindowAndGotoTitle(this._windowId);
                } else {
                    
                    if (scene.closeCustomWindow) {
                        scene.closeCustomWindow(this._windowId);
                    }
                    SceneManager.goto(Scene_Title);
                }
            } else {
                if (scene.closeCustomWindow) {
                    scene.closeCustomWindow(this._windowId);
                }
            }
        }
    };

    Window_Custom.prototype.updateScrollBar = function() {
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        if (sbSettings.useSkin) {
            this.updateScrollBarSkin();
            return;
        }
        
        if (!this._scrollBar) return;
        
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var scrollBarHeight = this.height - paddingTop - paddingBottom;
        var viewHeight = scrollBarHeight;
        var contentHeight = this._contentHeight || viewHeight;
        
        if (contentHeight <= viewHeight) {
            this._scrollBar.visible = false;
            this._scrollBarBg.visible = false;
            return;
        }
        
        this._scrollBar.visible = true;
        this._scrollBarBg.visible = true;
        
        var barHeight = Math.max(30, (viewHeight / contentHeight) * scrollBarHeight);
        var scrollRatio = this._scrollY / this._maxScrollY;
        var barY = scrollRatio * (scrollBarHeight - barHeight);
        
        var scrollBarWidth = sbSettings.width || 12;
        var scrollBarColor = sbSettings.color || '#ffffff';
        
        this._scrollBar.clear();
        this._scrollBar.beginFill(this.hexToNumber(scrollBarColor), 0.8);
        this._scrollBar.drawRoundedRect(0, barY, scrollBarWidth, barHeight, scrollBarWidth / 2);
        this._scrollBar.endFill();
    };

    Window_Custom.prototype.updateScrollBarSkin = function() {
        if (!this._scrollBarContainer) return;
        
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var scrollBarHeight = this.height - paddingTop - paddingBottom;
        var viewHeight = scrollBarHeight;
        var contentHeight = this._contentHeight || viewHeight;
        
        if (contentHeight <= viewHeight) {
            if (this._scrollBarSkinContainer) {
                this._scrollBarSkinContainer.visible = false;
            }
            return;
        }
        
        if (this._scrollBarSkinContainer) {
            this._scrollBarSkinContainer.visible = true;
        }
        
        var topHeight = 0;
        var bottomHeight = 0;
        
        if (this._scrollBarTopSprite && this._scrollBarTopSprite.bitmap.isReady()) {
            topHeight = this._scrollBarTopSprite.bitmap.height;
        }
        if (this._scrollBarBottomSprite && this._scrollBarBottomSprite.bitmap.isReady()) {
            bottomHeight = this._scrollBarBottomSprite.bitmap.height;
        }
        
        var topOverhang = topHeight / 2;
        var bottomOverhang = bottomHeight / 2;
        var effectiveScrollHeight = scrollBarHeight + topOverhang + bottomOverhang;
        
        var barHeight = Math.max(topHeight + bottomHeight, (viewHeight / contentHeight) * scrollBarHeight);
        var scrollRatio = this._maxScrollY > 0 ? this._scrollY / this._maxScrollY : 0;
        
        var barY = -topOverhang + scrollRatio * (scrollBarHeight - barHeight + topOverhang + bottomOverhang);
        
        var middleHeight = Math.max(0, barHeight - topHeight - bottomHeight);
        
        this._scrollBarContainer.y = barY;
        
        if (this._scrollBarTopSprite) {
            this._scrollBarTopSprite.x = 0;
            this._scrollBarTopSprite.y = 0;
        }
        
        if (this._scrollBarMiddleSprite && this._scrollBarMiddleSprite.bitmap.isReady()) {
            this._scrollBarMiddleSprite.x = 0;
            this._scrollBarMiddleSprite.y = topHeight;
            var originalMiddleHeight = this._scrollBarMiddleSprite.bitmap.height;
            if (originalMiddleHeight > 0) {
                this._scrollBarMiddleSprite.scale.y = middleHeight / originalMiddleHeight;
            }
        }
        
        if (this._scrollBarBottomSprite) {
            this._scrollBarBottomSprite.x = 0;
            this._scrollBarBottomSprite.y = topHeight + middleHeight;
        }
    };

    Window_Custom.prototype.createImageListSprites = function() {
        this.clearImageListSprites();
        
        var self = this;
        var ws = this._windowSettings || {};
        var offsetX = ws.imageOffsetX || 0;
        var offsetY = ws.imageOffsetY || 0;
        var spacingX = ws.imageSpacingX || 4;
        var spacingY = ws.imageSpacingY || 4;
        
        var listIds = Object.keys(this._imageLists).map(Number).sort(function(a, b) { return a - b; });
        
        var columnWidths = [];
        var columnItems = [];
        
        for (var i = 0; i < listIds.length; i++) {
            var listId = listIds[i];
            var items = this._imageLists[listId];
            if (!items || items.length === 0) {
                columnWidths.push(0);
                columnItems.push([]);
                continue;
            }
            
            columnItems.push(items);
            
            var maxWidth = 0;
            for (var rowIndex = 0; rowIndex < items.length; rowIndex++) {
                var item = items[rowIndex];
                var imageName = '';
                if (typeof item === 'string') {
                    imageName = item;
                } else {
                    imageName = item.baseImage || item.buttonImage || item.overlayImage || '';
                }
                var cachedSize = getPictureSizeSync(imageName);
                if (cachedSize) {
                    maxWidth = Math.max(maxWidth, cachedSize.width);
                } else {
                    maxWidth = Math.max(maxWidth, 48);
                }
            }
            columnWidths.push(maxWidth);
        }
        
        var columnX = [];
        var currentX = offsetX;
        for (var i = 0; i < columnWidths.length; i++) {
            columnX.push(currentX);
            currentX += columnWidths[i] + spacingX;
        }
        
        for (var colIdx = 0; colIdx < listIds.length; colIdx++) {
            var listId = listIds[colIdx];
            var items = columnItems[colIdx];
            if (!items || items.length === 0) continue;
            
            var currentY = offsetY;
            
            for (var rowIndex = 0; rowIndex < items.length; rowIndex++) {
                var item = items[rowIndex];
                if (!item) continue;
                
                var imageItem;
                if (typeof item === 'string') {
                    imageItem = {
                        baseImage: item,
                        overlayImage: '',
                        buttonImage: '',
                        buttonHoverImage: '',
                        commonEventId: 0
                    };
                } else {
                    imageItem = item;
                }
                
                if (!imageItem.baseImage && !imageItem.overlayImage && !imageItem.buttonImage) continue;
                
                (function(lId, rIdx, imgItem, xPos, yPos) {
                    var baseConditionMet = checkBaseCondition(imgItem);
                    var overlayConditionMet = checkOverlayCondition(imgItem);
                    var buttonConditionMet = checkButtonCondition(imgItem);
                    
                    var ws = self._windowSettings || {};
                    var useDisabledImg = ws.useDisabledImages !== false;
                    
                    var itemContainer = new Sprite();
                    itemContainer.x = xPos;
                    itemContainer.y = yPos;
                    itemContainer._listId = lId;
                    itemContainer._rowIndex = rIdx;
                    itemContainer._imageItem = imgItem;
                    itemContainer._isHovered = false;
                    itemContainer._isEnabled = buttonConditionMet;
                    itemContainer._baseConditionMet = baseConditionMet;
                    itemContainer._overlayConditionMet = overlayConditionMet;
                    itemContainer._buttonConditionMet = buttonConditionMet;
                    
                    if (useDisabledImg && imgItem.baseImage && imgItem.baseImageDisabled) {
                        itemContainer._baseImageEnabled = imgItem.baseImage;
                        itemContainer._baseImageDisabled = imgItem.baseImageDisabled;
                        ImageManager.loadCustomWindowPicture(imgItem.baseImage);
                        ImageManager.loadCustomWindowPicture(imgItem.baseImageDisabled);
                    }
                    if (useDisabledImg && imgItem.overlayImage && imgItem.overlayImageDisabled) {
                        itemContainer._overlayImageEnabled = imgItem.overlayImage;
                        itemContainer._overlayImageDisabled = imgItem.overlayImageDisabled;
                        ImageManager.loadCustomWindowPicture(imgItem.overlayImage);
                        ImageManager.loadCustomWindowPicture(imgItem.overlayImageDisabled);
                    }
                    if (useDisabledImg && imgItem.buttonImage && imgItem.buttonImageDisabled) {
                        itemContainer._buttonImageEnabled = imgItem.buttonImage;
                        itemContainer._buttonImageDisabled = imgItem.buttonImageDisabled;
                        ImageManager.loadCustomWindowPicture(imgItem.buttonImage);
                        ImageManager.loadCustomWindowPicture(imgItem.buttonImageDisabled);
                    }
                    
                    if (imgItem.baseImage || imgItem.baseImageDisabled) {
                        var baseImageName = (baseConditionMet || !useDisabledImg) ? imgItem.baseImage : 
                            (imgItem.baseImageDisabled || imgItem.baseImage);
                        if (baseImageName) {
                            var baseBitmap = ImageManager.loadCustomWindowPicture(baseImageName);
                            var baseSprite = new Sprite(baseBitmap);
                            baseSprite._type = 'base';
                            itemContainer.addChild(baseSprite);
                            itemContainer._baseSprite = baseSprite;
                            
                            if (!useDisabledImg && !baseConditionMet) {
                                var darkness = ws.disabledFilterOpacity !== undefined ? ws.disabledFilterOpacity : 128;
                                baseSprite.setBlendColor([0, 0, 0, darkness]);
                            }
                        }
                    }
                    
                    if (imgItem.overlayImage || imgItem.overlayImageDisabled) {
                        var overlayImageName = (overlayConditionMet || !useDisabledImg) ? imgItem.overlayImage : 
                            (imgItem.overlayImageDisabled || imgItem.overlayImage);
                        if (overlayImageName) {
                            var overlayBitmap = ImageManager.loadCustomWindowPicture(overlayImageName);
                            var overlaySprite = new Sprite(overlayBitmap);
                            overlaySprite._type = 'overlay';
                            itemContainer.addChild(overlaySprite);
                            itemContainer._overlaySprite = overlaySprite;
                            
                            if (!useDisabledImg && !overlayConditionMet) {
                                var darkness = ws.disabledFilterOpacity !== undefined ? ws.disabledFilterOpacity : 128;
                                overlaySprite.setBlendColor([0, 0, 0, darkness]);
                            }
                        }
                    }
                    
                    if (imgItem.buttonImage || imgItem.buttonImageDisabled) {
                        var buttonImageName = (buttonConditionMet || !useDisabledImg) ? imgItem.buttonImage : 
                            (imgItem.buttonImageDisabled || imgItem.buttonImage);
                        var buttonBitmap = ImageManager.loadCustomWindowPicture(buttonImageName);
                        var buttonSprite = new Sprite(buttonBitmap);
                        buttonSprite._type = 'button';
                        buttonSprite.x = imgItem.buttonOffsetX || 0;
                        buttonSprite.y = imgItem.buttonOffsetY || 0;
                        buttonSprite.visible = true;
                        itemContainer.addChild(buttonSprite);
                        itemContainer._buttonSprite = buttonSprite;
                        
                        var disabledDarken = imgItem.disabledDarken !== false;
                        if (!buttonConditionMet && disabledDarken) {
                            var darkness = imgItem.disabledDarkenOpacity !== undefined ? imgItem.disabledDarkenOpacity : 
                                (ws.disabledFilterOpacity !== undefined ? ws.disabledFilterOpacity : 128);
                            buttonSprite.setBlendColor([0, 0, 0, darkness]);
                            itemContainer._disabledToneApplied = true;
                        }
                        
                        if (imgItem.buttonHoverImage && buttonConditionMet) {
                            var hoverBitmap = ImageManager.loadCustomWindowPicture(imgItem.buttonHoverImage);
                            var hoverSprite = new Sprite(hoverBitmap);
                            hoverSprite._type = 'buttonHover';
                            hoverSprite.x = imgItem.buttonOffsetX || 0;
                            hoverSprite.y = imgItem.buttonOffsetY || 0;
                            hoverSprite.visible = false;
                            itemContainer.addChild(hoverSprite);
                            itemContainer._buttonHoverSprite = hoverSprite;
                        }
                    }
                    
                    if (imgItem.textList && imgItem.textList.length > 0) {
                        itemContainer._textSprites = [];
                        for (var ti = 0; ti < imgItem.textList.length; ti++) {
                            var textItem = imgItem.textList[ti];
                            var textSprite = self.createTextSprite(textItem);
                            if (textSprite) {
                                textSprite._textItem = textItem;
                                textSprite._textIndex = ti;
                                var textConditionMet = evaluateCondition(textItem.condition);
                                textSprite.visible = textConditionMet;
                                textSprite._conditionMet = textConditionMet;
                                itemContainer.addChild(textSprite);
                                itemContainer._textSprites.push(textSprite);
                            }
                        }
                    }
                    
                    itemContainer._useDisabledImages = useDisabledImg;
                    
                    self._imageSprites.push(itemContainer);
                    
                    if (self._imageContainer) {
                        self._imageContainer.addChild(itemContainer);
                    }
                    
                    var primaryBitmap = itemContainer._baseSprite ? itemContainer._baseSprite.bitmap :
                        (itemContainer._buttonSprite ? itemContainer._buttonSprite.bitmap :
                        (itemContainer._overlaySprite ? itemContainer._overlaySprite.bitmap : null));
                    if (primaryBitmap && !primaryBitmap.isReady()) {
                        self._needsPositionUpdate = true;
                    }
                })(listId, rowIndex, imageItem, columnX[colIdx], currentY);
                
                var primaryImage = imageItem.baseImage || imageItem.buttonImage || imageItem.overlayImage || '';
                var cachedSize = getPictureSizeSync(primaryImage);
                if (cachedSize) {
                    currentY += cachedSize.height + spacingY;
                } else {
                    currentY += 48 + spacingY;
                    this._needsPositionUpdate = true;
                }
            }
        }
        
        this.updateImagePositions();
        
        this.updateContentHeight();
        this.updateScrollRange();
        this.updateScrollBar();
    };

    Window_Custom.prototype.updateContentHeight = function() {
        var ws = this._windowSettings || {};
        var offsetY = ws.imageOffsetY || 0;
        var spacingY = ws.imageSpacingY || 4;
        
        var maxHeight = 0;
        var listIds = Object.keys(this._imageLists).map(Number).sort(function(a, b) { return a - b; });
        
        for (var i = 0; i < listIds.length; i++) {
            var listId = listIds[i];
            var items = this._imageLists[listId];
            if (!items || items.length === 0) continue;
            
            var columnHeight = offsetY;
            for (var rowIndex = 0; rowIndex < items.length; rowIndex++) {
                var spriteHeight = 0;
                for (var j = 0; j < this._imageSprites.length; j++) {
                    var container = this._imageSprites[j];
                    if (container._listId === listId && container._rowIndex === rowIndex) {
                        if (container._baseSprite && container._baseSprite.bitmap && container._baseSprite.bitmap.isReady()) {
                            spriteHeight = container._baseSprite.bitmap.height;
                        } else if (container._buttonSprite && container._buttonSprite.bitmap && container._buttonSprite.bitmap.isReady()) {
                            spriteHeight = container._buttonSprite.bitmap.height;
                        } else if (container._overlaySprite && container._overlaySprite.bitmap && container._overlaySprite.bitmap.isReady()) {
                            spriteHeight = container._overlaySprite.bitmap.height;
                        }
                        break;
                    }
                }
                
                if (spriteHeight === 0) {
                    var item = items[rowIndex];
                    var primaryImage = typeof item === 'string' ? item : (item.baseImage || item.buttonImage || item.overlayImage || '');
                    var cachedSize = getPictureSizeSync(primaryImage);
                    if (cachedSize) {
                        spriteHeight = cachedSize.height;
                    } else {
                        spriteHeight = 48;
                    }
                }
                
                columnHeight += spriteHeight + spacingY;
            }
            maxHeight = Math.max(maxHeight, columnHeight);
        }
        
        this._contentHeight = maxHeight;
    };

    Window_Custom.prototype.updateImagePositions = function() {
        var ws = this._windowSettings || {};
        var offsetX = ws.imageOffsetX || 0;
        var offsetY = ws.imageOffsetY || 0;
        var spacingX = ws.imageSpacingX || 4;
        var spacingY = ws.imageSpacingY || 4;
        
        var listIds = Object.keys(this._imageLists).map(Number).sort(function(a, b) { return a - b; });
        
        var columnWidths = [];
        for (var i = 0; i < listIds.length; i++) {
            var listId = listIds[i];
            var items = this._imageLists[listId];
            if (!items || items.length === 0) {
                columnWidths.push(0);
                continue;
            }
            
            var maxWidth = 0;
            for (var rowIndex = 0; rowIndex < items.length; rowIndex++) {
                for (var j = 0; j < this._imageSprites.length; j++) {
                    var container = this._imageSprites[j];
                    if (container._listId === listId && container._rowIndex === rowIndex) {
                        var spriteWidth = 0;
                        if (container._baseSprite && container._baseSprite.bitmap && container._baseSprite.bitmap.isReady()) {
                            spriteWidth = container._baseSprite.bitmap.width;
                        } else if (container._buttonSprite && container._buttonSprite.bitmap && container._buttonSprite.bitmap.isReady()) {
                            spriteWidth = container._buttonSprite.bitmap.width;
                        } else if (container._overlaySprite && container._overlaySprite.bitmap && container._overlaySprite.bitmap.isReady()) {
                            spriteWidth = container._overlaySprite.bitmap.width;
                        }
                        maxWidth = Math.max(maxWidth, spriteWidth);
                        break;
                    }
                }
            }
            columnWidths.push(maxWidth);
        }
        
        var columnX = [];
        var currentX = offsetX;
        for (var i = 0; i < columnWidths.length; i++) {
            columnX.push(currentX);
            currentX += columnWidths[i] + spacingX;
        }
        
        for (var colIdx = 0; colIdx < listIds.length; colIdx++) {
            var listId = listIds[colIdx];
            var items = this._imageLists[listId];
            if (!items || items.length === 0) continue;
            
            var currentY = offsetY;
            
            for (var rowIndex = 0; rowIndex < items.length; rowIndex++) {
                for (var j = 0; j < this._imageSprites.length; j++) {
                    var container = this._imageSprites[j];
                    if (container._listId === listId && container._rowIndex === rowIndex) {
                        container.x = columnX[colIdx];
                        container._originalY = currentY;
                        container.y = currentY - this._scrollY;
                        
                        var spriteHeight = 0;
                        if (container._baseSprite && container._baseSprite.bitmap && container._baseSprite.bitmap.isReady()) {
                            spriteHeight = container._baseSprite.bitmap.height;
                        } else if (container._buttonSprite && container._buttonSprite.bitmap && container._buttonSprite.bitmap.isReady()) {
                            spriteHeight = container._buttonSprite.bitmap.height;
                        } else if (container._overlaySprite && container._overlaySprite.bitmap && container._overlaySprite.bitmap.isReady()) {
                            spriteHeight = container._overlaySprite.bitmap.height;
                        }
                        currentY += spriteHeight + spacingY;
                        break;
                    }
                }
            }
        }
        
        this.updateContentHeight();
    };

    Window_Custom.prototype.updateScrollRange = function() {
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var viewHeight = this.height - paddingTop - paddingBottom;
        this._maxScrollY = Math.max(0, this._contentHeight - viewHeight);
        
        if (this._scrollY > this._maxScrollY) {
            this._scrollY = this._maxScrollY;
        }
    };

    Window_Custom.prototype.scrollBy = function(delta) {
        var newScrollY = this._scrollY + delta;
        newScrollY = Math.max(0, Math.min(this._maxScrollY, newScrollY));
        
        if (this._scrollY !== newScrollY) {
            this._scrollY = newScrollY;
            this.updateImagePositions();
            this.updateScrollBar();
        }
    };

    Window_Custom.prototype.getWindowId = function() {
        return this._windowId;
    };

    Window_Custom.prototype.setTouchEnabled = function(enabled) {
        this._touchEnabled = enabled;
    };

    Window_Custom.prototype.isTouchEnabled = function() {
        return this._touchEnabled;
    };

    Window_Custom.prototype.update = function() {
        Window_Base.prototype.update.call(this);
        
        
        if (this._isSuspended) {
            return;
        }
        
        if (this._confirmationVisible) {
            this.updateConfirmation();
            return;
        }
        
        this.updateImagePositionsIfNeeded();
        this.updateSelectableItems();
        this.processIndexSelection();
        this.processScroll();
        
        if (this.processCloseInput()) return;
        
        
        
        this.processButtonHover();
        this.processButtonClick();
        this.updateButtonEasing();
        this.updateConditions();
    };
    
    
    Window_Custom.prototype._saveSuspendState = function() {
        this._suspendOriginalOpacity = this.opacity;
        this._suspendOriginalContentsOpacity = this.contentsOpacity;
        if (this._bgSprite) {
            this._suspendOriginalBgOpacity = this._bgSprite.opacity;
        }
    };
    
    Window_Custom.prototype._applySuspendOpacity = function(opacity) {
        var ratio = opacity / 255;
        
        
        if (opacity === 255) {
            this.opacity = this._suspendOriginalOpacity !== undefined ? this._suspendOriginalOpacity : 255;
            this.contentsOpacity = this._suspendOriginalContentsOpacity !== undefined ? this._suspendOriginalContentsOpacity : 255;
            if (this._bgSprite) {
                this._bgSprite.opacity = this._suspendOriginalBgOpacity !== undefined ? this._suspendOriginalBgOpacity : 255;
            }
        } else {
            this.opacity = Math.floor((this._suspendOriginalOpacity || 255) * ratio);
            this.contentsOpacity = Math.floor((this._suspendOriginalContentsOpacity || 255) * ratio);
            if (this._bgSprite) {
                this._bgSprite.opacity = Math.floor((this._suspendOriginalBgOpacity || 255) * ratio);
            }
        }
        
        
        if (this._imageContainer) {
            this._setContainerOpacity(this._imageContainer, opacity);
        }
        
        
        if (this._scrollBar) {
            this._scrollBar.alpha = ratio;
        }
        if (this._scrollBarBg) {
            this._scrollBarBg.alpha = ratio;
        }
        
        
        if (this._scrollBarSkinContainer) {
            this._setContainerOpacity(this._scrollBarSkinContainer, opacity);
        }
        if (this._scrollBarContainer) {
            this._setContainerOpacity(this._scrollBarContainer, opacity);
        }
        if (this._scrollBarBgSprite) {
            this._scrollBarBgSprite.opacity = opacity;
        }
        if (this._scrollBarTopSprite) {
            this._scrollBarTopSprite.opacity = opacity;
        }
        if (this._scrollBarMiddleSprite) {
            this._scrollBarMiddleSprite.opacity = opacity;
        }
        if (this._scrollBarBottomSprite) {
            this._scrollBarBottomSprite.opacity = opacity;
        }
        if (this._scrollBarSprite) {
            this._scrollBarSprite.opacity = opacity;
        }
        
        
        if (this._closeButtonSprite) {
            this._closeButtonSprite.opacity = opacity;
        }
        
        
        if (this._confirmationContainer) {
            this._setContainerOpacity(this._confirmationContainer, opacity);
        }
    };
    
    
    Window_Custom.prototype._setContainerOpacity = function(container, opacity) {
        if (!container || !container.children) return;
        for (var i = 0; i < container.children.length; i++) {
            var child = container.children[i];
            if (child) {
                if (child.opacity !== undefined) {
                    child.opacity = opacity;
                }
                if (child.alpha !== undefined && !(child instanceof PIXI.Graphics)) {
                    child.alpha = opacity / 255;
                }
                
                if (child.children && child.children.length > 0) {
                    this._setContainerOpacity(child, opacity);
                }
            }
        }
    };
    
    Window_Custom.prototype.processCloseInput = function() {
        var closeSettings = this._windowSettings.closeSettings;
        if (!closeSettings) {
            return this.processCloseButton();
        }
        
        if (closeSettings.useCancelKey && Input.isTriggered('cancel')) {
            this.showConfirmation();
            return true;
        }
        
        if (closeSettings.useRightClick && TouchInput.isCancelled()) {
            this.showConfirmation();
            return true;
        }
        
        return this.processCloseButton();
    };
    
    Window_Custom.prototype.processCloseButton = function() {
        if (!this._closeButtonSprite) return false;
        
        var touchX = _customWindowMouseX;
        var touchY = _customWindowMouseY;
        
        var isHovered = this.updateCloseButtonHover(touchX, touchY);
        
        if (isHovered && TouchInput.isTriggered()) {
            this.showConfirmation();
            return true;
        }
        
        return false;
    };
    
    Window_Custom.prototype.updateConditions = function() {
        var ws = this._windowSettings || {};
        var darkness = ws.disabledFilterOpacity !== undefined ? ws.disabledFilterOpacity : 128;
        
        for (var i = 0; i < this._imageSprites.length; i++) {
            var container = this._imageSprites[i];
            var imageItem = container._imageItem;
            if (!imageItem) continue;
            
            var useDisabledImages = container._useDisabledImages !== false;
            
            var newBaseCondition = checkBaseCondition(imageItem);
            var newOverlayCondition = checkOverlayCondition(imageItem);
            var newButtonCondition = checkButtonCondition(imageItem);
            
            var needsUpdate = false;
            
            if (container._baseConditionMet !== newBaseCondition) {
                container._baseConditionMet = newBaseCondition;
                if (useDisabledImages) {
                    if (container._baseSprite && container._baseImageEnabled && container._baseImageDisabled) {
                        var newBaseImage = newBaseCondition ? container._baseImageEnabled : container._baseImageDisabled;
                        container._baseSprite.bitmap = ImageManager.loadCustomWindowPicture(newBaseImage);
                    }
                } else {
                    if (container._baseSprite) {
                        if (newBaseCondition) {
                            container._baseSprite.setBlendColor([0, 0, 0, 0]);
                        } else {
                            container._baseSprite.setBlendColor([0, 0, 0, darkness]);
                        }
                    }
                }
            }
            
            if (container._overlayConditionMet !== newOverlayCondition) {
                container._overlayConditionMet = newOverlayCondition;
                if (useDisabledImages) {
                    if (container._overlaySprite && container._overlayImageEnabled && container._overlayImageDisabled) {
                        var newOverlayImage = newOverlayCondition ? container._overlayImageEnabled : container._overlayImageDisabled;
                        container._overlaySprite.bitmap = ImageManager.loadCustomWindowPicture(newOverlayImage);
                    }
                } else {
                    if (container._overlaySprite) {
                        if (newOverlayCondition) {
                            container._overlaySprite.setBlendColor([0, 0, 0, 0]);
                        } else {
                            container._overlaySprite.setBlendColor([0, 0, 0, darkness]);
                        }
                    }
                }
            }
            
            if (container._buttonConditionMet !== newButtonCondition) {
                container._buttonConditionMet = newButtonCondition;
                container._isEnabled = newButtonCondition;
                
                if (useDisabledImages) {
                    if (container._buttonSprite && container._buttonImageEnabled && container._buttonImageDisabled) {
                        var newButtonImage = newButtonCondition ? container._buttonImageEnabled : container._buttonImageDisabled;
                        container._buttonSprite.bitmap = ImageManager.loadCustomWindowPicture(newButtonImage);
                    }
                    if (container._isIconButton && container._buttonSprite) {
                        container._buttonSprite.opacity = newButtonCondition ? 255 : 128;
                    }
                }
                
                var disabledDarken = imageItem.disabledDarken !== false;
                if (container._buttonSprite) {
                    if (newButtonCondition) {
                        container._buttonSprite.setBlendColor([0, 0, 0, 0]);
                    } else if (disabledDarken) {
                        var buttonDarkness = imageItem.disabledDarkenOpacity !== undefined ? imageItem.disabledDarkenOpacity : darkness;
                        container._buttonSprite.setBlendColor([0, 0, 0, buttonDarkness]);
                    }
                }
                
                if (newButtonCondition && imageItem.buttonHoverImage) {
                    if (!container._buttonHoverSprite) {
                        var hoverBitmap = ImageManager.loadCustomWindowPicture(imageItem.buttonHoverImage);
                        var hoverSprite = new Sprite(hoverBitmap);
                        hoverSprite._type = 'buttonHover';
                        hoverSprite.x = imageItem.buttonOffsetX || 0;
                        hoverSprite.y = imageItem.buttonOffsetY || 0;
                        hoverSprite.visible = false;
                        container.addChild(hoverSprite);
                        container._buttonHoverSprite = hoverSprite;
                    }
                } else {
                    if (container._buttonHoverSprite) {
                        container.removeChild(container._buttonHoverSprite);
                        container._buttonHoverSprite = null;
                    }
                    if (container._isHovered) {
                        container._isHovered = false;
                        if (container._buttonSprite) {
                            container._buttonSprite.visible = true;
                        }
                    }
                }
            }
            
            if (container._textSprites && container._textSprites.length > 0) {
                for (var ti = 0; ti < container._textSprites.length; ti++) {
                    var textSprite = container._textSprites[ti];
                    var textItem = textSprite._textItem;
                    if (textItem) {
                        var newTextCondition = evaluateCondition(textItem.condition);
                        if (textSprite._conditionMet !== newTextCondition) {
                            textSprite._conditionMet = newTextCondition;
                            textSprite.visible = newTextCondition;
                        }
                    }
                }
            }
        }
    };
    
    Window_Custom.prototype.updateContainerImages = function(container, isEnabled) {
        if (container._baseSprite && container._baseImageEnabled && container._baseImageDisabled) {
            var newBaseImage = isEnabled ? container._baseImageEnabled : container._baseImageDisabled;
            container._baseSprite.bitmap = ImageManager.loadCustomWindowPicture(newBaseImage);
        }
        
        if (container._overlaySprite && container._overlayImageEnabled && container._overlayImageDisabled) {
            var newOverlayImage = isEnabled ? container._overlayImageEnabled : container._overlayImageDisabled;
            container._overlaySprite.bitmap = ImageManager.loadCustomWindowPicture(newOverlayImage);
        }
        
        if (container._buttonSprite && container._buttonImageEnabled && container._buttonImageDisabled) {
            var newButtonImage = isEnabled ? container._buttonImageEnabled : container._buttonImageDisabled;
            container._buttonSprite.bitmap = ImageManager.loadCustomWindowPicture(newButtonImage);
        }
        
        if (container._isIconButton && container._buttonSprite) {
            container._buttonSprite.opacity = isEnabled ? 255 : 128;
        }
    };

    Window_Custom.prototype.updateSelectableItems = function() {
        this._selectableItems = [];
        for (var i = 0; i < this._imageSprites.length; i++) {
            var container = this._imageSprites[i];
            if (container._buttonSprite && container._isEnabled !== false) {
                this._selectableItems.push(container);
            }
        }
        if (this._selectableItems.length === 0) {
            this._selectedIndex = -1;
            return;
        }
        if (this._selectedIndex < 0) {
            this._selectedIndex = 0;
        }
        if (this._selectedIndex >= this._selectableItems.length) {
            this._selectedIndex = Math.max(0, this._selectableItems.length - 1);
        }
    };
    
    Window_Custom.prototype.applyImmediateHoverEffect = function(container) {
        if (!container || !container._buttonSprite) return false;
        
        if (!container._buttonSprite.bitmap || !container._buttonSprite.bitmap.isReady()) {
            return false;
        }
        
        this.applyButtonEffectImmediate(
            container,
            params.hoverScaleX,
            params.hoverScaleY,
            params.hoverOffsetX,
            params.hoverOffsetY
        );
        
        container._effectTarget = {
            scaleX: params.hoverScaleX,
            scaleY: params.hoverScaleY,
            offsetX: params.hoverOffsetX,
            offsetY: params.hoverOffsetY
        };
        
        return true;
    };

    Window_Custom.prototype.processIndexSelection = function() {
        if (!this.isOpen() || !this._touchEnabled) return;
        if (this._selectableItems.length === 0) return;
        
        var moved = false;
        var prevIndex = this._selectedIndex;
        
        if (Input.isRepeated('down')) {
            this.moveIndexDown();
            moved = true;
        } else if (Input.isRepeated('up')) {
            this.moveIndexUp();
            moved = true;
        } else if (Input.isRepeated('right')) {
            this.moveIndexRight();
            moved = true;
        } else if (Input.isRepeated('left')) {
            this.moveIndexLeft();
            moved = true;
        }
        
        if (moved) {
            this._inputMode = 'keyboard';
            var needsScroll = this.checkIfScrollNeeded();
            
            
            if (prevIndex !== this._selectedIndex) {
                this.playHoverSE();
            }
            
            if (prevIndex >= 0 && prevIndex < this._selectableItems.length && prevIndex !== this._selectedIndex) {
                var prevContainer = this._selectableItems[prevIndex];
                if (prevContainer) {
                    prevContainer._isHovered = false;
                    if (prevContainer._buttonHoverSprite) {
                        prevContainer._buttonSprite.visible = true;
                        prevContainer._buttonHoverSprite.visible = false;
                    }
                    this.applyButtonEffectImmediate(prevContainer, 1, 1, 0, 0);
                    prevContainer._effectTarget = null;
                    prevContainer._initialHoverDone = false;
                }
            }
            if (this._selectedIndex >= 0 && this._selectedIndex < this._selectableItems.length) {
                var newContainer = this._selectableItems[this._selectedIndex];
                if (newContainer) {
                    newContainer._isHovered = true;
                    if (newContainer._buttonHoverSprite && 
                        newContainer._buttonHoverSprite.bitmap && 
                        newContainer._buttonHoverSprite.bitmap.isReady()) {
                        newContainer._buttonSprite.visible = false;
                        newContainer._buttonHoverSprite.visible = true;
                    }
                    if (needsScroll) {
                        this.applyImmediateHoverEffect(newContainer);
                    } else {
                        this.applyButtonEffect(newContainer, false);
                        newContainer._initialHoverDone = true;
                    }
                }
            }
            this.ensureSelectedItemVisible();
        }
        
        
        if (this._selectedIndex >= 0 && this._selectedIndex < this._selectableItems.length) {
            var container = this._selectableItems[this._selectedIndex];
            if (container) {
                
                var isMouseInput = TouchInput.isPressed() || TouchInput.isTriggered() || TouchInput.isReleased();
                if (container._isEnabled !== false) {
                    if (Input.isTriggered('ok') && !isMouseInput) {
                        container._isPressed = true;
                        this._pressedButtonContainer = container;
                        this._pressedByKeyboard = true;  
                        this.applyButtonEffect(container, true);
                    }
                    else if (Input.isPressed('ok') && this._pressedButtonContainer === container && this._pressedByKeyboard) {
                        this.applyButtonEffect(container, true);
                    }
                    else if (!Input.isPressed('ok') && this._pressedButtonContainer === container && this._pressedByKeyboard) {
                        container._isPressed = false;
                        this._pressedButtonContainer = null;
                        this._pressedByKeyboard = false;
                        this.applyButtonEffect(container, false);
                        this.triggerButtonClick(container);
                    }
                } else {
                    if (Input.isTriggered('ok') && !isMouseInput) {
                        this.playDisabledSE();
                    }
                }
            }
        }
    };

    Window_Custom.prototype.moveIndexDown = function() {
        if (this._selectedIndex < 0) {
            this._selectedIndex = 0;
        } else {
            var columns = this.getColumns();
            var nextIndex = this._selectedIndex + columns;
            if (nextIndex < this._selectableItems.length) {
                this._selectedIndex = nextIndex;
            }
        }
    };

    Window_Custom.prototype.moveIndexUp = function() {
        if (this._selectedIndex < 0) {
            this._selectedIndex = 0;
        } else {
            var columns = this.getColumns();
            var nextIndex = this._selectedIndex - columns;
            if (nextIndex >= 0) {
                this._selectedIndex = nextIndex;
            }
        }
    };

    Window_Custom.prototype.moveIndexRight = function() {
        if (this._selectedIndex < 0) {
            this._selectedIndex = 0;
        } else {
            var nextIndex = this._selectedIndex + 1;
            if (nextIndex < this._selectableItems.length) {
                this._selectedIndex = nextIndex;
            }
        }
    };

    Window_Custom.prototype.moveIndexLeft = function() {
        if (this._selectedIndex < 0) {
            this._selectedIndex = 0;
        } else {
            var nextIndex = this._selectedIndex - 1;
            if (nextIndex >= 0) {
                this._selectedIndex = nextIndex;
            }
        }
    };

    Window_Custom.prototype.getColumns = function() {
        return 1;
    };

    Window_Custom.prototype.checkIfScrollNeeded = function() {
        if (this._selectedIndex < 0 || this._selectedIndex >= this._selectableItems.length) return false;
        
        var container = this._selectableItems[this._selectedIndex];
        if (!container) return false;
        
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var viewHeight = this.height - paddingTop - paddingBottom;
        var itemY = container._originalY !== undefined ? container._originalY : container.y + this._scrollY;
        var itemHeight = this.getItemHeight(container);
        
        if (itemY < this._scrollY) {
            return true;
        }
        if (itemY + itemHeight > this._scrollY + viewHeight) {
            return true;
        }
        return false;
    };

    Window_Custom.prototype.ensureSelectedItemVisible = function() {
        if (this._selectedIndex < 0 || this._selectedIndex >= this._selectableItems.length) return;
        
        var container = this._selectableItems[this._selectedIndex];
        if (!container) return;
        
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var viewHeight = this.height - paddingTop - paddingBottom;
        var itemY = container._originalY !== undefined ? container._originalY : container.y + this._scrollY;
        var itemHeight = this.getItemHeight(container);
        
        if (itemY < this._scrollY) {
            this.scrollTo(itemY);
        }
        else if (itemY + itemHeight > this._scrollY + viewHeight) {
            this.scrollTo(itemY + itemHeight - viewHeight);
        }
    };

    Window_Custom.prototype.getItemHeight = function(container) {
        var ws = this._windowSettings || {};
        var spacingY = ws.imageSpacingY || 4;
        
        if (container && container._baseSprite && container._baseSprite.bitmap && container._baseSprite.bitmap.isReady()) {
            return container._baseSprite.bitmap.height + spacingY;
        }
        return 48 + spacingY;
    };

    Window_Custom.prototype.triggerButtonClick = function(container) {
        if (!container || !container._imageItem) return;
        
        var ws = this._windowSettings || {};
        
        if (container._isEnabled === false) {
            
            this.playDisabledSE();
            return;
        }
        
        var imageItem = container._imageItem;
        if (imageItem.commonEventId > 0) {
            
            this.playClickSE();
            console.log('CustomWindow triggerButtonClick: Executing common event ' + imageItem.commonEventId);
            $gameTemp.reserveCommonEvent(imageItem.commonEventId);
        }
    };
    
    
    Window_Custom.prototype.playClickSE = function() {
        var ws = this._windowSettings || {};
        if (ws.clickSE) {
            var volume = ws.clickSEVolume !== undefined ? ws.clickSEVolume : 90;
            var pitch = ws.clickSEPitch !== undefined ? ws.clickSEPitch : 100;
            AudioManager.playSe({
                name: ws.clickSE,
                volume: volume,
                pitch: pitch,
                pan: 0
            });
        }
        
    };
    
    
    Window_Custom.prototype.playDisabledSE = function() {
        var ws = this._windowSettings || {};
        if (ws.disabledSE) {
            var volume = ws.disabledSEVolume !== undefined ? ws.disabledSEVolume : 90;
            var pitch = ws.disabledSEPitch !== undefined ? ws.disabledSEPitch : 100;
            AudioManager.playSe({
                name: ws.disabledSE,
                volume: volume,
                pitch: pitch,
                pan: 0
            });
        } else {
            
            SoundManager.playBuzzer();
        }
    };

    Window_Custom.prototype.updateImagePositionsIfNeeded = function() {
        if (!this._needsPositionUpdate) return;
        
        var allLoaded = true;
        for (var i = 0; i < this._imageSprites.length; i++) {
            var container = this._imageSprites[i];
            var primarySprite = container._baseSprite || container._buttonSprite || container._overlaySprite;
            if (primarySprite && primarySprite.bitmap) {
                if (!primarySprite.bitmap.isReady()) {
                    allLoaded = false;
                    break;
                }
            }
        }
        
        if (allLoaded) {
            this.updateImagePositions();
            this.updateContentHeight();
            this.updateScrollRange();
            this.updateScrollBar();
            this._needsPositionUpdate = false;
        }
    };

    Window_Custom.prototype.getMouseX = function() {
        return _customWindowMouseX;
    };

    Window_Custom.prototype.getMouseY = function() {
        return _customWindowMouseY;
    };

    Window_Custom.prototype.processButtonHover = function() {
        if (!this.isOpen() || !this._touchEnabled) return;
        
        var paddingLeft = this.getPaddingLeft();
        var paddingRight = this.getPaddingRight();
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var mouseX = this.getMouseX();
        var mouseY = this.getMouseY();
        var localX = this.canvasToLocalX(mouseX) - paddingLeft;
        var localY = this.canvasToLocalY(mouseY) - paddingTop;
        
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var scrollBarWidth = sbSettings.width || 12;
        var innerWidth = this.width - paddingLeft - paddingRight - scrollBarWidth;
        var innerHeight = this.height - paddingTop - paddingBottom;
        var isInsideWindow = localX >= 0 && localX < innerWidth && 
                             localY >= 0 && localY < innerHeight;
        
        var isMousePressed = TouchInput.isPressed();
        
        var mouseMoved = false;
        if (this._lastMouseX !== undefined && this._lastMouseY !== undefined) {
            if (mouseX !== this._lastMouseX || mouseY !== this._lastMouseY) {
                mouseMoved = true;
            }
        }
        this._lastMouseX = mouseX;
        this._lastMouseY = mouseY;
        
        if (this._inputMode === 'mouse' && mouseMoved) {
            var anySelectableButtonHovered = false;
            for (var j = 0; j < this._imageSprites.length; j++) {
                var c = this._imageSprites[j];
                
                if (c._buttonSprite && c._isEnabled !== false && isInsideWindow && this.isInsideButton(c, localX, localY)) {
                    anySelectableButtonHovered = true;
                    break;
                }
            }
            if (!anySelectableButtonHovered) {
                this._inputMode = 'keyboard';
            }
        }
        
        for (var i = 0; i < this._imageSprites.length; i++) {
            var container = this._imageSprites[i];
            if (!container._buttonSprite) continue;
            
            if (container._originalButtonX === undefined) {
                container._originalButtonX = container._buttonSprite.x;
                container._originalButtonY = container._buttonSprite.y;
                if (container._buttonSprite.bitmap && container._buttonSprite.bitmap.isReady()) {
                    container._originalButtonWidth = container._buttonSprite.bitmap.width;
                    container._originalButtonHeight = container._buttonSprite.bitmap.height;
                }
            }
            
            var isKeyboardSelectedItem = (this._selectableItems[this._selectedIndex] === container);
            
            var isMouseOverButton = isInsideWindow && this.isInsideButton(container, localX, localY);
            
            
            var isSelectableButton = container._isEnabled !== false;
            
            if (mouseMoved && isMouseOverButton && isSelectableButton && this._inputMode === 'keyboard') {
                this._inputMode = 'mouse';
                var hoverIndex = this._selectableItems.indexOf(container);
                if (hoverIndex >= 0) {
                    this._selectedIndex = hoverIndex;
                }
            }
            
            if (this._inputMode === 'mouse' && isMouseOverButton && isSelectableButton) {
                var hoverIndex = this._selectableItems.indexOf(container);
                if (hoverIndex >= 0 && this._selectedIndex !== hoverIndex) {
                    this._selectedIndex = hoverIndex;
                }
            }
            
            
            var isMouseHover = (this._inputMode === 'mouse') && isMouseOverButton && isSelectableButton;
            
            var isKeyboardSelected = (this._inputMode === 'keyboard') && isKeyboardSelectedItem;
            
            var shouldBeHovered = isMouseHover || isKeyboardSelected;
            
            if (shouldBeHovered) {
                var wasHovered = container._isHovered;
                container._isHovered = true;
                
                if (!wasHovered) {
                    container._initialHoverDone = false;
                    
                    this.playHoverSE();
                }
                
                if (container._buttonHoverSprite && 
                    container._buttonHoverSprite.bitmap && 
                    container._buttonHoverSprite.bitmap.isReady()) {
                    container._buttonSprite.visible = false;
                    container._buttonHoverSprite.visible = true;
                }
                
                
                if (this._inputMode === 'mouse' && isMousePressed && !container._isPressed && !this._pressedButtonContainer && !this._isDraggingScrollBar) {
                    container._isPressed = true;
                    this._pressedButtonContainer = container;
                }
                
                if (this._pressedButtonContainer === container) {
                    this.applyButtonEffect(container, true);
                } else {
                    if (!container._initialHoverDone) {
                        if (this.applyImmediateHoverEffect(container)) {
                            container._initialHoverDone = true;
                        }
                    } else {
                        this.applyButtonEffect(container, false);
                    }
                }
                
            } else {
                if (container._isHovered) {
                    container._isHovered = false;
                    
                    if (container._buttonHoverSprite) {
                        container._buttonSprite.visible = true;
                        container._buttonHoverSprite.visible = false;
                    }
                    
                    this.resetButtonEffect(container);
                }
                
                if (this._pressedButtonContainer === container) {
                    container._isPressed = false;
                }
            }
        }
    };

    
    Window_Custom.prototype.playHoverSE = function() {
        
        if (this._skipInitialHoverSE) {
            this._skipInitialHoverSE = false;
            return;
        }
        
        var ws = this._windowSettings || {};
        console.log('playHoverSE called, hoverSE:', ws.hoverSE, 'windowSettings:', ws);
        if (ws.hoverSE) {
            var volume = ws.hoverSEVolume !== undefined ? ws.hoverSEVolume : 90;
            var pitch = ws.hoverSEPitch !== undefined ? ws.hoverSEPitch : 100;
            AudioManager.playSe({
                name: ws.hoverSE,
                volume: volume,
                pitch: pitch,
                pan: 0
            });
        }
    };

    var easingFunctions = {
        linear: function(t) {
            return t;
        },
        easeOut: function(t) {
            return 1 - Math.pow(1 - t, 3);
        },
        easeIn: function(t) {
            return Math.pow(t, 3);
        },
        easeInOut: function(t) {
            return t < 0.5 ? 4 * t * t * t : 1 - Math.pow(-2 * t + 2, 3) / 2;
        },
        bounce: function(t) {
            var n1 = 7.5625;
            var d1 = 2.75;
            if (t < 1 / d1) {
                return n1 * t * t;
            } else if (t < 2 / d1) {
                return n1 * (t -= 1.5 / d1) * t + 0.75;
            } else if (t < 2.5 / d1) {
                return n1 * (t -= 2.25 / d1) * t + 0.9375;
            } else {
                return n1 * (t -= 2.625 / d1) * t + 0.984375;
            }
        },
        elastic: function(t) {
            if (t === 0 || t === 1) return t;
            return Math.pow(2, -10 * t) * Math.sin((t - 0.075) * (2 * Math.PI) / 0.3) + 1;
        }
    };

    Window_Custom.prototype.applyButtonEffect = function(container, isPressed) {
        var targetSprite = container._buttonHoverSprite && container._buttonHoverSprite.visible 
            ? container._buttonHoverSprite 
            : container._buttonSprite;
        
        if (!targetSprite) return;
        
        var targetScaleX, targetScaleY, targetOffsetX, targetOffsetY;
        
        if (isPressed) {
            targetScaleX = params.pressScaleX;
            targetScaleY = params.pressScaleY;
            targetOffsetX = params.pressOffsetX;
            targetOffsetY = params.pressOffsetY;
        } else {
            targetScaleX = params.hoverScaleX;
            targetScaleY = params.hoverScaleY;
            targetOffsetX = params.hoverOffsetX;
            targetOffsetY = params.hoverOffsetY;
        }
        
        if (params.useEasing) {
            if (container._effectTarget &&
                container._effectTarget.scaleX === targetScaleX &&
                container._effectTarget.scaleY === targetScaleY &&
                container._effectTarget.offsetX === targetOffsetX &&
                container._effectTarget.offsetY === targetOffsetY) {
                return;
            }
            
            container._effectTarget = {
                scaleX: targetScaleX,
                scaleY: targetScaleY,
                offsetX: targetOffsetX,
                offsetY: targetOffsetY
            };
            container._effectProgress = 0;
            container._effectDuration = params.easingDuration;
            container._effectStart = {
                scaleX: container._currentScaleX !== undefined ? container._currentScaleX : 1,
                scaleY: container._currentScaleY !== undefined ? container._currentScaleY : 1,
                offsetX: container._currentOffsetX !== undefined ? container._currentOffsetX : 0,
                offsetY: container._currentOffsetY !== undefined ? container._currentOffsetY : 0
            };
        } else {
            this.applyButtonEffectImmediate(container, targetScaleX, targetScaleY, targetOffsetX, targetOffsetY);
        }
    };

    Window_Custom.prototype.applyButtonEffectImmediate = function(container, scaleX, scaleY, offsetX, offsetY) {
        container._currentScaleX = scaleX;
        container._currentScaleY = scaleY;
        container._currentOffsetX = offsetX;
        container._currentOffsetY = offsetY;
        
        if (!container._buttonSprite) return;
        
        var w = container._originalButtonWidth;
        var h = container._originalButtonHeight;
        
        if (!w || !h) {
            if (container._buttonSprite.bitmap && container._buttonSprite.bitmap.isReady()) {
                w = container._buttonSprite.bitmap.width;
                h = container._buttonSprite.bitmap.height;
                container._originalButtonWidth = w;
                container._originalButtonHeight = h;
            } else {
                return;
            }
        }
        
        var scaleOffsetX = (w - w * scaleX) / 2;
        var scaleOffsetY = (h - h * scaleY) / 2;
        var newX = container._originalButtonX + scaleOffsetX + offsetX;
        var newY = container._originalButtonY + scaleOffsetY + offsetY;
        
        container._buttonSprite.scale.x = scaleX;
        container._buttonSprite.scale.y = scaleY;
        container._buttonSprite.x = newX;
        container._buttonSprite.y = newY;
        
        if (container._buttonHoverSprite) {
            container._buttonHoverSprite.scale.x = scaleX;
            container._buttonHoverSprite.scale.y = scaleY;
            container._buttonHoverSprite.x = newX;
            container._buttonHoverSprite.y = newY;
        }
    };

    Window_Custom.prototype.resetButtonEffect = function(container) {
        if (params.useEasing) {
            if (container._effectTarget &&
                container._effectTarget.scaleX === 1 &&
                container._effectTarget.scaleY === 1 &&
                container._effectTarget.offsetX === 0 &&
                container._effectTarget.offsetY === 0) {
                return;
            }
            
            container._effectTarget = {
                scaleX: 1,
                scaleY: 1,
                offsetX: 0,
                offsetY: 0
            };
            container._effectProgress = 0;
            container._effectDuration = params.easingDuration;
            container._effectStart = {
                scaleX: container._currentScaleX !== undefined ? container._currentScaleX : 1,
                scaleY: container._currentScaleY !== undefined ? container._currentScaleY : 1,
                offsetX: container._currentOffsetX !== undefined ? container._currentOffsetX : 0,
                offsetY: container._currentOffsetY !== undefined ? container._currentOffsetY : 0
            };
        } else {
            this.applyButtonEffectImmediate(container, 1, 1, 0, 0);
        }
    };

    Window_Custom.prototype.updateButtonEasing = function() {
        if (!params.useEasing) return;
        
        var easingFunc = easingFunctions[params.easingType] || easingFunctions.easeOut;
        
        for (var i = 0; i < this._imageSprites.length; i++) {
            var container = this._imageSprites[i];
            if (!container._buttonSprite) continue;
            if (!container._effectTarget) continue;
            if (!container._effectStart) continue;
            if (container._effectProgress === undefined) continue;
            if (container._effectProgress >= container._effectDuration) continue;
            
            container._effectProgress++;
            var t = container._effectProgress / container._effectDuration;
            var easedT = easingFunc(t);
            
            var start = container._effectStart;
            var target = container._effectTarget;
            
            var currentScaleX = start.scaleX + (target.scaleX - start.scaleX) * easedT;
            var currentScaleY = start.scaleY + (target.scaleY - start.scaleY) * easedT;
            var currentOffsetX = start.offsetX + (target.offsetX - start.offsetX) * easedT;
            var currentOffsetY = start.offsetY + (target.offsetY - start.offsetY) * easedT;
            
            this.applyButtonEffectImmediate(container, currentScaleX, currentScaleY, currentOffsetX, currentOffsetY);
        }
    };

    Window_Custom.prototype.processButtonClick = function() {
        if (!this.isOpen() || !this._touchEnabled) return;
        
        var paddingLeft = this.getPaddingLeft();
        var paddingRight = this.getPaddingRight();
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var mouseX = this.getMouseX();
        var mouseY = this.getMouseY();
        var localX = this.canvasToLocalX(mouseX) - paddingLeft;
        var localY = this.canvasToLocalY(mouseY) - paddingTop;
        
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var scrollBarWidth = sbSettings.width || 12;
        var innerWidth = this.width - paddingLeft - paddingRight - scrollBarWidth;
        var innerHeight = this.height - paddingTop - paddingBottom;
        var isInsideWindow = localX >= 0 && localX < innerWidth && 
                             localY >= 0 && localY < innerHeight;
        
        var isReleased = TouchInput.isReleased();
        var isTriggered = TouchInput.isTriggered();
        
        
        if (isTriggered || isReleased) {
            console.log('CustomWindow processButtonClick: isTriggered=' + isTriggered + ', isReleased=' + isReleased + ', _pressedButtonContainer=' + (this._pressedButtonContainer ? 'yes' : 'no') + ', _wasScrollBarDragging=' + (this._wasScrollBarDragging ? 'yes' : 'no'));
        }
        
        
        if (this._wasScrollBarDragging) {
            this._wasScrollBarDragging = false;
            this._pressedButtonContainer = null;
            return;
        }
        
        if (isReleased && this._pressedButtonContainer) {
            var container = this._pressedButtonContainer;
            container._isPressed = false;
            
            console.log('CustomWindow: Button released, checking if inside button...');
            
            if (isInsideWindow && this.isInsideButton(container, localX, localY)) {
                if (container._isEnabled !== false && container._imageItem && container._imageItem.commonEventId > 0) {
                    
                    this.playClickSE();
                    console.log('CustomWindow: Executing common event ' + container._imageItem.commonEventId);
                    $gameTemp.reserveCommonEvent(container._imageItem.commonEventId);
                } else if (container._isEnabled === false) {
                    
                    this.playDisabledSE();
                }
            }
            
            this._pressedButtonContainer = null;
        }
    };

    Window_Custom.prototype.isInsideButton = function(container, localX, localY) {
        if (!container._buttonSprite) return false;
        
        var originalX = container._originalButtonX !== undefined 
            ? container._originalButtonX 
            : container._buttonSprite.x;
        var originalY = container._originalButtonY !== undefined 
            ? container._originalButtonY 
            : container._buttonSprite.y;
        
        var buttonX = container.x + originalX;
        var buttonY = container.y + originalY;
        
        var buttonWidth, buttonHeight;
        if (container._originalButtonWidth !== undefined && container._originalButtonHeight !== undefined) {
            buttonWidth = container._originalButtonWidth;
            buttonHeight = container._originalButtonHeight;
        } else if (container._buttonSprite.bitmap && container._buttonSprite.bitmap.isReady()) {
            buttonWidth = container._buttonSprite.bitmap.width;
            buttonHeight = container._buttonSprite.bitmap.height;
        } else {
            return false;
        }
        
        return localX >= buttonX && localX < buttonX + buttonWidth &&
               localY >= buttonY && localY < buttonY + buttonHeight;
    };

    Window_Custom.prototype.isInsideImageItem = function(container, localX, localY) {
        if (!container._baseSprite || !container._baseSprite.bitmap) return false;
        if (!container._baseSprite.bitmap.isReady()) return false;
        
        var itemX = container.x;
        var itemY = container.y;
        var itemWidth = container._baseSprite.bitmap.width;
        var itemHeight = container._baseSprite.bitmap.height;
        
        return localX >= itemX && localX < itemX + itemWidth &&
               localY >= itemY && localY < itemY + itemHeight;
    };

    Window_Custom.prototype.processScroll = function() {
        if (!this.isOpen() || this._maxScrollY <= 0) return;
        
        if (!this._touchEnabled) return;
        
        if (this.isMouseInsideWindow()) {
            var wheelDelta = TouchInput.wheelY;
            if (wheelDelta !== 0) {
                this.scrollBy(wheelDelta > 0 ? params.scrollSpeed : -params.scrollSpeed);
            }
        }
        
        this.processScrollBarDrag();
    };

    Window_Custom.prototype.processScrollBarDrag = function() {
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var paddingRight = this.getPaddingRight();
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var scrollBarWidth = sbSettings.width || 12;
        var scrollBarX = this.width - paddingRight - scrollBarWidth;
        var scrollBarHeight = this.height - paddingTop - paddingBottom;
        
        var localX = this.canvasToLocalX(TouchInput.x);
        var localY = this.canvasToLocalY(TouchInput.y);
        
        if (this._isDraggingScrollBar) {
            if (TouchInput.isPressed()) {
                var deltaY = localY - this._dragStartY;
                var scrollRatio = deltaY / (scrollBarHeight - this.getScrollBarHeight());
                var newScrollY = this._dragStartScrollY + scrollRatio * this._maxScrollY;
                this.scrollTo(newScrollY);
            } else {
                this._isDraggingScrollBar = false;
                this._wasScrollBarDragging = true;  
            }
            return;
        }
        
        var isNewPress = TouchInput.isTriggered() || 
                         (TouchInput.isPressed() && !this._wasPressed);
        
        if (isNewPress) {
            if (this.isInsideScrollBar(localX, localY)) {
                this._isDraggingScrollBar = true;
                this._dragStartY = localY;
                this._dragStartScrollY = this._scrollY;
            } else if (this.isInsideScrollBarArea(localX, localY)) {
                this.scrollToPosition(localY - paddingTop);
            }
        }
        
        this._wasPressed = TouchInput.isPressed();
    };

    Window_Custom.prototype.getScrollBarHeight = function() {
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var scrollBarHeight = this.height - paddingTop - paddingBottom;
        var viewHeight = scrollBarHeight;
        var contentHeight = this._contentHeight || viewHeight;
        
        if (sbSettings.useSkin) {
            var topHeight = 0;
            var bottomHeight = 0;
            if (this._scrollBarTopSprite && this._scrollBarTopSprite.bitmap.isReady()) {
                topHeight = this._scrollBarTopSprite.bitmap.height;
            }
            if (this._scrollBarBottomSprite && this._scrollBarBottomSprite.bitmap.isReady()) {
                bottomHeight = this._scrollBarBottomSprite.bitmap.height;
            }
            return Math.max(topHeight + bottomHeight, (viewHeight / contentHeight) * scrollBarHeight);
        }
        
        return Math.max(30, (viewHeight / contentHeight) * scrollBarHeight);
    };

    Window_Custom.prototype.getScrollBarWidth = function() {
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        if (sbSettings.useSkin && this._scrollBarMiddleSprite && 
            this._scrollBarMiddleSprite.bitmap && this._scrollBarMiddleSprite.bitmap.isReady()) {
            return this._scrollBarMiddleSprite.bitmap.width;
        }
        return sbSettings.width || 12;
    };

    Window_Custom.prototype.getScrollBarX = function() {
        var paddingRight = this.getPaddingRight();
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var barWidth = this.getScrollBarWidth();
        var scrollBarWidth = sbSettings.width || 12;
        var offsetX = sbSettings.offsetX || 0;
        
        if (sbSettings.useSkin) {
            var centerX = this.width - paddingRight - scrollBarWidth / 2 + offsetX;
            return centerX - barWidth / 2;
        }
        return this.width - paddingRight - scrollBarWidth;
    };

    Window_Custom.prototype.getScrollBarY = function() {
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var scrollBarHeight = this.height - paddingTop - paddingBottom;
        var barHeight = this.getScrollBarHeight();
        var scrollRatio = this._maxScrollY > 0 ? this._scrollY / this._maxScrollY : 0;
        
        if (sbSettings.useSkin) {
            var topHeight = 0;
            var bottomHeight = 0;
            if (this._scrollBarTopSprite && this._scrollBarTopSprite.bitmap.isReady()) {
                topHeight = this._scrollBarTopSprite.bitmap.height;
            }
            if (this._scrollBarBottomSprite && this._scrollBarBottomSprite.bitmap.isReady()) {
                bottomHeight = this._scrollBarBottomSprite.bitmap.height;
            }
            var topOverhang = topHeight / 2;
            var bottomOverhang = bottomHeight / 2;
            return paddingTop - topOverhang + scrollRatio * (scrollBarHeight - barHeight + topOverhang + bottomOverhang);
        }
        
        return paddingTop + scrollRatio * (scrollBarHeight - barHeight);
    };

    Window_Custom.prototype.isInsideScrollBar = function(localX, localY) {
        var scrollBarX = this.getScrollBarX();
        var scrollBarY = this.getScrollBarY();
        var barWidth = this.getScrollBarWidth();
        var barHeight = this.getScrollBarHeight();
        
        return localX >= scrollBarX && localX < scrollBarX + barWidth &&
               localY >= scrollBarY && localY < scrollBarY + barHeight;
    };

    Window_Custom.prototype.isInsideScrollBarArea = function(localX, localY) {
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var scrollBarX = this.getScrollBarX();
        var barWidth = this.getScrollBarWidth();
        var scrollBarHeight = this.height - paddingTop - paddingBottom;
        
        return localX >= scrollBarX && localX < scrollBarX + barWidth &&
               localY >= paddingTop && localY < paddingTop + scrollBarHeight;
    };

    Window_Custom.prototype.scrollToPosition = function(posY) {
        var paddingTop = this.getPaddingTop();
        var paddingBottom = this.getPaddingBottom();
        var scrollBarHeight = this.height - paddingTop - paddingBottom;
        var barHeight = this.getScrollBarHeight();
        
        var targetY = posY - barHeight / 2;
        var scrollRatio = targetY / (scrollBarHeight - barHeight);
        var newScrollY = scrollRatio * this._maxScrollY;
        this.scrollTo(newScrollY);
    };

    Window_Custom.prototype.scrollTo = function(scrollY) {
        var newScrollY = Math.max(0, Math.min(this._maxScrollY, scrollY));
        if (this._scrollY !== newScrollY) {
            this._scrollY = newScrollY;
            this.updateImagePositions();
            this.updateScrollBar();
        }
    };

    Window_Custom.prototype.isMouseInsideWindow = function() {
        var mouseX = this.getMouseX();
        var mouseY = this.getMouseY();
        var x = this.canvasToLocalX(mouseX);
        var y = this.canvasToLocalY(mouseY);
        return x >= 0 && x < this.width && y >= 0 && y < this.height;
    };

    Window_Custom.prototype.canvasToLocalX = function(x) {
        var node = this;
        while (node) {
            x -= node.x;
            node = node.parent;
        }
        return x;
    };

    Window_Custom.prototype.canvasToLocalY = function(y) {
        var node = this;
        while (node) {
            y -= node.y;
            node = node.parent;
        }
        return y;
    };

    Window_Custom.prototype.clearImageListSprites = function() {
        for (var i = 0; i < this._imageSprites.length; i++) {
            if (this._imageContainer) {
                this._imageContainer.removeChild(this._imageSprites[i]);
            } else {
                this.removeChild(this._imageSprites[i]);
            }
        }
        this._imageSprites = [];
        this._scrollY = 0;
        this._contentHeight = 0;
    };

    Window_Custom.prototype.createTextSprite = function(textItem) {
        if (!textItem || !textItem.text) return null;
        
        var width = textItem.width || 200;
        var fontSize = textItem.fontSize || this.standardFontSize();
        var lineHeight = fontSize + 8;
        
        var bitmap = new Bitmap(width, lineHeight);
        
        bitmap.fontFace = this.getCustomFontFace();
        bitmap.fontSize = fontSize;
        
        if (textItem.textColor) {
            bitmap.textColor = textItem.textColor;
        } else {
            bitmap.textColor = this.normalColor ? this.normalColor() : '#ffffff';
        }
        
        if (textItem.outlineColor) {
            bitmap.outlineColor = textItem.outlineColor;
        } else {
            bitmap.outlineColor = 'rgba(0, 0, 0, 0.5)';
        }
        
        if (textItem.outlineWidth >= 0) {
            bitmap.outlineWidth = textItem.outlineWidth;
        } else {
            bitmap.outlineWidth = 4;
        }
        
        var align = textItem.align || 'left';
        bitmap.drawText(textItem.text, 0, 0, width, lineHeight, align);
        
        var sprite = new Sprite(bitmap);
        sprite.x = textItem.x || 0;
        sprite.y = textItem.y || 0;
        sprite._type = 'text';
        
        return sprite;
    };

    Window_Custom.prototype.getTextSettings = function() {
        var ws = this._windowSettings || {};
        
        if (ws.textPresetId && params.textPresets[ws.textPresetId]) {
            var preset = params.textPresets[ws.textPresetId];
            return {
                fontName: preset.fontName || '',
                fontSize: preset.fontSize || 26,
                textColor: preset.textColor || '#ffffff',
                outlineColor: preset.outlineColor || '#000000',
                outlineWidth: preset.outlineWidth !== undefined ? preset.outlineWidth : 4
            };
        }
        
        return {
            fontName: ws.customFont || '',
            fontSize: ws.fontSize || 26,
            textColor: ws.textColor || '#ffffff',
            outlineColor: ws.outlineColor || '#000000',
            outlineWidth: ws.outlineWidth !== undefined ? ws.outlineWidth : 4
        };
    };

    Window_Custom.prototype.getCustomFontFace = function() {
        var textSettings = this.getTextSettings();
        if (textSettings.fontName && params.customFonts[textSettings.fontName]) {
            return textSettings.fontName;
        }
        return this.standardFontFace ? this.standardFontFace() : 'GameFont';
    };

    Window_Custom.prototype.standardFontSize = function() {
        if (isMZ) {
            return $gameSystem.mainFontSize ? $gameSystem.mainFontSize() : 26;
        } else {
            return 28;
        }
    };

    Window_Custom.prototype.createDisabledFilterSprite = function(baseImageName, opacity) {
        if (!baseImageName) return null;
        
        var filterOpacity = opacity !== undefined ? opacity : 128;
        var cachedSize = getPictureSizeSync(baseImageName);
        
        if (cachedSize) {
            var filterBitmap = new Bitmap(cachedSize.width, cachedSize.height);
            filterBitmap.fillRect(0, 0, cachedSize.width, cachedSize.height, 'rgba(0, 0, 0, 1)');
            
            var filterSprite = new Sprite(filterBitmap);
            filterSprite.opacity = filterOpacity;
            filterSprite._type = 'disabledFilter';
            
            return filterSprite;
        }
        
        var filterSprite = new Sprite();
        filterSprite.opacity = filterOpacity;
        filterSprite._type = 'disabledFilter';
        filterSprite._pendingImageName = baseImageName;
        
        var bitmap = ImageManager.loadCustomWindowPicture(baseImageName);
        bitmap.addLoadListener(function() {
            var filterBitmap = new Bitmap(bitmap.width, bitmap.height);
            filterBitmap.fillRect(0, 0, bitmap.width, bitmap.height, 'rgba(0, 0, 0, 1)');
            filterSprite.bitmap = filterBitmap;
        });
        
        return filterSprite;
    };

    Window_Custom.prototype.createDisabledFilterSpriteWithSize = function(width, height, opacity) {
        if (width <= 0 || height <= 0) return null;
        
        var filterOpacity = opacity !== undefined ? opacity : 128;
        
        var filterBitmap = new Bitmap(width, height);
        filterBitmap.fillRect(0, 0, width, height, 'rgba(0, 0, 0, 1)');
        
        var filterSprite = new Sprite(filterBitmap);
        filterSprite.opacity = filterOpacity;
        filterSprite._type = 'disabledFilter';
        
        return filterSprite;
    };

    Window_Custom.prototype.addImage = function(imageName, listId) {
        if (!imageName) return;
        listId = listId || 1;
        
        if (!this._imageLists[listId]) {
            this._imageLists[listId] = [];
        }
        this._imageLists[listId].push(imageName);
        
        this.createImageListSprites();
    };

    Window_Custom.prototype.clearImageList = function(listId) {
        if (listId === 0 || listId === undefined) {
            this._imageLists = {};
        } else {
            delete this._imageLists[listId];
        }
        this.clearImageListSprites();
    };

    Window_Custom.prototype.getImageLists = function() {
        return this._imageLists;
    };

    Window_Custom.prototype.getImageList = function(listId) {
        return this._imageLists[listId] || [];
    };

    Window_Custom.prototype.createBackgroundSprite = function() {
        if (this._bgSprite) {
            this.removeChild(this._bgSprite);
        }
        
        var bitmap;
        if (isMZ) {
            bitmap = ImageManager.loadCustomWindowPicture(this._bgImageName);
        } else {
            bitmap = ImageManager.loadCustomWindowPicture(this._bgImageName);
        }
        
        this._bgSprite = new Sprite(bitmap);
        this._bgSprite.x = 0;
        this._bgSprite.y = 0;
        
        this.addChildToBack(this._bgSprite);
        
        this.opacity = 0;
        this.backOpacity = 0;
    };

    Window_Custom.prototype.refresh = function() {
        this.contents.clear();
        
        var defaultTextSettings = this.getTextSettings();
        var ws = this._windowSettings || {};
        
        var textElements = ws.textElements || [];
        if (textElements.length > 0) {
            for (var i = 0; i < textElements.length; i++) {
                this._drawTextElement(textElements[i], defaultTextSettings);
            }
        }
    };

    Window_Custom.prototype._drawTextElement = function(element, defaultSettings) {
        if (!element || !element.text) return;
        
        var ws = this._windowSettings || {};
        var text = element.text;
        
        if (element.variableId > 0 && $gameVariables) {
            var varValue = $gameVariables.value(element.variableId);
            text = text.replace(/%v/g, varValue);
        }
        
        text = this._convertEscapeCharacters(text);
        
        var fontSize = defaultSettings.fontSize || 26;
        var textColor = defaultSettings.textColor || '#ffffff';
        var outlineColor = defaultSettings.outlineColor || '#000000';
        var outlineWidth = defaultSettings.outlineWidth !== undefined ? defaultSettings.outlineWidth : 4;
        var fontFace = this.standardFontFace ? this.standardFontFace() : 'GameFont';
        
        if (element.textPresetId && params.textPresets[element.textPresetId]) {
            var preset = params.textPresets[element.textPresetId];
            fontSize = preset.fontSize || fontSize;
            textColor = preset.textColor || textColor;
            outlineColor = preset.outlineColor || outlineColor;
            outlineWidth = preset.outlineWidth !== undefined ? preset.outlineWidth : outlineWidth;
            if (preset.fontName) {
                fontFace = preset.fontName.replace(/\.(ttf|otf|woff|woff2)$/i, '');
            }
        }
        
        if (element.fontSize > 0) {
            fontSize = element.fontSize;
        }
        if (element.textColor) {
            textColor = element.textColor;
        }
        if (element.outlineColor) {
            outlineColor = element.outlineColor;
        }
        if (element.outlineWidth >= 0) {
            outlineWidth = element.outlineWidth;
        }
        
        this.contents.fontFace = fontFace;
        this.contents.fontSize = fontSize;
        this.contents.textColor = textColor;
        if (outlineWidth === 0) {
            this.contents.outlineColor = 'rgba(0, 0, 0, 0)';
            this.contents.outlineWidth = 0;
        } else {
            this.contents.outlineColor = outlineColor;
            this.contents.outlineWidth = outlineWidth;
        }
        
        var x = element.x || 0;
        var y = element.y || 0;
        var width = element.width || this.contentsWidth();
        var lineHeight = fontSize + 8;
        var align = element.textAlign || 'left';
        
        this.contents.drawText(text, x, y, width, lineHeight, align);
    };

    Window_Custom.prototype._convertEscapeCharacters = function(text) {
        text = text.replace(/\\/g, '\x1b');
        text = text.replace(/\x1b\x1b/g, '\\');
        text = text.replace(/\x1bV\[(\d+)\]/gi, function() {
            return $gameVariables ? $gameVariables.value(parseInt(arguments[1])) : 0;
        }.bind(this));
        text = text.replace(/\x1bN\[(\d+)\]/gi, function() {
            var actor = $gameActors ? $gameActors.actor(parseInt(arguments[1])) : null;
            return actor ? actor.name() : '';
        }.bind(this));
        text = text.replace(/\x1bP\[(\d+)\]/gi, function() {
            var actor = $gameParty ? $gameParty.members()[parseInt(arguments[1]) - 1] : null;
            return actor ? actor.name() : '';
        }.bind(this));
        text = text.replace(/\x1bG/gi, TextManager.currencyUnit || '');
        return text;
    };

    Window_Custom.prototype.setText = function(text) {
        this._text = text;
        this.refresh();
    };

    window.Window_Custom = Window_Custom;

    function Window_ItemCustom() {
        this.initialize.apply(this, arguments);
    }

    Window_ItemCustom.prototype = Object.create(Window_Custom.prototype);
    Window_ItemCustom.prototype.constructor = Window_ItemCustom;

    Window_ItemCustom.prototype.initialize = function(rect, settings, itemWindowId) {
        this._itemWindowSettings = settings;
        this._itemWindowId = itemWindowId;
        this._displayedItems = [];
        this._baseBackgroundSprite = null;
        this._windowBackgroundSprite = null;
        
        var windowSettings = {
            backgroundImage: '',
            text: '',
            imageOffsetX: 0,
            imageOffsetY: 0,
            imageSpacingX: settings.spacingX,
            imageSpacingY: settings.spacingY,
            scrollBarId: settings.scrollBarId || '',
            closeSettings: settings.closeSettings
        };
        
        Window_Custom.prototype.initialize.call(this, rect, windowSettings, params.windowOpacity, params.backOpacity, {}, itemWindowId);
        
        this.createWindowBackgroundSprite();
        
        this.refreshItemImages();
    };

    Window_ItemCustom.prototype._getScrollBarSettings = function() {
        var scrollBarId = this._itemWindowSettings.scrollBarId || '';
        return getScrollBarSettingsById(scrollBarId);
    };

    Window_ItemCustom.prototype.createWindowBackgroundSprite = function() {
        var settings = this._itemWindowSettings;
        if (!settings.windowBackgroundImage) return;
        
        this.opacity = 0;
        this._windowBackOpacity = 0;
        if (isMZ) {
            this._backSprite.opacity = 0;
            this._frameSprite.opacity = 0;
        } else {
            this._windowSpriteContainer.opacity = 0;
        }
        
        if (this._windowBackgroundSprite) {
            this.removeChild(this._windowBackgroundSprite);
        }
        
        var bitmap = ImageManager.loadCustomWindowPicture(settings.windowBackgroundImage);
        this._windowBackgroundSprite = new Sprite(bitmap);
        this._windowBackgroundSprite.x = 0;
        this._windowBackgroundSprite.y = 0;
        
        this.addChildAt(this._windowBackgroundSprite, 0);
    };

    Window_ItemCustom.prototype.createScrollBar = function() {
        var settings = this._itemWindowSettings;
        var paddingRight = settings.paddingRight || 18;
        var paddingTop = settings.paddingTop || 18;
        var paddingBottom = settings.paddingBottom || 18;
        
        var sbSettings = this._getScrollBarSettings();
        this._scrollBarConfig = sbSettings;
        var scrollBarWidth = sbSettings.width || 12;
        var scrollBarX = this.width - paddingRight - scrollBarWidth;
        var scrollBarHeight = this.height - paddingTop - paddingBottom;
        
        if (sbSettings.useSkin) {
            this.createScrollBarSkin();
            return;
        }
        
        this._scrollBarBg = new PIXI.Graphics();
        this._scrollBarBg.beginFill(this.hexToNumber(sbSettings.bgColor || '#000000'), 0.5);
        this._scrollBarBg.drawRect(0, 0, scrollBarWidth, scrollBarHeight);
        this._scrollBarBg.endFill();
        this._scrollBarBg.x = scrollBarX;
        this._scrollBarBg.y = paddingTop;
        this.addChild(this._scrollBarBg);
        
        this._scrollBar = new PIXI.Graphics();
        this._scrollBar.x = scrollBarX;
        this._scrollBar.y = paddingTop;
        this.addChild(this._scrollBar);
    };

    Window_ItemCustom.prototype.createBaseBackgroundSprite = function(scene, insertIndex) {
        var settings = this._itemWindowSettings;
        if (!settings.backgroundImage) return;
        
        if (this._baseBackgroundSprite) {
            if (this._baseBackgroundSprite.parent) {
                this._baseBackgroundSprite.parent.removeChild(this._baseBackgroundSprite);
            }
        }
        
        var bitmap = ImageManager.loadCustomWindowPicture(settings.backgroundImage);
        this._baseBackgroundSprite = new Sprite(bitmap);
        this._baseBackgroundSprite.x = settings.x;
        this._baseBackgroundSprite.y = settings.y;
        
        if (scene) {
            if (insertIndex >= 0) {
                scene.addChildAt(this._baseBackgroundSprite, insertIndex);
            } else {
                scene.addChild(this._baseBackgroundSprite);
            }
        }
    };

    Window_ItemCustom.prototype.removeBaseBackgroundSprite = function() {
        if (this._baseBackgroundSprite && this._baseBackgroundSprite.parent) {
            this._baseBackgroundSprite.parent.removeChild(this._baseBackgroundSprite);
        }
        this._baseBackgroundSprite = null;
    };

    Window_ItemCustom.prototype.updateScrollBar = function() {
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        if (sbSettings.useSkin) {
            this.updateScrollBarSkin();
            return;
        }
        
        if (!this._scrollBar) return;
        
        var settings = this._itemWindowSettings;
        var paddingTop = settings.paddingTop || 18;
        var paddingBottom = settings.paddingBottom || 18;
        
        var scrollBarHeight = this.height - paddingTop - paddingBottom;
        var viewHeight = scrollBarHeight;
        var contentHeight = this._contentHeight || viewHeight;
        
        if (contentHeight <= viewHeight) {
            this._scrollBar.visible = false;
            this._scrollBarBg.visible = false;
            return;
        }
        
        this._scrollBar.visible = true;
        this._scrollBarBg.visible = true;
        
        var barHeight = Math.max(30, (viewHeight / contentHeight) * scrollBarHeight);
        var scrollRatio = this._scrollY / this._maxScrollY;
        var barY = scrollRatio * (scrollBarHeight - barHeight);
        
        var scrollBarWidth = sbSettings.width || 12;
        var scrollBarColor = sbSettings.color || '#ffffff';
        
        this._scrollBar.clear();
        this._scrollBar.beginFill(this.hexToNumber(scrollBarColor), 0.8);
        this._scrollBar.drawRoundedRect(0, barY, scrollBarWidth, barHeight, scrollBarWidth / 2);
        this._scrollBar.endFill();
    };

    Window_ItemCustom.prototype.updateScrollRange = function() {
        var settings = this._itemWindowSettings;
        var paddingTop = settings.paddingTop || 18;
        var paddingBottom = settings.paddingBottom || 18;
        
        var viewHeight = this.height - paddingTop - paddingBottom;
        this._maxScrollY = Math.max(0, this._contentHeight - viewHeight);
        
        if (this._scrollY > this._maxScrollY) {
            this._scrollY = this._maxScrollY;
        }
    };

    Window_ItemCustom.prototype.getOwnedItemIds = function() {
        if (!$gameParty) return [];
        
        var settings = this._itemWindowSettings;
        var itemImages = settings.itemImages || [];
        var ownedItemIds = [];
        
        for (var i = 0; i < itemImages.length; i++) {
            var itemId = itemImages[i].itemId;
            var item = $dataItems[itemId];
            if (item && $gameParty.numItems(item) > 0) {
                ownedItemIds.push(itemId);
            }
        }
        
        return ownedItemIds;
    };

    Window_ItemCustom.prototype.getImageSettingsByItemId = function(itemId) {
        var settings = this._itemWindowSettings;
        var itemImages = settings.itemImages || [];
        
        for (var i = 0; i < itemImages.length; i++) {
            if (itemImages[i].itemId === itemId) {
                return itemImages[i];
            }
        }
        return null;
    };

    Window_ItemCustom.prototype.refreshItemImages = function() {
        var ownedItemIds = this.getOwnedItemIds();
        
        if (this.arraysEqual(ownedItemIds, this._displayedItems)) return;
        
        this._displayedItems = ownedItemIds.slice();
        this.clearImageListSprites();
        
        if (ownedItemIds.length === 0) {
            this.updateScrollRange();
            this.updateScrollBar();
            return;
        }
        
        var settings = this._itemWindowSettings;
        
        this._itemImageList = [];
        for (var i = 0; i < ownedItemIds.length; i++) {
            var itemId = ownedItemIds[i];
            var imgSettings = this.getImageSettingsByItemId(itemId);
            if (!imgSettings) continue;
            
            var useIcon = !imgSettings.baseImage && !imgSettings.buttonImage;
            var iconIndex = 0;
            if (useIcon) {
                var item = $dataItems[itemId];
                if (item) {
                    iconIndex = item.iconIndex;
                }
            }
            
            var imageItem = {
                baseImage: imgSettings.baseImage || '',
                baseImageDisabled: imgSettings.baseImageDisabled || '',
                baseCondition: imgSettings.baseCondition || null,
                overlayImage: '',
                overlayImageDisabled: '',
                overlayCondition: null,
                buttonImage: imgSettings.buttonImage || '',
                buttonImageDisabled: imgSettings.buttonImageDisabled || '',
                buttonHoverImage: imgSettings.buttonHoverImage || '',
                buttonOffsetX: imgSettings.buttonOffsetX || 0,
                buttonOffsetY: imgSettings.buttonOffsetY || 0,
                commonEventId: imgSettings.commonEventId || 0,
                buttonCondition: imgSettings.buttonCondition || null,
                itemId: itemId,
                useIcon: useIcon,
                iconIndex: iconIndex
            };
            
            this._itemImageList.push(imageItem);
        }
        
        this.createImageListSprites();
    };

    Window_ItemCustom.prototype.createIconSprite = function(iconIndex) {
        var iconWidth = 32;
        var iconHeight = 32;
        var iconsPerRow = 16;
        
        var bitmap = ImageManager.loadSystem('IconSet');
        var iconBitmap = new Bitmap(iconWidth, iconHeight);
        
        bitmap.addLoadListener(function() {
            var sx = (iconIndex % iconsPerRow) * iconWidth;
            var sy = Math.floor(iconIndex / iconsPerRow) * iconHeight;
            iconBitmap.blt(bitmap, sx, sy, iconWidth, iconHeight, 0, 0);
        });
        
        return iconBitmap;
    };

    Window_ItemCustom.prototype.createImageContainer = function() {
        var settings = this._itemWindowSettings;
        var paddingLeft = settings.paddingLeft || 18;
        var paddingRight = settings.paddingRight || 18;
        var paddingTop = settings.paddingTop || 18;
        var paddingBottom = settings.paddingBottom || 18;
        
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var scrollBarWidth = sbSettings.width || 12;
        var innerWidth = this.width - paddingLeft - paddingRight - scrollBarWidth;
        var innerHeight = this.height - paddingTop - paddingBottom;
        
        this._imageContainer = new PIXI.Container();
        this._imageContainer.x = paddingLeft;
        this._imageContainer.y = paddingTop;
        
        var mask = new PIXI.Graphics();
        mask.beginFill(0xffffff);
        mask.drawRect(0, 0, innerWidth, innerHeight);
        mask.endFill();
        mask.x = paddingLeft;
        mask.y = paddingTop;
        
        this.addChild(mask);
        this.addChild(this._imageContainer);
        this._imageContainer.mask = mask;
        this._containerMask = mask;
    };

    Window_ItemCustom.prototype.createImageListSprites = function() {
        this.clearImageListSprites();
        
        var self = this;
        var settings = this._itemWindowSettings;
        var spacingX = settings.spacingX || 4;
        var spacingY = settings.spacingY || 4;
        var itemWidth = settings.itemWidth || 48;
        var itemHeight = settings.itemHeight || 48;
        var columns = settings.columns || 4;
        
        var allItems = this._itemImageList || [];
        
        for (var index = 0; index < allItems.length; index++) {
            var imageItem = allItems[index];
            if (!imageItem) continue;
            
            var col = index % columns;
            var row = Math.floor(index / columns);
            var xPos = col * (itemWidth + spacingX);
            var yPos = row * (itemHeight + spacingY);
            
            (function(idx, imgItem, xPosition, yPosition) {
                var isEnabled = checkCondition(imgItem);
                
                var itemContainer = new Sprite();
                itemContainer.x = xPosition;
                itemContainer.y = yPosition;
                itemContainer._itemIndex = idx;
                itemContainer._imageItem = imgItem;
                itemContainer._isHovered = false;
                itemContainer._isEnabled = isEnabled;
                itemContainer._useDisabledImages = settings.useDisabledImages !== false;
                
                if (imgItem.useIcon) {
                    var iconBitmap = self.createIconSprite(imgItem.iconIndex);
                    var iconSprite = new Sprite(iconBitmap);
                    iconSprite._type = 'button';
                    iconSprite.x = (itemWidth - 32) / 2;
                    iconSprite.y = (itemHeight - 32) / 2;
                    iconSprite.visible = true;
                    itemContainer.addChild(iconSprite);
                    itemContainer._buttonSprite = iconSprite;
                    itemContainer._isIconButton = true;
                    
                    itemContainer._originalButtonWidth = 32;
                    itemContainer._originalButtonHeight = 32;
                    itemContainer._originalButtonX = iconSprite.x;
                    itemContainer._originalButtonY = iconSprite.y;
                    
                    if (!isEnabled) {
                        if (settings.useDisabledImages !== false) {
                            iconSprite.opacity = 128;
                        } else {
                            var darkness = settings.disabledFilterOpacity !== undefined ? settings.disabledFilterOpacity : 128;
                            iconSprite.setBlendColor([0, 0, 0, darkness]);
                        }
                    }
                } else {
                    var useDisabledImg = settings.useDisabledImages !== false;
                    var darkness = settings.disabledFilterOpacity !== undefined ? settings.disabledFilterOpacity : 128;
                    
                    if (imgItem.baseImage) {
                        var baseImageToUse = (isEnabled || !useDisabledImg) ? imgItem.baseImage : (imgItem.baseImageDisabled || imgItem.baseImage);
                        var baseBitmap = ImageManager.loadCustomWindowPicture(baseImageToUse);
                        var baseSprite = new Sprite(baseBitmap);
                        baseSprite._type = 'base';
                        itemContainer.addChild(baseSprite);
                        itemContainer._baseSprite = baseSprite;
                        
                        if (useDisabledImg && imgItem.baseImageDisabled) {
                            itemContainer._baseImageEnabled = imgItem.baseImage;
                            itemContainer._baseImageDisabled = imgItem.baseImageDisabled;
                            ImageManager.loadCustomWindowPicture(imgItem.baseImage);
                            ImageManager.loadCustomWindowPicture(imgItem.baseImageDisabled);
                        }
                        
                        if (!useDisabledImg && !isEnabled) {
                            baseSprite.setBlendColor([0, 0, 0, darkness]);
                        }
                    }
                    
                    if (imgItem.buttonImage) {
                        var buttonImageToUse = (isEnabled || !useDisabledImg) ? imgItem.buttonImage : (imgItem.buttonImageDisabled || imgItem.buttonImage);
                        var buttonBitmap = ImageManager.loadCustomWindowPicture(buttonImageToUse);
                        var buttonSprite = new Sprite(buttonBitmap);
                        buttonSprite._type = 'button';
                        buttonSprite.x = imgItem.buttonOffsetX || 0;
                        buttonSprite.y = imgItem.buttonOffsetY || 0;
                        buttonSprite.visible = true;
                        itemContainer.addChild(buttonSprite);
                        itemContainer._buttonSprite = buttonSprite;
                        
                        if (useDisabledImg && imgItem.buttonImageDisabled) {
                            itemContainer._buttonImageEnabled = imgItem.buttonImage;
                            itemContainer._buttonImageDisabled = imgItem.buttonImageDisabled;
                            ImageManager.loadCustomWindowPicture(imgItem.buttonImage);
                            ImageManager.loadCustomWindowPicture(imgItem.buttonImageDisabled);
                        }
                        
                        if (!useDisabledImg && !isEnabled) {
                            buttonSprite.setBlendColor([0, 0, 0, darkness]);
                        }
                        
                        if (imgItem.buttonHoverImage) {
                            var hoverBitmap = ImageManager.loadCustomWindowPicture(imgItem.buttonHoverImage);
                            var hoverSprite = new Sprite(hoverBitmap);
                            hoverSprite._type = 'buttonHover';
                            hoverSprite.x = imgItem.buttonOffsetX || 0;
                            hoverSprite.y = imgItem.buttonOffsetY || 0;
                            hoverSprite.visible = false;
                            itemContainer.addChild(hoverSprite);
                            itemContainer._buttonHoverSprite = hoverSprite;
                        }
                    }
                }
                
                self._imageSprites.push(itemContainer);
                
                if (self._imageContainer) {
                    self._imageContainer.addChild(itemContainer);
                }
            })(index, imageItem, xPos, yPos);
        }
        
        this.updateImagePositions();
        
        this.updateContentHeight();
        this.updateScrollRange();
        this.updateScrollBar();
    };

    Window_ItemCustom.prototype.updateContentHeight = function() {
        var settings = this._itemWindowSettings;
        var itemHeight = settings.itemHeight || 48;
        var spacingY = settings.spacingY || 4;
        var columns = settings.columns || 4;
        
        var totalItems = this._displayedItems ? this._displayedItems.length : 0;
        var rows = Math.ceil(totalItems / columns);
        
        if (rows > 0) {
            this._contentHeight = rows * itemHeight + (rows - 1) * spacingY;
        } else {
            this._contentHeight = 0;
        }
    };

    Window_ItemCustom.prototype.updateImagePositions = function() {
        var settings = this._itemWindowSettings;
        var spacingX = settings.spacingX || 4;
        var spacingY = settings.spacingY || 4;
        var itemWidth = settings.itemWidth || 48;
        var itemHeight = settings.itemHeight || 48;
        var columns = settings.columns || 4;
        
        for (var i = 0; i < this._imageSprites.length; i++) {
            var container = this._imageSprites[i];
            var index = container._itemIndex;
            if (index === undefined) continue;
            
            var col = index % columns;
            var row = Math.floor(index / columns);
            
            var originalY = row * (itemHeight + spacingY);
            container.x = col * (itemWidth + spacingX);
            container._originalY = originalY;
            container.y = originalY - this._scrollY;
        }
    };

    Window_ItemCustom.prototype.arraysEqual = function(a, b) {
        if (a.length !== b.length) return false;
        for (var i = 0; i < a.length; i++) {
            if (a[i] !== b[i]) return false;
        }
        return true;
    };

    Window_ItemCustom.prototype.processButtonClick = function() {
        if (!this.isOpen() || !this._touchEnabled) return;
        
        var settings = this._itemWindowSettings;
        var paddingLeft = settings.paddingLeft || 18;
        var paddingRight = settings.paddingRight || 18;
        var paddingTop = settings.paddingTop || 18;
        var paddingBottom = settings.paddingBottom || 18;
        
        var mouseX = this.getMouseX();
        var mouseY = this.getMouseY();
        var localX = this.canvasToLocalX(mouseX) - paddingLeft;
        var localY = this.canvasToLocalY(mouseY) - paddingTop;
        
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var scrollBarWidth = sbSettings.width || 12;
        var innerWidth = this.width - paddingLeft - paddingRight - scrollBarWidth;
        var innerHeight = this.height - paddingTop - paddingBottom;
        var isInsideWindow = localX >= 0 && localX < innerWidth && 
                             localY >= 0 && localY < innerHeight;
        
        var isReleased = TouchInput.isReleased();
        
        if (isReleased && this._pressedButtonContainer) {
            var container = this._pressedButtonContainer;
            container._isPressed = false;
            
            if (isInsideWindow && this.isInsideButton(container, localX, localY)) {
                if (container._isEnabled !== false) {
                    if (settings.clickItemIdVariable > 0 && container._imageItem) {
                        $gameVariables.setValue(settings.clickItemIdVariable, container._imageItem.itemId);
                    }
                    
                    if (container._imageItem && container._imageItem.commonEventId > 0) {
                        $gameTemp.reserveCommonEvent(container._imageItem.commonEventId);
                    }
                } else {
                    this.playDisabledSE();
                }
            }
            
            this._pressedButtonContainer = null;
        }
    };

    Window_ItemCustom.prototype.update = function() {
        Window_Custom.prototype.update.call(this);
        
        var currentOwnedItemIds = this.getOwnedItemIds();
        if (!this.arraysEqual(currentOwnedItemIds, this._displayedItems)) {
            this.refreshItemImages();
        }
    };

    Window_ItemCustom.prototype.isHoverEffectEnabled = function() {
        return this._itemWindowSettings && this._itemWindowSettings.useHoverEffect !== false;
    };

    Window_ItemCustom.prototype.applyButtonEffect = function(container, isPressed) {
        if (!this.isHoverEffectEnabled()) return;
        Window_Custom.prototype.applyButtonEffect.call(this, container, isPressed);
    };

    Window_ItemCustom.prototype.applyButtonEffectImmediate = function(container, scaleX, scaleY, offsetX, offsetY) {
        if (!this.isHoverEffectEnabled()) return;
        Window_Custom.prototype.applyButtonEffectImmediate.call(this, container, scaleX, scaleY, offsetX, offsetY);
    };

    Window_ItemCustom.prototype.applyImmediateHoverEffect = function(container) {
        if (!this.isHoverEffectEnabled()) return true;
        return Window_Custom.prototype.applyImmediateHoverEffect.call(this, container);
    };

    Window_ItemCustom.prototype.getColumns = function() {
        return this._itemWindowSettings ? this._itemWindowSettings.columns : 1;
    };

    Window_ItemCustom.prototype.getItemHeight = function(container) {
        if (!this._itemWindowSettings) return 48;
        return this._itemWindowSettings.itemHeight + this._itemWindowSettings.spacingY;
    };

    Window_ItemCustom.prototype.triggerButtonClick = function(container) {
        if (!container || !container._imageItem) return;
        
        if (container._isEnabled === false) {
            this.playDisabledSE();
            return;
        }
        
        var settings = this._itemWindowSettings;
        
        if (settings.clickItemIdVariable > 0 && container._imageItem.itemId) {
            $gameVariables.setValue(settings.clickItemIdVariable, container._imageItem.itemId);
        }
        
        if (container._imageItem.commonEventId > 0) {
            $gameTemp.reserveCommonEvent(container._imageItem.commonEventId);
        }
    };

    Window_ItemCustom.calculateWindowSize = function(settings, itemCount, imageSize) {
        if (settings.useWindowImageSize && imageSize) {
            return {
                width: imageSize.width,
                height: imageSize.height,
                needsScrollBar: false
            };
        }
        
        var columns = settings.columns;
        var maxRows = settings.maxRows;
        var itemWidth = settings.itemWidth;
        var itemHeight = settings.itemHeight;
        var spacingX = settings.spacingX;
        var spacingY = settings.spacingY;
        var padding = settings.padding;
        
        var actualRows = Math.ceil(itemCount / columns);
        
        var contentWidth = columns * itemWidth + (columns - 1) * spacingX;
        var contentHeight = maxRows * itemHeight + (maxRows - 1) * spacingY;
        
        var needsScrollBar = actualRows > maxRows;
        var sbSettings = getScrollBarSettingsById(settings.scrollBarId || '');
        var scrollBarWidth = needsScrollBar ? (sbSettings.width || 12) : 0;
        
        return {
            width: contentWidth + padding * 2 + scrollBarWidth,
            height: contentHeight + padding * 2,
            needsScrollBar: needsScrollBar
        };
    };

    window.Window_ItemCustom = Window_ItemCustom;

    var _Scene_Map_createAllWindows = Scene_Map.prototype.createAllWindows;
    Scene_Map.prototype.createAllWindows = function() {
        _Scene_Map_createAllWindows.call(this);
        this._customWindows = {};
        this._itemWindows = {};
        this._allWindowOrder = [];
        this._transitionPhase = 'none';
        this._transitionSettings = null;
        this._transitionCallback = null;
        this._transitionLayer = null;
        this._transitionFilter = null;
        this._transitionBlackSprite = null;
        this.restoreCustomWindows();
        this.restoreItemWindows();
    };

    Scene_Map.prototype.isCustomWindowActive = function() {
        if (this._customWindows) {
            for (var windowId in this._customWindows) {
                var win = this._customWindows[windowId];
                if (win && win.visible) {
                    return true;
                }
            }
        }
        if (this._itemWindows) {
            for (var itemWindowId in this._itemWindows) {
                var itemWin = this._itemWindows[itemWindowId];
                if (itemWin && itemWin.visible) {
                    return true;
                }
            }
        }
        if (this._skillTreeWindows) {
            for (var skillTreeId in this._skillTreeWindows) {
                var skillTreeWin = this._skillTreeWindows[skillTreeId];
                if (skillTreeWin && skillTreeWin.visible) {
                    return true;
                }
            }
        }
        return false;
    };

    Scene_Map.prototype.isPlayerMovementBlocked = function() {
        if (this._transitionLayer) {
            return true;
        }
        if (this._customWindows) {
            for (var windowId in this._customWindows) {
                var win = this._customWindows[windowId];
                if (win && win.visible) {
                    var settings = params.windowSettings[windowId];
                    if (settings && !settings.allowPlayerMovement) {
                        return true;
                    }
                }
            }
        }
        if (this._itemWindows) {
            for (var itemWindowId in this._itemWindows) {
                var itemWin = this._itemWindows[itemWindowId];
                if (itemWin && itemWin.visible) {
                    var itemSettings = params.itemWindowSettings[itemWindowId];
                    if (itemSettings && !itemSettings.allowPlayerMovement) {
                        return true;
                    }
                }
            }
        }
        if (this._skillTreeWindows) {
            for (var skillTreeId in this._skillTreeWindows) {
                var skillTreeWin = this._skillTreeWindows[skillTreeId];
                if (skillTreeWin && skillTreeWin.visible) {
                    var skillTreeSettings = params.skillTreeWindowSettings[skillTreeId];
                    if (skillTreeSettings && !skillTreeSettings.allowPlayerMovement) {
                        return true;
                    }
                }
            }
        }
        return false;
    };

    var _Game_Player_canMove = Game_Player.prototype.canMove;
    Game_Player.prototype.canMove = function() {
        var scene = SceneManager._scene;
        if (scene && scene.isPlayerMovementBlocked && scene.isPlayerMovementBlocked()) {
            return false;
        }
        return _Game_Player_canMove.call(this);
    };

    var _Scene_Map_isMenuEnabled = Scene_Map.prototype.isMenuEnabled;
    Scene_Map.prototype.isMenuEnabled = function() {
        if (this.isCustomWindowActive()) {
            return false;
        }
        if (this._transitionLayer) {
            return false;
        }
        return _Scene_Map_isMenuEnabled.call(this);
    };

    Scene_Map.prototype.isTransitioning = function() {
        return !!this._transitionLayer;
    };

    var _Scene_Map_isMenuCalled = Scene_Map.prototype.isMenuCalled;
    Scene_Map.prototype.isMenuCalled = function() {
        if (this.isCustomWindowActive()) {
            return false;
        }
        return _Scene_Map_isMenuCalled.call(this);
    };

    var _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.call(this);
    };

    Scene_Map.prototype.isTransitionRunning = function() {
        return this._transitionPhase !== 'none';
    };

    var hexToRGBArray = function(hex) {
        hex = hex.replace('#', '');
        if (hex.length === 3) {
            hex = hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2];
        }
        var r = parseInt(hex.substring(0, 2), 16) / 255;
        var g = parseInt(hex.substring(2, 4), 16) / 255;
        var b = parseInt(hex.substring(4, 6), 16) / 255;
        return [r, g, b];
    };

    Scene_Map.prototype.startTransition = function(transitionId, callback, afterFadeInCallback) {
        var transSettings = params.transitionEffects[transitionId];
        if (!transSettings) {
            if (callback) callback();
            if (afterFadeInCallback) afterFadeInCallback();
            return;
        }
        
        var self = this;
        this._transitionSettings = transSettings;
        this._transitionCallback = callback;
        this._transitionAfterFadeInCallback = afterFadeInCallback;
        this._transitionPhase = 'fadeOut';
        
        var ruleImage = transSettings.transitionImage;
        if (ruleImage) {
            var ruleBitmap = ImageManager.loadCustomWindowPicture(ruleImage);
            ruleBitmap.addLoadListener(function() {
                self.startRuleFade('out', ruleBitmap, transSettings);
            });
        } else {
            var whiteBitmap = new Bitmap(1, 1);
            whiteBitmap.fillAll('#ffffff');
            this.startRuleFade('out', whiteBitmap, transSettings);
        }
    };

    Scene_Map.prototype.startRuleFade = function(type, ruleBitmap, transSettings) {
        var self = this;
        var duration = type === 'out' ? transSettings.fadeOutDuration : transSettings.fadeInDuration;
        var fadeColor = transSettings.fadeColor || '#000000';
        var colorRGB = hexToRGBArray(fadeColor);
        
        if (type === 'out') {
            this._transitionRuleData = null;
        }
        
        var layer = new Sprite();
        layer.z = 100;
        this.addChild(layer);
        
        var blackBitmap = new Bitmap(Graphics.width, Graphics.height);
        
        blackBitmap.fillRect(0, 0, Graphics.width, Graphics.height, fadeColor);
        var blackSprite = new Sprite(blackBitmap);
        blackSprite.opacity = 0;
        layer.addChild(blackSprite);
        
        if (this._transitionLayer && this._transitionLayer.parent) {
            this._transitionLayer.parent.removeChild(this._transitionLayer);
        }
        this._transitionLayer = layer;
        this._transitionBlackSprite = blackSprite;
        this._transitionRuleBitmap = ruleBitmap;
        
        var frame = 0;
        var isFadeOut = (type === 'out');
        var isReverse = isFadeOut ? transSettings.fadeOutReverse : transSettings.fadeInReverse;
        
        function updateFade() {
            var progress = frame / duration;
            
            if (ruleBitmap.width > 1 && ruleBitmap.height > 1) {
                self.updateRuleTransition(blackSprite, ruleBitmap, progress, isFadeOut, colorRGB, isReverse);
            } else {
                var alpha = isFadeOut ? progress : (1.0 - progress);
                blackSprite.opacity = Math.floor(alpha * 255);
            }
            
            frame++;
            
            if (frame <= duration) {
                requestAnimationFrame(updateFade);
            } else {
                if (type === 'out') {
                    blackSprite.opacity = 255;
                    
                    if (self._transitionCallback) {
                        self._transitionCallback();
                    }
                    
                    self._transitionPhase = 'fadeIn';
                    self.startRuleFadeIn(ruleBitmap, transSettings, layer);
                } else {
                    if (layer && layer.parent) {
                        layer.parent.removeChild(layer);
                    }
                    self._transitionPhase = 'none';
                    self._transitionLayer = null;
                    self._transitionBlackSprite = null;
                    self._transitionRuleBitmap = null;
                    self._transitionSettings = null;
                    self._transitionCallback = null;
                    self._transitionRuleData = null;
                }
            }
        }
        
        requestAnimationFrame(updateFade);
    };

    Scene_Map.prototype.updateRuleTransition = function(targetSprite, ruleBitmap, progress, isFadeOut, colorRGB, isReverse) {
        var width = Graphics.width;
        var height = Graphics.height;
        var ruleWidth = ruleBitmap.width;
        var ruleHeight = ruleBitmap.height;
        
        if (!this._transitionRuleData) {
            var ruleCanvas = ruleBitmap._canvas || ruleBitmap._image;
            if (!ruleCanvas) return;
            
            var ruleCtx;
            if (ruleBitmap._canvas) {
                ruleCtx = ruleBitmap._context;
            } else {
                var tempCanvas = document.createElement('canvas');
                tempCanvas.width = ruleWidth;
                tempCanvas.height = ruleHeight;
                ruleCtx = tempCanvas.getContext('2d');
                ruleCtx.drawImage(ruleBitmap._image, 0, 0);
            }
            
            var ruleImageData = ruleCtx.getImageData(0, 0, ruleWidth, ruleHeight);
            this._transitionRuleData = ruleImageData.data;
        }
        
        var ruleData = this._transitionRuleData;
        
        var bitmap = new Bitmap(width, height);
        var ctx = bitmap._context;
        var imageData = ctx.createImageData(width, height);
        var data = imageData.data;
        
        var r = Math.floor(colorRGB[0] * 255);
        var g = Math.floor(colorRGB[1] * 255);
        var b = Math.floor(colorRGB[2] * 255);
        
        var scaleX = ruleWidth / width;
        var scaleY = ruleHeight / height;
        
        var edgeWidth = 0.1;
        
        for (var y = 0; y < height; y++) {
            for (var x = 0; x < width; x++) {
                var rx = Math.floor(x * scaleX);
                var ry = Math.floor(y * scaleY);
                rx = Math.min(rx, ruleWidth - 1);
                ry = Math.min(ry, ruleHeight - 1);
                
                var ruleIdx = (ry * ruleWidth + rx) * 4;
                var ruleValue = ruleData[ruleIdx] / 255.0;
                
                if (isReverse) {
                    ruleValue = 1.0 - ruleValue;
                }
                
                var threshold = progress;
                var alpha;
                if (isFadeOut) {
                    alpha = smoothstep(ruleValue - edgeWidth, ruleValue + edgeWidth, threshold);
                } else {
                    alpha = 1.0 - smoothstep(ruleValue - edgeWidth, ruleValue + edgeWidth, threshold);
                }
                
                var idx = (y * width + x) * 4;
                data[idx] = r;
                data[idx + 1] = g;
                data[idx + 2] = b;
                data[idx + 3] = Math.floor(alpha * 255);
            }
        }
        
        ctx.putImageData(imageData, 0, 0);
        
        targetSprite.bitmap = bitmap;
        targetSprite.opacity = 255;
    };

    var smoothstep = function(edge0, edge1, x) {
        var t = Math.max(0, Math.min(1, (x - edge0) / (edge1 - edge0)));
        return t * t * (3 - 2 * t);
    };

    Scene_Map.prototype.startRuleFadeIn = function(ruleBitmap, transSettings, existingLayer) {
        var self = this;
        var duration = transSettings.fadeInDuration;
        var fadeColor = transSettings.fadeColor || '#000000';
        var colorRGB = hexToRGBArray(fadeColor);
        var isReverse = transSettings.fadeInReverse;
        
        var layer = existingLayer;
        
        while (layer.children.length > 0) {
            layer.removeChildAt(0);
        }
        
        var blackSprite = new Sprite(new Bitmap(Graphics.width, Graphics.height));
        blackSprite.bitmap.fillAll(fadeColor);
        blackSprite.opacity = 255;
        layer.addChild(blackSprite);
        
        this._transitionBlackSprite = blackSprite;
        
        var frame = 0;
        
        function updateFade() {
            var progress = frame / duration;
            
            if (ruleBitmap.width > 1 && ruleBitmap.height > 1) {
                self.updateRuleTransition(blackSprite, ruleBitmap, progress, false, colorRGB, isReverse);
            } else {
                var alpha = 1.0 - progress;
                blackSprite.opacity = Math.floor(alpha * 255);
            }
            
            frame++;
            
            if (frame <= duration) {
                requestAnimationFrame(updateFade);
            } else {
                if (layer && layer.parent) {
                    layer.parent.removeChild(layer);
                }
                
                var afterCallback = self._transitionAfterFadeInCallback;
                self._transitionPhase = 'none';
                self._transitionLayer = null;
                self._transitionBlackSprite = null;
                self._transitionRuleBitmap = null;
                self._transitionSettings = null;
                self._transitionCallback = null;
                self._transitionAfterFadeInCallback = null;
                self._transitionRuleData = null;
                
                if (afterCallback) {
                    afterCallback();
                }
            }
        }
        
        requestAnimationFrame(updateFade);
    };

    Scene_Map.prototype.endTransition = function() {
        this._transitionPhase = 'none';
        if (this._transitionLayer && this._transitionLayer.parent) {
            this._transitionLayer.parent.removeChild(this._transitionLayer);
        }
        this._transitionLayer = null;
        this._transitionBlackSprite = null;
        this._transitionRuleBitmap = null;
        this._transitionSettings = null;
        this._transitionCallback = null;
        this._transitionRuleData = null;
    };

    
    var _customWindowPendingTitleFadeIn = null;

    
    var _Scene_Title_start = Scene_Title.prototype.start;
    Scene_Title.prototype.start = function() {
        _Scene_Title_start.call(this);
        
        
        if (_customWindowPendingTitleFadeIn) {
            var transSettings = _customWindowPendingTitleFadeIn;
            _customWindowPendingTitleFadeIn = null;
            this._startCustomFadeIn(transSettings);
        }
    };

    Scene_Title.prototype._startCustomFadeIn = function(transSettings) {
        var self = this;
        var duration = transSettings.fadeInDuration;
        var fadeColor = transSettings.fadeColor || '#000000';
        var isReverse = transSettings.fadeInReverse;
        
        
        var layer = new Sprite();
        layer.z = 100;
        this.addChild(layer);
        
        
        var blackBitmap = new Bitmap(Graphics.width, Graphics.height);
        blackBitmap.fillRect(0, 0, Graphics.width, Graphics.height, fadeColor);
        var blackSprite = new Sprite(blackBitmap);
        blackSprite.opacity = 255;
        layer.addChild(blackSprite);
        
        
        var ruleImage = transSettings.transitionImage;
        if (ruleImage) {
            var ruleBitmap = ImageManager.loadCustomWindowPicture(ruleImage);
            ruleBitmap.addLoadListener(function() {
                self._runCustomFadeIn(layer, blackSprite, ruleBitmap, transSettings);
            });
        } else {
            
            this._runCustomFadeIn(layer, blackSprite, null, transSettings);
        }
    };

    Scene_Title.prototype._runCustomFadeIn = function(layer, blackSprite, ruleBitmap, transSettings) {
        var self = this;
        var duration = transSettings.fadeInDuration;
        var fadeColor = transSettings.fadeColor || '#000000';
        var colorRGB = hexToRGBArray(fadeColor);
        var isReverse = transSettings.fadeInReverse;
        
        var frame = 0;
        
        function updateFade() {
            var progress = frame / duration;
            
            if (ruleBitmap && ruleBitmap.width > 1 && ruleBitmap.height > 1) {
                self._updateRuleTransitionForTitle(blackSprite, ruleBitmap, progress, false, colorRGB, isReverse);
            } else {
                var alpha = 1.0 - progress;
                blackSprite.opacity = Math.floor(alpha * 255);
            }
            
            frame++;
            
            if (frame <= duration) {
                requestAnimationFrame(updateFade);
            } else {
                if (layer && layer.parent) {
                    layer.parent.removeChild(layer);
                }
            }
        }
        
        requestAnimationFrame(updateFade);
    };

    Scene_Title.prototype._updateRuleTransitionForTitle = function(targetSprite, ruleBitmap, progress, isFadeOut, colorRGB, isReverse) {
        var width = Graphics.width;
        var height = Graphics.height;
        var ruleWidth = ruleBitmap.width;
        var ruleHeight = ruleBitmap.height;
        
        if (!this._transitionRuleData) {
            var ruleCanvas = ruleBitmap._canvas || ruleBitmap._image;
            if (!ruleCanvas) return;
            
            var ruleCtx;
            if (ruleBitmap._canvas) {
                ruleCtx = ruleBitmap._context;
            } else {
                var tempCanvas = document.createElement('canvas');
                tempCanvas.width = ruleWidth;
                tempCanvas.height = ruleHeight;
                ruleCtx = tempCanvas.getContext('2d');
                ruleCtx.drawImage(ruleBitmap._image, 0, 0);
            }
            
            var ruleImageData = ruleCtx.getImageData(0, 0, ruleWidth, ruleHeight);
            this._transitionRuleData = ruleImageData.data;
        }
        
        var ruleData = this._transitionRuleData;
        var threshold = isFadeOut ? progress * 255 : (1.0 - progress) * 255;
        var softness = 40;
        
        if (!targetSprite.bitmap || targetSprite.bitmap.width !== width) {
            targetSprite.bitmap = new Bitmap(width, height);
        }
        
        var bitmap = targetSprite.bitmap;
        var context = bitmap._context;
        var imageData = context.createImageData(width, height);
        var data = imageData.data;
        
        var r = Math.floor(colorRGB[0] * 255);
        var g = Math.floor(colorRGB[1] * 255);
        var b = Math.floor(colorRGB[2] * 255);
        
        for (var y = 0; y < height; y++) {
            for (var x = 0; x < width; x++) {
                var ruleX = Math.floor((x / width) * ruleWidth);
                var ruleY = Math.floor((y / height) * ruleHeight);
                var ruleIndex = (ruleY * ruleWidth + ruleX) * 4;
                var ruleValue = ruleData[ruleIndex];
                
                if (isReverse) {
                    ruleValue = 255 - ruleValue;
                }
                
                var alpha;
                if (isFadeOut) {
                    alpha = Math.min(255, Math.max(0, (threshold - ruleValue + softness) / softness * 255));
                } else {
                    alpha = Math.min(255, Math.max(0, (ruleValue - threshold + softness) / softness * 255));
                    alpha = 255 - alpha;
                }
                
                var index = (y * width + x) * 4;
                data[index] = r;
                data[index + 1] = g;
                data[index + 2] = b;
                data[index + 3] = alpha;
            }
        }
        
        context.putImageData(imageData, 0, 0);
        bitmap._baseTexture.update();
        targetSprite.opacity = 255;
    };

    Scene_Map.prototype.restoreCustomWindows = function() {
        if (!$gameSystem) return;
        var windowIds = $gameSystem.getDisplayedWindowIds();
        for (var i = 0; i < windowIds.length; i++) {
            var windowId = windowIds[i];
            var imageLists = $gameSystem.getCustomWindowImageLists(windowId);
            if (params.windowSettings[windowId]) {
                this.addCustomWindow(windowId, imageLists);
            }
        }
    };

    Scene_Map.prototype.restoreItemWindows = function() {
        if (!$gameSystem) return;
        var itemWindowIds = $gameSystem.getDisplayedItemWindowIds ? $gameSystem.getDisplayedItemWindowIds() : [];
        for (var i = 0; i < itemWindowIds.length; i++) {
            var itemWindowId = itemWindowIds[i];
            if (params.itemWindowSettings[itemWindowId]) {
                this.addItemWindow(itemWindowId);
            }
        }
    };

    Scene_Map.prototype.removeFromAllWindowOrder = function(type, id) {
        for (var i = this._allWindowOrder.length - 1; i >= 0; i--) {
            if (this._allWindowOrder[i].type === type && this._allWindowOrder[i].id === id) {
                this._allWindowOrder.splice(i, 1);
                break;
            }
        }
    };

    Scene_Map.prototype.addToAllWindowOrder = function(type, id) {
        this.removeFromAllWindowOrder(type, id);
        this._allWindowOrder.push({ type: type, id: id });
    };

    Scene_Map.prototype.addCustomWindow = function(windowId, additionalImageLists) {
        var settings = params.windowSettings[windowId];
        if (!settings) {
            console.warn('CustomWindow: Window ID ' + windowId + ' not found');
            return;
        }
        
        if (this._customWindows[windowId]) {
            this.removeCustomWindowById(windowId, false);
        }
        
        if ($gameSystem) {
            $gameSystem.addDisplayedWindow(windowId);
        }
        
        var self = this;
        var bgImage = settings.backgroundImage;
        
        var transitionId = settings.transitionId;
        if (transitionId && params.transitionEffects[transitionId]) {
            this.startTransition(transitionId, function() {
                if (bgImage && settings.useImageSize) {
                    loadPictureSize(bgImage, function(size) {
                        var width = size ? size.width : settings.width;
                        var height = size ? size.height : settings.height;
                        self.createCustomWindowFromSettings(windowId, settings, width, height, additionalImageLists);
                    });
                } else {
                    self.createCustomWindowFromSettings(windowId, settings, settings.width, settings.height, additionalImageLists);
                }
            });
        } else {
            if (bgImage && settings.useImageSize) {
                loadPictureSize(bgImage, function(size) {
                    var width = size ? size.width : settings.width;
                    var height = size ? size.height : settings.height;
                    self.createCustomWindowFromSettings(windowId, settings, width, height, additionalImageLists);
                });
            } else {
                this.createCustomWindowFromSettings(windowId, settings, settings.width, settings.height, additionalImageLists);
            }
        }
    };

    Scene_Map.prototype.createCustomWindowFromSettings = function(windowId, settings, width, height, additionalImageLists) {
        var rect;
        if (isMZ) {
            rect = new Rectangle(settings.x, settings.y, width, height);
        } else {
            rect = { x: settings.x, y: settings.y, width: width, height: height };
        }
        
        
        var sceneBackgroundImage = settings.sceneBackgroundImage;
        if (sceneBackgroundImage) {
            var priorityType = settings.priorityType || 'aboveFade';
            var pictureId = settings.pictureId || 50;
            this._createSceneBackgroundForWindow(windowId, sceneBackgroundImage, priorityType, pictureId);
        }
        
        var bgImage = settings.backgroundImage;
        var windowOpacity = bgImage ? 0 : params.windowOpacity;
        var backOpacity = bgImage ? 0 : params.backOpacity;
        
        var finalImageLists = {};
        var paramListIds = Object.keys(settings.imageList);
        for (var i = 0; i < paramListIds.length; i++) {
            var lid = paramListIds[i];
            finalImageLists[lid] = settings.imageList[lid].slice();
        }
        if (additionalImageLists) {
            var addListIds = Object.keys(additionalImageLists);
            for (var j = 0; j < addListIds.length; j++) {
                var lid = addListIds[j];
                if (!finalImageLists[lid]) {
                    finalImageLists[lid] = [];
                }
                finalImageLists[lid] = finalImageLists[lid].concat(additionalImageLists[lid]);
            }
        }
        
        var customWindow = new Window_Custom(rect, settings, windowOpacity, backOpacity, finalImageLists, windowId);
        this._customWindows[windowId] = customWindow;
        this.addToAllWindowOrder('custom', windowId);
        
        
        var priorityType = settings.priorityType || 'aboveFade';
        var pictureId = settings.pictureId || 50;
        this._addWindowWithPriority(customWindow, priorityType, pictureId);
        
        this.updateAllWindowsTouchEnabled();
    };

    
    Scene_Map.prototype._addWindowWithPriority = function(window, priorityType, pictureId) {
        if (priorityType === 'samePicture') {
            
            this._addWindowToPictureLayer(window, pictureId);
        } else {
            
            this.addWindow(window);
        }
    };

    
    Scene_Map.prototype._addWindowToPictureLayer = function(window, pictureId) {
        if (!this._spriteset) {
            console.warn('CustomWindow: _spriteset not found, using addWindow fallback');
            this.addWindow(window);
            return;
        }
        
        
        var pictureContainer = this._spriteset._pictureContainer;
        if (!pictureContainer) {
            console.warn('CustomWindow: _pictureContainer not found, using addWindow fallback');
            this.addWindow(window);
            return;
        }
        
        var insertIndex = pictureId + 1;
        insertIndex = Math.min(insertIndex, pictureContainer.children.length);
        
        
        pictureContainer.addChildAt(window, insertIndex);
    };

    Scene_Map.prototype._ensureSceneBackgrounds = function() {
        if (!this._customWindowSceneBackgrounds) {
            this._customWindowSceneBackgrounds = {};
        }
    };

    Scene_Map.prototype._createSceneBackgroundForWindow = function(windowId, imageName, priorityType, pictureId) {
        this._ensureSceneBackgrounds();
        
        this._removeSceneBackgroundForWindow(windowId);
        
        var bitmap = ImageManager.loadCustomWindowPicture(imageName);
        var sprite = new Sprite(bitmap);
        sprite.x = 0;
        sprite.y = 0;
        
        this._customWindowSceneBackgrounds[windowId] = sprite;
        
        priorityType = priorityType || 'aboveFade';
        pictureId = pictureId || 50;
        
        if (priorityType === 'samePicture') {
            if (this._spriteset && this._spriteset._pictureContainer) {
                var pictureContainer = this._spriteset._pictureContainer;
                var insertIndex = pictureId;
                insertIndex = Math.min(insertIndex, pictureContainer.children.length);
                pictureContainer.addChildAt(sprite, insertIndex);
            } else {
                this.addChild(sprite);
            }
        } else {
            if (this._spriteset) {
                var index = this.children.indexOf(this._spriteset);
                if (index >= 0) {
                    this.addChildAt(sprite, index + 1);
                } else {
                    this.addChild(sprite);
                }
            } else {
                this.addChild(sprite);
            }
        }
    };

    Scene_Map.prototype._removeSceneBackgroundForWindow = function(windowId) {
        this._ensureSceneBackgrounds();
        
        var sprite = this._customWindowSceneBackgrounds[windowId];
        if (sprite && sprite.parent) {
            sprite.parent.removeChild(sprite);
        }
        delete this._customWindowSceneBackgrounds[windowId];
    };

    Scene_Map.prototype._removeAllSceneBackgrounds = function() {
        this._ensureSceneBackgrounds();
        
        for (var windowId in this._customWindowSceneBackgrounds) {
            var sprite = this._customWindowSceneBackgrounds[windowId];
            if (sprite && sprite.parent) {
                sprite.parent.removeChild(sprite);
            }
        }
        this._customWindowSceneBackgrounds = {};
    };

    Scene_Map.prototype.updateAllWindowsTouchEnabled = function() {
        var lastWindow = this._allWindowOrder.length > 0 
            ? this._allWindowOrder[this._allWindowOrder.length - 1] 
            : null;
        
        for (var wid in this._customWindows) {
            var win = this._customWindows[wid];
            if (win) {
                var isLast = lastWindow && lastWindow.type === 'custom' && lastWindow.id === Number(wid);
                win.setTouchEnabled(isLast);
            }
        }
        
        for (var wid in this._itemWindows) {
            var win = this._itemWindows[wid];
            if (win) {
                var isLast = lastWindow && lastWindow.type === 'item' && lastWindow.id === Number(wid);
                win.setTouchEnabled(isLast);
            }
        }
    };

    Scene_Map.prototype.removeCustomWindowById = function(windowId, clearData) {
        
        this._removeSceneBackgroundForWindow(windowId);
        
        var win = this._customWindows[windowId];
        if (win && win.parent) {
            win.parent.removeChild(win);
        }
        delete this._customWindows[windowId];
        
        this.removeFromAllWindowOrder('custom', windowId);
        
        if (clearData && $gameSystem) {
            $gameSystem.removeDisplayedWindow(windowId);
        }
        
        this.updateAllWindowsTouchEnabled();
    };

    Scene_Map.prototype.closeAllCustomWindowsDirect = function() {
        
        this._removeAllSceneBackgrounds();
        
        for (var windowId in this._customWindows) {
            var win = this._customWindows[windowId];
            if (win && win.parent) {
                win.parent.removeChild(win);
            }
            this.removeFromAllWindowOrder('custom', Number(windowId));
        }
        this._customWindows = {};
    };

    Scene_Map.prototype.hideCustomWindow = function(windowId) {
        if (!windowId || windowId === 0) {
            for (var wid in this._customWindows) {
                var win = this._customWindows[wid];
                if (win) win.visible = false;
            }
        } else {
            var win = this._customWindows[windowId];
            if (win) win.visible = false;
        }
    };

    Scene_Map.prototype.closeCustomWindow = function(windowId) {
        var self = this;
        
        if (!windowId || windowId === 0) {
            if ($gameSystem) {
                $gameSystem.clearCustomWindowData();
            }
            this.closeAllCustomWindowsDirect();
        } else {
            var settings = params.windowSettings[windowId];
            var transitionId = settings ? settings.transitionId : '';
            
            if (transitionId && params.transitionEffects[transitionId]) {
                this.startTransition(transitionId, function() {
                    self.removeCustomWindowById(windowId, true);
                });
            } else {
                this.removeCustomWindowById(windowId, true);
            }
        }
    };

    Scene_Map.prototype.closeCustomWindowAndGotoTitle = function(windowId) {
        var self = this;
        
        if (!windowId || windowId === 0) {
            if ($gameSystem) {
                $gameSystem.clearCustomWindowData();
            }
            this.closeAllCustomWindowsDirect();
            SceneManager.goto(Scene_Title);
        } else {
            var settings = params.windowSettings[windowId];
            var transitionId = settings ? settings.transitionId : '';
            
            if (transitionId && params.transitionEffects[transitionId]) {
                var transSettings = params.transitionEffects[transitionId];
                
                
                this._startFadeOutOnly(transitionId, function() {
                    
                    self.removeCustomWindowById(windowId, true);
                    
                    _customWindowPendingTitleFadeIn = transSettings;
                    
                    SceneManager.goto(Scene_Title);
                });
            } else {
                this.removeCustomWindowById(windowId, true);
                SceneManager.goto(Scene_Title);
            }
        }
    };

    
    Scene_Map.prototype.suspendCustomWindowWithTransition = function(windowId, transitionId) {
        var self = this;
        var transSettings = transitionId ? params.transitionEffects[transitionId] : null;
        
        
        if (!windowId || windowId === 0) {
            for (var wid in this._customWindows) {
                var win = this._customWindows[wid];
                if (win) {
                    win._touchEnabled = false;
                    win._isSuspended = true;
                }
            }
        } else {
            var win = this._customWindows[windowId];
            if (win) {
                win._touchEnabled = false;
                win._isSuspended = true;
            }
        }
        
        if (transSettings) {
            
            this._suspendTargetWindowId = windowId;
            this._startSuspendFadeOut(transitionId, function() {
                
                self._applySuspendToWindows(windowId);
                
                if (self._transitionLayer && self._transitionLayer.parent) {
                    self._transitionLayer.parent.removeChild(self._transitionLayer);
                    self._transitionLayer = null;
                }
            });
        } else {
            
            this._applySuspendToWindows(windowId);
        }
    };
    
    
    Scene_Map.prototype._applySuspendToWindows = function(windowId) {
        if (!windowId || windowId === 0) {
            for (var wid in this._customWindows) {
                var win = this._customWindows[wid];
                if (win) {
                    if (win._saveSuspendState) {
                        win._saveSuspendState();
                    }
                    if (win._applySuspendOpacity) {
                        win._applySuspendOpacity(0);
                    }
                }
                
                var bgSprite = this._customWindowSceneBackgrounds ? this._customWindowSceneBackgrounds[wid] : null;
                if (bgSprite) {
                    bgSprite._suspendOriginalOpacity = bgSprite.opacity || 255;
                    bgSprite.opacity = 0;
                }
            }
        } else {
            var win = this._customWindows[windowId];
            if (win) {
                if (win._saveSuspendState) {
                    win._saveSuspendState();
                }
                if (win._applySuspendOpacity) {
                    win._applySuspendOpacity(0);
                }
            }
            
            var bgSprite = this._customWindowSceneBackgrounds ? this._customWindowSceneBackgrounds[windowId] : null;
            if (bgSprite) {
                bgSprite._suspendOriginalOpacity = bgSprite.opacity || 255;
                bgSprite.opacity = 0;
            }
        }
    };

    
    Scene_Map.prototype.resumeCustomWindowWithTransition = function(windowId, transitionId) {
        var self = this;
        var transSettings = transitionId ? params.transitionEffects[transitionId] : null;
        
        
        this._restoreSuspendedWindows(windowId);
        
        if (transSettings) {
            
            this._resumeTargetWindowId = windowId;
            this._startResumeFadeIn(transitionId, function() {
                
                self._enableWindowsAfterResume(windowId);
                
                if (self._transitionLayer && self._transitionLayer.parent) {
                    self._transitionLayer.parent.removeChild(self._transitionLayer);
                    self._transitionLayer = null;
                }
            });
        } else {
            
            this._enableWindowsAfterResume(windowId);
        }
    };
    
    
    Scene_Map.prototype._restoreSuspendedWindows = function(windowId) {
        if (!windowId || windowId === 0) {
            for (var wid in this._customWindows) {
                var win = this._customWindows[wid];
                if (win && win._applySuspendOpacity) {
                    win._applySuspendOpacity(255);
                }
                
                var bgSprite = this._customWindowSceneBackgrounds ? this._customWindowSceneBackgrounds[wid] : null;
                if (bgSprite) {
                    bgSprite.opacity = bgSprite._suspendOriginalOpacity || 255;
                }
            }
        } else {
            var win = this._customWindows[windowId];
            if (win && win._applySuspendOpacity) {
                win._applySuspendOpacity(255);
            }
            
            var bgSprite = this._customWindowSceneBackgrounds ? this._customWindowSceneBackgrounds[windowId] : null;
            if (bgSprite) {
                bgSprite.opacity = bgSprite._suspendOriginalOpacity || 255;
            }
        }
    };
    
    
    Scene_Map.prototype._enableWindowsAfterResume = function(windowId) {
        if (!windowId || windowId === 0) {
            for (var wid in this._customWindows) {
                var win = this._customWindows[wid];
                if (win) {
                    win._isSuspended = false;
                    win._touchEnabled = true;
                }
            }
        } else {
            var win = this._customWindows[windowId];
            if (win) {
                win._isSuspended = false;
                win._touchEnabled = true;
            }
        }
        this.updateAllWindowsTouchEnabled();
    };
    
    
    Scene_Map.prototype._startSuspendFadeOut = function(transitionId, callback) {
        var transSettings = params.transitionEffects[transitionId];
        if (!transSettings) {
            if (callback) callback();
            return;
        }
        
        var self = this;
        var ruleImage = transSettings.transitionImage;
        
        if (ruleImage) {
            var ruleBitmap = ImageManager.loadCustomWindowPicture(ruleImage);
            ruleBitmap.addLoadListener(function() {
                self._runSuspendFadeOut(ruleBitmap, transSettings, callback);
            });
        } else {
            var whiteBitmap = new Bitmap(1, 1);
            whiteBitmap.fillAll('#ffffff');
            this._runSuspendFadeOut(whiteBitmap, transSettings, callback);
        }
    };
    
    Scene_Map.prototype._runSuspendFadeOut = function(ruleBitmap, transSettings, callback) {
        var self = this;
        var duration = transSettings.fadeOutDuration;
        var fadeColor = transSettings.fadeColor || '#000000';
        var colorRGB = hexToRGBArray(fadeColor);
        var isReverse = transSettings.fadeOutReverse;
        
        var layer = new Sprite();
        layer.z = 100;
        this.addChild(layer);
        
        var blackBitmap = new Bitmap(Graphics.width, Graphics.height);
        blackBitmap.fillRect(0, 0, Graphics.width, Graphics.height, fadeColor);
        var blackSprite = new Sprite(blackBitmap);
        blackSprite.opacity = 0;
        layer.addChild(blackSprite);
        
        if (this._transitionLayer && this._transitionLayer.parent) {
            this._transitionLayer.parent.removeChild(this._transitionLayer);
        }
        this._transitionLayer = layer;
        this._transitionBlackSprite = blackSprite;
        this._transitionRuleBitmap = ruleBitmap;
        
        var frame = 0;
        
        function updateFade() {
            var progress = frame / duration;
            
            if (ruleBitmap.width > 1 && ruleBitmap.height > 1) {
                self.updateRuleTransition(blackSprite, ruleBitmap, progress, true, colorRGB, isReverse);
            } else {
                blackSprite.opacity = Math.floor(255 * progress);
            }
            
            frame++;
            
            if (frame >= duration) {
                blackSprite.opacity = 255;
                if (callback) callback();
            } else {
                requestAnimationFrame(updateFade);
            }
        }
        
        updateFade();
    };
    
    
    Scene_Map.prototype._startResumeFadeIn = function(transitionId, callback) {
        var transSettings = params.transitionEffects[transitionId];
        if (!transSettings) {
            if (callback) callback();
            return;
        }
        
        var self = this;
        var ruleImage = transSettings.transitionImage;
        
        if (ruleImage) {
            var ruleBitmap = ImageManager.loadCustomWindowPicture(ruleImage);
            ruleBitmap.addLoadListener(function() {
                self._runResumeFadeIn(ruleBitmap, transSettings, callback);
            });
        } else {
            var whiteBitmap = new Bitmap(1, 1);
            whiteBitmap.fillAll('#ffffff');
            this._runResumeFadeIn(whiteBitmap, transSettings, callback);
        }
    };
    
    Scene_Map.prototype._runResumeFadeIn = function(ruleBitmap, transSettings, callback) {
        var self = this;
        var duration = transSettings.fadeInDuration;
        var fadeColor = transSettings.fadeColor || '#000000';
        var colorRGB = hexToRGBArray(fadeColor);
        var isReverse = transSettings.fadeInReverse;
        
        var layer = new Sprite();
        layer.z = 100;
        this.addChild(layer);
        
        var blackBitmap = new Bitmap(Graphics.width, Graphics.height);
        blackBitmap.fillRect(0, 0, Graphics.width, Graphics.height, fadeColor);
        var blackSprite = new Sprite(blackBitmap);
        blackSprite.opacity = 255;
        layer.addChild(blackSprite);
        
        if (this._transitionLayer && this._transitionLayer.parent) {
            this._transitionLayer.parent.removeChild(this._transitionLayer);
        }
        this._transitionLayer = layer;
        this._transitionBlackSprite = blackSprite;
        this._transitionRuleBitmap = ruleBitmap;
        
        var frame = 0;
        
        function updateFade() {
            var progress = frame / duration;
            
            if (ruleBitmap.width > 1 && ruleBitmap.height > 1) {
                self.updateRuleTransition(blackSprite, ruleBitmap, progress, false, colorRGB, isReverse);
            } else {
                blackSprite.opacity = Math.floor(255 * (1 - progress));
            }
            
            frame++;
            
            if (frame >= duration) {
                blackSprite.opacity = 0;
                if (callback) callback();
            } else {
                requestAnimationFrame(updateFade);
            }
        }
        
        updateFade();
    };

    
    Scene_Map.prototype._startFadeOutOnly = function(transitionId, callback) {
        var transSettings = params.transitionEffects[transitionId];
        if (!transSettings) {
            if (callback) callback();
            return;
        }
        
        var self = this;
        this._transitionSettings = transSettings;
        this._transitionPhase = 'fadeOut';
        
        var ruleImage = transSettings.transitionImage;
        if (ruleImage) {
            var ruleBitmap = ImageManager.loadCustomWindowPicture(ruleImage);
            ruleBitmap.addLoadListener(function() {
                self._startFadeOutOnlyProcess(ruleBitmap, transSettings, callback);
            });
        } else {
            var whiteBitmap = new Bitmap(1, 1);
            whiteBitmap.fillAll('#ffffff');
            this._startFadeOutOnlyProcess(whiteBitmap, transSettings, callback);
        }
    };

    Scene_Map.prototype._startFadeOutOnlyProcess = function(ruleBitmap, transSettings, callback) {
        var self = this;
        var duration = transSettings.fadeOutDuration;
        var fadeColor = transSettings.fadeColor || '#000000';
        var colorRGB = hexToRGBArray(fadeColor);
        var isReverse = transSettings.fadeOutReverse;
        
        var layer = new Sprite();
        layer.z = 100;
        this.addChild(layer);
        
        var blackBitmap = new Bitmap(Graphics.width, Graphics.height);
        blackBitmap.fillRect(0, 0, Graphics.width, Graphics.height, fadeColor);
        var blackSprite = new Sprite(blackBitmap);
        blackSprite.opacity = 0;
        layer.addChild(blackSprite);
        
        if (this._transitionLayer && this._transitionLayer.parent) {
            this._transitionLayer.parent.removeChild(this._transitionLayer);
        }
        this._transitionLayer = layer;
        this._transitionBlackSprite = blackSprite;
        this._transitionRuleBitmap = ruleBitmap;
        
        var frame = 0;
        
        function updateFade() {
            var progress = frame / duration;
            
            if (ruleBitmap.width > 1 && ruleBitmap.height > 1) {
                self.updateRuleTransition(blackSprite, ruleBitmap, progress, true, colorRGB, isReverse);
            } else {
                var alpha = progress;
                blackSprite.opacity = Math.floor(alpha * 255);
            }
            
            frame++;
            
            if (frame <= duration) {
                requestAnimationFrame(updateFade);
            } else {
                blackSprite.opacity = 255;
                
                if (callback) {
                    callback();
                }
            }
        }
        
        requestAnimationFrame(updateFade);
    };

    Scene_Map.prototype.showCustomWindowById = function(windowId, additionalImageLists) {
        this.addCustomWindow(windowId, additionalImageLists);
    };

    Scene_Map.prototype.addImageToCustomWindow = function(windowId, imageName, listId) {
        if (!imageName) return;
        
        windowId = windowId || 0;
        listId = listId || 1;
        
        var targetWindowId = windowId;
        if (targetWindowId === 0 && this._customWindowOrder.length > 0) {
            targetWindowId = this._customWindowOrder[this._customWindowOrder.length - 1];
        }
        
        if (!targetWindowId) return;
        
        if ($gameSystem) {
            $gameSystem.addCustomWindowImage(targetWindowId, imageName, listId);
        }
        
        var win = this._customWindows[targetWindowId];
        if (win && win.addImage) {
            win.addImage(imageName, listId);
        }
    };

    Scene_Map.prototype.clearCustomWindowImages = function(windowId, listId) {
        windowId = windowId !== undefined ? windowId : 0;
        listId = listId !== undefined ? listId : 0;
        
        var targetWindowId = windowId;
        if (targetWindowId === 0 && this._customWindowOrder.length > 0) {
            targetWindowId = this._customWindowOrder[this._customWindowOrder.length - 1];
        }
        
        if (!targetWindowId) return;
        
        if ($gameSystem) {
            $gameSystem.clearCustomWindowImageList(targetWindowId, listId);
        }
        
        var win = this._customWindows[targetWindowId];
        if (win && win.clearImageList) {
            win.clearImageList(listId);
        }
    };

    Scene_Map.prototype.addItemWindow = function(itemWindowId) {
        var settings = params.itemWindowSettings[itemWindowId];
        if (!settings) {
            console.warn('CustomWindow: Item Window ID ' + itemWindowId + ' not found');
            return;
        }
        
        if (this._itemWindows[itemWindowId]) {
            this.removeItemWindowById(itemWindowId, false);
        }
        
        if ($gameSystem && $gameSystem.addDisplayedItemWindow) {
            $gameSystem.addDisplayedItemWindow(itemWindowId);
        }
        
        var self = this;
        
        var transitionId = settings.transitionId;
        if (transitionId && params.transitionEffects[transitionId]) {
            this.startTransition(transitionId, function() {
                self.createItemWindowFromSettings(itemWindowId, settings);
            });
        } else {
            this.createItemWindowFromSettings(itemWindowId, settings);
        }
    };

    Scene_Map.prototype.createItemWindowFromSettings = function(itemWindowId, settings) {
        var self = this;
        
        var itemCount = 0;
        if ($gameParty && settings.itemImages) {
            for (var i = 0; i < settings.itemImages.length; i++) {
                var itemId = settings.itemImages[i].itemId;
                var item = $dataItems[itemId];
                if (item && $gameParty.numItems(item) > 0) {
                    itemCount++;
                }
            }
        }
        if (itemCount < 1) itemCount = 1;
        
        var imageSize = null;
        if (settings.useWindowImageSize && settings.windowBackgroundImage) {
            imageSize = getPictureSizeSync(settings.windowBackgroundImage);
            
            if (!imageSize) {
                var bitmap = ImageManager.loadCustomWindowPicture(settings.windowBackgroundImage);
                if (bitmap.isReady()) {
                    imageSize = { width: bitmap.width, height: bitmap.height };
                } else {
                    var winId = itemWindowId;
                    bitmap.addLoadListener(function() {
                        if (self._itemWindows && self._itemWindows[winId]) {
                            var newSize = { width: bitmap.width, height: bitmap.height };
                            self.resizeItemWindow(winId, newSize);
                        }
                    });
                    imageSize = null;
                }
            }
        }
        
        var size = Window_ItemCustom.calculateWindowSize(settings, itemCount, imageSize);
        
        var windowX = settings.x + settings.windowOffsetX;
        var windowY = settings.y + settings.windowOffsetY;
        
        var rect;
        if (isMZ) {
            rect = new Rectangle(windowX, windowY, size.width, size.height);
        } else {
            rect = { x: windowX, y: windowY, width: size.width, height: size.height };
        }
        
        var itemWindow = new Window_ItemCustom(rect, settings, itemWindowId);
        this._itemWindows[itemWindowId] = itemWindow;
        this.addToAllWindowOrder('item', itemWindowId);
        
        var windowLayerIndex = this.children.indexOf(this._windowLayer);
        itemWindow.createBaseBackgroundSprite(this, windowLayerIndex);
        
        this.addWindow(itemWindow);
        
        this.updateAllWindowsTouchEnabled();
    };

    Scene_Map.prototype.resizeItemWindow = function(itemWindowId, newSize) {
        var win = this._itemWindows[itemWindowId];
        if (!win) return;
        
        var settings = win._itemWindowSettings;
        var windowX = settings.x + settings.windowOffsetX;
        var windowY = settings.y + settings.windowOffsetY;
        
        win.move(windowX, windowY, newSize.width, newSize.height);
        
        win.refreshItemImages();
    };

    Scene_Map.prototype.removeItemWindowById = function(itemWindowId, clearData) {
        var win = this._itemWindows[itemWindowId];
        if (win) {
            win.removeBaseBackgroundSprite();
            if (win.parent) {
                win.parent.removeChild(win);
            }
        }
        delete this._itemWindows[itemWindowId];
        
        this.removeFromAllWindowOrder('item', itemWindowId);
        
        if (clearData && $gameSystem && $gameSystem.removeDisplayedItemWindow) {
            $gameSystem.removeDisplayedItemWindow(itemWindowId);
        }
        
        this.updateAllWindowsTouchEnabled();
    };

    Scene_Map.prototype.hideItemWindow = function(itemWindowId) {
        if (!itemWindowId || itemWindowId === 0) {
            for (var wid in this._itemWindows) {
                var win = this._itemWindows[wid];
                if (win) {
                    win.visible = false;
                    if (win._baseBackgroundSprite) {
                        win._baseBackgroundSprite.visible = false;
                    }
                }
            }
        } else {
            var win = this._itemWindows[itemWindowId];
            if (win) {
                win.visible = false;
                if (win._baseBackgroundSprite) {
                    win._baseBackgroundSprite.visible = false;
                }
            }
        }
    };

    Scene_Map.prototype.showItemWindow = function(itemWindowId) {
        if (!itemWindowId || itemWindowId === 0) {
            for (var wid in this._itemWindows) {
                var win = this._itemWindows[wid];
                if (win) {
                    win.visible = true;
                    if (win._baseBackgroundSprite) {
                        win._baseBackgroundSprite.visible = true;
                    }
                }
            }
        } else {
            var win = this._itemWindows[itemWindowId];
            if (win) {
                win.visible = true;
                if (win._baseBackgroundSprite) {
                    win._baseBackgroundSprite.visible = true;
                }
            }
        }
    };

    Scene_Map.prototype.closeItemWindow = function(itemWindowId) {
        var self = this;
        
        if (!itemWindowId || itemWindowId === 0) {
            for (var wid in this._itemWindows) {
                this.removeItemWindowById(Number(wid), true);
            }
            this._itemWindows = {};
        } else {
            var settings = params.itemWindowSettings[itemWindowId];
            var transitionId = settings ? settings.transitionId : '';
            
            if (transitionId && params.transitionEffects[transitionId]) {
                this.startTransition(transitionId, function() {
                    self.removeItemWindowById(itemWindowId, true);
                });
            } else {
                this.removeItemWindowById(itemWindowId, true);
            }
        }
    };

    var _Game_System_initialize_itemWindow = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function() {
        _Game_System_initialize_itemWindow.call(this);
        this._displayedItemWindows = [];
    };

    Game_System.prototype.addDisplayedItemWindow = function(itemWindowId) {
        if (!this._displayedItemWindows) this._displayedItemWindows = [];
        if (this._displayedItemWindows.indexOf(itemWindowId) < 0) {
            this._displayedItemWindows.push(itemWindowId);
        }
    };

    Game_System.prototype.removeDisplayedItemWindow = function(itemWindowId) {
        if (!this._displayedItemWindows) return;
        var index = this._displayedItemWindows.indexOf(itemWindowId);
        if (index >= 0) {
            this._displayedItemWindows.splice(index, 1);
        }
    };

    Game_System.prototype.getDisplayedItemWindowIds = function() {
        return this._displayedItemWindows || [];
    };

    if (isMZ) {
        PluginManager.registerCommand(pluginName, 'showWindow', function(args) {
            var windowId = Number(args.windowId || 1);
            var scene = SceneManager._scene;
            if (scene && scene.addCustomWindow) {
                scene.addCustomWindow(windowId);
            }
        });

        PluginManager.registerCommand(pluginName, 'hideWindow', function(args) {
            var windowId = Number(args.windowId || 0);
            var scene = SceneManager._scene;
            if (scene && scene.hideCustomWindow) {
                scene.hideCustomWindow(windowId);
            }
        });

        PluginManager.registerCommand(pluginName, 'closeWindow', function(args) {
            var windowId = Number(args.windowId || 0);
            var scene = SceneManager._scene;
            if (scene && scene.closeCustomWindow) {
                scene.closeCustomWindow(windowId);
            }
        });

        PluginManager.registerCommand(pluginName, 'addImage', function(args) {
            var imageName = args.imageName || '';
            var listId = args.listId !== undefined && args.listId !== '' ? Number(args.listId) : 1;
            var windowId = args.windowId !== undefined && args.windowId !== '' ? Number(args.windowId) : 0;
            var scene = SceneManager._scene;
            if (scene && scene.addImageToCustomWindow) {
                scene.addImageToCustomWindow(windowId, imageName, listId);
            }
        });

        PluginManager.registerCommand(pluginName, 'clearImages', function(args) {
            var listId = args.listId !== undefined && args.listId !== '' ? Number(args.listId) : 0;
            var windowId = args.windowId !== undefined && args.windowId !== '' ? Number(args.windowId) : 0;
            var scene = SceneManager._scene;
            if (scene && scene.clearCustomWindowImages) {
                scene.clearCustomWindowImages(windowId, listId);
            }
        });

        PluginManager.registerCommand(pluginName, 'showItemWindow', function(args) {
            var itemWindowId = Number(args.itemWindowId || 1);
            var scene = SceneManager._scene;
            if (scene && scene.addItemWindow) {
                scene.addItemWindow(itemWindowId);
            }
        });

        PluginManager.registerCommand(pluginName, 'hideItemWindow', function(args) {
            var itemWindowId = Number(args.itemWindowId || 0);
            var scene = SceneManager._scene;
            if (scene && scene.hideItemWindow) {
                scene.hideItemWindow(itemWindowId);
            }
        });

        PluginManager.registerCommand(pluginName, 'closeItemWindow', function(args) {
            var itemWindowId = Number(args.itemWindowId || 0);
            var scene = SceneManager._scene;
            if (scene && scene.closeItemWindow) {
                scene.closeItemWindow(itemWindowId);
            }
        });

        PluginManager.registerCommand(pluginName, 'showSkillTree', function(args) {
            var windowId = String(args.windowId || 'skillTree1');
            var actorId = Number(args.actorId || 0);
            var scene = SceneManager._scene;
            if (scene && scene.showSkillTreeWindow) {
                scene.showSkillTreeWindow(windowId, actorId);
            }
        });

        PluginManager.registerCommand(pluginName, 'hideSkillTree', function(args) {
            var windowId = String(args.windowId || '');
            var scene = SceneManager._scene;
            if (scene && scene.hideSkillTreeWindow) {
                scene.hideSkillTreeWindow(windowId);
            }
        });

        PluginManager.registerCommand(pluginName, 'closeSkillTree', function(args) {
            var windowId = String(args.windowId || '');
            var scene = SceneManager._scene;
            if (scene && scene.closeSkillTreeWindow) {
                scene.closeSkillTreeWindow(windowId);
            }
        });

        PluginManager.registerCommand(pluginName, 'openSaveScreen', function(args) {
            SceneManager.push(Scene_Save);
        });

        PluginManager.registerCommand(pluginName, 'openLoadScreen', function(args) {
            SceneManager.push(Scene_Load);
        });

        PluginManager.registerCommand(pluginName, 'registerBasePreset', function(args) {
            var preset = parseSingleWindowBasePreset(args.preset);
            if (preset && preset.id) {
                _windowBasePresets[preset.id] = preset;
            } else {
                console.error('CustomWindow: 基本プリセットのパースに失敗しました');
            }
        });

        PluginManager.registerCommand(pluginName, 'registerWindowSettings', function(args) {
            var windowId = Number(args.windowId) || 1;
            var settings = parseSingleWindowSettings(args.settings);
            if (settings) {
                params.windowSettings[windowId] = settings;
                var scene = SceneManager._scene;
                if (scene && scene.addCustomWindow) {
                    scene.addCustomWindow(windowId);
                }
            } else {
                console.error('CustomWindow: ウィンドウ設定のパースに失敗しました');
            }
        });

        PluginManager.registerCommand(pluginName, 'suspendWindow', function(args) {
            var windowId = Number(args.windowId) || 0;
            var transitionId = String(args.transitionId || '');
            var scene = SceneManager._scene;
            if (scene && scene.suspendCustomWindowWithTransition) {
                scene.suspendCustomWindowWithTransition(windowId, transitionId);
            }
        });

        PluginManager.registerCommand(pluginName, 'resumeWindow', function(args) {
            var windowId = Number(args.windowId) || 0;
            var transitionId = String(args.transitionId || '');
            var scene = SceneManager._scene;
            if (scene && scene.resumeCustomWindowWithTransition) {
                scene.resumeCustomWindowWithTransition(windowId, transitionId);
            }
        });

        PluginManager.registerCommand(pluginName, 'loadSharedState', function(args) {
            if (ConfigManager.loadCwSharedState) {
                ConfigManager.loadCwSharedState();
            }
        });

        PluginManager.registerCommand(pluginName, 'saveSharedState', function(args) {
            if (ConfigManager.saveCwSharedState) {
                ConfigManager.saveCwSharedState();
            }
        });
    }

    if (!isMZ) {
        var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
        Game_Interpreter.prototype.pluginCommand = function(command, args) {
            _Game_Interpreter_pluginCommand.call(this, command, args);
            
            if (command === 'CustomWindow') {
                var subCommand = args[0];
                
                if (subCommand === 'show') {
                    var windowId = args[1] !== undefined ? Number(args[1]) : 1;
                    var scene = SceneManager._scene;
                    if (scene && scene.addCustomWindow) {
                        scene.addCustomWindow(windowId);
                    }
                } else if (subCommand === 'hide') {
                    var windowId = args[1] !== undefined ? Number(args[1]) : 0;
                    var scene = SceneManager._scene;
                    if (scene && scene.hideCustomWindow) {
                        scene.hideCustomWindow(windowId);
                    }
                } else if (subCommand === 'close') {
                    var windowId = args[1] !== undefined ? Number(args[1]) : 0;
                    var scene = SceneManager._scene;
                    if (scene && scene.closeCustomWindow) {
                        scene.closeCustomWindow(windowId);
                    }
                } else if (subCommand === 'addImage') {
                    var imageName = args[1] || '';
                    var listId = args[2] !== undefined ? Number(args[2]) : 1;
                    var windowId = args[3] !== undefined ? Number(args[3]) : 0;
                    var scene = SceneManager._scene;
                    if (scene && scene.addImageToCustomWindow) {
                        scene.addImageToCustomWindow(windowId, imageName, listId);
                    }
                } else if (subCommand === 'clearImages') {
                    var listId = args[1] !== undefined ? Number(args[1]) : 0;
                    var windowId = args[2] !== undefined ? Number(args[2]) : 0;
                    var scene = SceneManager._scene;
                    if (scene && scene.clearCustomWindowImages) {
                        scene.clearCustomWindowImages(windowId, listId);
                    }
                } else if (subCommand === 'showItem') {
                    var itemWindowId = args[1] !== undefined ? Number(args[1]) : 1;
                    var scene = SceneManager._scene;
                    if (scene && scene.addItemWindow) {
                        scene.addItemWindow(itemWindowId);
                    }
                } else if (subCommand === 'hideItem') {
                    var itemWindowId = args[1] !== undefined ? Number(args[1]) : 0;
                    var scene = SceneManager._scene;
                    if (scene && scene.hideItemWindow) {
                        scene.hideItemWindow(itemWindowId);
                    }
                } else if (subCommand === 'closeItem') {
                    var itemWindowId = args[1] !== undefined ? Number(args[1]) : 0;
                    var scene = SceneManager._scene;
                    if (scene && scene.closeItemWindow) {
                        scene.closeItemWindow(itemWindowId);
                    }
                } else if (subCommand === 'showSkillTree') {
                    var skillTreeId = args[1] || '';
                    var actorId = args[2] !== undefined ? Number(args[2]) : 0;
                    var scene = SceneManager._scene;
                    if (scene && scene.showSkillTreeWindow) {
                        scene.showSkillTreeWindow(skillTreeId, actorId);
                    }
                } else if (subCommand === 'hideSkillTree') {
                    var skillTreeId = args[1] || '';
                    var scene = SceneManager._scene;
                    if (scene && scene.hideSkillTreeWindow) {
                        scene.hideSkillTreeWindow(skillTreeId);
                    }
                } else if (subCommand === 'closeSkillTree') {
                    var skillTreeId = args[1] || '';
                    var scene = SceneManager._scene;
                    if (scene && scene.closeSkillTreeWindow) {
                        scene.closeSkillTreeWindow(skillTreeId);
                    }
                } else if (subCommand === 'suspend') {
                    var windowId = args[1] !== undefined ? Number(args[1]) : 0;
                    var transitionId = args[2] || '';
                    var scene = SceneManager._scene;
                    if (scene && scene.suspendCustomWindowWithTransition) {
                        scene.suspendCustomWindowWithTransition(windowId, transitionId);
                    }
                } else if (subCommand === 'resume') {
                    var windowId = args[1] !== undefined ? Number(args[1]) : 0;
                    var transitionId = args[2] || '';
                    var scene = SceneManager._scene;
                    if (scene && scene.resumeCustomWindowWithTransition) {
                        scene.resumeCustomWindowWithTransition(windowId, transitionId);
                    }
                } else if (subCommand === 'loadSharedState') {
                    if (ConfigManager.loadCwSharedState) {
                        ConfigManager.loadCwSharedState();
                    }
                } else if (subCommand === 'saveSharedState') {
                    if (ConfigManager.saveCwSharedState) {
                        ConfigManager.saveCwSharedState();
                    }
                }
            }
        };
    }


    function Window_SkillTree() {
        this.initialize.apply(this, arguments);
    }

    Window_SkillTree.prototype = Object.create(Window_Base.prototype);
    Window_SkillTree.prototype.constructor = Window_SkillTree;

    Window_SkillTree.prototype.initialize = function(settings, actorId) {
        this._settings = settings;
        this._windowId = null;
        this._actorId = actorId || settings.actorId || 0;
        this._skillNodes = [];
        this._nodeSprites = [];
        this._backgroundSprite = null;
        this._connectionLayer = null;
        this._connectionSprites = {};
        this._loadedImages = {};
        this._isReady = false;
        this._confirmWindow = null;
        this._pendingNode = null;
        this._skillPointSprite = null;
        this._skillPointDigitSprites = [];
        this._spriteSheetBitmap = null;
        this._lastSkillPoints = -1;
        
        this._selectedNodeIndex = -1;
        this._cursorSprite = null;
        this._cursorSettings = null;
        this._defaultCursorMode = false;
        
        this._inputGuardFrames = 0;
        
        this._inputMode = 'keyboard';
        this._lastMouseX = 0;
        this._lastMouseY = 0;

        var x = settings.x;
        var y = settings.y;
        var width = settings.width;
        var height = settings.height;

        if (Utils.RPGMAKER_NAME === 'MZ') {
            Window_Base.prototype.initialize.call(this, new Rectangle(x, y, width, height));
        } else {
            Window_Base.prototype.initialize.call(this, x, y, width, height);
        }

        this.opacity = 0;
        this.contentsOpacity = 255;
        this._windowFrameSprite.visible = false;
        if (this._windowBackSprite) this._windowBackSprite.visible = false;

        this._loadBackgroundImage();
        
        this._createConnectionLayer();
        
        this._prepareSkillNodes();
        
        this._createSkillPointDisplay();
        
        this._parseCursorSettings();
        this._createCursorSprite();
    };

    Window_SkillTree.prototype._loadBackgroundImage = function() {
        var settings = this._settings;
        if (settings.backgroundImage) {
            var bitmap = ImageManager.loadBitmap('img/customwindow/', settings.backgroundImage);
            bitmap.addLoadListener(function() {
                this._createBackgroundSprite(bitmap);
                if (settings.useImageSize) {
                    this._resizeToImage(bitmap);
                }
                this._checkAllImagesLoaded();
            }.bind(this));
        } else {
            this._checkAllImagesLoaded();
        }
    };

    Window_SkillTree.prototype._createBackgroundSprite = function(bitmap) {
        if (this._backgroundSprite) {
            this.removeChild(this._backgroundSprite);
        }
        this._backgroundSprite = new Sprite(bitmap);
        this._backgroundSprite.x = 0;
        this._backgroundSprite.y = 0;
        this.addChildAt(this._backgroundSprite, 0);
    };

    Window_SkillTree.prototype._resizeToImage = function(bitmap) {
        var newWidth = bitmap.width;
        var newHeight = bitmap.height;
        this.move(this.x, this.y, newWidth, newHeight);
    };

    Window_SkillTree.prototype._createConnectionLayer = function() {
        this._connectionLayer = new Sprite();
        this._connectionLayer.x = 0;
        this._connectionLayer.y = 0;
        this.addChild(this._connectionLayer);
        
        this._preloadConnectionImages();
    };

    Window_SkillTree.prototype._preloadConnectionImages = function() {
        var nodes = this._settings.skillNodes || [];
        for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];
            var connections = node.connectionImages || [];
            for (var j = 0; j < connections.length; j++) {
                var conn = connections[j];
                if (conn.image && !this._loadedImages[conn.image]) {
                    this._loadedImages[conn.image] = ImageManager.loadBitmap('img/customwindow/', conn.image);
                }
            }
        }
    };

    Window_SkillTree.prototype._refreshConnectionImages = function() {
        if (!this._connectionLayer) return;
        
        var actor = this._getActor();
        if (!actor) return;
        
        var nodes = this._settings.skillNodes || [];
        
        for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];
            var isLearned = actor.isLearnedSkill(node.skillId);
            var connections = node.connectionImages || [];
            
            for (var j = 0; j < connections.length; j++) {
                var conn = connections[j];
                var spriteKey = node.skillId + '_' + j;
                
                if (isLearned) {
                    if (!this._connectionSprites[spriteKey] && conn.image) {
                        var sprite = new Sprite();
                        sprite.x = conn.x;
                        sprite.y = conn.y;
                        
                        if (this._loadedImages[conn.image] && this._loadedImages[conn.image].isReady()) {
                            sprite.bitmap = this._loadedImages[conn.image];
                        } else if (this._loadedImages[conn.image]) {
                            var loadedImg = this._loadedImages[conn.image];
                            loadedImg.addLoadListener(function(s, img) {
                                s.bitmap = img;
                            }.bind(this, sprite, loadedImg));
                        }
                        
                        this._connectionSprites[spriteKey] = sprite;
                        this._connectionLayer.addChild(sprite);
                    } else if (this._connectionSprites[spriteKey]) {
                        this._connectionSprites[spriteKey].visible = true;
                    }
                } else {
                    if (this._connectionSprites[spriteKey]) {
                        this._connectionSprites[spriteKey].visible = false;
                    }
                }
            }
        }
    };

    Window_SkillTree.prototype._prepareSkillNodes = function() {
        var nodes = this._settings.skillNodes || [];
        var loadCount = 0;
        var totalToLoad = 0;

        for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];
            if (node.nodeImage) totalToLoad++;
            if (node.nodeImageLearned) totalToLoad++;
            if (node.nodeImageDisabled) totalToLoad++;
        }

        if (totalToLoad === 0) {
            this._createNodeSprites();
            return;
        }

        var self = this;
        var onImageLoaded = function() {
            loadCount++;
            if (loadCount >= totalToLoad) {
                self._createNodeSprites();
            }
        };

        for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];
            if (node.nodeImage) {
                this._loadedImages[node.nodeImage] = ImageManager.loadBitmap('img/customwindow/', node.nodeImage);
                this._loadedImages[node.nodeImage].addLoadListener(onImageLoaded);
            }
            if (node.nodeImageLearned) {
                this._loadedImages[node.nodeImageLearned] = ImageManager.loadBitmap('img/customwindow/', node.nodeImageLearned);
                this._loadedImages[node.nodeImageLearned].addLoadListener(onImageLoaded);
            }
            if (node.nodeImageDisabled) {
                this._loadedImages[node.nodeImageDisabled] = ImageManager.loadBitmap('img/customwindow/', node.nodeImageDisabled);
                this._loadedImages[node.nodeImageDisabled].addLoadListener(onImageLoaded);
            }
        }
    };

    Window_SkillTree.prototype._createNodeSprites = function() {
        var nodes = this._settings.skillNodes || [];
        
        for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];
            var nodeContainer = this._createNodeSprite(node);
            this._nodeSprites.push(nodeContainer);
            this.addChild(nodeContainer);
        }

        this._checkAllImagesLoaded();
    };

    Window_SkillTree.prototype._createNodeSprite = function(node) {
        var container = new Sprite();
        container._nodeData = node;
        container.x = node.nodeX;
        container.y = node.nodeY;

        var actor = this._getActor();
        var isLearned = actor ? actor.isLearnedSkill(node.skillId) : false;
        var canLearn = this._canLearnSkill(node.skillId);

        var mainSprite = new Sprite();
        if (node.nodeImage && this._loadedImages[node.nodeImage]) {
            mainSprite.bitmap = this._loadedImages[node.nodeImage];
        } else {
            mainSprite.bitmap = this._createIconBitmap(node);
        }
        container._mainSprite = mainSprite;
        container.addChild(mainSprite);

        if (node.nodeImageLearned && this._loadedImages[node.nodeImageLearned]) {
            var learnedSprite = new Sprite();
            learnedSprite.bitmap = this._loadedImages[node.nodeImageLearned];
            learnedSprite.visible = isLearned;
            container._learnedSprite = learnedSprite;
            container.addChild(learnedSprite);
        }

        if (!isLearned) {
            var filterOpacity = node.filterOpacity >= 0 ? node.filterOpacity : this._settings.unlearnedFilterOpacity;
            if (filterOpacity > 0) {
                var filterSprite = this._createFilterSprite(node, mainSprite.bitmap);
                filterSprite.opacity = filterOpacity;
                container._filterSprite = filterSprite;
                container.addChild(filterSprite);
            }
        }

        if (node.nodeImageDisabled && this._loadedImages[node.nodeImageDisabled]) {
            var disabledSprite = new Sprite();
            disabledSprite.bitmap = this._loadedImages[node.nodeImageDisabled];
            disabledSprite.visible = !isLearned && !canLearn;
            container._disabledSprite = disabledSprite;
            container.addChild(disabledSprite);
        }

        return container;
    };

    Window_SkillTree.prototype._createFilterSprite = function(node, baseBitmap) {
        var filterSprite = new Sprite();
        
        if (baseBitmap && baseBitmap.isReady()) {
            this._applyFilterToBitmap(filterSprite, baseBitmap);
        } else if (baseBitmap) {
            baseBitmap.addLoadListener(function() {
                this._applyFilterToBitmap(filterSprite, baseBitmap);
            }.bind(this));
        }
        
        return filterSprite;
    };

    Window_SkillTree.prototype._applyFilterToBitmap = function(sprite, baseBitmap) {
        var width = baseBitmap.width;
        var height = baseBitmap.height;
        
        var filterBitmap = new Bitmap(width, height);
        
        filterBitmap.blt(baseBitmap, 0, 0, width, height, 0, 0);
        
        var context = filterBitmap._context;
        context.globalCompositeOperation = 'source-in';
        context.fillStyle = 'rgba(0, 0, 0, 1)';
        context.fillRect(0, 0, width, height);
        context.globalCompositeOperation = 'source-over';
        
        filterBitmap._baseTexture.update();
        sprite.bitmap = filterBitmap;
    };

    Window_SkillTree.prototype._createIconBitmap = function(node) {
        var skill = $dataSkills[node.skillId];
        if (!skill) return new Bitmap(node.nodeWidth, node.nodeHeight);

        var iconIndex = skill.iconIndex;
        var bitmap = new Bitmap(node.nodeWidth, node.nodeHeight);
        var iconBitmap = ImageManager.loadSystem('IconSet');

        if (iconBitmap.isReady()) {
            this._drawIconToBitmap(bitmap, iconBitmap, iconIndex, node.nodeWidth, node.nodeHeight);
        } else {
            iconBitmap.addLoadListener(function() {
                this._drawIconToBitmap(bitmap, iconBitmap, iconIndex, node.nodeWidth, node.nodeHeight);
            }.bind(this));
        }

        return bitmap;
    };

    Window_SkillTree.prototype._drawIconToBitmap = function(destBitmap, iconBitmap, iconIndex, width, height) {
        var iconWidth = Window_Base._iconWidth || 32;
        var iconHeight = Window_Base._iconHeight || 32;
        var sx = (iconIndex % 16) * iconWidth;
        var sy = Math.floor(iconIndex / 16) * iconHeight;

        destBitmap.blt(iconBitmap, sx, sy, iconWidth, iconHeight, 0, 0, width, height);
    };

    Window_SkillTree.prototype._parseCursorSettings = function() {
        var settings = this._settings.cursorSettings;
        if (!settings) {
            this._cursorSettings = {
                cursorImage: '',
                cursorOffsetX: 0,
                cursorOffsetY: 0,
                selectSE: '',
                selectSEVolume: 90,
                selectSEPitch: 100,
                selectSEPan: 0
            };
            return;
        }
        
        if (typeof settings === 'object' && settings.cursorImage !== undefined) {
            this._cursorSettings = settings;
            return;
        }
        
        if (typeof settings === 'string') {
            try {
                settings = JSON.parse(settings);
            } catch (e) {
                settings = {};
            }
        }
        
        this._cursorSettings = {
            cursorImage: settings.cursorImage || '',
            cursorOffsetX: Number(settings.cursorOffsetX) || 0,
            cursorOffsetY: Number(settings.cursorOffsetY) || 0,
            selectSE: settings.selectSE || '',
            selectSEVolume: Number(settings.selectSEVolume) || 90,
            selectSEPitch: Number(settings.selectSEPitch) || 100,
            selectSEPan: Number(settings.selectSEPan) || 0
        };
    };

    Window_SkillTree.prototype._createCursorSprite = function() {
        this._cursorSprite = new Sprite();
        this._cursorSprite.visible = false;
        this.addChild(this._cursorSprite);
        
        if (this._cursorSettings && this._cursorSettings.cursorImage) {
            var self = this;
            var bitmap = ImageManager.loadBitmap('img/customwindow/', this._cursorSettings.cursorImage);
            bitmap.addLoadListener(function() {
                self._cursorSprite.bitmap = bitmap;
                self._updateCursorPosition();
            });
        } else {
            this._createDefaultCursorBitmap();
        }
        
        this._createDescriptionSprite();
    };

    Window_SkillTree.prototype._createDescriptionSprite = function() {
        this._descriptionSprite = new Sprite();
        this._descriptionSprite.visible = false;
        this.addChild(this._descriptionSprite);
    };

    Window_SkillTree.prototype._updateDescriptionImage = function() {
        if (!this._descriptionSprite) return;
        
        if (this._selectedNodeIndex < 0 || this._selectedNodeIndex >= this._nodeSprites.length) {
            this._descriptionSprite.visible = false;
            return;
        }
        
        var container = this._nodeSprites[this._selectedNodeIndex];
        if (!container) {
            this._descriptionSprite.visible = false;
            return;
        }
        
        var node = container._nodeData;
        var descSettings = node.descriptionImageSettings || {};
        
        var actor = this._getActor();
        var isLearned = actor && actor.isLearnedSkill(node.skillId);
        var canLearn = this._canLearnSkill(node.skillId);
        
        var imageToUse = '';
        if (isLearned) {
            if (descSettings.imageLearned) {
                imageToUse = descSettings.imageLearned;
            } else if (descSettings.imageLearnable) {
                imageToUse = descSettings.imageLearnable;
            }
        } else if (canLearn) {
            if (descSettings.imageLearnable) {
                imageToUse = descSettings.imageLearnable;
            }
        } else {
            if (descSettings.imageDisabled) {
                imageToUse = descSettings.imageDisabled;
            }
        }
        
        if (!imageToUse) {
            this._descriptionSprite.visible = false;
            return;
        }
        
        var self = this;
        var x = descSettings.x || 0;
        var y = descSettings.y || 0;
        
        var bitmap = ImageManager.loadBitmap('img/customwindow/', imageToUse);
        bitmap.addLoadListener(function() {
            self._descriptionSprite.bitmap = bitmap;
            self._descriptionSprite.x = x;
            self._descriptionSprite.y = y;
            self._descriptionSprite.visible = true;
        });
    };

    Window_SkillTree.prototype._createDefaultCursorBitmap = function() {
        var size = 8;
        var bitmap = new Bitmap(size * 2, size * 2);
        var context = bitmap._context;
        
        context.strokeStyle = '#ffffff';
        context.lineWidth = 3;
        context.strokeRect(2, 2, size * 2 - 4, size * 2 - 4);
        
        bitmap._baseTexture.update();
        this._cursorSprite.bitmap = bitmap;
        
        this._defaultCursorMode = true;
    };

    Window_SkillTree.prototype._updateCursorPosition = function() {
        if (!this._cursorSprite) return;
        
        if (this._selectedNodeIndex < 0 || this._selectedNodeIndex >= this._nodeSprites.length) {
            this._cursorSprite.visible = false;
            return;
        }
        
        var container = this._nodeSprites[this._selectedNodeIndex];
        if (!container) {
            this._cursorSprite.visible = false;
            return;
        }
        
        var node = container._nodeData;
        var offsetX = this._cursorSettings ? this._cursorSettings.cursorOffsetX : 0;
        var offsetY = this._cursorSettings ? this._cursorSettings.cursorOffsetY : 0;
        
        this._cursorSprite.x = node.nodeX + offsetX;
        this._cursorSprite.y = node.nodeY + offsetY;
        
        if (this._cursorSprite.bitmap && this._cursorSprite.bitmap.isReady()) {
            this._cursorSprite.visible = true;
        } else if (this._defaultCursorMode) {
            this._cursorSprite.visible = true;
        }
        
        this.removeChild(this._cursorSprite);
        this.addChild(this._cursorSprite);
    };

    Window_SkillTree.prototype._selectNode = function(index, playSound) {
        if (index === this._selectedNodeIndex) return;
        
        var prevIndex = this._selectedNodeIndex;
        this._selectedNodeIndex = index;
        
        this._updateCursorPosition();
        
        this._updateDescriptionImage();
        
        if (playSound !== false && index >= 0) {
            this._playSelectSE();
        }
    };

    Window_SkillTree.prototype._playSelectSE = function() {
        if (this._cursorSettings && this._cursorSettings.selectSE) {
            var se = {
                name: this._cursorSettings.selectSE,
                volume: this._cursorSettings.selectSEVolume,
                pitch: this._cursorSettings.selectSEPitch,
                pan: this._cursorSettings.selectSEPan
            };
            AudioManager.playSe(se);
        } else {
            SoundManager.playCursor();
        }
    };

    Window_SkillTree.prototype._processKeyboardInput = function() {
        if (!this._isReady || !this.visible) return;
        if (this._confirmWindow && this._confirmWindow.visible) return;
        
        var scene = SceneManager._scene;
        if (scene && scene.isTransitioning && scene.isTransitioning()) return;
        
        if (this._inputGuardFrames > 0) {
            this._inputGuardFrames--;
            return;
        }
        
        if (Input.isRepeated('down')) {
            this._inputMode = 'keyboard';
            this._moveCursorDown();
        } else if (Input.isRepeated('up')) {
            this._inputMode = 'keyboard';
            this._moveCursorUp();
        } else if (Input.isRepeated('right')) {
            this._inputMode = 'keyboard';
            this._moveCursorRight();
        } else if (Input.isRepeated('left')) {
            this._inputMode = 'keyboard';
            this._moveCursorLeft();
        }
        
        if (Input.isTriggered('ok')) {
            this._confirmSelectedNode();
        }
        
        if (Input.isTriggered('cancel')) {
            this._closeWindow();
        }
    };

    Window_SkillTree.prototype._getChildNodes = function(currentNode) {
        var children = [];
        var currentSkillId = currentNode.skillId;
        
        for (var i = 0; i < this._nodeSprites.length; i++) {
            var node = this._nodeSprites[i]._nodeData;
            var requiredSkills = node.learnCondition.requiredSkills || [];
            for (var j = 0; j < requiredSkills.length; j++) {
                if (requiredSkills[j] === currentSkillId) {
                    children.push({ index: i, node: node });
                    break;
                }
            }
        }
        return children;
    };

    Window_SkillTree.prototype._getParentNodes = function(currentNode) {
        var parents = [];
        var requiredSkills = currentNode.learnCondition.requiredSkills || [];
        
        for (var i = 0; i < requiredSkills.length; i++) {
            var requiredSkillId = requiredSkills[i];
            for (var j = 0; j < this._nodeSprites.length; j++) {
                var node = this._nodeSprites[j]._nodeData;
                if (node.skillId === requiredSkillId) {
                    parents.push({ index: j, node: node });
                    break;
                }
            }
        }
        return parents;
    };

    Window_SkillTree.prototype._selectClosestInDirection = function(candidates, currentNode, dirX, dirY) {
        if (candidates.length === 0) return -1;
        
        var bestIndex = -1;
        var bestScore = Infinity;
        
        for (var i = 0; i < candidates.length; i++) {
            var candidate = candidates[i];
            var dx = candidate.node.nodeX - currentNode.nodeX;
            var dy = candidate.node.nodeY - currentNode.nodeY;
            
            var dot = dx * dirX + dy * dirY;
            if (dot > 0) {
                var distance = Math.sqrt(dx * dx + dy * dy);
                if (distance < bestScore) {
                    bestScore = distance;
                    bestIndex = candidate.index;
                }
            }
        }
        
        if (bestIndex < 0 && candidates.length > 0) {
            bestScore = Infinity;
            for (var i = 0; i < candidates.length; i++) {
                var candidate = candidates[i];
                var dx = candidate.node.nodeX - currentNode.nodeX;
                var dy = candidate.node.nodeY - currentNode.nodeY;
                var distance = Math.sqrt(dx * dx + dy * dy);
                if (distance < bestScore) {
                    bestScore = distance;
                    bestIndex = candidate.index;
                }
            }
        }
        
        return bestIndex;
    };

    Window_SkillTree.prototype._moveCursorDown = function() {
        if (this._nodeSprites.length === 0) return;
        
        if (this._selectedNodeIndex < 0) {
            this._selectNode(0);
            return;
        }
        
        var currentContainer = this._nodeSprites[this._selectedNodeIndex];
        var currentNode = currentContainer._nodeData;
        var useConnection = this._cursorSettings && this._cursorSettings.downUseConnection;
        
        var bestIndex = -1;
        
        if (useConnection) {
            var children = this._getChildNodes(currentNode);
            bestIndex = this._selectClosestInDirection(children, currentNode, 0, 1);
        } else {
            var bestDistance = Infinity;
            for (var i = 0; i < this._nodeSprites.length; i++) {
                if (i === this._selectedNodeIndex) continue;
                
                var node = this._nodeSprites[i]._nodeData;
                var dx = node.nodeX - currentNode.nodeX;
                var dy = node.nodeY - currentNode.nodeY;
                
                if (dy > 0) {
                    var angle = Math.atan2(dy, dx) * 180 / Math.PI;
                    if (angle >= 45 && angle <= 135) {
                        var distance = Math.sqrt(dx * dx + dy * dy);
                        if (distance < bestDistance) {
                            bestDistance = distance;
                            bestIndex = i;
                        }
                    }
                }
            }
        }
        
        if (bestIndex >= 0) {
            this._selectNode(bestIndex);
        }
    };

    Window_SkillTree.prototype._moveCursorUp = function() {
        if (this._nodeSprites.length === 0) return;
        
        if (this._selectedNodeIndex < 0) {
            this._selectNode(0);
            return;
        }
        
        var currentContainer = this._nodeSprites[this._selectedNodeIndex];
        var currentNode = currentContainer._nodeData;
        var useConnection = this._cursorSettings && this._cursorSettings.upUseConnection;
        
        var bestIndex = -1;
        
        if (useConnection) {
            var parents = this._getParentNodes(currentNode);
            bestIndex = this._selectClosestInDirection(parents, currentNode, 0, -1);
        } else {
            var bestDistance = Infinity;
            for (var i = 0; i < this._nodeSprites.length; i++) {
                if (i === this._selectedNodeIndex) continue;
                
                var node = this._nodeSprites[i]._nodeData;
                var dx = node.nodeX - currentNode.nodeX;
                var dy = node.nodeY - currentNode.nodeY;
                
                if (dy < 0) {
                    var angle = Math.atan2(dy, dx) * 180 / Math.PI;
                    if (angle >= -135 && angle <= -45) {
                        var distance = Math.sqrt(dx * dx + dy * dy);
                        if (distance < bestDistance) {
                            bestDistance = distance;
                            bestIndex = i;
                        }
                    }
                }
            }
        }
        
        if (bestIndex >= 0) {
            this._selectNode(bestIndex);
        }
    };

    Window_SkillTree.prototype._moveCursorRight = function() {
        if (this._nodeSprites.length === 0) return;
        
        if (this._selectedNodeIndex < 0) {
            this._selectNode(0);
            return;
        }
        
        var currentContainer = this._nodeSprites[this._selectedNodeIndex];
        var currentNode = currentContainer._nodeData;
        var useConnection = this._cursorSettings && this._cursorSettings.rightUseConnection;
        
        var bestIndex = -1;
        
        if (useConnection) {
            var children = this._getChildNodes(currentNode);
            bestIndex = this._selectClosestInDirection(children, currentNode, 1, 0);
        } else {
            var bestDistance = Infinity;
            for (var i = 0; i < this._nodeSprites.length; i++) {
                if (i === this._selectedNodeIndex) continue;
                
                var node = this._nodeSprites[i]._nodeData;
                var dx = node.nodeX - currentNode.nodeX;
                var dy = node.nodeY - currentNode.nodeY;
                
                if (dx > 0) {
                    var angle = Math.atan2(dy, dx) * 180 / Math.PI;
                    if (angle >= -60 && angle <= 60) {
                        var distance = Math.sqrt(dx * dx + dy * dy);
                        if (distance < bestDistance) {
                            bestDistance = distance;
                            bestIndex = i;
                        }
                    }
                }
            }
        }
        
        if (bestIndex >= 0) {
            this._selectNode(bestIndex);
        }
    };

    Window_SkillTree.prototype._moveCursorLeft = function() {
        if (this._nodeSprites.length === 0) return;
        
        if (this._selectedNodeIndex < 0) {
            this._selectNode(0);
            return;
        }
        
        var currentContainer = this._nodeSprites[this._selectedNodeIndex];
        var currentNode = currentContainer._nodeData;
        var useConnection = this._cursorSettings && this._cursorSettings.leftUseConnection;
        
        var bestIndex = -1;
        
        if (useConnection) {
            var parents = this._getParentNodes(currentNode);
            bestIndex = this._selectClosestInDirection(parents, currentNode, -1, 0);
        } else {
            var bestDistance = Infinity;
            for (var i = 0; i < this._nodeSprites.length; i++) {
                if (i === this._selectedNodeIndex) continue;
                
                var node = this._nodeSprites[i]._nodeData;
                var dx = node.nodeX - currentNode.nodeX;
                var dy = node.nodeY - currentNode.nodeY;
                
                if (dx < 0) {
                    var angle = Math.atan2(dy, dx) * 180 / Math.PI;
                    if (angle >= 120 || angle <= -120) {
                        var distance = Math.sqrt(dx * dx + dy * dy);
                        if (distance < bestDistance) {
                            bestDistance = distance;
                            bestIndex = i;
                        }
                    }
                }
            }
        }
        
        if (bestIndex >= 0) {
            this._selectNode(bestIndex);
        }
    };

    Window_SkillTree.prototype._confirmSelectedNode = function() {
        if (this._selectedNodeIndex < 0 || this._selectedNodeIndex >= this._nodeSprites.length) return;
        
        var container = this._nodeSprites[this._selectedNodeIndex];
        var node = container._nodeData;
        this._onNodeClick(node);
    };

    Window_SkillTree.prototype._getActor = function() {
        if (this._actorId > 0) {
            return $gameActors.actor(this._actorId);
        }
        return $gameParty.leader();
    };

    Window_SkillTree.prototype._getNodeBySkillId = function(skillId) {
        var nodes = this._settings.skillNodes || [];
        for (var i = 0; i < nodes.length; i++) {
            if (nodes[i].skillId === skillId) {
                return nodes[i];
            }
        }
        return null;
    };

    Window_SkillTree.prototype._canLearnSkill = function(skillId) {
        var node = this._getNodeBySkillId(skillId);
        if (!node) return false;

        var condition = node.learnCondition;
        if (!condition) return true;

        var actor = this._getActor();
        if (!actor) return false;

        if (condition.requiredSkills && condition.requiredSkills.length > 0) {
            for (var i = 0; i < condition.requiredSkills.length; i++) {
                var reqSkillId = condition.requiredSkills[i];
                if (!actor.isLearnedSkill(reqSkillId)) {
                    return false;
                }
            }
        }

        if (condition.switchConditions && condition.switchConditions.length > 0) {
            for (var i = 0; i < condition.switchConditions.length; i++) {
                var swCond = condition.switchConditions[i];
                if (swCond.switchId > 0) {
                    var switchValue = $gameSwitches.value(swCond.switchId);
                    if (switchValue !== swCond.switchValue) {
                        return false;
                    }
                }
            }
        }

        if (condition.variableConditions && condition.variableConditions.length > 0) {
            for (var i = 0; i < condition.variableConditions.length; i++) {
                var varCond = condition.variableConditions[i];
                if (varCond.variableId > 0) {
                    var varValue = $gameVariables.value(varCond.variableId);
                    var compareValue = varCond.value;
                    var result = false;

                    switch (varCond.comparison) {
                        case 'gte': result = varValue >= compareValue; break;
                        case 'gt':  result = varValue > compareValue; break;
                        case 'lte': result = varValue <= compareValue; break;
                        case 'lt':  result = varValue < compareValue; break;
                        case 'eq':  result = varValue === compareValue; break;
                        case 'neq': result = varValue !== compareValue; break;
                        default:    result = varValue >= compareValue; break;
                    }

                    if (!result) {
                        return false;
                    }
                }
            }
        }

        return true;
    };

    Window_SkillTree.prototype._createSkillPointDisplay = function() {
        var settings = this._settings;
        if (!settings.showSkillPointDisplay || settings.skillPointVariable <= 0) return;

        var displaySettings = settings.skillPointDisplaySettings;
        
        var container = new Sprite();
        container.x = displaySettings.x;
        container.y = displaySettings.y;
        
        this._skillPointSprite = container;
        this._skillPointDigitSprites = [];
        this._decorationSprite = null;
        this.addChild(container);

        if (displaySettings.decorationImage) {
            this._decorationBitmap = ImageManager.loadSystem(displaySettings.decorationImage);
            this._decorationSprite = new Sprite();
            this._decorationSprite.visible = false;
            container.addChild(this._decorationSprite);
            var self = this;
            this._decorationBitmap.addLoadListener(function() {
                self._decorationSprite.bitmap = self._decorationBitmap;
                self._decorationSprite.visible = true;
                self._lastSkillPoints = -1;
                self._refreshSkillPointDisplay();
            });
        }

        if (displaySettings.useSpriteSheet && displaySettings.spriteSheetImage) {
            this._spriteSheetBitmap = ImageManager.loadSystem(displaySettings.spriteSheetImage);
            var self = this;
            this._spriteSheetBitmap.addLoadListener(function() {
                self._lastSkillPoints = -1;
                self._refreshSkillPointDisplay();
            });
        } else {
            var bitmap = new Bitmap(displaySettings.width, displaySettings.fontSize + 10);
            container.bitmap = bitmap;
            this._refreshSkillPointDisplay();
        }
    };

    Window_SkillTree.prototype._refreshSkillPointDisplay = function() {
        if (!this._skillPointSprite) return;

        var settings = this._settings;
        var displaySettings = settings.skillPointDisplaySettings;
        var currentSP = this.getSkillPoints();
        
        if (this._lastSkillPoints === currentSP) return;
        this._lastSkillPoints = currentSP;

        if (displaySettings.useSpriteSheet && this._spriteSheetBitmap && this._spriteSheetBitmap.isReady()) {
            this._refreshSpriteSheetDisplay(currentSP);
        } else if (this._skillPointSprite.bitmap) {
            this._refreshTextDisplay(currentSP);
        }
    };

    Window_SkillTree.prototype._refreshSpriteSheetDisplay = function(value) {
        var displaySettings = this._settings.skillPointDisplaySettings;
        
        var valueStr = String(Math.max(0, Math.floor(Number(value) || 0)));
        var digits = valueStr.split('');
        
        var digitWidth = Math.floor(this._spriteSheetBitmap.width / 10);
        var digitHeight = this._spriteSheetBitmap.height;
        var spacing = displaySettings.digitSpacing;

        for (var i = 0; i < this._skillPointDigitSprites.length; i++) {
            this._skillPointDigitSprites[i].visible = false;
        }

        var totalWidth = digits.length * digitWidth + (digits.length - 1) * spacing;
        var startX = 0;
        
        if (displaySettings.textAlign === 'center') {
            startX = (displaySettings.width - totalWidth) / 2;
        } else if (displaySettings.textAlign === 'right') {
            startX = displaySettings.width - totalWidth;
        }

        for (var i = 0; i < digits.length; i++) {
            var digit = parseInt(digits[i], 10);
            if (isNaN(digit) || digit < 0 || digit > 9) digit = 0;
            
            var sprite;

            if (i < this._skillPointDigitSprites.length) {
                sprite = this._skillPointDigitSprites[i];
                sprite.visible = true;
            } else {
                sprite = new Sprite();
                this._skillPointDigitSprites.push(sprite);
                this._skillPointSprite.addChild(sprite);
            }

            var sx = digit * digitWidth;
            var bitmap = new Bitmap(digitWidth, digitHeight);
            bitmap.blt(this._spriteSheetBitmap, sx, 0, digitWidth, digitHeight, 0, 0);
            sprite.bitmap = bitmap;
            sprite.x = startX + i * (digitWidth + spacing);
            sprite.y = 0;
        }

        if (this._decorationSprite && this._decorationBitmap && this._decorationBitmap.isReady()) {
            var lastDigitX = startX + (digits.length - 1) * (digitWidth + spacing) + digitWidth;
            this._decorationSprite.x = lastDigitX + displaySettings.decorationOffsetX;
            this._decorationSprite.y = displaySettings.decorationOffsetY;
        }
    };

    Window_SkillTree.prototype._refreshTextDisplay = function(value) {
        var displaySettings = this._settings.skillPointDisplaySettings;
        var bitmap = this._skillPointSprite.bitmap;
        bitmap.clear();

        var fontSize = displaySettings.fontSize;
        var textColor = displaySettings.textColor;
        var outlineColor = displaySettings.outlineColor;
        var outlineWidth = displaySettings.outlineWidth;

        if (displaySettings.textPresetId && params.textPresets[displaySettings.textPresetId]) {
            var preset = params.textPresets[displaySettings.textPresetId];
            fontSize = preset.fontSize || fontSize;
            textColor = preset.textColor || textColor;
            outlineColor = preset.outlineColor || outlineColor;
            outlineWidth = preset.outlineWidth !== undefined ? preset.outlineWidth : outlineWidth;
        }

        bitmap.fontSize = fontSize;
        bitmap.textColor = textColor;
        bitmap.outlineColor = outlineColor;
        bitmap.outlineWidth = outlineWidth;

        var text = displaySettings.format.replace(/%1/g, value);
        bitmap.drawText(text, 0, 0, displaySettings.width, fontSize + 10, displaySettings.textAlign);
    };

    Window_SkillTree.prototype._checkAllImagesLoaded = function() {
        var bgReady = !this._settings.backgroundImage || this._backgroundSprite;
        var nodesReady = this._nodeSprites.length === (this._settings.skillNodes || []).length;

        if (bgReady && nodesReady) {
            this._isReady = true;
            this._refreshConnectionImages();
            
            if (this._nodeSprites.length > 0 && this._selectedNodeIndex < 0) {
                this._selectNode(0, false);
            }
        }
    };

    Window_SkillTree.prototype.isReady = function() {
        return this._isReady;
    };

    Window_SkillTree.prototype.refresh = function() {
        this._refreshConnectionImages();
        
        for (var i = 0; i < this._nodeSprites.length; i++) {
            var container = this._nodeSprites[i];
            var node = container._nodeData;
            var mainSprite = container._mainSprite;
            var learnedSprite = container._learnedSprite;
            var disabledSprite = container._disabledSprite;
            var filterSprite = container._filterSprite;
            
            var actor = this._getActor();
            var isLearned = actor ? actor.isLearnedSkill(node.skillId) : false;
            var canLearn = this._canLearnSkill(node.skillId);

            if (learnedSprite) {
                learnedSprite.visible = isLearned;
            }

            if (disabledSprite) {
                disabledSprite.visible = !isLearned && !canLearn;
            }

            if (isLearned) {
                if (filterSprite) {
                    filterSprite.visible = false;
                }
            } else {
                var filterOpacity = node.filterOpacity >= 0 ? node.filterOpacity : this._settings.unlearnedFilterOpacity;
                if (filterSprite) {
                    filterSprite.visible = true;
                } else {
                    if (filterOpacity > 0 && mainSprite && mainSprite.bitmap) {
                        var newFilter = this._createFilterSprite(node, mainSprite.bitmap);
                        newFilter.opacity = filterOpacity;
                        container._filterSprite = newFilter;
                        container.addChild(newFilter);
                    }
                }
            }
        }
    };

    Window_SkillTree.prototype.setActorId = function(actorId) {
        if (this._actorId !== actorId) {
            this._actorId = actorId;
            this.refresh();
        }
    };

    Window_SkillTree.prototype.update = function() {
        Window_Base.prototype.update.call(this);
        this._processKeyboardInput();
        this._updateNodeHover();
        this._updateNodeClick();
        this._refreshSkillPointDisplay();
    };

    Window_SkillTree.prototype._updateNodeHover = function() {
        if (!this._isReady || !this.visible) return;
        if (this._confirmWindow && this._confirmWindow.visible) return;
        
        var scene = SceneManager._scene;
        if (scene && scene.isTransitioning && scene.isTransitioning()) return;

        var mouseX = _customWindowMouseX;
        var mouseY = _customWindowMouseY;
        var localX = mouseX - this.x;
        var localY = mouseY - this.y;

        var mouseMoved = (mouseX !== this._lastMouseX || mouseY !== this._lastMouseY);
        this._lastMouseX = mouseX;
        this._lastMouseY = mouseY;

        if (!mouseMoved) {
            return;
        }

        var hoveredIndex = -1;

        for (var i = 0; i < this._nodeSprites.length; i++) {
            var container = this._nodeSprites[i];
            var node = container._nodeData;
            var mainSprite = container._mainSprite;

            if (!mainSprite) continue;

            var nodeWidth = this._getNodeWidth(mainSprite, node);
            var nodeHeight = this._getNodeHeight(mainSprite, node);

            if (localX >= node.nodeX && localX < node.nodeX + nodeWidth &&
                localY >= node.nodeY && localY < node.nodeY + nodeHeight) {
                hoveredIndex = i;
                break;
            }
        }

        if (hoveredIndex >= 0) {
            if (this._inputMode === 'keyboard' || hoveredIndex !== this._selectedNodeIndex) {
                this._inputMode = 'mouse';
                this._selectNode(hoveredIndex);
            }
        }
    };

    Window_SkillTree.prototype._getNodeWidth = function(mainSprite, node) {
        if (mainSprite && mainSprite.bitmap && mainSprite.bitmap.isReady() && mainSprite.bitmap.width > 0) {
            return mainSprite.bitmap.width;
        }
        return node.nodeWidth > 0 ? node.nodeWidth : 48;
    };

    Window_SkillTree.prototype._getNodeHeight = function(mainSprite, node) {
        if (mainSprite && mainSprite.bitmap && mainSprite.bitmap.isReady() && mainSprite.bitmap.height > 0) {
            return mainSprite.bitmap.height;
        }
        return node.nodeHeight > 0 ? node.nodeHeight : 48;
    };

    Window_SkillTree.prototype._updateNodeClick = function() {
        if (!this._isReady || !this.visible) return;
        if (this._confirmWindow && this._confirmWindow.visible) return;
        
        var scene = SceneManager._scene;
        if (scene && scene.isTransitioning && scene.isTransitioning()) return;
        
        if (this._inputGuardFrames > 0) return;

        if (TouchInput.isCancelled()) {
            this._closeWindow();
            return;
        }
        
        
        var wasPressed = this._isMousePressed;
        this._isMousePressed = TouchInput.isPressed();
        
        
        if (wasPressed && !this._isMousePressed) {
            var localX = TouchInput.x - this.x;
            var localY = TouchInput.y - this.y;

            for (var i = 0; i < this._nodeSprites.length; i++) {
                var container = this._nodeSprites[i];
                var node = container._nodeData;
                var mainSprite = container._mainSprite;

                if (!mainSprite) continue;

                var nodeWidth = this._getNodeWidth(mainSprite, node);
                var nodeHeight = this._getNodeHeight(mainSprite, node);

                if (localX >= node.nodeX && localX < node.nodeX + nodeWidth &&
                    localY >= node.nodeY && localY < node.nodeY + nodeHeight) {
                    this._selectNode(i, false);
                    this._onNodeClick(node);
                    if (this._confirmWindow) return;
                    break;
                }
            }
        }
    };

    Window_SkillTree.prototype._closeWindow = function() {
        var scene = SceneManager._scene;
        if (scene && scene.closeSkillTreeWindow) {
            var windowId = this._windowId;
            if (windowId) {
                scene.closeSkillTreeWindow(windowId);
            }
        }
    };

    Window_SkillTree.prototype._onNodeClick = function(node) {
        var actor = this._getActor();
        if (!actor) return;

        if (actor.isLearnedSkill(node.skillId)) return;

        if (!this._canLearnSkill(node.skillId)) return;

        var spVarId = this._settings.skillPointVariable;
        var currentSP = spVarId > 0 ? $gameVariables.value(spVarId) : Infinity;
        var requiredSP = node.requiredSP || 0;

        if (currentSP < requiredSP) {
            SoundManager.playBuzzer();
            return;
        }

        if (this._settings.showConfirmWindow) {
            this._pendingNode = node;
            this._showConfirmWindow(node);
            this._inputGuardFrames = 1;
        } else {
            this._learnSkill(node);
        }
    };

    Window_SkillTree.prototype.getSkillPoints = function() {
        var spVarId = this._settings.skillPointVariable;
        return spVarId > 0 ? $gameVariables.value(spVarId) : Infinity;
    };

    Window_SkillTree.prototype.setSkillPoints = function(value) {
        var spVarId = this._settings.skillPointVariable;
        if (spVarId > 0) {
            $gameVariables.setValue(spVarId, value);
        }
    };

    Window_SkillTree.prototype._learnSkill = function(node) {
        var actor = this._getActor();
        if (!actor) return;

        var spVarId = this._settings.skillPointVariable;
        if (spVarId > 0) {
            var currentSP = $gameVariables.value(spVarId);
            var requiredSP = node.requiredSP || 0;
            $gameVariables.setValue(spVarId, currentSP - requiredSP);
        }

        actor.learnSkill(node.skillId);

        this.refresh();

        this._updateDescriptionImage();

        SoundManager.playUseSkill();
    };

    Window_SkillTree.prototype._showConfirmWindow = function(node) {
        if (this._confirmWindow) {
            this.removeChild(this._confirmWindow);
        }

        var confirmSettings = this._settings.confirmWindowSettings;
        var skill = $dataSkills[node.skillId];
        var skillName = skill ? skill.name : '';
        var requiredSP = node.requiredSP || 0;

        this._confirmWindow = new Window_SkillTreeConfirm(
            this, confirmSettings, skillName, requiredSP
        );
        this.addChild(this._confirmWindow);
    };

    Window_SkillTree.prototype._closeConfirmWindow = function() {
        if (this._confirmWindow) {
            this.removeChild(this._confirmWindow);
            this._confirmWindow = null;
        }
    };

    Window_SkillTree.prototype._onConfirmYes = function() {
        if (this._pendingNode) {
            this._learnSkill(this._pendingNode);
            this._pendingNode = null;
        }
        this._closeConfirmWindow();
        this._inputGuardFrames = 1;
    };

    Window_SkillTree.prototype._onConfirmNo = function() {
        this._pendingNode = null;
        this._closeConfirmWindow();
        this._inputGuardFrames = 1;
    };


    function Window_SkillTreeConfirm() {
        this.initialize.apply(this, arguments);
    }

    Window_SkillTreeConfirm.prototype = Object.create(Window_Base.prototype);
    Window_SkillTreeConfirm.prototype.constructor = Window_SkillTreeConfirm;

    Window_SkillTreeConfirm.prototype.initialize = function(parent, settings, skillName, requiredSP) {
        this._parentWindow = parent;
        this._settings = settings;
        this._skillName = skillName;
        this._requiredSP = requiredSP;
        this._buttons = [];
        this._selectedIndex = 0;
        this._isFirstFrame = true;

        var width = settings.width;
        var height = settings.height;
        var x = (parent.width - width) / 2;
        var y = (parent.height - height) / 2;

        if (Utils.RPGMAKER_NAME === 'MZ') {
            Window_Base.prototype.initialize.call(this, new Rectangle(x, y, width, height));
        } else {
            Window_Base.prototype.initialize.call(this, x, y, width, height);
        }

        this._loadBackgroundImage();
        this._createContents();
    };

    Window_SkillTreeConfirm.prototype._loadBackgroundImage = function() {
        var settings = this._settings;
        if (settings.backgroundImage) {
            var bitmap = ImageManager.loadBitmap('img/customwindow/', settings.backgroundImage);
            bitmap.addLoadListener(function() {
                this._createBackgroundSprite(bitmap);
            }.bind(this));
        }
    };

    Window_SkillTreeConfirm.prototype._createBackgroundSprite = function(bitmap) {
        var sprite = new Sprite(bitmap);
        sprite.x = 0;
        sprite.y = 0;
        this.addChildAt(sprite, 0);
    };

    Window_SkillTreeConfirm.prototype._createContents = function() {
        var settings = this._settings;
        var width = this.contentsWidth();
        var height = this.contentsHeight();

        this.contents.clear();
        this.contents.fontSize = settings.fontSize;
        this.contents.textColor = settings.textColor;

        var text = settings.confirmText;
        text = text.replace(/%1/g, this._skillName);
        text = text.replace(/%2/g, this._requiredSP);

        var textY = 10;
        this.contents.drawText(text, 0, textY, width, settings.fontSize, 'center');

        this._createButtons();
    };

    Window_SkillTreeConfirm.prototype._createButtons = function() {
        var settings = this._settings;
        var width = this.contentsWidth();
        var height = this.contentsHeight();
        
        var fontSize = settings.fontSize || 24;
        var buttonWidth = Math.max(80, fontSize * 4);
        var buttonHeight = fontSize + 8;
        var spacing = Math.max(10, fontSize / 2);
        
        this._buttonWidth = buttonWidth;
        this._buttonHeight = buttonHeight;
        this._buttonSpacing = spacing;

        if (settings.buttonLayout === 'vertical') {
            var buttonX = (width - buttonWidth) / 2;
            var totalHeight = buttonHeight * 2 + spacing;
            var startY = height - totalHeight - 10;
            
            this._yesButton = this._createButton(buttonX, startY, buttonWidth, buttonHeight, settings.yesText);
            
            this._noButton = this._createButton(buttonX, startY + buttonHeight + spacing, buttonWidth, buttonHeight, settings.noText);
        } else {
            var buttonY = height - buttonHeight - 10;
            
            var yesX = width / 2 - buttonWidth - spacing / 2;
            this._yesButton = this._createButton(yesX, buttonY, buttonWidth, buttonHeight, settings.yesText);
            
            var noX = width / 2 + spacing / 2;
            this._noButton = this._createButton(noX, buttonY, buttonWidth, buttonHeight, settings.noText);
        }
        
        this._refreshButtonSelection();
    };

    Window_SkillTreeConfirm.prototype._createButton = function(x, y, width, height, text) {
        var settings = this._settings;
        
        this.contents.drawText(text, x, y, width, height, 'center');

        return {
            x: x + this.padding,
            y: y + this.padding,
            width: width,
            height: height,
            text: text
        };
    };

    Window_SkillTreeConfirm.prototype.update = function() {
        Window_Base.prototype.update.call(this);

        this._processKeyboardInput();

        this._processMouseHover();
        
        
        var wasPressed = this._isMousePressed;
        this._isMousePressed = TouchInput.isPressed();
        
        
        if (wasPressed && !this._isMousePressed) {
            var localX = TouchInput.x - this._parentWindow.x - this.x;
            var localY = TouchInput.y - this._parentWindow.y - this.y;

            if (this._yesButton && 
                localX >= this._yesButton.x && localX < this._yesButton.x + this._yesButton.width &&
                localY >= this._yesButton.y && localY < this._yesButton.y + this._yesButton.height) {
                SoundManager.playOk();
                TouchInput.clear();
                this._parentWindow._onConfirmYes();
                return;
            }

            if (this._noButton &&
                localX >= this._noButton.x && localX < this._noButton.x + this._noButton.width &&
                localY >= this._noButton.y && localY < this._noButton.y + this._noButton.height) {
                SoundManager.playCancel();
                TouchInput.clear();
                this._parentWindow._onConfirmNo();
                return;
            }
        }

    };

    Window_SkillTreeConfirm.prototype._processMouseHover = function() {
        var mouseX = _customWindowMouseX;
        var mouseY = _customWindowMouseY;
        
        var localX = mouseX - this._parentWindow.x - this.x;
        var localY = mouseY - this._parentWindow.y - this.y;
        
        var oldIndex = this._selectedIndex;

        if (this._yesButton && 
            localX >= this._yesButton.x && localX < this._yesButton.x + this._yesButton.width &&
            localY >= this._yesButton.y && localY < this._yesButton.y + this._yesButton.height) {
            this._selectedIndex = 0;
        }

        if (this._noButton &&
            localX >= this._noButton.x && localX < this._noButton.x + this._noButton.width &&
            localY >= this._noButton.y && localY < this._noButton.y + this._noButton.height) {
            this._selectedIndex = 1;
        }

        if (oldIndex !== this._selectedIndex) {
            SoundManager.playCursor();
            this._refreshButtonSelection();
        }
    };

    Window_SkillTreeConfirm.prototype._processKeyboardInput = function() {
        if (this._isFirstFrame) {
            this._isFirstFrame = false;
            this._waitForOkRelease = Input.isPressed('ok');
            return;
        }
        
        if (this._waitForOkRelease) {
            if (!Input.isPressed('ok')) {
                this._waitForOkRelease = false;
            }
            return;
        }
        
        var settings = this._settings;
        var isVertical = settings.buttonLayout === 'vertical';
        var changed = false;
        
        if (isVertical) {
            if (Input.isRepeated('up') || Input.isRepeated('down')) {
                this._selectedIndex = this._selectedIndex === 0 ? 1 : 0;
                changed = true;
            }
        } else {
            if (Input.isRepeated('left') || Input.isRepeated('right')) {
                this._selectedIndex = this._selectedIndex === 0 ? 1 : 0;
                changed = true;
            }
        }
        
        if (changed) {
            SoundManager.playCursor();
            this._refreshButtonSelection();
        }
        
        if (Input.isTriggered('ok')) {
            if (this._selectedIndex === 0) {
                SoundManager.playOk();
                this._parentWindow._onConfirmYes();
            } else {
                SoundManager.playCancel();
                this._parentWindow._onConfirmNo();
            }
        }
        
        if (Input.isTriggered('cancel')) {
            SoundManager.playCancel();
            this._parentWindow._onConfirmNo();
        }
    };

    Window_SkillTreeConfirm.prototype._refreshButtonSelection = function() {
        var settings = this._settings;
        var width = this.contentsWidth();
        var height = this.contentsHeight();
        
        var buttonWidth = this._buttonWidth || 80;
        var buttonHeight = this._buttonHeight || 32;
        var spacing = this._buttonSpacing || 20;
        
        this.contents.fontSize = settings.fontSize;
        this.contents.textColor = settings.textColor;

        if (settings.buttonLayout === 'vertical') {
            var buttonX = (width - buttonWidth) / 2;
            var totalHeight = buttonHeight * 2 + spacing;
            var startY = height - totalHeight - 10;
            
            this.contents.clearRect(0, startY - 5, width, totalHeight + 20);
            
            var yesY = startY;
            var noY = startY + buttonHeight + spacing;
            
            if (this._selectedIndex === 0) {
                this.contents.fillRect(buttonX - 2, yesY - 2, buttonWidth + 4, buttonHeight + 4, 'rgba(255, 255, 255, 0.3)');
            } else {
                this.contents.fillRect(buttonX - 2, noY - 2, buttonWidth + 4, buttonHeight + 4, 'rgba(255, 255, 255, 0.3)');
            }
            
            this.contents.drawText(settings.yesText, buttonX, yesY, buttonWidth, buttonHeight, 'center');
            this.contents.drawText(settings.noText, buttonX, noY, buttonWidth, buttonHeight, 'center');
        } else {
            var buttonY = height - buttonHeight - 10;
            
            this.contents.clearRect(0, buttonY - 5, width, buttonHeight + 20);
            
            var yesX = width / 2 - buttonWidth - spacing / 2;
            var noX = width / 2 + spacing / 2;
            
            if (this._selectedIndex === 0) {
                this.contents.fillRect(yesX - 2, buttonY - 2, buttonWidth + 4, buttonHeight + 4, 'rgba(255, 255, 255, 0.3)');
            } else {
                this.contents.fillRect(noX - 2, buttonY - 2, buttonWidth + 4, buttonHeight + 4, 'rgba(255, 255, 255, 0.3)');
            }
            
            this.contents.drawText(settings.yesText, yesX, buttonY, buttonWidth, buttonHeight, 'center');
            this.contents.drawText(settings.noText, noX, buttonY, buttonWidth, buttonHeight, 'center');
        }
    };


    var _Game_System_initialize_skillTree = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function() {
        _Game_System_initialize_skillTree.call(this);
        this._openSkillTreeWindows = {};
    };

    Game_System.prototype.saveSkillTreeWindowState = function(windowId, actorId) {
        if (!this._openSkillTreeWindows) {
            this._openSkillTreeWindows = {};
        }
        this._openSkillTreeWindows[windowId] = { actorId: actorId };
    };

    Game_System.prototype.removeSkillTreeWindowState = function(windowId) {
        if (this._openSkillTreeWindows) {
            if (windowId) {
                delete this._openSkillTreeWindows[windowId];
            } else {
                this._openSkillTreeWindows = {};
            }
        }
    };

    Game_System.prototype.getOpenSkillTreeWindows = function() {
        return this._openSkillTreeWindows || {};
    };

    var _Scene_Map_createAllWindows_skillTree = Scene_Map.prototype.createAllWindows;
    Scene_Map.prototype.createAllWindows = function() {
        _Scene_Map_createAllWindows_skillTree.call(this);
        this._skillTreeWindows = {};
        
        this._restoreSkillTreeWindows();
    };

    Scene_Map.prototype._restoreSkillTreeWindows = function() {
        var openWindows = $gameSystem.getOpenSkillTreeWindows();
        for (var windowId in openWindows) {
            var state = openWindows[windowId];
            var settings = params.skillTreeWindowSettings[windowId];
            if (settings) {
                var window = new Window_SkillTree(settings, state.actorId);
                window._windowId = windowId;
                this._skillTreeWindows[windowId] = window;
                this.addChild(window);
            }
        }
    };

    Scene_Map.prototype.showSkillTreeWindow = function(windowId, actorId) {
        var settings = params.skillTreeWindowSettings[windowId];
        if (!settings) return;

        if (this._skillTreeWindows[windowId]) {
            this.removeChild(this._skillTreeWindows[windowId]);
        }

        var self = this;
        var transitionId = settings.transitionId;
        
        var createWindow = function() {
            var window = new Window_SkillTree(settings, actorId);
            window._windowId = windowId;
            self._skillTreeWindows[windowId] = window;
            self.addChild(window);
            
            $gameSystem.saveSkillTreeWindowState(windowId, actorId);
            
            if (self._transitionLayer && self._transitionLayer.parent) {
                self.removeChild(self._transitionLayer);
                self.addChild(self._transitionLayer);
            }
        };
        
        if (transitionId && params.transitionEffects[transitionId]) {
            this.startTransition(transitionId, createWindow);
        } else {
            createWindow();
        }
    };

    Scene_Map.prototype.hideSkillTreeWindow = function(windowId) {
        if (windowId) {
            var window = this._skillTreeWindows[windowId];
            if (window) {
                window.visible = false;
            }
        } else {
            for (var id in this._skillTreeWindows) {
                if (this._skillTreeWindows[id]) {
                    this._skillTreeWindows[id].visible = false;
                }
            }
        }
    };

    Scene_Map.prototype.closeSkillTreeWindow = function(windowId) {
        var self = this;
        
        if (windowId) {
            var settings = params.skillTreeWindowSettings[windowId];
            var transitionId = settings ? settings.transitionId : '';
            
            if (transitionId && params.transitionEffects[transitionId]) {
                this.startTransition(transitionId, function() {
                    self._removeSkillTreeWindowById(windowId);
                });
            } else {
                this._removeSkillTreeWindowById(windowId);
            }
        } else {
            for (var id in this._skillTreeWindows) {
                if (this._skillTreeWindows[id]) {
                    this.removeChild(this._skillTreeWindows[id]);
                }
            }
            this._skillTreeWindows = {};
            $gameSystem.removeSkillTreeWindowState();
        }
    };

    Scene_Map.prototype._removeSkillTreeWindowById = function(windowId) {
        var window = this._skillTreeWindows[windowId];
        if (window) {
            this.removeChild(window);
            delete this._skillTreeWindows[windowId];
        }
        $gameSystem.removeSkillTreeWindowState(windowId);
    };


    function Window_SaveLoadCustom() {
        this.initialize.apply(this, arguments);
    }

    Window_SaveLoadCustom.prototype = Object.create(Window_Base.prototype);
    Window_SaveLoadCustom.prototype.constructor = Window_SaveLoadCustom;

    Window_SaveLoadCustom.prototype.initialize = function(settings, sceneType) {
        this._settings = JSON.parse(JSON.stringify(settings));
        this._sceneType = sceneType;
        this._slotSprites = [];
        this._buttonSprites = [];
        this._selectedSlotIndex = 0;
        this._isReady = false;
        this._scrollY = 0;
        this._maxScrollY = 0;
        this._scrollBarSprite = null;
        this._slotContainer = null;
        this._isDraggingScrollBar = false;
        this._wasScrollBarPressed = false;
        this._dragStartY = 0;
        this._dragStartScrollY = 0;
        this._scrollBarThumbHeight = 0;
        this._isProcessing = false;
        
        var x = settings.x;
        var y = settings.y;
        var width = settings.width;
        var height = settings.height;
        
        if (Utils.RPGMAKER_NAME === 'MZ') {
            Window_Base.prototype.initialize.call(this, new Rectangle(x, y, width, height));
        } else {
            Window_Base.prototype.initialize.call(this, x, y, width, height);
        }
        
        this.opacity = 0;
        this._loadBackgroundImage();
        this._createSlotContainer();
        this._createSlotSprites();
        this._createTextElements();
        this._createButtonElements();
        this._createScrollBar();
        this._updateScrollBar();
    };

    Window_SaveLoadCustom.prototype._createSlotContainer = function() {
        var settings = this._settings;
        var paddingLeft = settings.windowPaddingLeft || 0;
        var paddingTop = settings.windowPaddingTop || 0;
        var paddingRight = settings.windowPaddingRight || 0;
        var paddingBottom = settings.windowPaddingBottom || 0;
        
        this._slotContainer = new Sprite();
        this._slotContainer.x = 0;
        this._slotContainer.y = 0;
        
        var maskWidth = this.width - paddingLeft - paddingRight;
        var maskHeight = this.height - paddingTop - paddingBottom;
        var maskBitmap = new Bitmap(this.width, this.height);
        maskBitmap.fillRect(paddingLeft, paddingTop, maskWidth, maskHeight, '#ffffff');
        this._slotContainerMask = new Sprite(maskBitmap);
        this._slotContainerMask.x = 0;
        this._slotContainerMask.y = 0;
        
        this.addChild(this._slotContainerMask);
        this.addChild(this._slotContainer);
        this._slotContainer.mask = this._slotContainerMask;
    };

    Window_SaveLoadCustom.prototype._updateSlotContainerMask = function() {
        var settings = this._settings;
        var paddingLeft = settings.windowPaddingLeft || 0;
        var paddingTop = settings.windowPaddingTop || 0;
        var paddingRight = settings.windowPaddingRight || 0;
        var paddingBottom = settings.windowPaddingBottom || 0;
        
        var maskWidth = this.width - paddingLeft - paddingRight;
        var maskHeight = this.height - paddingTop - paddingBottom;
        
        if (this._slotContainerMask) {
            this._slotContainerMask.bitmap = new Bitmap(this.width, this.height);
            this._slotContainerMask.bitmap.fillRect(paddingLeft, paddingTop, maskWidth, maskHeight, '#ffffff');
        }
    };

    Window_SaveLoadCustom.prototype._loadBackgroundImage = function() {
        var settings = this._settings;
        if (settings.windowImage) {
            var bitmap = ImageManager.loadBitmap('img/customwindow/', settings.windowImage);
            var self = this;
            bitmap.addLoadListener(function() {
                self._createBackgroundSprite(bitmap);
                if (settings.useImageSize) {
                    self.width = bitmap.width;
                    self.height = bitmap.height;
                    self._updateSlotContainerMask();
                    self._calculateMaxScroll();
                    self._removeScrollBar();
                    self._createScrollBar();
                }
                self._isReady = true;
            });
        } else {
            this._isReady = true;
        }
    };

    Window_SaveLoadCustom.prototype._updateWindowImage = function(imageName) {
        if (!imageName) return;
        
        var bitmap = ImageManager.loadBitmap('img/customwindow/', imageName);
        var self = this;
        bitmap.addLoadListener(function() {
            self._createBackgroundSprite(bitmap);
        });
    };

    Window_SaveLoadCustom.prototype._removeScrollBar = function() {
        if (this._scrollBarBg) {
            this.removeChild(this._scrollBarBg);
            this._scrollBarBg = null;
        }
        if (this._scrollBarSprite) {
            this.removeChild(this._scrollBarSprite);
            this._scrollBarSprite = null;
        }
    };

    Window_SaveLoadCustom.prototype._createBackgroundSprite = function(bitmap) {
        if (this._backgroundSprite) {
            this.removeChild(this._backgroundSprite);
        }
        var sprite = new Sprite(bitmap);
        sprite.x = 0;
        sprite.y = 0;
        this._backgroundSprite = sprite;
        this.addChildAt(sprite, 0);
    };

    Window_SaveLoadCustom.prototype._createSlotSprites = function() {
        var settings = this._settings;
        var template = settings.slotTemplate;
        
        if (!template || template.slotCount <= 0) return;
        
        var self = this;
        
        var paddingLeft = settings.windowPaddingLeft || 0;
        var paddingTop = settings.windowPaddingTop || 0;
        
        var slotCount = template.slotCount;
        var startSlotId = template.startSlotId || 1;
        var columns = template.columns || 1;
        var baseX = (template.x || 0) + paddingLeft;
        var baseY = (template.y || 0) + paddingTop;
        var offsetX = template.offsetX || 0;
        var offsetY = template.offsetY !== undefined ? template.offsetY : 10;
        
        var bgImageName = template.backgroundImageUsed || template.backgroundImage;
        
        var createSlots = function(actualSlotWidth, actualSlotHeight) {
            
            for (var i = 0; i < slotCount; i++) {
                var slotId = startSlotId + i;
                var col = i % columns;
                var row = Math.floor(i / columns);
                
                var slotX = baseX + col * (actualSlotWidth + offsetX);
                var slotY = baseY + row * (actualSlotHeight + offsetY);
            
            var slotSettings = {
                slotId: slotId,
                x: slotX,
                y: slotY,
                width: template.width,
                height: template.height,
                backgroundImage: template.backgroundImage,
                backgroundImageUsed: template.backgroundImageUsed,
                backgroundImageSelected: template.backgroundImageSelected,
                selectionFrameImage: template.selectionFrameImage,
                selectionFrameOffsetX: template.selectionFrameOffsetX,
                selectionFrameOffsetY: template.selectionFrameOffsetY,
                showPlaytime: template.showPlaytime,
                playtimeX: template.playtimeX,
                playtimeY: template.playtimeY,
                playtimeScaleX: template.playtimeScaleX,
                showTimestamp: template.showTimestamp,
                timestampX: template.timestampX,
                timestampY: template.timestampY,
                timestampScaleX: template.timestampScaleX,
                timestampSplit: template.timestampSplit,
                timestampLineHeight: template.timestampLineHeight,
                showScreenshot: template.showScreenshot,
                screenshotX: template.screenshotX,
                screenshotY: template.screenshotY,
                screenshotWidth: template.screenshotWidth,
                screenshotHeight: template.screenshotHeight,
                textPresetId: template.textPresetId,
                textElements: template.textElements,
                gaugeElements: template.gaugeElements
            };
            
                var slotSprite = new Sprite_SaveSlot(slotSettings, self);
                slotSprite.x = slotSettings.x;
                slotSprite.y = slotSettings.y;
                self._slotSprites.push(slotSprite);
                self._slotContainer.addChild(slotSprite);
            }
            
            self._calculateMaxScroll();
            
            if (self._slotSprites.length > 0) {
                var initialIndex = -1;
                
                if (self._sceneType === 'save') {
                    initialIndex = self._findLatestSaveSlot();
                    if (initialIndex < 0) {
                        for (var i = 0; i < self._slotSprites.length; i++) {
                            if (!self._hasSlotData(i)) {
                                initialIndex = i;
                                break;
                            }
                        }
                    }
                } else {
                    initialIndex = self._findLatestSaveSlot();
                    if (initialIndex < 0) {
                        for (var i = 0; i < self._slotSprites.length; i++) {
                            if (self._hasSlotData(i)) {
                                initialIndex = i;
                                break;
                            }
                        }
                    }
                }
                
                if (initialIndex < 0) {
                    initialIndex = 0;
                }
                
                self._selectSlot(initialIndex, false, true);
            }
        };
        
        if (bgImageName) {
            var testBitmap = ImageManager.loadBitmap('img/customwindow/', bgImageName);
            if (testBitmap.isReady && testBitmap.isReady()) {
                createSlots(testBitmap.width, testBitmap.height);
            } else {
                testBitmap.addLoadListener(function() {
                    createSlots(testBitmap.width, testBitmap.height);
                });
            }
        } else {
            createSlots(template.width, template.height);
        }
    };

    Window_SaveLoadCustom.prototype._calculateMaxScroll = function() {
        var settings = this._settings;
        var template = settings.slotTemplate;
        if (!template || template.slotCount <= 0) {
            this._maxScrollY = 0;
            return;
        }
        
        var self = this;
        var paddingTop = settings.windowPaddingTop || 0;
        var paddingBottom = settings.windowPaddingBottom || 0;
        var slotCount = template.slotCount;
        var columns = template.columns || 1;
        var rows = Math.ceil(slotCount / columns);
        var offsetY = template.offsetY !== undefined ? template.offsetY : 10;
        
        var calculateScroll = function(slotHeight) {
            var contentHeight = (template.y || 0) + paddingTop + rows * slotHeight + (rows - 1) * offsetY;
            var viewHeight = self.height - paddingTop - paddingBottom;
            
            self._maxScrollY = Math.max(0, contentHeight - viewHeight);
        };
        
        var bgImageName = template.backgroundImageUsed || template.backgroundImage;
        if (bgImageName) {
            var testBitmap = ImageManager.loadBitmap('img/customwindow/', bgImageName);
            if (testBitmap && testBitmap.isReady && testBitmap.isReady() && testBitmap.height > 0) {
                calculateScroll(testBitmap.height);
            } else {
                testBitmap.addLoadListener(function() {
                    calculateScroll(testBitmap.height);
                    self._updateScrollBar();
                });
                calculateScroll(template.height || 90);
            }
        } else {
            calculateScroll(template.height || 90);
        }
    };

    Window_SaveLoadCustom.prototype._getScrollBarSettings = function() {
        var settings = this._settings;
        var scrollBarId = settings.scrollBarId || '';
        return getScrollBarSettingsById(scrollBarId);
    };

    Window_SaveLoadCustom.prototype._createScrollBar = function() {
        var settings = this._settings;
        if (this._maxScrollY <= 0) return;
        
        var paddingTop = settings.windowPaddingTop || 0;
        var paddingBottom = settings.windowPaddingBottom || 0;
        var paddingRight = settings.windowPaddingRight || 0;
        
        var sbSettings = this._getScrollBarSettings();
        this._scrollBarConfig = sbSettings;
        
        var scrollBarWidth = sbSettings.width || 12;
        var viewHeight = this.height - paddingTop - paddingBottom;
        var offsetX = sbSettings.offsetX || 0;
        
        if (sbSettings.useSkin) {
            this._createScrollBarSkin(paddingTop, paddingRight, viewHeight, offsetX, sbSettings);
        } else {
            this._createScrollBarSimple(paddingTop, paddingRight, viewHeight, scrollBarWidth, offsetX, sbSettings);
        }
    };

    Window_SaveLoadCustom.prototype._createScrollBarSimple = function(paddingTop, paddingRight, viewHeight, scrollBarWidth, offsetX, sbSettings) {
        this._scrollBarBg = new Sprite(new Bitmap(scrollBarWidth, viewHeight));
        this._scrollBarBg.bitmap.fillAll(sbSettings.bgColor || '#000000');
        this._scrollBarBg.x = this.width - paddingRight - scrollBarWidth + offsetX;
        this._scrollBarBg.y = paddingTop;
        this._scrollBarBg.opacity = 128;
        this.addChild(this._scrollBarBg);
        
        var thumbHeight = Math.max(20, viewHeight * (viewHeight / (viewHeight + this._maxScrollY)));
        this._scrollBarSprite = new Sprite(new Bitmap(scrollBarWidth, thumbHeight));
        this._scrollBarSprite.bitmap.fillAll(sbSettings.color || '#ffffff');
        this._scrollBarSprite.x = this.width - paddingRight - scrollBarWidth + offsetX;
        this._scrollBarSprite.y = paddingTop;
        this.addChild(this._scrollBarSprite);
    };

    Window_SaveLoadCustom.prototype._createScrollBarSkin = function(paddingTop, paddingRight, viewHeight, offsetX, sbSettings) {
        var scrollBarWidth = sbSettings.width || 12;
        var scrollBarCenterX = this.width - paddingRight - scrollBarWidth / 2 + offsetX;
        
        this._scrollBarSkinContainer = new PIXI.Container();
        this._scrollBarSkinContainer.x = scrollBarCenterX;
        this._scrollBarSkinContainer.y = paddingTop;
        this.addChild(this._scrollBarSkinContainer);
        
        if (sbSettings.skinBg) {
            this._scrollBarBgSprite = new Sprite(ImageManager.loadCustomWindowPicture(sbSettings.skinBg));
            this._scrollBarBgSprite.anchor.x = 0.5;
            this._scrollBarBgSprite.x = 0;
            this._scrollBarBgSprite.y = 0;
            this._scrollBarSkinContainer.addChild(this._scrollBarBgSprite);
            
            var self = this;
            this._scrollBarBgSprite.bitmap.addLoadListener(function() {
                self._updateScrollBarSkinBgSize(viewHeight);
            });
        }
        
        this._scrollBarContainer = new PIXI.Container();
        this._scrollBarSkinContainer.addChild(this._scrollBarContainer);
        
        this._scrollBarTopSprite = null;
        if (sbSettings.skinTop) {
            this._scrollBarTopSprite = new Sprite(ImageManager.loadCustomWindowPicture(sbSettings.skinTop));
            this._scrollBarTopSprite.anchor.x = 0.5;
            this._scrollBarContainer.addChild(this._scrollBarTopSprite);
        }
        
        this._scrollBarMiddleSprite = null;
        if (sbSettings.skinMiddle) {
            this._scrollBarMiddleSprite = new Sprite(ImageManager.loadCustomWindowPicture(sbSettings.skinMiddle));
            this._scrollBarMiddleSprite.anchor.x = 0.5;
            this._scrollBarContainer.addChild(this._scrollBarMiddleSprite);
        }
        
        this._scrollBarBottomSprite = null;
        if (sbSettings.skinBottom) {
            this._scrollBarBottomSprite = new Sprite(ImageManager.loadCustomWindowPicture(sbSettings.skinBottom));
            this._scrollBarBottomSprite.anchor.x = 0.5;
            this._scrollBarContainer.addChild(this._scrollBarBottomSprite);
        }
        
        var self = this;
        this._preloadScrollBarSkinImages(sbSettings, function() {
            self._updateScrollBarSkin(viewHeight);
        });
        
        this._scrollBarSprite = this._scrollBarContainer;
        this._scrollBarBg = this._scrollBarSkinContainer;
    };

    Window_SaveLoadCustom.prototype._preloadScrollBarSkinImages = function(sbSettings, callback) {
        var images = [];
        if (sbSettings.skinTop) images.push(sbSettings.skinTop);
        if (sbSettings.skinMiddle) images.push(sbSettings.skinMiddle);
        if (sbSettings.skinBottom) images.push(sbSettings.skinBottom);
        if (sbSettings.skinBg) images.push(sbSettings.skinBg);
        
        if (images.length === 0) {
            callback();
            return;
        }
        
        var loadedCount = 0;
        for (var i = 0; i < images.length; i++) {
            var bitmap = ImageManager.loadCustomWindowPicture(images[i]);
            if (bitmap.isReady()) {
                loadedCount++;
                if (loadedCount >= images.length) callback();
            } else {
                bitmap.addLoadListener(function() {
                    loadedCount++;
                    if (loadedCount >= images.length) callback();
                });
            }
        }
    };

    Window_SaveLoadCustom.prototype._updateScrollBarSkinBgSize = function(viewHeight) {
        if (!this._scrollBarBgSprite || !this._scrollBarBgSprite.bitmap.isReady()) return;
        var bitmap = this._scrollBarBgSprite.bitmap;
        this._scrollBarBgSprite.scale.y = viewHeight / bitmap.height;
    };

    Window_SaveLoadCustom.prototype._updateScrollBarSkin = function(viewHeight) {
        if (!this._scrollBarContainer) return;
        
        var thumbHeight = Math.max(20, viewHeight * (viewHeight / (viewHeight + this._maxScrollY)));
        var topHeight = 0;
        var bottomHeight = 0;
        var y = 0;
        
        if (this._scrollBarTopSprite && this._scrollBarTopSprite.bitmap.isReady()) {
            topHeight = this._scrollBarTopSprite.bitmap.height;
            this._scrollBarTopSprite.y = y;
            y += topHeight;
        }
        
        if (this._scrollBarMiddleSprite && this._scrollBarMiddleSprite.bitmap.isReady()) {
            if (this._scrollBarBottomSprite && this._scrollBarBottomSprite.bitmap.isReady()) {
                bottomHeight = this._scrollBarBottomSprite.bitmap.height;
            }
            var middleHeight = Math.max(1, thumbHeight - topHeight - bottomHeight);
            this._scrollBarMiddleSprite.y = y;
            this._scrollBarMiddleSprite.scale.y = middleHeight / this._scrollBarMiddleSprite.bitmap.height;
            y += middleHeight;
        }
        
        if (this._scrollBarBottomSprite && this._scrollBarBottomSprite.bitmap.isReady()) {
            this._scrollBarBottomSprite.y = y;
        }
        
        this._scrollBarThumbHeight = thumbHeight;
    };

    Window_SaveLoadCustom.prototype._updateScrollBar = function() {
        if (this._maxScrollY <= 0) return;
        
        var settings = this._settings;
        var paddingTop = settings.windowPaddingTop || 0;
        var paddingBottom = settings.windowPaddingBottom || 0;
        var viewHeight = this.height - paddingTop - paddingBottom;
        
        var scrollRatio = this._scrollY / this._maxScrollY;
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        
        if (sbSettings.useSkin && this._scrollBarContainer) {
            var thumbHeight = this._scrollBarThumbHeight || 20;
            var maxThumbY = viewHeight - thumbHeight;
            this._scrollBarContainer.y = maxThumbY * scrollRatio;
        }
        else if (this._scrollBarSprite) {
            var thumbHeight = this._scrollBarSprite.height || 20;
            var maxThumbY = viewHeight - thumbHeight;
            this._scrollBarSprite.y = paddingTop + maxThumbY * scrollRatio;
        }
    };

    Window_SaveLoadCustom.prototype._createTextElements = function() {
        var settings = this._settings;
        var textElements = settings.textElements || [];
        
        for (var i = 0; i < textElements.length; i++) {
            var textSettings = textElements[i];
            this._drawTextElement(textSettings);
        }
    };

    Window_SaveLoadCustom.prototype._drawTextElement = function(textSettings) {
        var settings = this._settings;
        var paddingLeft = settings.windowPaddingLeft || 0;
        var paddingTop = settings.windowPaddingTop || 0;
        
        var fontSize = 26;
        var textColor = '#ffffff';
        var outlineColor = '#000000';
        var outlineWidth = 4;
        
        if (textSettings.textPresetId && params.textPresets[textSettings.textPresetId]) {
            var preset = params.textPresets[textSettings.textPresetId];
            fontSize = preset.fontSize || fontSize;
            textColor = preset.textColor || textColor;
            outlineColor = preset.outlineColor || outlineColor;
            outlineWidth = preset.outlineWidth !== undefined ? preset.outlineWidth : outlineWidth;
        }
        
        this.contents.fontSize = fontSize;
        this.contents.textColor = textColor;
        this.contents.outlineColor = outlineColor;
        this.contents.outlineWidth = outlineWidth;
        
        this.contents.drawText(
            textSettings.text,
            textSettings.x + paddingLeft,
            textSettings.y + paddingTop,
            textSettings.width,
            fontSize + 4,
            textSettings.textAlign
        );
    };

    Window_SaveLoadCustom.prototype._createButtonElements = function() {
        var settings = this._settings;
        var buttonElements = settings.buttonElements || [];
        var paddingLeft = settings.windowPaddingLeft || 0;
        var paddingTop = settings.windowPaddingTop || 0;
        var windowX = this.x;
        var windowY = this.y;
        
        for (var i = 0; i < buttonElements.length; i++) {
            var buttonSettings = buttonElements[i];
            var buttonSprite = new Sprite_SaveLoadButton(buttonSettings, this);
            
            if (buttonSettings.useScreenCoordinates) {
                buttonSprite.x = buttonSettings.x - windowX;
                buttonSprite.y = buttonSettings.y - windowY;
            } else {
                buttonSprite.x = buttonSettings.x + paddingLeft;
                buttonSprite.y = buttonSettings.y + paddingTop;
            }
            this._buttonSprites.push(buttonSprite);
            this.addChild(buttonSprite);
        }
    };

    Window_SaveLoadCustom.prototype._selectSlot = function(index, noScroll, noSound) {
        if (index < 0 || index >= this._slotSprites.length) return;
        
        var oldIndex = this._selectedSlotIndex;
        this._selectedSlotIndex = index;
        
        for (var i = 0; i < this._slotSprites.length; i++) {
            this._slotSprites[i].setSelected(i === index);
        }
        
        if (!noScroll) {
            this._scrollToSlot(index);
        }
        
        if (oldIndex !== index && !noSound) {
            SoundManager.playCursor();
        }
    };

    Window_SaveLoadCustom.prototype.getSelectedSlotId = function() {
        if (this._selectedSlotIndex >= 0 && this._selectedSlotIndex < this._slotSprites.length) {
            return this._slotSprites[this._selectedSlotIndex]._settings.slotId;
        }
        return 1;
    };

    Window_SaveLoadCustom.prototype._hasSlotData = function(index) {
        if (index < 0 || index >= this._slotSprites.length) return false;
        var slotId = this._slotSprites[index]._settings.slotId;
        var info = DataManager.savefileInfo(slotId);
        return !!info;
    };

    Window_SaveLoadCustom.prototype._canSelectSlot = function(index) {
        if (this._sceneType === 'save') {
            return true;
        }
        return this._hasSlotData(index);
    };

    Window_SaveLoadCustom.prototype._findLatestSaveSlot = function() {
        var latestIndex = -1;
        var latestTimestamp = 0;
        
        for (var i = 0; i < this._slotSprites.length; i++) {
            var slotId = this._slotSprites[i]._settings.slotId;
            var info = DataManager.savefileInfo(slotId);
            
            if (info && info.timestamp) {
                if (info.timestamp > latestTimestamp) {
                    latestTimestamp = info.timestamp;
                    latestIndex = i;
                }
            }
        }
        
        return latestIndex;
    };

    Window_SaveLoadCustom.prototype._findNextValidSlot = function(startIndex, direction, maxSteps) {
        maxSteps = maxSteps || this._slotSprites.length;
        var index = startIndex;
        
        for (var i = 0; i < maxSteps; i++) {
            index += direction;
            
            if (index < 0) index = this._slotSprites.length - 1;
            if (index >= this._slotSprites.length) index = 0;
            
            if (this._hasSlotData(index)) {
                return index;
            }
            
            if (index === startIndex) break;
        }
        
        return startIndex;
    };

    Window_SaveLoadCustom.prototype.refreshAllSlots = function() {
        for (var i = 0; i < this._slotSprites.length; i++) {
            var slot = this._slotSprites[i];
            if (slot && slot._refreshContents) {
                slot._screenshotLoaded = false;
                slot._refreshContents();
            }
        }
    };

    Window_SaveLoadCustom.prototype.update = function() {
        Window_Base.prototype.update.call(this);
        if (this._isProcessing) return;
        this._processInput();
        this._processMouseWheel();
        this._processScrollBarDrag();
        this._updateSlotContainerPosition();
    };

    Window_SaveLoadCustom.prototype.setProcessing = function(processing) {
        this._isProcessing = processing;
    };

    Window_SaveLoadCustom.prototype._processMouseWheel = function() {
        if (!this._isReady || this._maxScrollY <= 0) return;
        
        var wheelY = TouchInput.wheelY;
        if (wheelY !== 0) {
            var scrollSpeed = params.scrollSpeed || 20;
            this._scrollY += wheelY > 0 ? scrollSpeed : -scrollSpeed;
            this._scrollY = Math.max(0, Math.min(this._maxScrollY, this._scrollY));
            this._updateScrollBar();
        }
    };

    Window_SaveLoadCustom.prototype._processScrollBarDrag = function() {
        if (!this._isReady || this._maxScrollY <= 0) return;
        
        var settings = this._settings;
        var paddingTop = settings.windowPaddingTop || 0;
        var paddingBottom = settings.windowPaddingBottom || 0;
        var paddingRight = settings.windowPaddingRight || 0;
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var scrollBarWidth = sbSettings.width || 12;
        var viewHeight = this.height - paddingTop - paddingBottom;
        
        var localX = TouchInput.x - this.x;
        var localY = TouchInput.y - this.y;
        
        if (this._isDraggingScrollBar) {
            if (TouchInput.isPressed()) {
                var thumbHeight = this._getScrollBarThumbHeight();
                var deltaY = localY - this._dragStartY;
                var scrollRatio = deltaY / (viewHeight - thumbHeight);
                var newScrollY = this._dragStartScrollY + scrollRatio * this._maxScrollY;
                this._scrollY = Math.max(0, Math.min(this._maxScrollY, newScrollY));
                this._updateScrollBar();
            } else {
                this._isDraggingScrollBar = false;
            }
            return;
        }
        
        var isNewPress = TouchInput.isTriggered() || 
                         (TouchInput.isPressed() && !this._wasScrollBarPressed);
        
        if (isNewPress) {
            if (this._isInsideScrollBarThumb(localX, localY)) {
                this._isDraggingScrollBar = true;
                this._dragStartY = localY;
                this._dragStartScrollY = this._scrollY;
            } else if (this._isInsideScrollBarArea(localX, localY)) {
                this._scrollToPosition(localY - paddingTop);
            }
        }
        
        this._wasScrollBarPressed = TouchInput.isPressed();
    };

    Window_SaveLoadCustom.prototype._getScrollBarThumbHeight = function() {
        if (this._scrollBarThumbHeight) {
            return this._scrollBarThumbHeight;
        }
        var settings = this._settings;
        var paddingTop = settings.windowPaddingTop || 0;
        var paddingBottom = settings.windowPaddingBottom || 0;
        var viewHeight = this.height - paddingTop - paddingBottom;
        return Math.max(20, viewHeight * (viewHeight / (viewHeight + this._maxScrollY)));
    };

    Window_SaveLoadCustom.prototype._isInsideScrollBarThumb = function(localX, localY) {
        var settings = this._settings;
        var paddingTop = settings.windowPaddingTop || 0;
        var paddingBottom = settings.windowPaddingBottom || 0;
        var paddingRight = settings.windowPaddingRight || 0;
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var scrollBarWidth = sbSettings.width || 12;
        var offsetX = sbSettings.offsetX || 0;
        var viewHeight = this.height - paddingTop - paddingBottom;
        
        var scrollBarX = this.width - paddingRight - scrollBarWidth + offsetX;
        var thumbHeight = this._getScrollBarThumbHeight();
        var scrollRatio = this._scrollY / this._maxScrollY;
        var maxThumbY = viewHeight - thumbHeight;
        var thumbY = paddingTop + maxThumbY * scrollRatio;
        
        return localX >= scrollBarX && localX < scrollBarX + scrollBarWidth &&
               localY >= thumbY && localY < thumbY + thumbHeight;
    };

    Window_SaveLoadCustom.prototype._isInsideScrollBarArea = function(localX, localY) {
        var settings = this._settings;
        var paddingTop = settings.windowPaddingTop || 0;
        var paddingBottom = settings.windowPaddingBottom || 0;
        var paddingRight = settings.windowPaddingRight || 0;
        var sbSettings = this._scrollBarConfig || this._getScrollBarSettings();
        var scrollBarWidth = sbSettings.width || 12;
        var offsetX = sbSettings.offsetX || 0;
        var viewHeight = this.height - paddingTop - paddingBottom;
        
        var scrollBarX = this.width - paddingRight - scrollBarWidth + offsetX;
        
        return localX >= scrollBarX && localX < scrollBarX + scrollBarWidth &&
               localY >= paddingTop && localY < paddingTop + viewHeight;
    };

    Window_SaveLoadCustom.prototype._scrollToPosition = function(posY) {
        var settings = this._settings;
        var paddingTop = settings.windowPaddingTop || 0;
        var paddingBottom = settings.windowPaddingBottom || 0;
        var viewHeight = this.height - paddingTop - paddingBottom;
        var thumbHeight = this._getScrollBarThumbHeight();
        
        var scrollRatio = (posY - thumbHeight / 2) / (viewHeight - thumbHeight);
        scrollRatio = Math.max(0, Math.min(1, scrollRatio));
        this._scrollY = scrollRatio * this._maxScrollY;
        this._updateScrollBar();
    };

    Window_SaveLoadCustom.prototype._updateSlotContainerPosition = function() {
        if (this._slotContainer) {
            this._slotContainer.y = -this._scrollY;
        }
    };

    Window_SaveLoadCustom.prototype._scrollToSlot = function(index) {
        if (this._maxScrollY <= 0) return;
        
        var settings = this._settings;
        var template = settings.slotTemplate;
        if (!template) return;
        
        var paddingTop = settings.windowPaddingTop || 0;
        var paddingBottom = settings.windowPaddingBottom || 0;
        var columns = template.columns || 1;
        var row = Math.floor(index / columns);
        
        var slotHeight = template.height || 90;
        if (this._slotSprites.length > 0 && this._slotSprites[0]._settings.actualHeight) {
            slotHeight = this._slotSprites[0]._settings.actualHeight;
        }
        
        var offsetY = template.offsetY !== undefined ? template.offsetY : 10;
        var slotY = (template.y || 0) + paddingTop + row * (slotHeight + offsetY);
        var slotBottom = slotY + slotHeight;
        
        var viewTop = this._scrollY;
        var viewBottom = this._scrollY + this.height - paddingTop - paddingBottom;
        
        if (slotY < viewTop + paddingTop) {
            this._scrollY = slotY - paddingTop;
        }
        else if (slotBottom > viewBottom + paddingTop) {
            this._scrollY = slotBottom - (this.height - paddingTop - paddingBottom);
        }
        
        this._scrollY = Math.max(0, Math.min(this._maxScrollY, this._scrollY));
        this._updateScrollBar();
    };

    Window_SaveLoadCustom.prototype._processInput = function() {
        if (!this._isReady) return;
        
        if (Input.isRepeated('up')) {
            this._moveCursorVertical(-1);
        } else if (Input.isRepeated('down')) {
            this._moveCursorVertical(1);
        } else if (Input.isRepeated('left')) {
            this._moveCursorHorizontal(-1);
        } else if (Input.isRepeated('right')) {
            this._moveCursorHorizontal(1);
        }
        
        if (Input.isTriggered('ok')) {
            this._onConfirm();
        }
        
        if (Input.isTriggered('cancel')) {
            this._onBack();
        }
        
        if (TouchInput.isCancelled()) {
            this._onBack();
        }
    };

    Window_SaveLoadCustom.prototype._moveCursor = function(direction) {
        var newIndex = this._selectedSlotIndex + direction;
        if (newIndex < 0) newIndex = this._slotSprites.length - 1;
        if (newIndex >= this._slotSprites.length) newIndex = 0;
        this._selectSlot(newIndex);
    };

    Window_SaveLoadCustom.prototype._moveCursorVertical = function(direction) {
        var columns = this._settings.slotTemplate ? this._settings.slotTemplate.columns || 1 : 1;
        var startIndex = this._selectedSlotIndex;
        var newIndex = startIndex;
        
        for (var i = 0; i < this._slotSprites.length; i++) {
            newIndex += direction * columns;
            
            if (newIndex < 0) {
                var col = startIndex % columns;
                var lastRowStartIndex = Math.floor((this._slotSprites.length - 1) / columns) * columns;
                newIndex = Math.min(lastRowStartIndex + col, this._slotSprites.length - 1);
            } else if (newIndex >= this._slotSprites.length) {
                newIndex = startIndex % columns;
            }
            
            if (this._canSelectSlot(newIndex) || newIndex === startIndex) {
                break;
            }
            
            startIndex = newIndex;
        }
        
        if (this._canSelectSlot(newIndex)) {
            this._selectSlot(newIndex);
        }
    };

    Window_SaveLoadCustom.prototype._moveCursorHorizontal = function(direction) {
        var columns = this._settings.slotTemplate ? this._settings.slotTemplate.columns || 1 : 1;
        if (columns <= 1) return;
        
        var currentRow = Math.floor(this._selectedSlotIndex / columns);
        var currentCol = this._selectedSlotIndex % columns;
        var startIndex = this._selectedSlotIndex;
        var newIndex = startIndex;
        
        for (var i = 0; i < columns; i++) {
            var newCol = (currentCol + direction * (i + 1)) % columns;
            if (newCol < 0) newCol += columns;
            
            newIndex = currentRow * columns + newCol;
            if (newIndex >= this._slotSprites.length) {
                newIndex = currentRow * columns;
            }
            
            if (this._canSelectSlot(newIndex) || newIndex === startIndex) {
                break;
            }
        }
        
        if (this._canSelectSlot(newIndex)) {
            this._selectSlot(newIndex);
        }
    };

    Window_SaveLoadCustom.prototype._onConfirm = function() {
        var scene = SceneManager._scene;
        if (scene && scene.onCustomSlotConfirm) {
            scene.onCustomSlotConfirm(this.getSelectedSlotId());
        }
    };

    Window_SaveLoadCustom.prototype._onBack = function() {
        var scene = SceneManager._scene;
        if (scene && scene.onCustomBack) {
            scene.onCustomBack();
        }
    };

    Window_SaveLoadCustom.prototype._onPrevSlot = function() {
        this._moveCursor(-1);
    };

    Window_SaveLoadCustom.prototype._onNextSlot = function() {
        this._moveCursor(1);
    };

    Window_SaveLoadCustom.prototype._onGotoSave = function() {
        var scene = SceneManager._scene;
        if (scene && scene.onGotoSave) {
            scene.onGotoSave(this);
        }
    };

    Window_SaveLoadCustom.prototype._onGotoLoad = function() {
        var scene = SceneManager._scene;
        if (scene && scene.onGotoLoad) {
            scene.onGotoLoad(this);
        }
    };

    Window_SaveLoadCustom.prototype.switchMode = function(newSceneType, newSettings) {
        if (this._sceneType === newSceneType) {
            return;
        }
        
        var oldSceneType = this._sceneType;
        this._sceneType = newSceneType;
        
        
        for (var i = 0; i < this._buttonSprites.length; i++) {
            this.removeChild(this._buttonSprites[i]);
        }
        this._buttonSprites = [];
        
        
        if (newSettings && newSettings.buttonElements) {
            this._settings.buttonElements = JSON.parse(JSON.stringify(newSettings.buttonElements));
        }
        
        this._createButtonElements();
        
        
        if (newSettings && newSettings.textElements) {
            this._settings.textElements = JSON.parse(JSON.stringify(newSettings.textElements));
            
            this.contents.clear();
            this._createTextElements();
        }
        
        
        if (newSettings && newSettings.windowImage) {
            this._settings.windowImage = newSettings.windowImage;
            this._updateWindowImage(newSettings.windowImage);
        }
        
        
        if (newSceneType === 'load') {
            if (!this._canSelectSlot(this._selectedSlotIndex)) {
                var latestIndex = this._findLatestSaveSlot();
                if (latestIndex >= 0) {
                    this._selectSlot(latestIndex, false, true);
                }
            }
        }
        
        
        for (var j = 0; j < this._slotSprites.length; j++) {
            this._slotSprites[j].setSelected(j === this._selectedSlotIndex);
        }
        
        var scene = SceneManager._scene;
        if (scene && scene.onModeChanged) {
            scene.onModeChanged(oldSceneType, newSceneType, newSettings);
        }
    };

    function Sprite_SaveSlot() {
        this.initialize.apply(this, arguments);
    }

    Sprite_SaveSlot.prototype = Object.create(Sprite.prototype);
    Sprite_SaveSlot.prototype.constructor = Sprite_SaveSlot;

    Sprite_SaveSlot.prototype.initialize = function(settings, parentWindow) {
        Sprite.prototype.initialize.call(this);
        this._settings = settings;
        this._parentWindow = parentWindow;
        this._isSelected = false;
        this._isHovered = false;
        this._backgroundBitmaps = {};
        
        this._loadBackgroundImages();
        this._createContents();
    };

    Sprite_SaveSlot.prototype._loadBackgroundImages = function() {
        var settings = this._settings;
        var self = this;
        
        if (settings.backgroundImage) {
            var bitmap = ImageManager.loadBitmap('img/customwindow/', settings.backgroundImage);
            bitmap.addLoadListener(function() {
                self._backgroundBitmaps.empty = bitmap;
                self._updateBackground();
            });
        }
        
        if (settings.backgroundImageUsed) {
            var bitmapUsed = ImageManager.loadBitmap('img/customwindow/', settings.backgroundImageUsed);
            bitmapUsed.addLoadListener(function() {
                self._backgroundBitmaps.used = bitmapUsed;
                self._updateBackground();
            });
        }
        
        if (settings.backgroundImageSelected) {
            var bitmapSelected = ImageManager.loadBitmap('img/customwindow/', settings.backgroundImageSelected);
            bitmapSelected.addLoadListener(function() {
                self._backgroundBitmaps.selected = bitmapSelected;
                self._updateBackground();
            });
        }
        
        if (settings.selectionFrameImage) {
            var bitmapFrame = ImageManager.loadBitmap('img/customwindow/', settings.selectionFrameImage);
            bitmapFrame.addLoadListener(function() {
                self._backgroundBitmaps.selectionFrame = bitmapFrame;
                self._updateSelectionFrame();
            });
        }
    };

    Sprite_SaveSlot.prototype._createContents = function() {
        var settings = this._settings;
        var self = this;
        
        this._screenshotSprite = new Sprite();
        this.addChild(this._screenshotSprite);
        
        this._backgroundSprite = new Sprite();
        this.addChild(this._backgroundSprite);
        
        this._selectionFrameSprite = new Sprite();
        this._selectionFrameSprite.x = settings.selectionFrameOffsetX || 0;
        this._selectionFrameSprite.y = settings.selectionFrameOffsetY || 0;
        this._selectionFrameSprite.visible = false;
        this.addChild(this._selectionFrameSprite);
        
        var bgImageName = settings.backgroundImageUsed || settings.backgroundImage;
        if (bgImageName) {
            var bgBitmap = ImageManager.loadBitmap('img/customwindow/', bgImageName);
            bgBitmap.addLoadListener(function() {
                
                self._settings.actualWidth = bgBitmap.width;
                self._settings.actualHeight = bgBitmap.height;
                
                self._contentsBitmap = new Bitmap(bgBitmap.width, bgBitmap.height);
                self._contentsSprite = new Sprite(self._contentsBitmap);
                self.addChild(self._contentsSprite);
                self._refreshContents();
            });
        } else {
            this._settings.actualWidth = settings.width;
            this._settings.actualHeight = settings.height;
            this._contentsBitmap = new Bitmap(settings.width, settings.height);
            this._contentsSprite = new Sprite(this._contentsBitmap);
            this.addChild(this._contentsSprite);
            this._refreshContents();
        }
    };

    Sprite_SaveSlot.prototype._drawTextWithScale = function(text, x, y, width, height, align, scaleX) {
        scaleX = scaleX || 1.0;
        
        if (scaleX !== 1.0 && scaleX > 0) {
            var tempWidth = Math.ceil(width);
            var tempBitmap = new Bitmap(tempWidth, height);
            
            tempBitmap.fontSize = this._contentsBitmap.fontSize;
            tempBitmap.textColor = this._contentsBitmap.textColor;
            tempBitmap.outlineWidth = this._contentsBitmap.outlineWidth;
            tempBitmap.outlineColor = this._contentsBitmap.outlineColor;
            tempBitmap.fontFace = this._contentsBitmap.fontFace;
            if (tempBitmap._makeFontNameText) {
                tempBitmap.font = tempBitmap._makeFontNameText();
            }
            
            tempBitmap.drawText(text, 0, 0, tempWidth, height, align);
            
            var context = this._contentsBitmap.context;
            context.save();
            context.imageSmoothingEnabled = false;
            context.drawImage(
                tempBitmap.canvas,
                0, 0, tempWidth, height,
                x, y, Math.ceil(tempWidth * scaleX), height
            );
            context.restore();
        } else {
            this._contentsBitmap.drawText(text, x, y, width, height, align);
        }
    };

    Sprite_SaveSlot.prototype._refreshContents = function() {
        var settings = this._settings;
        var slotId = settings.slotId;
        var info = DataManager.savefileInfo(slotId);
        
        this._contentsBitmap.clear();
        
        var fontSize = 20;
        var textColor = '#ffffff';
        var outlineColor = '#000000';
        var outlineWidth = 3;
        var fontName = '';
        
        if (settings.textPresetId && params.textPresets[settings.textPresetId]) {
            var preset = params.textPresets[settings.textPresetId];
            fontSize = preset.fontSize || fontSize;
            textColor = preset.textColor || textColor;
            outlineColor = preset.outlineColor || outlineColor;
            outlineWidth = preset.outlineWidth !== undefined ? preset.outlineWidth : outlineWidth;
            fontName = preset.fontName || fontName;
            if (fontName) {
                fontName = fontName.replace(/\.(ttf|otf|woff|woff2)$/i, '');
            }
        }
        
        this._contentsBitmap.fontSize = fontSize;
        this._contentsBitmap.textColor = textColor;
        this._contentsBitmap.outlineWidth = outlineWidth;
        this._contentsBitmap.outlineColor = outlineWidth === 0 ? 'rgba(0, 0, 0, 0)' : outlineColor;
        if (fontName) {
            this._contentsBitmap.fontFace = fontName;
            this._contentsBitmap.fontSize = fontSize;
            if (this._contentsBitmap._makeFontNameText) {
                this._contentsBitmap.font = this._contentsBitmap._makeFontNameText();
            }
        }
        
        if (info) {
            if (settings.showPlaytime && info.playtime) {
                this._contentsBitmap.fontSize = fontSize;
                this._contentsBitmap.textColor = textColor;
                this._contentsBitmap.outlineWidth = outlineWidth;
                this._contentsBitmap.outlineColor = outlineWidth === 0 ? 'rgba(0, 0, 0, 0)' : outlineColor;
                if (fontName) {
                    this._contentsBitmap.fontFace = fontName;
                    this._contentsBitmap.fontSize = fontSize;
                    if (this._contentsBitmap._makeFontNameText) {
                        this._contentsBitmap.font = this._contentsBitmap._makeFontNameText();
                    }
                }
                
                var actualWidth = settings.actualWidth || settings.width;
                this._drawTextWithScale(
                    info.playtime,
                    settings.playtimeX,
                    settings.playtimeY,
                    actualWidth - settings.playtimeX,
                    fontSize + 4,
                    'left',
                    settings.playtimeScaleX || 1.0
                );
            }
            
            if (settings.showTimestamp && info.timestamp) {
                this._contentsBitmap.fontSize = fontSize;
                this._contentsBitmap.textColor = textColor;
                this._contentsBitmap.outlineWidth = outlineWidth;
                this._contentsBitmap.outlineColor = outlineWidth === 0 ? 'rgba(0, 0, 0, 0)' : outlineColor;
                if (fontName) {
                    this._contentsBitmap.fontFace = fontName;
                    this._contentsBitmap.fontSize = fontSize;
                    if (this._contentsBitmap._makeFontNameText) {
                        this._contentsBitmap.font = this._contentsBitmap._makeFontNameText();
                    }
                }
                
                var date = new Date(info.timestamp);
                var actualWidth = settings.actualWidth || settings.width;
                
                if (settings.timestampSplit) {
                    var year = date.getFullYear();
                    var month = (date.getMonth() + 1).toString().padStart(2, '0');
                    var day = date.getDate().toString().padStart(2, '0');
                    var hours = date.getHours().toString().padStart(2, '0');
                    var minutes = date.getMinutes().toString().padStart(2, '0');
                    var seconds = date.getSeconds().toString().padStart(2, '0');
                    
                    var dateLine = year + '/' + month + '/' + day;
                    var timeLine = hours + ':' + minutes + ':' + seconds;
                    
                    var dateLineWidth = this._contentsBitmap.measureTextWidth(dateLine);
                    var timeLineWidth = this._contentsBitmap.measureTextWidth(timeLine);
                    
                    this._drawTextWithScale(
                        dateLine,
                        settings.timestampX,
                        settings.timestampY,
                        actualWidth - settings.timestampX,
                        fontSize + 4,
                        'left',
                        settings.timestampScaleX || 1.0
                    );
                    
                    var lineHeight = settings.timestampLineHeight || 24;
                    var scaleX = settings.timestampScaleX || 1.0;
                    var centerOffset = (dateLineWidth * scaleX - timeLineWidth * scaleX) / 2;
                    
                    this._drawTextWithScale(
                        timeLine,
                        settings.timestampX + centerOffset,
                        settings.timestampY + lineHeight,
                        actualWidth - settings.timestampX - centerOffset,
                        fontSize + 4,
                        'left',
                        scaleX
                    );
                } else {
                    var dateStr = date.toLocaleString();
                    this._drawTextWithScale(
                        dateStr,
                        settings.timestampX,
                        settings.timestampY,
                        actualWidth - settings.timestampX,
                        fontSize + 4,
                        'left',
                        settings.timestampScaleX || 1.0
                    );
                }
            }
            
            if (settings.showScreenshot) {
                this._drawScreenshot(slotId, settings);
            }
            if (settings.textElements && settings.textElements.length > 0) {
                this._drawTextElements(slotId, settings, info);
            }
            if (settings.gaugeElements && settings.gaugeElements.length > 0) {
                this._drawGaugeElements(slotId, settings, info);
            }
        }
    };

    Sprite_SaveSlot.prototype._drawGaugeElements = function(slotId, settings, info) {
        var self = this;
        var gaugeElements = settings.gaugeElements;
        
        if (!gaugeElements || gaugeElements.length === 0) {
            return;
        }
        
        for (var i = 0; i < gaugeElements.length; i++) {
            var elem = gaugeElements[i];
            
            if (elem.backgroundImage) {
                var bgBitmap = ImageManager.loadBitmap('img/customwindow/', elem.backgroundImage);
                
                if (bgBitmap.isReady() && bgBitmap.width > 0 && bgBitmap.height > 0) {
                    this._contentsBitmap.blt(bgBitmap, 0, 0, bgBitmap.width, bgBitmap.height, elem.x, elem.y);
                } else if (!bgBitmap.isReady()) {
                    bgBitmap.addLoadListener(function() {
                        self._refreshContents();
                    });
                    return;
                }
            }
            
            var currentValue = this._getVariableFromSaveData(slotId, elem.currentVariableId);
            var maxValue = this._getVariableFromSaveData(slotId, elem.maxVariableId);
            
            var hasValidValues = (currentValue !== null && maxValue !== null && maxValue > 0);
            
            if (hasValidValues) {
                var rate = Math.max(0, Math.min(1, currentValue / maxValue));
                
                if (elem.gaugeImage) {
                    var gaugeBitmap = ImageManager.loadBitmap('img/customwindow/', elem.gaugeImage);
                    
                    if (gaugeBitmap.isReady() && gaugeBitmap.width > 0 && gaugeBitmap.height > 0) {
                        var srcWidth, srcHeight, destX, destY;
                        
                        if (elem.direction === 'vertical') {
                            srcWidth = gaugeBitmap.width;
                            srcHeight = Math.floor(gaugeBitmap.height * rate);
                            var offsetY = gaugeBitmap.height - srcHeight;
                            destX = elem.x;
                            destY = elem.y + offsetY;
                            this._contentsBitmap.blt(gaugeBitmap, 0, offsetY, srcWidth, srcHeight, destX, destY);
                        } else {
                            srcWidth = Math.floor(gaugeBitmap.width * rate);
                            srcHeight = gaugeBitmap.height;
                            destX = elem.x;
                            destY = elem.y;
                            this._contentsBitmap.blt(gaugeBitmap, 0, 0, srcWidth, srcHeight, destX, destY);
                        }
                    } else if (!gaugeBitmap.isReady()) {
                        gaugeBitmap.addLoadListener(function() {
                            self._refreshContents();
                        });
                        return;
                    }
                }
            }
            
            if (elem.overlayImage) {
                var overlayBitmap = ImageManager.loadBitmap('img/customwindow/', elem.overlayImage);
                
                if (overlayBitmap.isReady() && overlayBitmap.width > 0 && overlayBitmap.height > 0) {
                    var overlayX = elem.x + (elem.overlayOffsetX || 0);
                    var overlayY = elem.y + (elem.overlayOffsetY || 0);
                    this._contentsBitmap.blt(overlayBitmap, 0, 0, overlayBitmap.width, overlayBitmap.height, overlayX, overlayY);
                } else if (!overlayBitmap.isReady()) {
                    overlayBitmap.addLoadListener(function() {
                        self._refreshContents();
                    });
                    return;
                }
            }
        }
    };

    Sprite_SaveSlot.prototype._drawTextElements = function(slotId, settings, info) {
        var self = this;
        var textElements = settings.textElements;
        
        if (!textElements || textElements.length === 0) {
            return;
        }
        
        for (var i = 0; i < textElements.length; i++) {
            var elem = textElements[i];
            var text = elem.text || '';
            
            text = text.replace(/%s/g, String(slotId));
            
            if (elem.variableId > 0) {
                var variableValue = this._getVariableFromSaveData(slotId, elem.variableId);
                if (variableValue === null) {
                    variableValue = 0;
                }
                text = text.replace(/%v/g, String(variableValue));
                if (elem.text === '' || elem.text === '%v') {
                    text = String(variableValue);
                }
            }
            
            var fontSize = 20;
            var textColor = '#ffffff';
            var outlineColor = '#000000';
            var outlineWidth = 3;
            var fontName = '';
            
            var presetId = elem.textPresetId || settings.textPresetId;
            if (presetId && params.textPresets[presetId]) {
                var preset = params.textPresets[presetId];
                fontSize = preset.fontSize || fontSize;
                textColor = preset.textColor || textColor;
                outlineColor = preset.outlineColor || outlineColor;
                outlineWidth = preset.outlineWidth !== undefined ? preset.outlineWidth : outlineWidth;
                fontName = preset.fontName || fontName;
                if (fontName) {
                    fontName = fontName.replace(/\.(ttf|otf|woff|woff2)$/i, '');
                }
            }
            
            if (elem.fontSize && elem.fontSize > 0) {
                fontSize = elem.fontSize;
            }
            
            this._contentsBitmap.fontSize = fontSize;
            this._contentsBitmap.textColor = textColor;
            this._contentsBitmap.outlineWidth = outlineWidth;
            this._contentsBitmap.outlineColor = outlineWidth === 0 ? 'rgba(0, 0, 0, 0)' : outlineColor;
            if (fontName) {
                this._contentsBitmap.fontFace = fontName;
                this._contentsBitmap.fontSize = fontSize;
                if (this._contentsBitmap._makeFontNameText) {
                    this._contentsBitmap.font = this._contentsBitmap._makeFontNameText();
                }
            }
            
            var actualWidth = settings.actualWidth || settings.width;
            var width = elem.width > 0 ? elem.width : (actualWidth - elem.x);
            var align = elem.textAlign || 'left';
            var scaleX = elem.scaleX || 1.0;
            
            this._drawTextWithScale(text, elem.x, elem.y, width, fontSize + 4, align, scaleX);
        }
    };

    var _saveDataVariablesCache = {};

    Sprite_SaveSlot.prototype._getVariableFromSaveData = function(slotId, variableId) {
        var cacheKey = slotId + '_' + variableId;
        if (_saveDataVariablesCache[cacheKey] !== undefined) {
            return _saveDataVariablesCache[cacheKey];
        }

        var info = null;
        
        if (DataManager.savefileInfo) {
            info = DataManager.savefileInfo(slotId);
        }
        else if (DataManager.loadGlobalInfo) {
            var globalInfo = DataManager.loadGlobalInfo();
            if (globalInfo && globalInfo[slotId]) {
                info = globalInfo[slotId];
            }
        }
        
        if (!info) {
            _saveDataVariablesCache[cacheKey] = null;
            return null;
        }
        
        var result = null;
        
        if (info.variables && info.variables[variableId] !== undefined) {
            result = info.variables[variableId];
        }
        _saveDataVariablesCache[cacheKey] = result;
        return result;
    };

    Sprite_SaveSlot.clearVariablesCache = function() {
        _saveDataVariablesCache = {};
    };

    Sprite_SaveSlot.prototype._drawScreenshot = function(slotId, settings) {
        this._screenshotLoaded = false;
        this._screenshotSlotId = slotId;
    };
    
    Sprite_SaveSlot.prototype._loadScreenshot = function() {
        if (this._screenshotLoaded) return;
        this._screenshotLoaded = true;
        
        var self = this;
        var settings = this._settings;
        var slotId = this._screenshotSlotId;
        var x = settings.screenshotX;
        var y = settings.screenshotY;
        var width = settings.screenshotWidth;
        var height = settings.screenshotHeight;
        
        var bitmapWidth = settings.actualWidth || settings.width;
        var bitmapHeight = settings.actualHeight || settings.height;
        
        if (!this._screenshotBitmap) {
            this._screenshotBitmap = new Bitmap(bitmapWidth, bitmapHeight);
            this._screenshotSprite.bitmap = this._screenshotBitmap;
        }
        
        this._screenshotBitmap.clear();
        
        try {
            var snapshot = null;
            
            if (DataManager.savefileInfo) {
                var info = DataManager.savefileInfo(slotId);
                if (info && info.snapshot) {
                    snapshot = info.snapshot;
                }
            }
            else if (DataManager.loadGlobalInfo) {
                var globalInfo = DataManager.loadGlobalInfo();
                if (globalInfo && globalInfo[slotId] && globalInfo[slotId].snapshot) {
                    snapshot = globalInfo[slotId].snapshot;
                }
            }
            
            if (snapshot) {
                var img = new Image();
                img.onload = function() {
                    var context = self._screenshotBitmap._context || self._screenshotBitmap.context;
                    if (context) {
                        context.drawImage(img, 0, 0, img.width, img.height, x, y, width, height);
                        if (self._screenshotBitmap._baseTexture && self._screenshotBitmap._baseTexture.update) {
                            self._screenshotBitmap._baseTexture.update();
                        }
                    }
                };
                img.onerror = function(e) {
                    console.error('[_loadScreenshot] Image load error:', e);
                };
                img.src = snapshot;
            }
        } catch (e) {
            console.warn('CustomWindow: Failed to load screenshot for slot', slotId, e);
        }
    };
    
    Sprite_SaveSlot.prototype._unloadScreenshot = function() {
        if (this._screenshotBitmap) {
            this._screenshotBitmap.clear();
        }
        this._screenshotLoaded = false
    };

    Sprite_SaveSlot.prototype.setSelected = function(selected) {
        this._isSelected = selected;
        this._updateBackground();
        this._updateSelectionFrame();
    };

    Sprite_SaveSlot.prototype._updateSelectionFrame = function() {
        if (!this._selectionFrameSprite) return;
        
        if (this._isSelected && this._backgroundBitmaps.selectionFrame) {
            this._selectionFrameSprite.bitmap = this._backgroundBitmaps.selectionFrame;
            this._selectionFrameSprite.visible = true;
        } else {
            this._selectionFrameSprite.visible = false;
        }
    };

    Sprite_SaveSlot.prototype._updateBackground = function() {
        var settings = this._settings;
        var slotId = settings.slotId;
        var info = DataManager.savefileInfo(slotId);
        
        var bgBitmap = null;
        
        if (!info) {
            bgBitmap = this._backgroundBitmaps.empty;
        } else if (this._isSelected && this._backgroundBitmaps.selected) {
            bgBitmap = this._backgroundBitmaps.selected;
        } else if (this._backgroundBitmaps.used) {
            bgBitmap = this._backgroundBitmaps.used;
        }
        
        if (bgBitmap && this._backgroundSprite) {
            this._backgroundSprite.bitmap = bgBitmap;
        }
    };

    Sprite_SaveSlot.prototype.update = function() {
        Sprite.prototype.update.call(this);
        this._updateHover();
        this._updateClick();
        this._updateScreenshotLoading();
    };
    
    Sprite_SaveSlot.prototype._updateScreenshotLoading = function() {
        if (!this._settings.showScreenshot) return;
        
        var parentWindow = this._parentWindow;
        if (!parentWindow) return;
        
        var scrollY = parentWindow._scrollY || 0;
        var slotY = this.y - scrollY;
        var slotHeight = this._settings.actualHeight || this._settings.height;
        
        var windowSettings = parentWindow._settings || {};
        var paddingTop = windowSettings.windowPaddingTop || 0;
        var paddingBottom = windowSettings.windowPaddingBottom || 0;
        var viewTop = paddingTop;
        var viewBottom = parentWindow.height - paddingBottom;
        var slotBottom = slotY + slotHeight;
        var slotTop = slotY;
        var isCompletelyOutside = (slotBottom <= viewTop || slotTop >= viewBottom);
        var isVisible = !isCompletelyOutside;
        
        if (isVisible && !this._screenshotLoaded) {
            this._loadScreenshot();
        } else if (!isVisible && this._screenshotLoaded) {
            this._unloadScreenshot();
        }
    };

    Sprite_SaveSlot.prototype._updateHover = function() {
        if (this._parentWindow && this._parentWindow._isProcessing) return;
        var mouseX = _customWindowMouseX;
        var mouseY = _customWindowMouseY;
        var parentWindow = this._parentWindow;
        var parentX = parentWindow.x;
        var parentY = parentWindow.y;
        var innerPadding = parentWindow.padding || 0;
        var containerX = parentWindow._slotContainer ? parentWindow._slotContainer.x : 0;
        var containerY = parentWindow._slotContainer ? parentWindow._slotContainer.y : 0;
        var slotWorldX = parentX + innerPadding + containerX + this.x;
        var slotWorldY = parentY + innerPadding + containerY + this.y;
        var localX = mouseX - slotWorldX;
        var localY = mouseY - slotWorldY;
        var settings = this._settings;
        var wasHovered = this._isHovered;
        var hitWidth = this._contentsBitmap ? this._contentsBitmap.width : settings.width;
        var hitHeight = this._contentsBitmap ? this._contentsBitmap.height : settings.height;
        var windowSettings = parentWindow._settings || {};
        var paddingLeft = windowSettings.windowPaddingLeft || 0;
        var paddingTop = windowSettings.windowPaddingTop || 0;
        var paddingRight = windowSettings.windowPaddingRight || 0;
        var paddingBottom = windowSettings.windowPaddingBottom || 0;
        var visibleLeft = parentX + paddingLeft;
        var visibleTop = parentY + paddingTop;
        var visibleRight = parentX + parentWindow.width - paddingRight;
        var visibleBottom = parentY + parentWindow.height - paddingBottom;
        var isMouseInVisibleArea = (mouseX >= visibleLeft && mouseX < visibleRight &&
                                    mouseY >= visibleTop && mouseY < visibleBottom);
        
        this._isHovered = isMouseInVisibleArea &&
                          (localX >= 0 && localX < hitWidth &&
                          localY >= 0 && localY < hitHeight);
        
        if (this._isHovered && !wasHovered) {
            var index = this._parentWindow._slotSprites.indexOf(this);
            if (index >= 0 && this._parentWindow._canSelectSlot(index)) {
                this._parentWindow._selectSlot(index, true);
            }
        }
    };

    Sprite_SaveSlot.prototype._updateClick = function() {
        if (this._parentWindow && this._parentWindow._isProcessing) return;
        if (!this._isHovered) {
            this._isPressed = false;
            return;
        }
        
        var wasPressed = this._isPressed;
        this._isPressed = TouchInput.isPressed();
        
        if (wasPressed && !this._isPressed) {
            this._parentWindow._onConfirm();
        }
    };

    function Sprite_SaveLoadButton() {
        this.initialize.apply(this, arguments);
    }

    Sprite_SaveLoadButton.prototype = Object.create(Sprite.prototype);
    Sprite_SaveLoadButton.prototype.constructor = Sprite_SaveLoadButton;

    Sprite_SaveLoadButton.prototype.initialize = function(settings, parentWindow) {
        Sprite.prototype.initialize.call(this);
        this._settings = settings;
        this._parentWindow = parentWindow;
        this._isHovered = false;
        this._isPressed = false;
        this._bitmaps = {};
        
        this._loadImages();
    };

    Sprite_SaveLoadButton.prototype._loadImages = function() {
        var settings = this._settings;
        var self = this;
        
        if (settings.image) {
            var bitmap = ImageManager.loadBitmap('img/customwindow/', settings.image);
            bitmap.addLoadListener(function() {
                self._bitmaps.normal = bitmap;
                self._updateImage();
            });
        }
        
        if (settings.imageHover) {
            var bitmapHover = ImageManager.loadBitmap('img/customwindow/', settings.imageHover);
            bitmapHover.addLoadListener(function() {
                self._bitmaps.hover = bitmapHover;
            });
        }
        
        if (settings.imagePressed) {
            var bitmapPressed = ImageManager.loadBitmap('img/customwindow/', settings.imagePressed);
            bitmapPressed.addLoadListener(function() {
                self._bitmaps.pressed = bitmapPressed;
            });
        }
    };

    Sprite_SaveLoadButton.prototype._updateImage = function() {
        if (this._isPressed && this._bitmaps.pressed) {
            this.bitmap = this._bitmaps.pressed;
        } else if (this._isHovered && this._bitmaps.hover) {
            this.bitmap = this._bitmaps.hover;
        } else if (this._bitmaps.normal) {
            this.bitmap = this._bitmaps.normal;
        }
    };

    Sprite_SaveLoadButton.prototype.update = function() {
        Sprite.prototype.update.call(this);
        this._updateHover();
        this._updateClick();
    };

    Sprite_SaveLoadButton.prototype._updateHover = function() {
        if (!this.bitmap) return;
        if (this._parentWindow && this._parentWindow._isProcessing) return;
        
        var mouseX = _customWindowMouseX;
        var mouseY = _customWindowMouseY;
        var parentWindow = this._parentWindow;
        var parentX = parentWindow.x;
        var parentY = parentWindow.y;
        var buttonSettings = this._settings || {};
        
        var localX, localY;
        var isMouseInValidArea;
        
        if (buttonSettings.useScreenCoordinates) {
            var buttonScreenX = parentX + this.x;
            var buttonScreenY = parentY + this.y;
            localX = mouseX - buttonScreenX;
            localY = mouseY - buttonScreenY;
            isMouseInValidArea = true;
        } else {
            localX = mouseX - parentX - this.x;
            localY = mouseY - parentY - this.y;
            var windowSettings = parentWindow._settings || {};
            var paddingLeft = windowSettings.windowPaddingLeft || 0;
            var paddingTop = windowSettings.windowPaddingTop || 0;
            var paddingRight = windowSettings.windowPaddingRight || 0;
            var paddingBottom = windowSettings.windowPaddingBottom || 0;
            var visibleLeft = parentX + paddingLeft;
            var visibleTop = parentY + paddingTop;
            var visibleRight = parentX + parentWindow.width - paddingRight;
            var visibleBottom = parentY + parentWindow.height - paddingBottom;
            isMouseInValidArea = (mouseX >= visibleLeft && mouseX < visibleRight &&
                                  mouseY >= visibleTop && mouseY < visibleBottom);
        }
        
        var wasHovered = this._isHovered;
        this._isHovered = isMouseInValidArea &&
                          (localX >= 0 && localX < this.bitmap.width &&
                          localY >= 0 && localY < this.bitmap.height);
        
        if (this._isHovered !== wasHovered) {
            this._updateImage();
        }
    };

    Sprite_SaveLoadButton.prototype._updateClick = function() {
        if (this._parentWindow && this._parentWindow._isProcessing) return;
        if (!this._isHovered) {
            this._isPressed = false;
            return;
        }
        
        var wasPressed = this._isPressed;
        this._isPressed = TouchInput.isPressed();
        
        if (this._isPressed !== wasPressed) {
            this._updateImage();
        }
        
        if (wasPressed && !this._isPressed) {
            this._onClick();
        }
    };

    Sprite_SaveLoadButton.prototype._onClick = function() {
        var settings = this._settings;
        
        if (settings.clickSE) {
            AudioManager.playSe({ name: settings.clickSE, volume: 90, pitch: 100, pan: 0 });
        } else {
            SoundManager.playOk();
        }
        
        switch (settings.action) {
            case 'back':
                this._parentWindow._onBack();
                break;
            case 'confirm':
                this._parentWindow._onConfirm();
                break;
            case 'prevSlot':
                this._parentWindow._onPrevSlot();
                break;
            case 'nextSlot':
                this._parentWindow._onNextSlot();
                break;
            case 'gotoSave':
                this._parentWindow._onGotoSave();
                break;
            case 'gotoLoad':
                this._parentWindow._onGotoLoad();
                break;
        }
    };

    var _Scene_File_create = Scene_File.prototype.create;
    Scene_File.prototype.create = function() {
        _Scene_File_create.call(this);
        this._createSceneBackground();
        this._createCustomSaveLoadWindows();
    };

    var _Scene_File_createHelpWindow = Scene_File.prototype.createHelpWindow;
    Scene_File.prototype.createHelpWindow = function() {
        var settings = this._getCustomWindowSettings();
        if (settings && settings.enabled) {
            var rect = new Rectangle(-1000, 0, 1, 1);
            this._helpWindow = new Window_Help(rect);
            this._helpWindow.visible = false;
            this.addWindow(this._helpWindow);
            return;
        }
        _Scene_File_createHelpWindow.call(this);
    };

    var _Scene_File_createListWindow = Scene_File.prototype.createListWindow;
    Scene_File.prototype.createListWindow = function() {
        var settings = this._getCustomWindowSettings();
        if (settings && settings.enabled) {
            var rect = new Rectangle(-1000, 0, 1, 1);
            this._listWindow = new Window_SavefileList(rect);
            this._listWindow.visible = false;
            this._listWindow.deactivate();
            this.addWindow(this._listWindow);
            return;
        }
        _Scene_File_createListWindow.call(this);
    };

    Scene_File.prototype._createSceneBackground = function() {
        var settings = this._getCustomWindowSettings();
        if (settings && settings.enabled && settings.sceneBackgroundImage) {
            if (this._backgroundSprite) {
                this._backgroundSprite.visible = false;
            }
            
            var bitmap = ImageManager.loadBitmap('img/customwindow/', settings.sceneBackgroundImage);
            this._customSceneBackground = new Sprite(bitmap);
            this._customSceneBackground.x = 0;
            this._customSceneBackground.y = 0;
            this.addChildAt(this._customSceneBackground, 0);
        }
    };

    Scene_File.prototype._updateSceneBackground = function(newSettings) {
        if (!newSettings) return;
        
        var newImage = newSettings.sceneBackgroundImage || '';
        
        if (this._customSceneBackground) {
            this.removeChild(this._customSceneBackground);
            this._customSceneBackground = null;
        }
        
        if (newImage) {
            if (this._backgroundSprite) {
                this._backgroundSprite.visible = false;
            }
            
            var bitmap = ImageManager.loadBitmap('img/customwindow/', newImage);
            this._customSceneBackground = new Sprite(bitmap);
            this._customSceneBackground.x = 0;
            this._customSceneBackground.y = 0;
            this.addChildAt(this._customSceneBackground, 0);
        } else {
            if (this._backgroundSprite) {
                this._backgroundSprite.visible = true;
            }
        }
    };

    Scene_File.prototype._createCustomSaveLoadWindows = function() {
        Sprite_SaveSlot.clearVariablesCache();
        
        this._customSaveLoadWindow = null;
        var sceneType = this._getSceneType();
        var settings = this._getCustomWindowSettings();
        
        if (settings && settings.enabled) {
            var customWindow = new Window_SaveLoadCustom(settings, sceneType);
            this._customSaveLoadWindow = customWindow;
            this.addChild(customWindow);
            
            if (settings.hideDefaultWindows) {
                this._hideDefaultWindows();
            }
        }
    };

    Scene_File.prototype._getSceneType = function() {
        return 'file';
    };

    Scene_File.prototype._getCustomWindowSettings = function() {
        return null;
    };

    Scene_File.prototype._hideDefaultWindows = function() {
        if (this._listWindow) {
            this._listWindow.visible = false;
            this._listWindow.deactivate();
            this._listWindow.deselect();
        }
        if (this._helpWindow) {
            this._helpWindow.visible = false;
        }
    };

    var _Scene_File_start = Scene_File.prototype.start;
    Scene_File.prototype.start = function() {
        var settings = this._getCustomWindowSettings();
        if (settings && settings.enabled && settings.hideDefaultWindows) {
            Scene_MenuBase.prototype.start.call(this);
        } else {
            _Scene_File_start.call(this);
        }
    };

    var _Scene_File_activateListWindow = Scene_File.prototype.activateListWindow;
    Scene_File.prototype.activateListWindow = function() {
        var settings = this._getCustomWindowSettings();
        if (settings && settings.enabled && settings.hideDefaultWindows) {
            return;
        }
        _Scene_File_activateListWindow.call(this);
    };

    Scene_File.prototype.onCustomSlotConfirm = function(slotId) {
    };

    Scene_File.prototype.onCustomBack = function() {
        SoundManager.playCancel();
        this.popScene();
    };

    var _Scene_Save_create = Scene_Save.prototype.create;
    Scene_Save.prototype.create = function() {
        _Scene_Save_create.call(this);
    };

    Scene_Save.prototype._getSceneType = function() {
        return 'save';
    };

    Scene_Save.prototype._getCustomWindowSettings = function() {
        return params.saveScreenSettings;
    };

    Scene_Save.prototype.onCustomSlotConfirm = function(slotId) {
        var currentMode = this._getCurrentSceneType ? this._getCurrentSceneType() : 'save';
        
        if (currentMode === 'load') {
            this._executeLoad(slotId);
            return;
        }
        
        if ($gameSystem.setSavefileId) {
            $gameSystem.setSavefileId(slotId);
        }
        $gameSystem.onBeforeSave();
        
        var self = this;
        var result = DataManager.saveGame(slotId);
        
        if (result && typeof result.then === 'function') {
            result.then(function() {
                SoundManager.playSave();
                Sprite_SaveSlot.clearVariablesCache();
                if (self._customSaveLoadWindow) {
                    self._customSaveLoadWindow.refreshAllSlots();
                }
                self.popScene();
            }).catch(function() {
                SoundManager.playBuzzer();
            });
        }
        else if (result) {
            SoundManager.playSave();
            if (StorageManager.cleanBackup) {
                StorageManager.cleanBackup(slotId);
            }
            Sprite_SaveSlot.clearVariablesCache();
            if (this._customSaveLoadWindow) {
                this._customSaveLoadWindow.refreshAllSlots();
            }
            this.popScene();
        } else {
            SoundManager.playBuzzer();
        }
    };

    Scene_Save.prototype.onGotoLoad = function(customWindow) {
        if (customWindow) {
            var loadSettings = params.loadScreenSettings;
            customWindow.switchMode('load', loadSettings);
            this._customSceneType = 'load';
        }
    };

    Scene_Save.prototype.onGotoSave = function(customWindow) {
        var currentMode = this._customSceneType || 'save';
        if (customWindow && currentMode !== 'save') {
            var saveSettings = params.saveScreenSettings;
            customWindow.switchMode('save', saveSettings);
            this._customSceneType = 'save';
        } else {
        }
    };

    Scene_Save.prototype._getCurrentSceneType = function() {
        return this._customSceneType || 'save';
    };

    Scene_Save.prototype.onModeChanged = function(oldMode, newMode, newSettings) {
        if (this._updateSceneBackground) {
            this._updateSceneBackground(newSettings);
        }
    };

    Scene_Save.prototype._executeLoad = function(slotId) {
        if (this._customSaveLoadWindow) {
            this._customSaveLoadWindow.setProcessing(true);
        }
        if (DataManager.loadGame(slotId)) {
            SoundManager.playLoad();
            this.fadeOutAll();
            
            var isMZ = Utils.RPGMAKER_NAME === 'MZ';
            if (isMZ) {
                if (this.reloadMapIfUpdated) {
                    this.reloadMapIfUpdated();
                }
                SceneManager.goto(Scene_Map);
                if ($gameSystem.onAfterLoad) {
                    $gameSystem.onAfterLoad();
                }
            } else {
                if ($gameSystem.onAfterLoad) {
                    $gameSystem.onAfterLoad();
                }
                SceneManager.goto(Scene_Map);
            }
        } else {
            SoundManager.playBuzzer();
        }
    };

    var _Scene_Load_create = Scene_Load.prototype.create;
    Scene_Load.prototype.create = function() {
        _Scene_Load_create.call(this);
    };

    Scene_Load.prototype._getSceneType = function() {
        return 'load';
    };

    Scene_Load.prototype._getCustomWindowSettings = function() {
        if (this._isFromTitle()) {
            return params.titleLoadScreenSettings.enabled ? params.titleLoadScreenSettings : params.loadScreenSettings;
        }
        return params.loadScreenSettings;
    };

    Scene_Load.prototype._isFromTitle = function() {
        if (SceneManager._previousClass) {
            return SceneManager._previousClass === Scene_Title;
        }
        if (SceneManager._stack && SceneManager._stack.length > 0) {
            var previousScene = SceneManager._stack[SceneManager._stack.length - 1];
            return previousScene === Scene_Title;
        }
        return !$gameParty || !$gameParty.exists();
    };

    Scene_Load.prototype.onGotoSave = function(customWindow) {
        if (customWindow) {
            var saveSettings = params.saveScreenSettings;
            customWindow.switchMode('save', saveSettings);
            this._customSceneType = 'save';
        }
    };

    Scene_Load.prototype.onGotoLoad = function(customWindow) {
        var currentMode = this._customSceneType || 'load';
        if (customWindow && currentMode !== 'load') {
            var loadSettings = params.loadScreenSettings;
            customWindow.switchMode('load', loadSettings);
            this._customSceneType = 'load';
        } else {
        }
    };

    Scene_Load.prototype._getCurrentSceneType = function() {
        return this._customSceneType || 'load';
    };

    Scene_Load.prototype.onModeChanged = function(oldMode, newMode, newSettings) {
        if (this._updateSceneBackground) {
            this._updateSceneBackground(newSettings);
        }
    };

    var _Game_System_onAfterLoad = Game_System.prototype.onAfterLoad;
    Game_System.prototype.onAfterLoad = function() {
        if (this._bgmOnSave === null || this._bgmOnSave === undefined) {
            this._bgmOnSave = { name: '', volume: 90, pitch: 100, pan: 0 };
        }
        if (this._bgsOnSave === null || this._bgsOnSave === undefined) {
            this._bgsOnSave = { name: '', volume: 90, pitch: 100, pan: 0 };
        }
        _Game_System_onAfterLoad.call(this);
    };

    Scene_Load.prototype.onCustomSlotConfirm = function(slotId) {
        var currentMode = this._getCurrentSceneType ? this._getCurrentSceneType() : 'load';
        
        if (currentMode === 'save') {
            this._executeSave(slotId);
            return;
        }
        
        if (this._customSaveLoadWindow) {
            this._customSaveLoadWindow.setProcessing(true);
        }
        if (DataManager.loadGame(slotId)) {
            SoundManager.playLoad();
            this.fadeOutAll();
            
            var isMZ = Utils.RPGMAKER_NAME === 'MZ';
            if (isMZ) {
                if (this.reloadMapIfUpdated) {
                    this.reloadMapIfUpdated();
                }
                SceneManager.goto(Scene_Map);
                this._loadSuccess = true;
            } else {
                if ($gameSystem.versionId() !== $dataSystem.versionId) {
                    $gamePlayer.reserveTransfer($gameMap.mapId(), $gamePlayer.x, $gamePlayer.y);
                    $gamePlayer.requestMapReload();
                }
                SceneManager.goto(Scene_Map);
                this._loadSuccess = false;
            }
        } else {
            SoundManager.playBuzzer();
        }
    };

    Scene_Load.prototype._executeSave = function(slotId) {
        if ($gameSystem.setSavefileId) {
            $gameSystem.setSavefileId(slotId);
        }
        $gameSystem.onBeforeSave();
        
        var self = this;
        var result = DataManager.saveGame(slotId);
        
        if (result && typeof result.then === 'function') {
            result.then(function() {
                SoundManager.playSave();
                Sprite_SaveSlot.clearVariablesCache();
                if (self._customSaveLoadWindow) {
                    self._customSaveLoadWindow.refreshAllSlots();
                }
                self.popScene();
            }).catch(function() {
                SoundManager.playBuzzer();
            });
        }
        else if (result) {
            SoundManager.playSave();
            if (StorageManager.cleanBackup) {
                StorageManager.cleanBackup(slotId);
            }
            Sprite_SaveSlot.clearVariablesCache();
            if (this._customSaveLoadWindow) {
                this._customSaveLoadWindow.refreshAllSlots();
            }
            this.popScene();
        } else {
            SoundManager.playBuzzer();
        }
    };

    var isMZ = Utils.RPGMAKER_NAME === 'MZ';

    var _getRequiredVariableIds = function() {
        var ids = [];
        var collectFromSettings = function(settings) {
            if (settings && settings.slotTemplate) {
                if (settings.slotTemplate.textElements) {
                    var textElements = settings.slotTemplate.textElements;
                    for (var i = 0; i < textElements.length; i++) {
                        var elem = textElements[i];
                        if (elem.variableId && elem.variableId > 0) {
                            if (ids.indexOf(elem.variableId) === -1) {
                                ids.push(elem.variableId);
                            }
                        }
                    }
                }
                if (settings.slotTemplate.gaugeElements) {
                    var gaugeElements = settings.slotTemplate.gaugeElements;
                    for (var i = 0; i < gaugeElements.length; i++) {
                        var elem = gaugeElements[i];
                        if (elem.currentVariableId && elem.currentVariableId > 0) {
                            if (ids.indexOf(elem.currentVariableId) === -1) {
                                ids.push(elem.currentVariableId);
                            }
                        }
                        if (elem.maxVariableId && elem.maxVariableId > 0) {
                            if (ids.indexOf(elem.maxVariableId) === -1) {
                                ids.push(elem.maxVariableId);
                            }
                        }
                    }
                }
            }
        };
        collectFromSettings(params.saveScreenSettings);
        collectFromSettings(params.loadScreenSettings);
        collectFromSettings(params.titleLoadScreenSettings);
        return ids;
    };

    var _addVariablesToSaveInfo = function(info) {
        var variableIds = _getRequiredVariableIds();
        if (variableIds.length > 0 && $gameVariables) {
            info.variables = {};
            for (var i = 0; i < variableIds.length; i++) {
                var id = variableIds[i];
                info.variables[id] = $gameVariables.value(id);
            }
        }
        return info;
    };

    if (!isMZ) {
        var _DataManager_makeSavefileInfo = DataManager.makeSavefileInfo;
        DataManager.makeSavefileInfo = function() {
            var info = _DataManager_makeSavefileInfo.call(this);
            
            _addVariablesToSaveInfo(info);
            
            if (SceneManager._backgroundBitmap) {
                try {
                    var bitmap = SceneManager._backgroundBitmap;
                    var canvas = bitmap._canvas;
                    if (canvas) {
                        var targetWidth = 144;
                        var targetHeight = 81;
                        
                        if (params.commonSlotTemplate && params.commonSlotTemplate.showScreenshot) {
                            targetWidth = params.commonSlotTemplate.screenshotWidth || 144;
                            targetHeight = params.commonSlotTemplate.screenshotHeight || 81;
                        }
                        else if (params.saveScreenSettings && params.saveScreenSettings.slotTemplate && 
                                 params.saveScreenSettings.slotTemplate.showScreenshot) {
                            targetWidth = params.saveScreenSettings.slotTemplate.screenshotWidth || 144;
                            targetHeight = params.saveScreenSettings.slotTemplate.screenshotHeight || 81;
                        }
                        
                        var tempCanvas = document.createElement('canvas');
                        tempCanvas.width = targetWidth;
                        tempCanvas.height = targetHeight;
                        var ctx = tempCanvas.getContext('2d');
                        ctx.drawImage(canvas, 0, 0, tempCanvas.width, tempCanvas.height);
                        var quality = params.screenshotQuality || 0.92;
                        var format = params.screenshotFormat || 'jpeg';
                        if (format === 'png') {
                            info.snapshot = tempCanvas.toDataURL('image/png');
                        } else {
                            info.snapshot = tempCanvas.toDataURL('image/jpeg', quality);
                        }
                    }
                } catch (e) {
                }
            }
            return info;
        };
        
        var _Scene_Map_callMenu = Scene_Map.prototype.callMenu;
        Scene_Map.prototype.callMenu = function() {
            SceneManager.snapForBackground();
            _Scene_Map_callMenu.call(this);
        };
        
        var _Scene_Menu_commandSave = Scene_Menu.prototype.commandSave;
        Scene_Menu.prototype.commandSave = function() {
            if (!SceneManager._backgroundBitmap) {
                SceneManager.snapForBackground();
            }
            _Scene_Menu_commandSave.call(this);
        };
    } else {
        var _Scene_Map_callMenu_MZ = Scene_Map.prototype.callMenu;
        Scene_Map.prototype.callMenu = function() {
            SceneManager.snapForBackground();
            _Scene_Map_callMenu_MZ.call(this);
        };
        
        var _Scene_Menu_commandSave_MZ = Scene_Menu.prototype.commandSave;
        Scene_Menu.prototype.commandSave = function() {
            if (!SceneManager._backgroundBitmap) {
                SceneManager.snapForBackground();
            }
            _Scene_Menu_commandSave_MZ.call(this);
        };
        
        var _DataManager_makeSavefileInfo_MZ = DataManager.makeSavefileInfo;
        DataManager.makeSavefileInfo = function() {
            var info = _DataManager_makeSavefileInfo_MZ.call(this);
            
            _addVariablesToSaveInfo(info);
            
            if (SceneManager._backgroundBitmap) {
                try {
                    var bitmap = SceneManager._backgroundBitmap;
                    var canvas = bitmap._canvas || bitmap._image;
                    if (!canvas && bitmap._context) {
                        canvas = bitmap._context.canvas;
                    }
                    if (canvas) {
                        var targetWidth = 144;
                        var targetHeight = 81;
                        
                        if (params.commonSlotTemplate && params.commonSlotTemplate.showScreenshot) {
                            targetWidth = params.commonSlotTemplate.screenshotWidth || 144;
                            targetHeight = params.commonSlotTemplate.screenshotHeight || 81;
                        }
                        else if (params.saveScreenSettings && params.saveScreenSettings.slotTemplate && 
                                 params.saveScreenSettings.slotTemplate.showScreenshot) {
                            targetWidth = params.saveScreenSettings.slotTemplate.screenshotWidth || 144;
                            targetHeight = params.saveScreenSettings.slotTemplate.screenshotHeight || 81;
                        }
                        
                        var tempCanvas = document.createElement('canvas');
                        tempCanvas.width = targetWidth;
                        tempCanvas.height = targetHeight;
                        var ctx = tempCanvas.getContext('2d');
                        ctx.drawImage(canvas, 0, 0, tempCanvas.width, tempCanvas.height);
                        var quality = params.screenshotQuality || 0.92;
                        var format = params.screenshotFormat || 'jpeg';
                        if (format === 'png') {
                            info.snapshot = tempCanvas.toDataURL('image/png');
                        } else {
                            info.snapshot = tempCanvas.toDataURL('image/jpeg', quality);
                        }
                    }
                } catch (e) {
                }
            }
            
            return info;
        };
    }

})();
