/*:
 * @target MZ
 * @plugindesc （修正版）プラグインコマンドで「変数が一定値以上なら一度だけコモンイベントを呼び出し実行（戻ってくる）」できます。
 * @author ChatGPT
 *
 * @command CheckAndCall
 * @text 条件を満たしたら一度だけ呼び出し
 *
 * @arg variableId
 * @type variable
 * @default 10
 *
 * @arg threshold
 * @type number
 * @default 30
 *
 * @arg commonEventId
 * @type common_event
 * @default 1
 *
 * @arg flagId
 * @type switch
 * @default 100
 */

(() => {
    PluginManager.registerCommand("OneTimeAffinityByCommand", "CheckAndCall", function(args) {
        // 注意: ここは "function" を使う。this は呼び出し元の Game_Interpreter を参照する前提
        const variableId = Number(args.variableId);
        const threshold = Number(args.threshold);
        const commonEventId = Number(args.commonEventId);
        const flagId = Number(args.flagId);

        // 既に発動済みなら何もしない
        if ($gameSwitches.value(flagId)) return;

        const value = $gameVariables.value(variableId);

        if (value >= threshold) {
            $gameSwitches.setValue(flagId, true);

            const commonEvent = $dataCommonEvents[commonEventId];
            if (!commonEvent) return;

            // this は Game_Interpreter のインスタンスであるはず → setupChild を使って挿入実行
            // 呼び出し元のイベント内で「プラグインコマンド」を使っている必要があります
            try {
                this.setupChild(commonEvent.list, this._eventId);
            } catch (e) {
                // 万が一 this が Game_Interpreter でない場合（プラグインコマンドがイベント外から呼ばれた等）、
                // reserveCommonEvent にフォールバックさせる（戻らないが実行はされる）
                console.warn("CheckAndCall: setupChild failed, falling back to reserveCommonEvent.", e);
                $gameTemp.reserveCommonEvent(commonEventId);
            }
        }
    });
})();
