/*:
 * @target MZ
 * @plugindesc 親密度が一定値以上になったとき、コモンイベントを一度だけ自動実行します。
 * @author ChatGPT
 *
 * @param AffinityVariable
 * @text 親密度の変数ID
 * @type variable
 * @default 10
 *
 * @param Threshold
 * @text 発動条件の値(以上)
 * @type number
 * @default 30
 *
 * @param CommonEventId
 * @text 実行するコモンイベントID
 * @type common_event
 * @default 1
 *
 * @help
 * 指定した変数が指定値以上になった瞬間、
 * 指定したコモンイベントを「一度だけ」自動実行します。
 *
 * 実行済みかどうかは内部スイッチで自動管理します。
 */

(() => {
    const params = PluginManager.parameters('OneTimeAffinityEvent');
    const affinityVar = Number(params.AffinityVariable || 10);
    const threshold = Number(params.Threshold || 30);
    const commonEventId = Number(params.CommonEventId || 1);

    const _Game_Map_update = Game_Map.prototype.update;
    Game_Map.prototype.update = function(sceneActive) {
        _Game_Map_update.call(this, sceneActive);

        // 実行済みチェックを内部的に保持
        if (!this._affinityEventDone) {
            const value = $gameVariables.value(affinityVar);
            if (value >= threshold) {
                this._affinityEventDone = true;
                $gameTemp.reserveCommonEvent(commonEventId);
            }
        }
    };
})();
