// AutonomousMovementFix.js Ver.1.1.0
// MIT License (C) 2023 あわやまたな
// http://opensource.org/licenses/mit-license.php

/*:
* @target MZ MV
* @plugindesc Modify Autonomous Movement [Custom].
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/article/501379026.html
* @help Ver.1.1.0
* If the contents of the autonomous movement before the page change
* and the autonomous movement after the change are the same,
* the progress of the movement route will be maintained.
*
* [Plugin Command (MV)]
* resetEventPosition EventID //Reset event position
*
* @command resetEventPosition
* @text Reset Event Position
* @desc Returns the event to its initial position and resets the progress of the movement route.
*
* @arg eventId
* @text Event ID
* @desc Specify the event ID.
* This event at 0.
* @default 0
*
*/

/*:ja
* @target MZ MV
* @plugindesc 自律移動［カスタム］を修正します。
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/article/501379026.html
* @help ページ変更前の自律移動と、変更後の自律移動の内容が同じだった場合、
* 移動ルートの進度を維持します。
*
* ［プラグインコマンド（MV）］
* resetEventPosition イベントID //イベントの位置をリセット
*
* [更新履歴]
* 2023/11/07：Ver.1.0.0　公開。
* 2023/11/08：Ver.1.1.0　イベントの位置をリセットする機能を追加。
*
* @command resetEventPosition
* @text イベントの位置をリセット
* @desc イベントを初期位置に戻して移動ルートの進度をリセットします。
*
* @arg eventId
* @text イベントID
* @desc イベントIDを指定します。
* 0でこのイベント。
* @default 0
*
*/

'use strict';

{

	const useMZ = Utils.RPGMAKER_NAME === "MZ";
	const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];
	const hasPluginCommonBase = typeof PluginManagerEx === "function";

	if (useMZ) {
		PluginManager.registerCommand(pluginName, "resetEventPosition", function(args){
			const characterId = Number(args.eventId || 0);
			const character = this.character(characterId);
			if (characterId >= 0 && character) {
				character.resetPosition();
			}
		});

		if(hasPluginCommonBase){
			PluginManagerEx.registerCommand(document.currentScript, "resetEventPosition", function(args) {
				const characterId = args.eventId || 0;
				const character = this.character(characterId);
				if (characterId >= 0 && character) {
					character.resetPosition();
				}
			});
		}
	}

	const _Game_Interpreter_command356 = Game_Interpreter.prototype.command356;
	Game_Interpreter.prototype.command356 = function(params) {
		_Game_Interpreter_command356.apply(this, arguments);
	};

	const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	Game_Interpreter.prototype.pluginCommand = function(command, args) {
		_Game_Interpreter_pluginCommand.apply(this, arguments);
		if (command === "resetEventPosition") {
			const characterId = Number(args[0] || 0);
			const character = this.character(characterId);
			if (characterId >= 0 && character) {
				character.resetPosition();
			}
		}
	};

	//-----------------------------------------------------------------------------
	// Game_Event

	const _Game_Event_setupPageSettings = Game_Event.prototype.setupPageSettings;
	Game_Event.prototype.setupPageSettings = function() {
		const lastRoute = this._moveRouteForcing ? this._originalMoveRoute : this._moveRoute;
		const lastIndex = this._moveRouteForcing ? this._originalMoveRouteIndex : this._moveRouteIndex;
		const moveRoute = this.page().moveRoute;
		_Game_Event_setupPageSettings.apply(this, arguments);
		if (moveRoute && lastRoute && moveRoute.list.length > 1 && moveRoute.list.length === lastRoute.list.length && JSON.stringify(moveRoute) === JSON.stringify(lastRoute)) {
			if (this._moveRouteForcing) {
				this._originalMoveRouteIndex = lastIndex;
			} else {
				this._moveRouteIndex = lastIndex;
			}
		}
	};

	Game_Event.prototype.resetPosition = function() {
		this.locate(this.event().x, this.event().y);
		if (this._moveRouteForcing) {
			this._originalMoveRouteIndex = 0;
		} else {
			this._moveRouteIndex = 0;
		}
	};

}