// UnflaggedTiles.js Ver.1.0.1
// MIT License (C) 2024 あわやまたな
// http://opensource.org/licenses/mit-license.php

/*:
* @target MZ MV
* @orderBefore MapLayerEx
* @plugindesc Disables the flag for the specified tile.
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/article/504160842.html
* @help Ver.1.0.1
* Using a ○ flag will always reflect the passage settings,
* making it easier for characters to invade map decorations.
* So this plugin provides a way to draw tiles on the lower layer
* while ignoring the passage settings.
*
* If you set it to a ☆ flag and change all four directions except for → to ・,
* it will be displayed in a lower layer while retaining the properties of the ☆,
* which means that the passage settings will be ignored.
*
*/

/*:ja
* @target MZ MV
* @orderBefore MapLayerEx
* @plugindesc 指定したタイルのフラグを無効化します。
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/article/504160842.html
* @help ○判定だと必ず通行設定が反映されるのでマップの装飾に
* キャラクターがめり込みがちです。
* なのでこのプラグインは通行設定を無視しつつ下層レイヤーに
* タイルを表示する方法を提供します。
*
* ☆判定にして4方向の→以外を全て・にすると、
* 通行設定が無視されるという☆の性質を持ちながら、
* 下層レイヤーに表示されるようになります。
* 
*
* [更新履歴]
* 2024/07/28：Ver.1.0.0　公開。
* 2024/07/30：Ver.1.0.1　不具合修正。
*
*/

'use strict';
{
	//-----------------------------------------------------------------------------
	// Tilemap
	
	const _Tilemap__isHigherTile = Tilemap.prototype._isHigherTile;
	Tilemap.prototype._isHigherTile = function(tileId) {
		return _Tilemap__isHigherTile.call(this, tileId) && (this.flags[tileId] & 0xF) !== 0xB;
	};
}