// WindowAvoidsPlayer.js Ver.2.0.0
// MIT License (C) 2023 あわやまたな
// http://opensource.org/licenses/mit-license.php

/*:
* @target MZ
* @plugindesc  メッセージウィンドウがプレイヤーに被らないようにします。
* @orderAfter MessagePlus
* @orderAfter MessageFaceOption
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/article/499238761.html
* @help ツクール2000の再現機能。
* プレイヤーが画面上方に位置している場合はウィンドウを下に、
* 画面下方に位置している場合はウィンドウを上に表示するようにします。
*
* [更新履歴]
* 2023/05/05：Ver.1.0.0　公開。
* 2023/12/18：Ver.1.1.0　不具合修正。
* 2023/12/18：Ver.2.0.0　機能を簡素化。
*
* @param tolerance
* @text 許容値
* @desc プレイヤーが画面中央からどれくらいズレた時にウィンドウの位置を変えるかを数値で指定します。autoならタイル幅に依存。
* @type combo
* @default auto
*
* @command enableAvoid
* @text 回避有効化
* @desc プレイヤーが画面上方に位置している場合はウィンドウを下に、画面下方に位置している場合はウィンドウを上に表示するようにします。
*
* @command disableAvoid
* @text 回避無効化
* @desc 元に戻します。
*
*/

'use strict';

{
	const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];
	const parameters = PluginManager.parameters(pluginName);
	const numWindows = Number(parameters["numWindows"]);
	const hasPluginCommonBase = typeof PluginManagerEx === "function";
	const tolerance = Math.abs(parameters["tolerance"]);
	const isAuto = parameters["tolerance"] === "auto";

	//-----------------------------------------------------------------------------
	// PluginManager

	PluginManager.registerCommand(pluginName, "enableAvoid", function (args) {
		$gameSystem.setWindowAvoidPlayerMode(true);
	});

	PluginManager.registerCommand(pluginName, "disableAvoid", function (args) {
		$gameSystem.setWindowAvoidPlayerMode(false);
	});

	//-----------------------------------------------------------------------------
	// Game_System

	const _Game_System_initialize = Game_System.prototype.initialize;
	Game_System.prototype.initialize = function() {
		_Game_System_initialize.call(this);
		this._windowAvoidPlayerMode = false;
	};

	Game_System.prototype.windowAvoidPlayerMode = function() {
		return this._windowAvoidPlayerMode;
	};

	Game_System.prototype.setWindowAvoidPlayerMode = function(bool) {
		this._windowAvoidPlayerMode = bool;
	};

	//-----------------------------------------------------------------------------
	// Game_Message

	const _Game_Message_setPositionType = Game_Message.prototype.setPositionType;
	Game_Message.prototype.setPositionType = function(positionType) {
		if ($gameSystem.windowAvoidPlayerMode() && SceneManager._scene.constructor === Scene_Map) {
			const gh = Graphics.height / 2;
			const playerY = $gamePlayer.screenY();
			const ty = isAuto ? $gameMap.tileWidth(): tolerance;
			if (Math.abs(gh - playerY) >= ty) {
				positionType = (gh < playerY ? 0 : 2);
			}
		}
		_Game_Message_setPositionType.call(this, positionType);
	};

}