/*:
 * @param DayFormatVariable
 * @text 一日のフォーマット変数
 * @type variable
 * @default 0
 * @desc 1日の時間を格納する変数IDを指定します。
 */

(() => {
    const pluginName = "ChronusDayFormatAddon";
    const parameters = PluginManager.parameters(pluginName);
    const dayFormatVariable = Number(parameters['DayFormatVariable']) || 0;

    const _Game_Chronus_setGameVariable = Game_Chronus.prototype.setGameVariable;
    Game_Chronus.prototype.setGameVariable = function() {
        _Game_Chronus_setGameVariable.call(this);
        if (dayFormatVariable > 0) {
            const totalMinutes = this.getHour() * 60 + this.getMinute();
            $gameVariables.setValue(dayFormatVariable, totalMinutes);
        }
    };
})();