/*:
 * @target MZ
 * @param color @text 線色 @type string @default #FFFFFF
 * @param alpha @text 透明度 @type number @min 0 @max 1 @decimals 2 @default 1
 * @param lineWidth @text 線幅 @type number @min 1 @default 1
 * @param dash @text 点の長さ @type number @min 1 @default 3
 * @param gap @text 点の間隔 @type number @min 1 @default 3
 * @param offsetY @text 下線オフセットY @type number @default -2
 */
(() => {
  'use strict';
  const pn = document.currentScript.src.split('/').pop().replace(/\.js$/, '');
  const P = PluginManager.parameters(pn);
  const COLOR = String(P.color || '#FFFFFF');
  const ALPHA = Number(P.alpha ?? 1);
  const LW    = Math.max(1, Number(P.lineWidth || 1));
  const DASH  = Math.max(1, Number(P.dash || 3));
  const GAP   = Math.max(1, Number(P.gap || 3));
  const OFFY  = Number(P.offsetY || -2);

  if (!window.Window_TextLog) return; 

  const _drawTextLog = Window_TextLog.prototype.drawTextLog;
  Window_TextLog.prototype.drawTextLog = function() {
    _drawTextLog.call(this);

    const ctx = this.contents?.context;
    if (!ctx) return;

    ctx.save();
    ctx.setLineDash([DASH, GAP]);
    ctx.strokeStyle = COLOR;
    ctx.globalAlpha = ALPHA;
    ctx.lineWidth = LW;

    for (let i = 0; i < this._lineTops.length; i++) {
      const top = this._lineTops[i] ?? 0;
      const h   = this._lineHeights[i] ?? this.lineHeight();
      const y   = top + h - this.scrollBaseY() + OFFY;
      ctx.beginPath();
      ctx.moveTo(0, y);
      ctx.lineTo(this.innerWidth, y);
      ctx.stroke();
    }
    ctx.restore();
  };
})();
