(() => {
    const _Sprite_Reflect_initialize = KCDev.Mirrors.Sprite_Reflect.prototype.initialize;
    KCDev.Mirrors.Sprite_Reflect.prototype.initialize = function (parentSprite) {
        _Sprite_Reflect_initialize.call(this, parentSprite);

        if (parentSprite) {
            this._parentSprite = parentSprite;
        }
    };

    const _Sprite_Reflect_updateBitmap = KCDev.Mirrors.Sprite_Reflect.prototype.updateBitmap;
    KCDev.Mirrors.Sprite_Reflect.prototype.updateBitmap = function () {
        _Sprite_Reflect_updateBitmap.apply(this, arguments);

        if (this._parentSprite) {
            this.bitmap = this._parentSprite.bitmap; 
        }
    };

    const _KCDev_setReflectFrame = KCDev.Mirrors.setReflectFrame;
    KCDev.Mirrors.setReflectFrame = function (r) {
        if (!r._parentSprite) {
            _KCDev_setReflectFrame.call(this, r);
            return;
        }

        const parent = r._parentSprite;
        const pw = parent.patternWidth();
        const ph = parent.patternHeight();

        if (r === parent._reflectionWall) {
            const direction = parent._character.direction();
            const sx = (parent.characterBlockX() + parent.characterPatternX()) * pw;

            let sy;
            if (direction === 2) { 
                sy = (parent.characterBlockY() + 3) * ph;
            } else if (direction === 8) {
                sy = (parent.characterBlockY()) * ph;
            } else if (direction === 6) { 
                sy = (parent.characterBlockY() + 1) * ph; 
            } else if (direction === 4) {
                sy = (parent.characterBlockY() + 2) * ph;
            }

            r.setFrame(sx, sy, pw, ph);
        } else {
            const sx = (parent.characterBlockX() + parent.characterPatternX()) * pw;
            const sy = (parent.characterBlockY() + parent.characterPatternY()) * ph;
            r.setFrame(sx, sy, pw, ph);
        }
    };

    const _Sprite_Character_updateBitmap = Sprite_Character.prototype.updateBitmap;
    Sprite_Character.prototype.updateBitmap = function () {
        if (this._character && this._character.motionData) {
            const motionFileName = this._character.motionData.fileName;
            if (motionFileName && motionFileName !== this._motionFileName) {
                this.bitmap = ImageManager.loadCharacter(motionFileName);
                this._motionFileName = motionFileName;
            }
        } else {
            _Sprite_Character_updateBitmap.apply(this, arguments);
        }

        if (this._reflectionFloor) this._reflectionFloor.updateBitmap();
        if (this._reflectionWall) this._reflectionWall.updateBitmap();
    };

    const _Sprite_Character_updateFrame = Sprite_Character.prototype.updateFrame;
    Sprite_Character.prototype.updateFrame = function () {
        if (this._character && this._character.motionData) {
            const motionPattern = this._character.motionPattern || 0;
            const direction = this._character.direction();
            const frameWidth = this.patternWidth();
            const frameHeight = this.patternHeight();
            const index = (direction - 2) / 2; 
            this.setFrame(motionPattern * frameWidth, index * frameHeight, frameWidth, frameHeight);
        } else {
            _Sprite_Character_updateFrame.call(this);
        }
    };

    const _Spriteset_Map_createCharacters = Spriteset_Map.prototype.createCharacters;
    Spriteset_Map.prototype.createCharacters = function () {
        _Spriteset_Map_createCharacters.call(this);

        this._characterSprites.forEach(sprite => {
            if (
                sprite._character &&
                sprite.bitmap &&
                sprite.bitmap.width > 192
            ) {
                sprite.visible = false;
            }
        });
    };
})();
