/*:
 * @command ErasePictures
 * @text ピクチャ削除
 * @desc 複数のピクチャを削除します。削除するピクチャのIDを指定してください。
 *
 * @arg ids
 * @type string
 * @text ピクチャID
 * @desc 削除するピクチャのIDをカンマ区切りで指定します（例: "1,2,3"）。
 * @default
 */

(() => {
    const pluginName = 'Kamichichi_BatchPictureErase';

    PluginManager.registerCommand(pluginName, 'ErasePictures', args => {
        const parseIds = (input) => {
            const ids = [];
            input.split(',').forEach(part => {
                if (part.includes('-')) {
                    const [start, end] = part.split('-').map(num => Number(num.trim()));
                    if (!isNaN(start) && !isNaN(end) && start <= end) {
                        for (let i = start; i <= end; i++) {
                            ids.push(i);
                        }
                    }
                } else {
                    const id = Number(part.trim());
                    if (!isNaN(id)) {
                        ids.push(id);
                    }
                }
            });
            return ids;
        };

        const pictureIds = parseIds(args.ids);
        pictureIds.forEach(id => {
            if (id > 0) {
                $gameScreen.erasePicture(id); 
            }
        });
    });
})();
