(() => {
    const _Game_Event_setupPageSettings = Game_Event.prototype.setupPageSettings;
    Game_Event.prototype.setupPageSettings = function() {
        _Game_Event_setupPageSettings.call(this);
        this.checkAndMoveToCCPCoordinates();
    };

    Game_Event.prototype.checkAndMoveToCCPCoordinates = function() {
        const page = this.page();
        if (!page) return;

        const list = page.list;
        for (const command of list) {
            if (command.code === 108 || command.code === 408) {
                const match = command.parameters[0].match(/<CCP:(\d+(?:\.\d+)?),(\d+(?:\.\d+)?)>/);
                if (match) {
                    const x = parseFloat(match[1]);
                    const y = parseFloat(match[2]);
                    this.setPositionForCCP(x, y);
                    return; 
                }
            }
        }
    };

    Game_Event.prototype.setPositionForCCP = function(x, y) {
        this._realX = x;
        this._realY = y;
        this._x = Math.floor(x);
        this._y = Math.floor(y);
        this.refreshBushDepth();
    };
})();
