/*:
* @command setWaitMode
* @desc 完了までウェイト
*
* @arg waitMode
* @text ウェイトモード
* @type select
* @default route
* @option 移動ルート
* @value route
* @option アニメーション
* @value animation
* @option フキダシアイコン
* @value balloon
*
* @arg characterId
* @text キャラクターID
* @desc 未入力で最後に対象となったキャラクター。
* @default

*/

;(() => {
    'use strict'

    const _Scene_Map_createMenuButton = Scene_Map.prototype.createMenuButton
    Scene_Map.prototype.createMenuButton = function() {
        _Scene_Map_createMenuButton.apply(this, arguments)
        this._menuButton.updateOpacity = function() { this.opacity = 0 }
    }

    const _Scene_Map_shouldAutosave = Scene_Map.prototype.shouldAutosave;
    Scene_Map.prototype.shouldAutosave = function() {
        const result = _Scene_Map_shouldAutosave.apply(this, arguments);
        return result && !SceneManager.isFromTitle();
    };

    SceneManager.isFromTitle = function() {
        return this._previousClass === Scene_Title;
    }

    const _Window_MapName_initialize = Window_MapName.prototype.initialize;
    Window_MapName.prototype.initialize = function (rect) {
      _Window_MapName_initialize.call(this, rect);
      this._contentsBackSprite.alpha = 0;
    };


	Scene_MenuBase.prototype.buttonAreaBottom = function() {
		return 0;
	};

	Scene_MenuBase.prototype.mainAreaHeight = function() {
		return Graphics.boxHeight - this.helpAreaHeight();
	};


	Sprite_Button.prototype.updateOpacity = function() {
		this.opacity = this._pressed ? 0 : 0;
	};

   const  _Window_Base_createContents = Window_Base.prototype.createContents;
    Window_Base.prototype.createContents = function() {
        _Window_Base_createContents.apply(this, arguments);
        this.contents.outlineWidth = 4;
    };

    ColorManager.outlineColor = function() {
        return "black";
    };

[Window_Message, Window_ChoiceList, Window_NameEdit].forEach(w =>
        Object.defineProperty(w.prototype, "openness", {
            get: function() {
                return this._openness;
            },
            set: function(value) {
                if (this._openness !== value) {
                    this._openness = value.clamp(0, 255);
                    if (!this._background && !this._dimmerSprite?.visible) {
                        this.opacity = this._openness;
                    }
                }
            },
            configurable: true
        })
    );

Window_Base.prototype.lineHeight = function() {
    return 42;
};

const _Window_Message_drawFace = Window_Message.prototype.drawFace;
Window_Message.prototype.drawFace = function() {
};

Window_Message.prototype.newLineX = function() {
	return 2;  
};
Input.keyMapper[65] = 'A'
Input.keyMapper[83] = 'S'
Input.keyMapper[67] = 'C'


    Game_Character.prototype.walkPixels = function(xPixels, yPixels) {
        const targetX = this._realX + xPixels / $gameMap.tileWidth();
        const targetY = this._realY + yPixels / $gameMap.tileHeight();
        this.setDestination(targetX, targetY); 
    };
    Game_Character.prototype.W = function(xPixels, yPixels) {
        const targetX = this._realX + xPixels / $gameMap.tileWidth();
        const targetY = this._realY + yPixels / $gameMap.tileHeight();
        this.setDestination(targetX, targetY); 
    };



  const _Scene_Title_update = Scene_Title.prototype.update;
  Scene_Title.prototype.update = function() {
    _Scene_Title_update.call(this);

    const s = this._backSprite1;
    if (!s) return;

    // 毎フレーム固定（他処理で戻されても勝つ）
    s.anchor.set(0.5, 0.5);
    s.x = Graphics.width / 2;
    s.y = Graphics.height / 2;
    s.scale.set(2, 2);
  };

    
})();


