/*:
 * @param MaxItemCount
 * @text 最大所持数
 * @type number
 * @min 0
 * @default 9999
 */

(() => {
  "use strict";

  const params = PluginManager.parameters(document.currentScript.src.match(/([^/]+)\.js$/)[1]);
  const MAX = Number(params.MaxItemCount || 9999);

  const _maxItems = Game_Party.prototype.maxItems;
  Game_Party.prototype.maxItems = function(item) {
    _maxItems.call(this, item);
    return MAX;
  };
})();
