﻿/*:
 * @target MZ
 * @plugindesc Random get items only
 * @author NUUN 
 * @version 1.3.3
 *
 * @help
 * ランダムで「アイテムのみ」を取得します（武器/防具/お金/コモンイベントなし）。
 * 重みは「固定重み + 共通の加算変数」で動的に変えられます。
 *
 * 実際の重み = weight + $gameVariables.value(WeightAddVar)
 * 実際の重みが 0 以下になった候補は抽選対象から外します。
 *
 * 抽選処理が終わったら、加算変数(WeightAddVar)を 0 に戻します。
 * （加算され続けるのを防ぐため）
 *
 * @command ItemList
 * @desc ランダムに取得するアイテムを指定します。
 * @arg list
 * @text ランダムアイテム
 * @type struct<randomList>[]
 *
 * @param CommonListIdVar
 * @text 取得リストID変数
 * @type variable
 * @default 0
 *
 * @param ItemNameVar
 * @text 取得アイテム名変数
 * @type variable
 * @default 0
 * 

 * @param ItemIconIDVar
 * @text 取得アイテムアイコンID変数
 * @type variable
 * @default 0
 *
 * @param WeightVar
 * @text 実際に使われた重み変数
 * @type variable
 * @default 0
 *
 * @param WeightAddVar
 * @text 重みに加算する共通変数
 * @type variable
 * @default 0
 */

/*~struct~randomList:
 * @param ItemId
 * @text 取得アイテム
 * @type item
 *
 * @param weight
 * @text 固定重み
 * @type number
 * @default 1
 *
 * @param Cond
 * @text 条件式
 * @type combo
 * @option '$gameVariables.value(0);'
 * @option '$gameSwitches.value(0);'
 * @default
 */

var Imported = Imported || {};
Imported.NUUN_RandomItems = true;

(() => {
  'use strict';

  if (!DataManager.nuun_structureData) {
    DataManager.nuun_structureData = function(params) {
      if (!params) return [];
      try {
        return JSON.parse(JSON.stringify(params, (k, v) => {
          if (typeof v !== 'string') return v;
          try {
            return JSON.parse(v);
          } catch {
            return v;
          }
        })) || [];
      } catch {
        return [];
      }
    };
  }

  const parameters = PluginManager.parameters('NUUN_RandomItems');
  const CommonListIdVar = Number(parameters['CommonListIdVar'] || 0);
  const ItemNameVar = Number(parameters['ItemNameVar'] || 0);
  const ItemIconIDVar = Number(parameters['ItemIconIDVar'] || 0);
  const WeightVar = Number(parameters['WeightVar'] || 0);
  const WeightAddVar = Number(parameters['WeightAddVar'] || 0);

  let __eventId = 0;

  PluginManager.registerCommand('NUUN_RandomItems', 'ItemList', args => {
    $gameParty.randomItems(args);
  });

  const _command357 = Game_Interpreter.prototype.command357;
  Game_Interpreter.prototype.command357 = function(params) {
    if (params[0] === 'NUUN_RandomItems') {
      __eventId = this._eventId;
    }
    return _command357.call(this, params);
  };

  Game_Party.prototype.randomItems = function(args) {
    // 変数初期化（取得結果が残り続けるのを防ぐ）
    if (CommonListIdVar > 0) $gameVariables.setValue(CommonListIdVar, 0);
    if (ItemIconIDVar > 0) $gameVariables.setValue(ItemIconIDVar, 0);
    if (WeightVar > 0) $gameVariables.setValue(WeightVar, 0);

    const list = DataManager.nuun_structureData(args.list);
    if (!list.length) return;

    const valid = list.filter(a => !a.Cond || eval(a.Cond));
    const picked = this.pickRandomItem(valid);
    if (!picked) {
      resetWeightAddVar();
      return;
    }

    const interpreter = new Game_Interpreter();
    interpreter._eventId = __eventId;
    __eventId = 0;

    interpreter.command126([picked.id, 0, 0, 1]);

    resetWeightAddVar();
  };

  function resetWeightAddVar() {
    if (WeightAddVar > 0) {
    }
  }

  function calcEffectiveWeight(entry) {
    const base = Number(entry.weight || 0);
    const add = (WeightAddVar > 0) ? Number($gameVariables.value(WeightAddVar) || 0) : 0;
    const w = base + add;
    return Number.isFinite(w) ? w : 0;
  }

  Game_Party.prototype.pickRandomItem = function(list) {
    const candidates = [];
    let total = 0;

    for (const e of list) {
      if (!$dataItems[e.ItemId]) continue;

      const w = calcEffectiveWeight(e);
      if (w <= 0) continue;

      candidates.push({ e, w });
      total += w;
    }

    if (total <= 0 || candidates.length === 0) return null;

    let rand = Math.random() * total;
    let acc = 0;

    for (const c of candidates) {
      acc += c.w;
      if (acc > rand) {
        const id = c.e.ItemId;
        $gameVariables.setValue(CommonListIdVar, id);
        if (ItemIconIDVar > 0) $gameVariables.setValue(ItemIconIDVar, $dataItems[id].iconIndex);
        if (ItemNameVar > 0) $gameVariables.setValue(ItemNameVar, $dataItems[id].name);
        $gameVariables.setValue(WeightVar, Math.floor(c.w));
        return $dataItems[id];
      }
    }
    return null;
  };

})();
