/*:
 * @param screenshotFolder
 * @text スクショ保存先フォルダ名
 * @type string
 * @default screenshot
 *
 * @param targetVariableId
 * @text 格納する変数ID
 * @type variable
 * @default 1
 *
 * @command countImages
 * @text 画像枚数をカウントして変数に格納
 * @desc 指定されたフォルダ内の画像枚数を指定変数に格納します。
 *
 */

(() => {
    const pluginName = "ScreenshotCountToVariable";
    const params = PluginManager.parameters(pluginName);
    const screenshotFolder = String(params["screenshotFolder"] || "screenshot");
    const targetVariableId = Number(params["targetVariableId"] || 1);

    PluginManager.registerCommand(pluginName, "countImages", () => {
        const fs = require('fs');
        const path = require('path');

        const dirPath = path.join(path.resolve(''), screenshotFolder);
        let count = 0;

        if (fs.existsSync(dirPath)) {
            count = fs.readdirSync(dirPath, { withFileTypes: true })
                .filter(file => file.isFile() && /\.(png|jpg|jpeg)$/i.test(file.name))
                .length;
        }

        $gameVariables.setValue(targetVariableId, count);
        console.log(`フォルダ「${screenshotFolder}」内の画像数: ${count}枚を変数[${targetVariableId}]に格納しました。`);
    });
})();
