/*:
 * @param variableId
 * @text イベントIDを代入する変数ID
 * @type variable
 * @desc 今話しかけているイベントのIDを代入する変数IDを指定してください。
 * @default 1
 *
 * @param pageVariableId
 * @text イベントページ番号を代入する変数ID
 * @type variable
 * @desc 今話しかけているイベントが「何ページ目で動いているか(1始まり)」を代入する変数ID。0なら代入しない。
 * @default 2
 */

(() => {
  const pluginName = "SetTalkingEventId";
  const parameters = PluginManager.parameters(pluginName);
  const variableId = Number(parameters["variableId"] || 1);
  const pageVariableId = Number(parameters["pageVariableId"] || 0);

  const _Game_Event_start = Game_Event.prototype.start;
  Game_Event.prototype.start = function() {
    const id = this.eventId();
    $gameVariables.setValue(variableId, id);

    // ページ番号(0始まり) → エディタ表示に合わせて(1始まり)へ
    let pageIndex0 = null;

    // MZ標準は _pageIndex を持つ。将来差分や他プラグイン干渉に備えて多重フォールバック。
    if (typeof this.pageIndex === "function") {
      pageIndex0 = this.pageIndex();
    } else if (this._pageIndex != null) {
      pageIndex0 = this._pageIndex;
    }

    const pageNumber = (typeof pageIndex0 === "number" && pageIndex0 >= 0) ? (pageIndex0 + 1) : 0;

    if (pageVariableId > 0) {
      $gameVariables.setValue(pageVariableId, pageNumber);
    }

    console.log(`話しかけたイベントID: ${id} / ページ: ${pageNumber}`);

    _Game_Event_start.call(this);
  };
})();
