/*:
 * @param jsonFileName
 * @text JSONファイル名
 * @desc タイトル画面に使用するJSONファイル名を指定。（例：title.json）
 * @type string
 * @default title.json
 * 
 * @param animationName
 * @text アニメーション名
 * @desc タイトル画面で再生するアニメーション名を指定します（例：title_01）。
 * @type string
 * @default title_01
 * 
 * @param skeletonName
 * @text スケルトン名
 * @desc タイトル画面に使用するスケルトン名を指定します（例：title）。
 * @type string
 * @default title
 * 
 */

(function () {
    const parameters = PluginManager.parameters('TitleScreenSpine');
    const jsonFileName = parameters['jsonFileName'] || 'title.json';
    const animationName = parameters['animationName'] || 'title_01';
    const skeletonName = parameters['skeletonName'] || 'title';

    let transitionFromTitle = false;

    function setupSpineBackground(scene, options = {}) {
        scene._spineBackgroundLayer = new Sprite();
        scene.addChild(scene._spineBackgroundLayer);

        const spine = new Game_Spine();
        const sprite = new Sprite_Spine(spine);
        spine.setSkeleton(skeletonName).setAnimation(0, animationName);
        spine.setOffset(Graphics.width / 2, Graphics.height / 2);
        spine.setScale(1, 1);

        if (options.stopAnimation) {
            spine.setTimeScale(0);
        }
        if (options.applyBlur) {
            const blurFilter = new PIXI.filters.BlurFilter();
            sprite.filters = [blurFilter];
        }

        scene._spineBackgroundLayer.addChild(sprite);
        scene.addChildAt(scene._spineBackgroundLayer, 1); 
    }

    const _Scene_Title_createBackground = Scene_Title.prototype.createBackground;
    Scene_Title.prototype.createBackground = function() {
        _Scene_Title_createBackground.call(this);
        setupSpineBackground(this);
    };

    const _Scene_Title_commandOptions = Scene_Title.prototype.commandOptions;
    Scene_Title.prototype.commandOptions = function() {
        transitionFromTitle = true;
        _Scene_Title_commandOptions.call(this);
    };

    const _Scene_Options_createBackground = Scene_Options.prototype.createBackground;
    Scene_Options.prototype.createBackground = function() {
        _Scene_Options_createBackground.call(this);

        if (transitionFromTitle) {
            setupSpineBackground(this, { stopAnimation: true, applyBlur: true });
            transitionFromTitle = false;
        }
    };
})();
