(() => {
  "use strict";

  const FOOTSTEP_DIR = "footstep/";

  if (ConfigManager.footstepVolume == null) ConfigManager.footstepVolume = 100;

  const _makeData = ConfigManager.makeData;
  ConfigManager.makeData = function() {
    const config = _makeData.call(this);
    config.footstepVolume = this.footstepVolume;
    return config;
  };

  const _applyData = ConfigManager.applyData;
  ConfigManager.applyData = function(config) {
    _applyData.call(this, config);
    this.footstepVolume = this.readVolume(config, "footstepVolume");
  };

  AudioManager._footstepBuffers = AudioManager._footstepBuffers || [null, null];

  AudioManager.playFootstepSe = function(se, bufferIndex) {
    if (!se || !se.name) return;

    const name = (typeof se.name === "string" && se.name && !se.name.includes("/"))
      ? (FOOTSTEP_DIR + se.name)
      : se.name;

    const idx = bufferIndex ? 1 : 0;

    const old = this._footstepBuffers[idx];
    if (old && old.stop) old.stop();

    const buffer = this.createBuffer("se/", name);

    const ch = (ConfigManager.footstepVolume ?? 100) / 100;
    const v = Math.max(0, Math.min(100, Math.round((se.volume ?? 90) * ch)));

    buffer.volume = v / 100;
    if (buffer.pitch != null) buffer.pitch = (se.pitch ?? 100) / 100;
    if (buffer.pan != null) buffer.pan = (se.pan ?? 0) / 100;

    buffer.play(false);
    this._footstepBuffers[idx] = buffer;
  };

  Game_CharacterBase.prototype.playStepSound = function(se) {
    const bufIndex = this._stepToggle ? 1 : 0;
    AudioManager.playFootstepSe(se, bufIndex);
    this._stepToggle = !this._stepToggle;
  };
})();
