/*:
 * @param CollectionSettings
 * @text 収集率設定一覧
 * @desc 収集率の計算と代入を複数設定できます。
 * @type struct<CollectionSetting>[]
 * @default []
 */

/*~struct~CollectionSetting:
 * @param ItemIds
 * @text 対象アイテムID一覧
 * @desc 収集率の対象となるアイテムのIDを指定（カンマ区切り）
 * @type number[]
 * @default []
 *
 * @param VariableId
 * @text 収集率代入変数ID
 * @desc 収集率を代入する変数のIDを指定
 * @type variable
 * @default 1
 */

(() => {
    const pluginName = "kamichichi_CLV";
    const parameters = PluginManager.parameters(pluginName);
    const collectionSettings = JSON.parse(parameters['CollectionSettings']).map(setting => {
        const data = JSON.parse(setting);
        return {
            itemIds: JSON.parse(data.ItemIds).map(Number),
            variableId: Number(data.VariableId)
        };
    });

    function updateCollectionRates() {
        collectionSettings.forEach(setting => {
            const totalItems = setting.itemIds.length;
            if (totalItems === 0) return;

            let obtainedCount = 0;
            setting.itemIds.forEach(id => {
                if ($gameParty.hasItem($dataItems[id])) {
                    obtainedCount++;
                }
            });

            const rate = Math.floor((obtainedCount / totalItems) * 100);
            $gameVariables.setValue(setting.variableId, rate);
        });
    }

    const _Game_Party_gainItem = Game_Party.prototype.gainItem;
    Game_Party.prototype.gainItem = function(item, amount, includeEquip) {
        _Game_Party_gainItem.call(this, item, amount, includeEquip);
        if (DataManager.isItem(item)) {
            updateCollectionRates();
        }
    };

    const _Game_System_onAfterLoad = Game_System.prototype.onAfterLoad;
    Game_System.prototype.onAfterLoad = function() {
        _Game_System_onAfterLoad.call(this);
        updateCollectionRates();
    };
})();