/*:
 * @command flashPicture
 * @text ピクチャ点滅
 * @desc 指定したピクチャIDのピクチャをイーズインしながら繰り返し点滅させる
 *
 * @arg pictureId
 * @text ピクチャID
 * @desc 点滅させるピクチャのID
 * @type number
 * @min 1
 * @default 1
 *
 * @arg duration
 * @text 点滅フレーム数
 * @desc 1回の点滅にかかるフレーム数（60で1秒）
 * @type number
 * @min 1
 * @default 60
 */

(() => {
    const pluginName = "kamichichi_PFI";

    PluginManager.registerCommand(pluginName, "flashPicture", args => {
        const pictureId = Number(args.pictureId);
        const duration = Number(args.duration);

        const picture = $gameScreen.picture(pictureId);
        if (!picture) return;

        const maxAlpha = 255;
        const minAlpha = 50; 
        let frame = 0;
        let direction = 1;

        const easeInOut = t => (1 - Math.cos(Math.PI * t)) / 2;

        const updateFlash = () => {
            if (!$gameScreen.picture(pictureId)) return;

            const t = frame / duration;
            const alpha = Math.round(minAlpha + (maxAlpha - minAlpha) * easeInOut(t));
            picture._opacity = alpha;

            frame += direction;
            if (frame >= duration || frame <= 0) {
                direction *= -1;
            }

            requestAnimationFrame(updateFlash);
        };

        updateFlash();
    });
})();
