(() => {
    const _Game_Event_setupPage = Game_Event.prototype.setupPage;
    Game_Event.prototype.setupPage = function() {
        _Game_Event_setupPage.call(this);
        this.checkCommentSwitch();
    };

    Game_Event.prototype.checkCommentSwitch = function() {
        if (!this.page()) return;
        const list = this.list();
        if (!list || list.length === 0) return;

        for (let i = 0; i < Math.min(3, list.length); i++) {
            if (list[i].code === 108 || list[i].code === 408) {
                const comment = list[i].parameters[0];
                const matchOn = comment.match(/<CS:(\d+)>/i);
                const matchOff = comment.match(/<CS_OFF:(\d+)>/i);
                if (matchOn) {
                    const switchId = Number(matchOn[1]);
                    if (!$gameSwitches.value(switchId)) {
                        $gameSwitches.setValue(switchId, true);
                    }
                }
                if (matchOff) {
                    const switchId = Number(matchOff[1]);
                    if ($gameSwitches.value(switchId)) {
                        $gameSwitches.setValue(switchId, false);
                    }
                }
            }
        }
    };
})();
