(() => {
    "use strict";

    let _needResume = false;

    function suspendAudio() {
        if (window.WebAudio && WebAudio._context && WebAudio._context.state === "running") {
            _needResume = true;
            WebAudio._context.suspend().catch(err => console.warn(err));
        }
    }

    function resumeAudio() {
        if (window.WebAudio && WebAudio._context && WebAudio._context.state === "suspended" && _needResume) {
            WebAudio._context.resume().catch(err => console.warn(err));
            _needResume = false;
        }
    }

    window.addEventListener("blur", () => {
        suspendAudio();
    });

    window.addEventListener("focus", () => {
        resumeAudio();
    });

    document.addEventListener("visibilitychange", () => {
        if (document.visibilityState === "hidden") {
            suspendAudio();
        } else {
            resumeAudio();
        }
    });
})();
