var Imported = Imported || {};
var KAMICHICHI = KAMICHICHI || {};
Imported.KAMICHICHI_CommonEventButtons = 1;
KAMICHICHI.CommonEventButtons = KAMICHICHI.CommonEventButtons || {};

(function ($) {

  $.Regex = /<CE[-_ ]button:\s*(.+?)\s*switch:\s*(\d+)\s*\/>/im

  $.buttonTrigger = function (commonEvent) {
    if (commonEvent.buttonTrigger === undefined) {
      commonEvent.buttonTrigger = { button: null, switchId: null };
      var list = commonEvent.list;
      for (var i = 0; i < list.length; i++) {
        var cmd = list[i];
        if (cmd.code === 108) { 
          var res = $.Regex.exec(cmd.parameters[0]);
          if (res) {
            commonEvent.buttonTrigger.button = res[1];
            commonEvent.buttonTrigger.switchId = Number(res[2]);
          }
        }
      }
    }
    return commonEvent.buttonTrigger;
  };

  Scene_Base.prototype.loadCommonEventButtons = function () {
    this._commonEventButtons = [];
    for (var i = 1; i < $dataCommonEvents.length; i++) {
      var cev = $dataCommonEvents[i];
      var trigger = $.buttonTrigger(cev);
      if (trigger.button) {
        this._commonEventButtons.push({
          button: trigger.button,
          switchId: trigger.switchId,
          eventId: cev.id
        });
      }
    }
  };

  Scene_Base.prototype.updateCommonEventButtons = function () {
    if (!this.canCheckCommonEventButton()) {
      return;
    }
    for (var i = 0; i < this._commonEventButtons.length; i++) {
      var entry = this._commonEventButtons[i];
      if (Input.isTriggered(entry.button) && $gameSwitches.value(entry.switchId)) {
        $gameTemp.reserveCommonEvent(entry.eventId);
      }
    }
  };

  Scene_Base.prototype.canCheckCommonEventButton = function () {
    if ($gameMap.isEventRunning()) {
      return false;
    }
    return true;
  }


  var KAMICHICHI_SceneMap_initialize = Scene_Map.prototype.initialize;
  Scene_Map.prototype.initialize = function () {
    KAMICHICHI_SceneMap_initialize.call(this);
    this.loadCommonEventButtons();
  };

  var KAMICHICHI_SceneMap_update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function () {
    KAMICHICHI_SceneMap_update.call(this);
    this.updateCommonEventButtons();
  };


  var KAMICHICHI_SceneBattle_initialize = Scene_Battle.prototype.initialize;
  Scene_Battle.prototype.initialize = function () {
    KAMICHICHI_SceneBattle_initialize.call(this);
    this.loadCommonEventButtons();
  };

  var KAMICHICHI_SceneBattle_update = Scene_Battle.prototype.update;
  Scene_Battle.prototype.update = function () {
    KAMICHICHI_SceneBattle_update.call(this);
    this.updateCommonEventButtons();
  };

})(KAMICHICHI.CommonEventButtons);
