/*:
 * @param CommonEventId
 * @text 実行するコモンイベントID
 * @type common_event
 * @default 1
 */

(() => {
    const pluginName = document.currentScript.src.match(/([^/]+)\.js$/)[1];
    const params = PluginManager.parameters(pluginName);
    const commonEventId = Number(params.CommonEventId || 0);

    if (!commonEventId) return;

    const _Scene_Map_start = Scene_Map.prototype.start;
    Scene_Map.prototype.start = function() {
        _Scene_Map_start.call(this);

        if ($gameTemp._kamichichiMapTransferExecuted) return;

        $gameTemp._kamichichiMapTransferExecuted = true;
        $gameTemp.reserveCommonEvent(commonEventId);
    };

    const _Game_Player_performTransfer = Game_Player.prototype.performTransfer;
    Game_Player.prototype.performTransfer = function() {
        $gameTemp._kamichichiMapTransferExecuted = false;
        _Game_Player_performTransfer.call(this);
    };
})();
