/*:
 * @param Enable
 * @text 機能を有効にする
 * @type boolean
 * @default true
 *
 * @param CommonEventId
 * @text オプション終了後のコモンイベント
 * @type common_event
 * @default 0
 *
 * @param MasterSwitchId
 * @text 大本ON/OFFスイッチ
 * @desc このスイッチがONの時だけ機能します。0なら常に有効。
 * @type switch
 * @default 0
 *
 */

(() => {
    "use strict";

    const pluginName = "kamichichi_messege_option";
    const parameters = PluginManager.parameters(pluginName);

    const paramEnable         = parameters["Enable"] === "true";
    const paramCommonEventId  = Number(parameters["CommonEventId"] || 0);
    const paramMasterSwitchId = Number(parameters["MasterSwitchId"] || 0);

    Input.keyMapper[65] = "A";

    function isMasterEnabledBySwitch() {
        if (!paramMasterSwitchId || paramMasterSwitchId <= 0) return true;
        if (!$gameSwitches) return false;
        return !!$gameSwitches.value(paramMasterSwitchId);
    }

    function isMessageWindowActive() {
        const scene = SceneManager._scene;
        if (scene && scene._messageWindow) {
            const win = scene._messageWindow;
            if (win.visible && win.openness > 0 && !win.isClosing()) {
                return true;
            }
        }
        if ($gameMessage && $gameMessage.isBusy()) {
            return true;
        }
        return false;
    }

    function isAnyChoiceWindowActive() {
        const scene = SceneManager._scene;
        if (!scene) return false;

        const choiceWin = scene._choiceListWindow;
        if (choiceWin && choiceWin.visible && choiceWin.isOpen && choiceWin.isOpen() && choiceWin.active) {
            return true;
        }

        const galgeWin = scene._galgeChoiceListWindow;
        if (galgeWin && galgeWin.visible && galgeWin.isOpen && galgeWin.isOpen() && galgeWin.active) {
            return true;
        }

        return false;
    }

    function shouldOpenMessageOption() {
        if (!paramEnable) return false;

        // ★追加：大本ON/OFFスイッチ
        if (!isMasterEnabledBySwitch()) return false;

        if (!isMessageWindowActive()) return false;

        if (isAnyChoiceWindowActive()) return false;

        if (SceneManager.isSceneChanging()) return false;
        if (!Input.isTriggered("A")) return false;
        return true;
    }

    function markOpenFromMessage() {
        if ($gameTemp) {
            $gameTemp._kchMessageOptionOpened = true;
        }
    }

    function consumeOpenFromMessageFlag() {
        if ($gameTemp && $gameTemp._kchMessageOptionOpened) {
            $gameTemp._kchMessageOptionOpened = false;
            return true;
        }
        return false;
    }

    function updateKchMessageOptionInterpreter() {
        if (!$gameTemp) return;
        const interpreter = $gameTemp._kchMessageOptionInterpreter;
        if (interpreter && interpreter.isRunning()) {
            interpreter.update();
        } else if (interpreter && !interpreter.isRunning()) {
            $gameTemp._kchMessageOptionInterpreter = null;
        }
    }

    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.call(this);
        if (shouldOpenMessageOption()) {
            markOpenFromMessage();
            SceneManager.push(Scene_Options);
        }
    };

    const _Scene_Map_updateMain = Scene_Map.prototype.updateMain;
    Scene_Map.prototype.updateMain = function() {
        updateKchMessageOptionInterpreter();
        _Scene_Map_updateMain.call(this);
    };

    const _Scene_Battle_update = Scene_Battle.prototype.update;
    Scene_Battle.prototype.update = function() {
        _Scene_Battle_update.call(this);
        if (shouldOpenMessageOption()) {
            markOpenFromMessage();
            SceneManager.push(Scene_Options);
        }
        updateKchMessageOptionInterpreter();
    };

    const _Scene_Options_terminate = Scene_Options.prototype.terminate;
    Scene_Options.prototype.terminate = function() {
        _Scene_Options_terminate.call(this);

        if (!consumeOpenFromMessageFlag()) return;
        if (!paramCommonEventId || paramCommonEventId <= 0) return;
        if (!$dataCommonEvents || !$dataCommonEvents[paramCommonEventId]) return;
        if (!$gameTemp) return;

        const commonEvent = $dataCommonEvents[paramCommonEventId];
        const interpreter = new Game_Interpreter();
        interpreter.setup(commonEvent.list);
        $gameTemp._kchMessageOptionInterpreter = interpreter;
    };

})();
