/*:
 * @param activeSwitchId
 * @text 有効化スイッチID
 * @type switch
 * @desc 動作を有効にするスイッチのIDを指定します。
 * @default 1
 *
 * @param pauseFrames
 * @text 停止フレーム数
 * @type number
 * @desc プレイヤーが停止とみなされるフレーム数を指定します。
 * @default 60
 *
 * @param onPauseCommonEvent
 * @text 停止時コモンイベント
 * @type common_event
 * @desc プレイヤーが指定フレーム停止した場合に実行するコモンイベント。
 * @default 1
 *
 * @param onMoveCommonEvent
 * @text 移動時コモンイベント
 * @type common_event
 * @desc 停止状態から移動した場合に実行するコモンイベント。
 * @default 2
 */

(() => {
    const parameters = PluginManager.parameters('kamichichi_player_pause_common');
    const activeSwitchId = Number(parameters['activeSwitchId'] || 1);
    const pauseFrames = Number(parameters['pauseFrames'] || 60);
    const onPauseCommonEvent = Number(parameters['onPauseCommonEvent'] || 1);
    const onMoveCommonEvent = Number(parameters['onMoveCommonEvent'] || 2);

    let pauseCounter = 0;
    let wasPlayerStopped = false;

    const _Game_Player_update = Game_Player.prototype.update;
    Game_Player.prototype.update = function(sceneActive) {
        _Game_Player_update.call(this, sceneActive);

        if (!$gameSwitches.value(activeSwitchId)) {
            pauseCounter = 0;
            wasPlayerStopped = false;
            return;
        }

        if (this.isMoving()) {
            if (wasPlayerStopped) {
                wasPlayerStopped = false;
                $gameTemp.reserveCommonEvent(onMoveCommonEvent);
            }
            pauseCounter = 0;
        } else {
            pauseCounter++;
            if (pauseCounter >= pauseFrames && !wasPlayerStopped) {
                wasPlayerStopped = true;
                $gameTemp.reserveCommonEvent(onPauseCommonEvent);
            }
        }
    };
})();
