/*:
 * @command set
 * @text Set X & Y Offset
 * @desc Set X & Y Offset
 *
 * @arg eventId
 * @default 0
 * @text Event ID
 * @desc Event ID (0 = this event)
 *
 * @arg x
 * @default 0
 * @text X Offset
 * @desc X Offset
 *
 * @arg y
 * @default 0
 * @text Y Offset
 * @desc Y Offset
 *
 * @command setX
 * @text Set X Offset
 * @desc Set X Offset
 *
 * @arg eventId
 * @default 0
 * @text Event ID
 * @desc Event ID (0 = this event)
 *
 * @arg x
 * @default 0
 * @text X Offset
 * @desc X Offset
 *
 * @command setY
 * @text Set Y Offset
 * @desc Set Y Offset
 *
 * @arg eventId
 * @default 0
 * @text Event ID
 * @desc Event ID (0 = this event)
 *
 * @arg y
 * @default 0
 * @text Y Offset
 * @desc Y Offset
 *
 * @command setZ
 * @text Set Z Layer Index
 * @desc Set Z Layer Index
 *
 * @arg eventId
 * @default 0
 * @text Event ID
 * @desc Event ID (0 = this event)
 *
 * @arg z
 * @default
 * @text Z Layer Index
 * @desc Z Layer Index
 *
 * @command setHue
 * @text Set Hue
 * @desc Set Hue (Range -360 to 360)
 *
 * @arg eventId
 * @default 0
 * @text Event ID
 * @desc Event ID (0 = this event)
 *
 * @arg hue
 * @default 0
 * @text Hue
 * @desc Hue (Range -360 to 360)
 *
 * @command setMirror
 * @text Set Mirror
 * @desc Set Mirror
 *
 * @arg eventId
 * @default 0
 * @text Event ID
 * @desc Event ID (0 = this event)
 *
 * @arg mirror
 * @default true
 * @text Mirror Mode
 * @desc Mirror
 *
 * @param Mirror Data
 * @text Mirror Data
 * @type struct<mirrorSettings>[]
 * @desc Mirror Settings（CTB準拠）
 * @default []
 *
 * @param __reserved__
 * @text （内部用）
 * @type hidden
 * @default 0
 *
 */

/*~struct~mirrorSettings:
 * @param X
 * @desc X Location of Mirror (relative to parent)
 * @default 0
 *
 * @param Y
 * @desc Y Location of Mirror (relative to parent)
 * @default 0
 *
 * @param Source X
 * @desc Source X Frame Start Location of Mirrored Image (ex: sx)
 * @default sx
 *
 * @param Source Y
 * @desc Source Y Frame Start Location of Mirrored Image (ex: sy)
 * @default sy
 *
 * @param Source Width
 * @desc Source Frame Width of Mirrored Image (ex: pw)
 * @default pw
 *
 * @param Source Height
 * @desc Source Frame Height of Mirrored Image (ex: ph)
 * @default ph
 *
 * @param Check X Location
 * @desc Code that determines when mirrored (X Location)
 * @default a._realX >= b._realX-.6 && a._realX <= b._realX+.9
 *
 * @param Check Y Location
 * @desc Code that determines when mirrored (Y Location)
 * @default b._realY >= a._realY+1 && b._realY <= a._realY+1.7
 */

(() => {
  'use strict';
  const BUNDLE_NAME = 'kamichichi_SpriteEX';
  const params = PluginManager.parameters(BUNDLE_NAME);
  var CTB = window.CTB || {}; CTB.SpriteExtras = CTB.SpriteExtras || {};
  (function($_$){
    const pluginName = BUNDLE_NAME;

    const parseJSONSafe = (s, def) => {
      try { return JSON.parse(s); } catch(_) { return def; }
    };

    $_$.par = {};
    $_$.par['Mirror Data'] = parseJSONSafe(params['Mirror Data']||'[]', []);

    DataManager.getCurrentEventId = function(){
      if ($gameMap._interpreter && $gameMap._interpreter.character(0)){
        const ch = $gameMap._interpreter.character(0);
        if (ch && ch._eventId){ return ch._eventId; }
      }
      return 0;
    };

    PluginManager.registerCommand(pluginName, 'set', args => {
      const eventId = eval(args.eventId) === 0 ? DataManager.getCurrentEventId() : eval(args.eventId);
      const e = SceneManager._scene?._spriteset?._characterSprites?.filter(v => v._character?._eventId === eventId) || [];
      e.forEach(v => { if (v._character){ v._character._ctbExtra = v._character._ctbExtra || {}; v._character._ctbExtra.x = (args.x); v._character._ctbExtra.y = (args.y);} });
    });
    PluginManager.registerCommand(pluginName, 'setX', args => {
      const eventId = eval(args.eventId) === 0 ? DataManager.getCurrentEventId() : eval(args.eventId);
      const e = SceneManager._scene?._spriteset?._characterSprites?.filter(v => v._character?._eventId === eventId) || [];
      e.forEach(v => { if (v._character){ v._character._ctbExtra = v._character._ctbExtra || {}; v._character._ctbExtra.x = (args.x);} });
    });
    PluginManager.registerCommand(pluginName, 'setY', args => {
      const eventId = eval(args.eventId) === 0 ? DataManager.getCurrentEventId() : eval(args.eventId);
      const e = SceneManager._scene?._spriteset?._characterSprites?.filter(v => v._character?._eventId === eventId) || [];
      e.forEach(v => { if (v._character){ v._character._ctbExtra = v._character._ctbExtra || {}; v._character._ctbExtra.y = (args.y);} });
    });
    PluginManager.registerCommand(pluginName, 'setZ', args => {
      const eventId = eval(args.eventId) === 0 ? DataManager.getCurrentEventId() : eval(args.eventId);
      const e = SceneManager._scene?._spriteset?._characterSprites?.filter(v => v._character?._eventId === eventId) || [];
      e.forEach(v => { if (v._character){ v._character._ctbExtra = v._character._ctbExtra || {}; v._character._ctbExtra.z = (args.z);} });
    });
    PluginManager.registerCommand(pluginName, 'setHue', args => {
      const eventId = eval(args.eventId) === 0 ? DataManager.getCurrentEventId() : eval(args.eventId);
      const e = SceneManager._scene?._spriteset?._characterSprites?.filter(v => v._character?._eventId === eventId) || [];
      e.forEach(v => { if (v._character){ v._character._ctbExtra = v._character._ctbExtra || {}; v._character._ctbExtra.hue = (args.hue);} });
    });
    PluginManager.registerCommand(pluginName, 'setMirror', args => {
      const eventId = eval(args.eventId) === 0 ? DataManager.getCurrentEventId() : eval(args.eventId);
      const e = SceneManager._scene?._spriteset?._characterSprites?.filter(v => v._character?._eventId === eventId) || [];
      e.forEach(v => { if (v._character){ v._character._ctbExtra = v._character._ctbExtra || {}; v._character._ctbExtra.mirror = (args.mirror);} });
    });

    const str2obj = str => (str||'').split(',').map(s=>s.split(':').map(_=>_.trim())).reduce((a,[k,v])=>{ if(k) a[k]=v; return a; },{});

    DataManager.getCommandValue = function(a, d) {
      let v = null; if (a && d){ let z = '/>', c = d + ':'; let i = [a.indexOf(c)];
        if (i[0] > -1){ i[1] = i[0]+c.length; i[2] = a.indexOf(z, i[1]); if (i[2] === -1) {i[2] = null}; i[3] = i[2] ? i[2]-i[1]: null; v = a.substr(i[1], i[3]).trim(); }
      } return v;
    };

    const _SprChar_init = Sprite_Character.prototype.initialize;
    Sprite_Character.prototype.initialize = function(character){
      _SprChar_init.apply(this, arguments);
      this._character = this._character || {};
      if (this._character._eventId && $dataMap && $dataMap.events[this._character._eventId]){
        const note = $dataMap.events[this._character._eventId].note || '';
        let v = null;
        v = DataManager.getCommandValue(note, 'xOff');   if (v) {this._character._ctbExtra = this._character._ctbExtra || {}; this._character._ctbExtra.xNote = v;}
        v = DataManager.getCommandValue(note, 'yOff');   if (v) {this._character._ctbExtra = this._character._ctbExtra || {}; this._character._ctbExtra.yNote = v;}
        v = DataManager.getCommandValue(note, 'z');      if (v) {this._character._ctbExtra = this._character._ctbExtra || {}; this._character._ctbExtra.zNote = v;}
        v = DataManager.getCommandValue(note, 'hue');    if (v) {this._character._ctbExtra = this._character._ctbExtra || {}; this._character._ctbExtra.hueNote = v;}
        v = DataManager.getCommandValue(note, 'srcX');   if (v) {this._character._ctbExtra = this._character._ctbExtra || {}; this._character._ctbExtra.srcX_Note = v;}
        v = DataManager.getCommandValue(note, 'srcY');   if (v) {this._character._ctbExtra = this._character._ctbExtra || {}; this._character._ctbExtra.srcY_Note = v;}
        v = DataManager.getCommandValue(note, 'frameW'); if (v) {this._character._ctbExtra = this._character._ctbExtra || {}; this._character._ctbExtra.frameW_Note = v;}
        v = DataManager.getCommandValue(note, 'frameH'); if (v) {this._character._ctbExtra = this._character._ctbExtra || {}; this._character._ctbExtra.frameH_Note = v;}
        v = DataManager.getCommandValue(note, 'mirror'); if (v) {this._character._ctbExtra = this._character._ctbExtra || {}; this._character._ctbExtra.mirror_Note = v;}
      }
      this._character._ctbExtra        = this._character._ctbExtra        || {x:0, y:0, hue: 0};
      this._character._ctbExtra.x      = this._character._ctbExtra.x      || (this._character._ctbExtra.xNote)     || 0;
      this._character._ctbExtra.y      = this._character._ctbExtra.y      || (this._character._ctbExtra.yNote)     || 0;
      this._character._ctbExtra.z      = this._character._ctbExtra.z      || this._character._ctbExtra.zNote       || null;
      this._character._ctbExtra.hue    = this._character._ctbExtra.hue    || (this._character._ctbExtra.hueNote)   || 0;
      this._character._ctbExtra.srcX   = this._character._ctbExtra.srcX   || this._character._ctbExtra.srcX_Note   || null;
      this._character._ctbExtra.srcY   = this._character._ctbExtra.srcY   || this._character._ctbExtra.srcY_Note   || null;
      this._character._ctbExtra.frameW = this._character._ctbExtra.frameW || this._character._ctbExtra.frameW_Note || 0;
      this._character._ctbExtra.frameH = this._character._ctbExtra.frameH || this._character._ctbExtra.frameH_Note || 0;
      this._character._ctbExtra.mirror = this._character._ctbExtra.mirror || this._character._ctbExtra.mirror_Note;

      if (this._character._ctbExtra.mirror){
        this._mirrorSprite = new Sprite_Mirror($gamePlayer);
        this.addChild(this._mirrorSprite);
      }
    };

    Sprite_Character.prototype.updateTileFrame = function(){
      const tileId = this._tileId, pw = this.patternWidth(), ph = this.patternHeight();
      const sx = ((Math.floor(tileId / 128) % 2) * 8 + (tileId % 8)) * pw;
      const sy = (Math.floor((tileId % 256) / 8) % 16) * ph;
      const n = {
        sx: eval(this._character._ctbExtra.srcX) || sx,
        sy: eval(this._character._ctbExtra.srcY) || sy,
        pw: eval(this._character._ctbExtra.frameW) || pw,
        ph: eval(this._character._ctbExtra.frameH) || ph,
      };
      this.setFrame(n.sx, n.sy, n.pw, n.ph);
    };

    Sprite_Character.prototype.updateCharacterFrame = function(){
      const pw = this.patternWidth(), ph = this.patternHeight();
      const sx = (this.characterBlockX() + this.characterPatternX()) * pw;
      const sy = (this.characterBlockY() + this.characterPatternY()) * ph;
      const n = {
        sx: eval(this._character._ctbExtra.srcX) || sx,
        sy: eval(this._character._ctbExtra.srcY) || sy,
        pw: eval(this._character._ctbExtra.frameW) || pw,
        ph: eval(this._character._ctbExtra.frameH) || ph,
      };
      this.updateHalfBodySprites();
      if (this._bushDepth > 0){
        const d = this._bushDepth;
        this._upperBody.setFrame(n.sx, n.sy, n.pw, n.ph - d);
        this._lowerBody.setFrame(n.sx, n.sy + n.ph - d, n.pw, d);
        this.setFrame(n.sx, n.sy, 0, n.ph);
      } else {
        this.setFrame(n.sx, n.sy, n.pw, n.ph);
      }
    };

    Sprite_Character.prototype.updatePosition = function(){
      this.x = this._character.screenX() + eval(this._character._ctbExtra.x);
      this.y = this._character.screenY() + eval(this._character._ctbExtra.y);
      this.z = eval(this._character._ctbExtra.z) || this._character.screenZ();
    };

    const _SprChar_updateOther = Sprite_Character.prototype.updateOther;
    Sprite_Character.prototype.updateOther = function(){
      _SprChar_updateOther.apply(this, arguments);
      if (this._character){
        this._character._ctbExtra = this._character._ctbExtra || {};
        if (this._character._ctbExtra.hue){ this.setHue(eval(this._character._ctbExtra.hue)); }
      }
    };

    const _SprChar_updateVisibility = Sprite_Character.prototype.updateVisibility;
    Sprite_Character.prototype.updateVisibility = function(){
      let isMirrored = false;
      if (this._mirrorSprite){
        this._mirrorSprite._mirrored = this._mirrorSprite._mirrored || {};
        if (this._mirrorSprite._mirrored.objectData){
          if (this._character.isTransparent()) this.visible = false;
          isMirrored = true;
        }
      }
      if (!isMirrored) _SprChar_updateVisibility.apply(this, arguments);
    };

    function Sprite_Mirror(){ this.initialize(...arguments); }
    Sprite_Mirror.prototype = Object.create(Sprite.prototype);
    Sprite_Mirror.prototype.constructor = Sprite_Mirror;

    Sprite_Mirror.prototype.initialize = function(character){
      Sprite.prototype.initialize.call(this);
      this.initMembers();
      this._mirrored = new Game_Player();
      this._mirrored._stepAnime = true;
      this.setMirrorImage($gamePlayer);
      this.setCharacter(this._mirrored);
    };
    Sprite_Mirror.prototype.setMirrorImage = function(actor){
      const characterName = actor ? actor._characterName : '';
      const characterIndex = actor ? actor._characterIndex : 0;
      this._mirrored.objectData = actor;
      this._mirrored.setImage(characterName, characterIndex);
      this._mirrored._stepAnime = true;
    };
    Sprite_Mirror.prototype.initMembers = function(){
      this.anchor.x = 0.5; this.anchor.y = 1;
      this._character = null; this._balloonDuration = 0; this._tilesetId = 0;
      this._upperBody = null; this._lowerBody = null;
    };
    Sprite_Mirror.prototype.setCharacter = function(character){ this._character = character; };
    Sprite_Mirror.prototype.checkCharacter = function(character){ return this._character === character; };
    Sprite_Mirror.prototype.update = function(){
      Sprite.prototype.update.call(this);
      this.updateBitmap(); this.updateFrame(); this.updatePosition(); this.updateOther(); this.updateVisibility();
    };
    Sprite_Mirror.prototype.updateVisibility = function(){ Sprite.prototype.updateVisibility.call(this); this.visible = this.needsDisplay(); };
    Sprite_Mirror.prototype.needsDisplay = function(){
      if (this.isEmptyCharacter() || this._character.isTransparent()) return false;
      if (this.parent._character._ctbExtra && this.parent._character._ctbExtra.mirror){
        let v = this.hasCharacterInfront($gamePlayer);
        if (!v){
          for (let i=0;i<$gamePlayer._followers._data.length && !v;i++) v = this.hasCharacterInfront($gamePlayer._followers._data[i]);
          if (!v){ for (const ev of ($dataMap.events||[]).filter(Boolean)){ v = this.hasCharacterInfront($gameMap._events[ev.id]); if (v) break; } }
        }
        return v;
      }
      return false;
    };
    Sprite_Mirror.prototype.hasCharacterInfront = function(b){
      if (!b) return false;
      const a = this.parent._character;
      let cx = a._realX >= b._realX - .6 && a._realX <= b._realX + .9;
      let cy = b._realY >= a._realY + 1 && b._realY <= a._realY + 1.7;
      const dataStr = a._ctbExtra ? (a._ctbExtra.mirror || null) : null;
      if (dataStr){
        const data = str2obj(dataStr); if (data){
          const index = (eval(data.type)||1) - 1;
          cx = $_$.par['Mirror Data'][index]?.['Check X Location'] ?? cx;
          cy = $_$.par['Mirror Data'][index]?.['Check Y Location'] ?? cy;
        }
      }
      if (eval(cx) && eval(cy)){ this.setMirrorImage(b); return true; }
      return false;
    };
    Sprite_Mirror.prototype.isTile = function(){ return this._character.isTile(); };
    Sprite_Mirror.prototype.isObjectCharacter = function(){ return this._character.isObjectCharacter(); };
    Sprite_Mirror.prototype.isEmptyCharacter = function(){ return this._tileId === 0 && !this._characterName; };
    Sprite_Mirror.prototype.updateBitmap = function(){ if (this.isImageChanged()){ this._characterName = this._character.characterName(); this._characterIndex = this._character.characterIndex(); this.setCharacterBitmap(); } };
    Sprite_Mirror.prototype.isImageChanged = function(){ return (this._characterName !== this._character.characterName() || this._characterIndex !== this._character.characterIndex()); };
    Sprite_Mirror.prototype.setCharacterBitmap = function(){ this.bitmap = ImageManager.loadCharacter(this._characterName); this._isBigCharacter = ImageManager.isBigCharacter(this._characterName); };
    Sprite_Mirror.prototype.updateFrame = function(){
      let pw = this.patternWidth(), ph = this.patternHeight();
      let sx = (this.characterBlockX() + this.characterPatternX()) * pw;
      let sy = (this.characterBlockY() + this.characterPatternY()) * ph;
      const dataStr = this.parent._character._ctbExtra ? (this.parent._character._ctbExtra.mirror || null) : null;
      if (dataStr){
        const data = str2obj(dataStr); if (data){ const index = (eval(data.type)||1) - 1; sx = eval($_$.par['Mirror Data'][index]['Source X']); sy = eval($_$.par['Mirror Data'][index]['Source Y']); pw = eval($_$.par['Mirror Data'][index]['Source Width']); ph = eval($_$.par['Mirror Data'][index]['Source Height']); }
      } else {
        sx = sx + 10; sy = sy + 0; pw = pw - 20; ph = ph - 12;
      }
      this.updateHalfBodySprites();
      if (this._bushDepth > 0){
        const d = this._bushDepth; this._upperBody.setFrame(sx, sy, pw, ph - d); this._lowerBody.setFrame(sx, sy + ph - d, pw, d); this.setFrame(sx, sy, 0, ph);
      } else { this.setFrame(sx, sy, pw, ph); }
    };
    Sprite_Mirror.prototype.updatePosition = function(){
      const a = this.parent._character._ctbExtra;
      if (a){
        const b = this.parent._character._mirrored ? this.parent._character._mirrored.objectData._ctbExtra : {};
        const dataStr = a.mirror; if (dataStr){ const data = str2obj(dataStr); if (data){ const index = (eval(data.type)||1) - 1; this.x = eval($_$.par['Mirror Data'][index]['X']); this.y = eval($_$.par['Mirror Data'][index]['Y']); this.x += eval(b?.x||0); this.y += eval(b?.y||0); } }
      } else { this.x = 0; this.y = -23; }
    };
    Sprite_Mirror.prototype.characterBlockX = function(){ return this._isBigCharacter ? 0 : (this._character.characterIndex() % 4) * 3; };
    Sprite_Mirror.prototype.characterBlockY = function(){ return this._isBigCharacter ? 0 : Math.floor(this._character.characterIndex() / 4) * 4; };
    Sprite_Mirror.prototype.characterPatternX = function(){ return this._character.pattern(); };
    Sprite_Mirror.prototype.characterPatternY = function(){ return (this._character.direction() - 2) / 2; };
    Sprite_Mirror.prototype.patternWidth  = function(){ if (this._tileId > 0) return $gameMap.tileWidth();  return this._isBigCharacter ? this.bitmap.width / 3 : this.bitmap.width / 12; };
    Sprite_Mirror.prototype.patternHeight = function(){ if (this._tileId > 0) return $gameMap.tileHeight(); return this._isBigCharacter ? this.bitmap.height / 4 : this.bitmap.height / 8; };
    Sprite_Mirror.prototype.updateHalfBodySprites = function(){
      if (this._bushDepth > 0){ this.createHalfBodySprites(); this._upperBody.bitmap = this.bitmap; this._upperBody.visible = true; this._upperBody.y = -this._bushDepth; this._lowerBody.bitmap = this.bitmap; this._lowerBody.visible = true; this._upperBody.setBlendColor(this.getBlendColor()); this._lowerBody.setBlendColor(this.getBlendColor()); this._upperBody.setColorTone(this.getColorTone()); this._lowerBody.setColorTone(this.getColorTone()); this._upperBody.blendMode = this.blendMode; this._lowerBody.blendMode = this.blendMode; }
      else if (this._upperBody){ this._upperBody.visible = false; this._lowerBody.visible = false; }
    };
    Sprite_Mirror.prototype.createHalfBodySprites = function(){
      if (!this._upperBody){ this._upperBody = new Sprite(); this._upperBody.anchor.x = 0.5; this._upperBody.anchor.y = 1; this.addChild(this._upperBody); }
      if (!this._lowerBody){ this._lowerBody = new Sprite(); this._lowerBody.anchor.x = 0.5; this._lowerBody.anchor.y = 1; this._lowerBody.opacity = 128; this.addChild(this._lowerBody); }
    };
    Sprite_Mirror.prototype.updateOther = function(){
      this.opacity = 80; this.blendMode = this._character.blendMode(); this._bushDepth = this._character.bushDepth();
      if (this._mirrored.objectData){
        const v = this._mirrored.objectData;
        if (v._direction === 4 || v._direction === 6) this._character._direction = v._direction;
        if (v._direction === 2) this._character._direction = 8;
        if (v._direction === 8) this._character._direction = 2;
        this._character._stepAnime = ((this._mirrored.objectData.isMoving() && this._mirrored.objectData.hasWalkAnime()) || v._stepAnime);
        this._character._walkAnime = v._walkAnime; this._character.updateAnimationCount();
        if (this._character._animationCount >= this._character.animationWait()) { this._character.updatePattern(); this._character._animationCount = 0; }
      }
    };
  })(CTB.SpriteExtras);

  (function(){
    class Game_Scale {
      constructor(scaleX = 1, scaleY = 1, symbol = Game_Scale.ALL_SYMBOL){ this._x = scaleX; this._y = scaleY; this._symbol = symbol; }
      static get ALL_SYMBOL(){ return 'all'; }
      static get META_NAME(){ return 'scale'; }
      set(x = 1, y = 1){ this._x = x; this._y = y; }
      get x(){ return this._x; } get y(){ return this._y; } get symbol(){ return this._symbol; }
    }
    window.Game_Scale = Game_Scale;

    const _Game_System_initialize = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function(){ _Game_System_initialize.call(this); this._characterScaleDict = {}; };
    Game_System.prototype.characterScaleDict = function(){ this._characterScaleDict ||= {}; return this._characterScaleDict; };
    Game_System.prototype.changeCharacterScale = function(scaleX = 1, scaleY = 1, symbol = Game_Scale.ALL_SYMBOL){ this._setCharacterScale(scaleX, scaleY, symbol); this._applyCharacterScale(symbol); };
    Game_System.prototype.getCharacterScaleX = function(symbol = Game_Scale.ALL_SYMBOL){ const t = this.characterScaleDict()[symbol]; return t ? t.x : 1; };
    Game_System.prototype.getCharacterScaleY = function(symbol = Game_Scale.ALL_SYMBOL){ const t = this.characterScaleDict()[symbol]; return t ? t.y : 1; };
    Game_System.prototype._applyCharacterScale = function(symbol = Game_Scale.ALL_SYMBOL){ const ss = SceneManager._scene?._spriteset; if (ss){ const x = this.getCharacterScaleX(symbol), y = this.getCharacterScaleY(symbol); ss.setCharacterScale(x, y, symbol); } };
    Game_System.prototype._setCharacterScale = function(scaleX = 1, scaleY = 1, symbol = Game_Scale.ALL_SYMBOL){ let t = this.characterScaleDict()[symbol]; if (!t){ this.characterScaleDict()[symbol] = new Game_Scale(scaleX, scaleY, symbol); } this.characterScaleDict()[symbol].set(scaleX, scaleY); };

    Game_Character.prototype.scaleMeta = function(){ return 'null'; };
    Game_Event.prototype.scaleMeta = function(){ return this.event().meta[Game_Scale.META_NAME] || 'null'; };
    Game_Player.prototype.scaleMeta = function(){ return 'player'; };
    Game_Follower.prototype.scaleMeta = function(){ return 'follower'; };
    Game_Vehicle.prototype.scaleMeta = function(){ return 'vehicle'; };

    Game_Event.prototype.getScaleFromMeta = function(){
      const sx = this.event().meta.scaleX ? parseFloat(this.event().meta.scaleX) : 1;
      const sy = this.event().meta.scaleY ? parseFloat(this.event().meta.scaleY) : 1;
      return { x: sx, y: sy };
    };
    
      const parseScalePair = s => {
    if (typeof s !== 'string') return null;
    const t = s.split(',').map(v => v.trim()).filter(Boolean);
    if (t.length === 0) return null;
    const a = parseFloat(t[0]);
    const b = t.length > 1 ? parseFloat(t[1]) : a;
    if (Number.isFinite(a) && Number.isFinite(b)) return { x: a, y: b };
    return null;
  };
    Game_Event.prototype.scaleMeta = function(){
    const m = this.event().meta[Game_Scale.META_NAME];
    if (!m) return 'null';
    const p = parseScalePair(m);
    return p ? 'null' : m;
  };

Game_Event.prototype.getScaleFromMeta = function(){
  const ev = this.event();
  if (!ev || !ev.meta) {
    return { x: 1, y: 1 };
  }

  const m = ev.meta[Game_Scale.META_NAME];
  const p = parseScalePair(m);
  if (p) return p;

  const sx = ev.meta.scaleX ? parseFloat(ev.meta.scaleX) : 1;
  const sy = ev.meta.scaleY ? parseFloat(ev.meta.scaleY) : 1;
  return { x: sx, y: sy };
};

    const _Spriteset_Map_createCharacters = Spriteset_Map.prototype.createCharacters;
    Spriteset_Map.prototype.createCharacters = function(){
      _Spriteset_Map_createCharacters.call(this);
      this._characterSprites.forEach(sprite => {
        const ch = sprite._character;
        if (ch instanceof Game_Event){ const sc = ch.getScaleFromMeta(); sprite.scale.set(sc.x, sc.y); }
      });
    };

    Spriteset_Map.prototype.setCharacterScale = function(scaleX, scaleY, symbol){
      if (symbol === Game_Scale.ALL_SYMBOL){ this._applyCharacterScale(this._characterSprites, scaleX, scaleY); }
      else {
        const list = this._characterSprites.filter(s => s && s._character.scaleMeta() === symbol);
        this._applyCharacterScale(list, scaleX, scaleY);
      }
    };
    Spriteset_Map.prototype._applyCharacterScale = function(list, x, y){ list.forEach(s => s && s.scale.set(x, y)); };
    Spriteset_Map.prototype._changeOnlyAllSymbolSprite = function(){ const x = $gameSystem.getCharacterScaleX(); const y = $gameSystem.getCharacterScaleY(); this.setCharacterScale(x, y, Game_Scale.ALL_SYMBOL); };
    Spriteset_Map.prototype._changeAllCharacterScaleExceptAllSymbol = function(){ const keys = Object.keys($gameSystem.characterScaleDict()).filter(k => k !== Game_Scale.ALL_SYMBOL); keys.forEach(k => { const m = $gameSystem.characterScaleDict()[k]; this.setCharacterScale(m.x, m.y, k); }); };
  })();

  (function(){
    window.Fuku_Plugins = window.Fuku_Plugins || {}; Fuku_Plugins.EventTremble = { Version: 100 };
    const dm_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function(contents){
      dm_extractSaveContents.apply(this, arguments);
      const restore = ev => {
        if (ev && ev._fuku_trembleinfo){ const power = ev._fuku_trembleinfo.power; const speed = ev._fuku_trembleinfo.speed; const stop_cycle = ev._fuku_trembleinfo.stop_cycle; ev._fuku_trembleinfo = undefined; if (power){ Fuku_Plugins.EventTremble.startObject(ev, power, speed, stop_cycle); } }
      };
      restore($gamePlayer); $gameMap.events().forEach(restore);
    };
    const hook_screenX = function(){ return this._fuku_trembleinfo.screenX.call(this) + this._fuku_trembleinfo.offsetx; };
    const hook_update  = function(){ const info = this._fuku_trembleinfo; info.update.apply(this, arguments); if (!info.power) return; info.ang += info.speed; info.offsetx = Math.round(Math.sin(info.ang) * info.power); if (info.stop_ang && (info.ang > info.stop_ang)) Fuku_Plugins.EventTremble.stopObject(this); };

    Fuku_Plugins.EventTremble.startObject = function(event, power, speed, stop_cycle){
      if (!event._fuku_trembleinfo){ event._fuku_trembleinfo = { ang: 0.0, offsetx: 0, screenX: event.screenX, update: event.update }; event.screenX = hook_screenX; event.update = hook_update; }
      event._fuku_trembleinfo.power = power; event._fuku_trembleinfo.speed = speed;
      if (stop_cycle){ event._fuku_trembleinfo.stop_cycle = stop_cycle; event._fuku_trembleinfo.stop_ang = event._fuku_trembleinfo.ang + stop_cycle * Math.PI * 2; }
      else { event._fuku_trembleinfo.stop_cycle = null; event._fuku_trembleinfo.stop_ang = null; }
      return true;
    };
    Fuku_Plugins.EventTremble.start = function(eventid, power, speed, stop_cycle){ const event = (eventid < 0 ? $gamePlayer : $gameMap.event(eventid)); if (!event) return false; return Fuku_Plugins.EventTremble.startObject(event, power, speed, stop_cycle); };
    Fuku_Plugins.EventTremble.stopObject = function(event){
      if (!event._fuku_trembleinfo) return false;
      if ((event.screenX === hook_screenX) && (event.update === hook_update)){
        event.screenX = event._fuku_trembleinfo.screenX; event.update = event._fuku_trembleinfo.update; event._fuku_trembleinfo = undefined;
      } else {
        event._fuku_trembleinfo.power = null; event._fuku_trembleinfo.ang = 0.0; event._fuku_trembleinfo.offsetx = 0;
      }
      return true;
    };
    Fuku_Plugins.EventTremble.stop = function(eventid){ const event = (eventid < 0 ? $gamePlayer : $gameMap.event(eventid)); if (!event) return false; return Fuku_Plugins.EventTremble.stopObject(event); };
    Fuku_Plugins.EventTremble.speed2cycleframe = function(speed){ return Math.PI * 2 / speed; };
  })();
})();
