/*:
 * @param VariableActions
 * @text 監視設定一覧
 * @type struct<Action>[]
 * @default []
 */

/*~struct~Action:
 * @param Note
 * @text メモ
 * @type string
 * @default
 * @desc どの監視設定か分かるメモ。動作には影響しません。
 *
 * @param MasterSwitch
 * @text 有効化スイッチ
 * @type switch
 * @default 0
 * @desc この監視設定のON/OFFを制御するスイッチ。0なら常に有効。
 *
 * @param VariableID
 * @text 監視する変数ID
 * @type variable
 * @default 1
 * @desc 条件判定に使う変数。
 *
 * @param Condition
 * @text 条件
 * @type select
 * @option =
 * @option !=
 * @option <
 * @option <=
 * @option >
 * @option >=
 * @default =
 * @desc 変数と判定値の比較方法。
 *
 * @param Value
 * @text 判定値
 * @type number
 * @default 1
 * @desc 変数と比較する値。
 *
 * @param ActionType
 * @text アクションタイプ
 * @type select
 * @option Switch
 * @option CommonEvent
 * @default Switch
 * @desc 条件を満たしたときに行う処理。
 *
 * @param SwitchID
 * @text 操作するスイッチ
 * @type switch
 * @default 1
 * @desc アクションタイプが「Switch」のときに瞬間的にON→OFFするスイッチ。
 *
 * @param CommonEventID
 * @text 実行するコモンイベント
 * @type common_event
 * @default 1
 * @desc アクションタイプが「CommonEvent」のときに予約するコモンイベント。
 */

(() => {
    const parameters = PluginManager.parameters('kamichichi_vss');
    const actions = JSON.parse(parameters['VariableActions'] || '[]').map(a => {
        try {
            return JSON.parse(a);
        } catch (e) {
            return {};
        }
    });

    const lastConditionStates = [];

    const _Game_Map_update = Game_Map.prototype.update;
    Game_Map.prototype.update = function(sceneActive) {
        _Game_Map_update.call(this, sceneActive);

        if (!actions.length) return;

        for (let i = 0; i < actions.length; i++) {
            const action = actions[i];
            if (!action) continue;

            const masterSwitchId = Number(action.MasterSwitch || 0);
            if (masterSwitchId > 0 && !$gameSwitches.value(masterSwitchId)) {
                lastConditionStates[i] = false;
                continue;
            }

            const variableId = Number(action.VariableID || 0);
            if (variableId <= 0) {
                lastConditionStates[i] = false;
                continue;
            }

            const condition = action.Condition || '=';
            const value = Number(action.Value || 0);
            const v = $gameVariables.value(variableId);

            let now = false;
            switch (condition) {
                case '=':  now = (v === value); break;
                case '!=': now = (v !== value); break;
                case '<':  now = (v <  value); break;
                case '<=': now = (v <= value); break;
                case '>':  now = (v >  value); break;
                case '>=': now = (v >= value); break;
                default:   now = false; break;
            }

            const prev = !!lastConditionStates[i];

            if (!prev && now) {
                if (action.ActionType === "Switch") {
                    const switchId = Number(action.SwitchID || 0);
                    if (switchId > 0) {
                        $gameSwitches.setValue(switchId, true);
                        setTimeout(() => {
                            $gameSwitches.setValue(switchId, false);
                        }, 0);
                    }
                } else if (action.ActionType === "CommonEvent") {
                    const commonEventId = Number(action.CommonEventID || 0);
                    if (commonEventId > 0) {
                        $gameTemp.reserveCommonEvent(commonEventId);
                    }
                }
            }

            lastConditionStates[i] = now;
        }
    };
})();
