/*:ja
 * @plugindesc オプション改変
 * @author Souji Kenzaki / Documented by Sairi
 * @target MZ
 * 
 * @param Options
 * @desc オプションに出す項目の一覧
 * @type struct<OptionDetail>[]
 * @default []
 * 
 * @param Categories
 * @desc オプションに出す項目の一覧
 * @type struct<CategoryData>[]
 * @default []
 * 
 * @param fadeInDuration
 * @text ウィンドウフェードイン時間（ミリ秒）
 * @desc ウィンドウがフェードインしてくる時間。0で無効。
 * @type number
 * @default 50
 * 
 * @param easeInDuration
 * @text ウィンドウイーズイン時間（ミリ秒）
 * @desc ウィンドウがイーズインしてくる時間。0で無効。
 * @type number
 * @default 50
 * 
 * @param barBitmap
 * @desc バーのゲージ画像名
 * @type string
 * @default OPbar
 * 
 * @param dialBitmap
 * @desc バーのツマミ部分画像名
 * @type string
 * @default OPdial
 * 
 * @param buttonBitmapOn
 * @desc スイッチ項目が「ON」時の画像名
 * @type string
 * @default OPon
 * 
 * @param buttonBitmapOff
 * @desc スイッチ項目が「OFF」時の画像名
 * @type string
 * @default OPoff
 * 
 * @param textOverhead
 * @desc 項目全体の開始位置
 * @type number
 * @default 10
 * 
 * @param barOverhead
 * @desc バーの開始位置
 * @type number
 * @default 10
 * 
 * @param statusTextWidth
 * @desc バー項目の右手に出る現在の値表示の幅、ゲージとの間隔を調整します。
 * @type number
 * @default 50
 * 
 * @param titleTextWidth
 * @desc 項目テキストの幅
 * @type number
 * @default 50
 * 
 * @param CWindowX
 * @desc カテゴリウインドウのx位置
 * @type number
 * @min -9999
 * @default 0
 * 
 * @param CWindowY
 * @desc カテゴリウインドウのy位置
 * @type number
 * @min -9999
 * @default 0
 * 
 * @param CWindowWidth
 * @desc カテゴリウインドウの横幅。
 * @type number
 * @default 0
 * 
 * @param CWindowHeight
 * @desc カテゴリウインドウの縦幅。
 * @type number
 * @default 0
 * 
 * @param CWindowCols
 * @desc カテゴリウインドウの横並びの数
 * @type number
 * @default 1
 * 
 * @param WindowX
 * @desc ウインドウのx位置
 * @type number
 * @min -9999
 * @default 0
 * 
 * @param WindowY
 * @desc ウインドウのy位置
 * @type number
 * @min -9999
 * @default 0
 * 
 * @param WindowWidth
 * @desc ウインドウの横幅。0ならデフォルト通り
 * @type number
 * @default 0
 * 
 * @param WindowHeight
 * @desc ウインドウの縦幅。0ならデフォルト通り
 * @type number
 * @default 0
 * 
 * @param WindowXoverhead
 * @desc ウインドウに対する画像or文字の相対座標X
 * @type number
 * @min -9999
 * @default 0
 * 
 * @param WindowYoverhead
 * @desc ウインドウに対する画像or文字の相対座標Y
 * @type number
 * @min -9999
 * @default 0
 * 
 * @param HeightPerRow
 * @desc マスごとの高さ
 * @type number
 * @min -9999
 * @default 0
 * 
 * @param rectXoverhead
 * @desc 選択マス内での位置調整X
 * @type number
 * @min -9999
 * @default 0
 * 
 * @param rectYoverhead
 * @desc 選択マス内での位置調整Y
 * @type number
 * @min -9999
 * @default 0
 * 
 * @param WindowBack
 * @desc ウィンドウ背景名。空白の場合デフォルト。
 * @type string
 * @default 
 * 
 * @param SceneBack
 * @desc シーン全体背景名。空白の場合なし。
 * @type string
 * @default 
 * 
 * @param enableMouseControl
 * @text マウス操作を有効にする
 * @type boolean
 * @default true
 * @desc オプション画面でマウス操作を有効にするかどうか。falseで無効。
 * 
 * 
 * @help このプラグインには、プラグインコマンドはありません。
 *
 * 画像ファイルは img/system に置いてください。
 *
 * タイトル画面で此方の内容を変更した場合でも、独自変数、
 * 及びスイッチの項目はゲームがスタートした時点で初期化されます。
 *
 * 
 */
/*~struct~OptionDetail:
 * @param name
 * @desc オプション名（オプション画面に表示されるもの）
 * @type string
 * 
 * @param optionCategory
 * @desc カテゴリーID。下記カテゴリーデータとマッチさせるもの。
 * @type string
 * 
 * @param data
 * @desc このオプションによって変更される値(ConfigManager.bgmVolume等)。同じものが2つ以上あるとエラーになりますのでご注意ください。
 * @type string
 * 
 * @param optionType
 * @desc ボタン（true/false値）かバー(数値)か、スクリプト実行か
 * @type select
 * @option ボタン
 * @value 1
 * @option バー
 * @value 2
 * @option スクリプト実行
 * @value 3
 * @option なにもしない
 * @value 4
 * 
 * @param image
 * @desc オプションに表示する画像
 * @type file
 * @dir img/pictures
 * @require 1
 * 
 * @param typeMin
 * @desc 数値バー時のみ有効。最小値
 * @type number
 * @default 0
 * 
 * @param typeMax
 * @desc 数値バー時のみ有効。最大値
 * @type number
 * @default 100
 * 
 * @param keyStep
 * @desc 数値バー時のみ有効。1押しごとの変動値
 * @type number
 * @default 1
 * 
 * @param showBar
 * @desc バーを表示するかどうか
 * @type boolean
 * @default true
 * 
 * @param showNumber
 * @desc 数字を表示するかどうか
 * @type boolean
 * @default true
 * 
 * @param showText
 * @desc テキストを表示するかどうか
 * @type boolean
 * @default false
 * 
 * @param nameX
 * @desc nameの表示位置X（オプション項目からの相対位置）
 * @type number
 * @default 0
 * 
 * @param nameY
 * @desc nameの表示位置Y（オプション項目からの相対位置）
 * @type number
 * @default 0
 * 
 * 
 * @param switchTextMapping
 * @desc スイッチに対応するテキストのマッピング。例: {"true":"有効", "false":"無効"}
 * @type string
 * @default "{}"
 * 
 * @param showSwitchText
 * @desc スイッチテキストを表示するかどうか
 * @type boolean
 * @default false
 * 
 * @param switchTextX
 * @desc スイッチテキストの表示位置X（オプション項目からの相対位置）
 * @type number
 * @default 0
 * 
 * @param switchTextY
 * @desc スイッチテキストの表示位置Y（オプション項目からの相対位置）
 * @type number
 * @default 0
 * 
 * @param imageOn
 * @desc スイッチがオンの時に表示する画像
 * @type file
 * @dir img/pictures
 * @require 1
 * 
 * @param imageOff
 * @desc スイッチがオフの時に表示する画像
 * @type file
 * @dir img/pictures
 * @require 1
 * 
 * @param buttonX
 * @desc ボタンの表示位置X（オプション項目からの相対位置）
 * @type number
 * @default 0
 * 
 * @param buttonY
 * @desc ボタンの表示位置Y（オプション項目からの相対位置）
 * @type number
 * @default 0
 * 
 * @param textX
 * @desc テキストの表示位置X（オプション項目からの相対位置）
 * @type number
 * @default 0
 * 
 * @param textY
 * @desc テキストの表示位置Y（オプション項目からの相対位置）
 * @type number
 * @default 0
 * 
 * @param textWidth
 * @desc テキストの幅
 * @type number
 * @default 100
 * 
 * @param textFontSize
 * @desc テキストのフォントサイズ
 * @type number
 * @default 28
 * 
 * @param textMapping
 * @desc 数値に対応するテキストのマッピング。JSON形式で指定。例: {"1":"低","2":"中","3":"高"}
 * @type string
 * @default "{}"
 * 
 * @param condition
 * @desc $gameSwitches.value(1)で表示非表示を設定可能
 * @type string
 * @default true
 */
/*~struct~TextMapping:
 * @param 0
 * @desc 0に対応するテキスト
 * @type string
 * 
 * @param 1
 * @desc 1に対応するテキスト
 * @type string
 * 
 * @param 2
 * @desc 2に対応するテキスト
 * @type string
 * 
 * @param 3
 * @desc 3に対応するテキスト
 * @type string
 */
/*~struct~CategoryData:
 * 
 * @param categoryId
 * @desc カテゴリーのID。<optionCategory>と一致させる事
 * @type string
 * 
 * @param categoryName
 * @desc カテゴリー表示名
 * @type string
 * 
 * @param sceneBackImage
 * @desc カテゴリーごとの背景画像名。img/systemに配置すること。
 * @type file
 * @dir img/system
 * @default ""
 */
(function () {
    let parameters = PluginManager.parameters('kzmz_OptionCustomize');
    let barBitmap = parameters['barBitmap'] || "OPbar";//バー本体の名前。
    let dialBitmap = parameters['dialBitmap'] || "OPdial"; //ツマミの名前。
    let buttonBitmapOn = parameters['buttonBitmapOn'] || "OPon"; //ボタンONの名前。
    let buttonBitmapOff = parameters['buttonBitmapOff'] || "OPoff"; //ボタンOFFの名前

    let textOverhead = Number(parameters['textOverhead']) || 10; 
    let barOverhead = Number(parameters['barOverhead']) || 10; 
    let statusTextWidth = Number(parameters['statusTextWidth']) || 50; 
    let titleTextWidth = Number(parameters['titleTextWidth']) || 50; 

    let _wX = Number(parameters['WindowX']) || 0; 
    let _wY = Number(parameters['WindowY']) || 0; 
    let _wW = Number(parameters['WindowWidth']) || 0; 
    let _wH = Number(parameters['WindowHeight']) || 0; 
    let _wOX = Number(parameters['WindowXoverhead']) || 0; 
    let _wOY = Number(parameters['WindowYoverhead']) || 0; 
    let _rOX = Number(parameters['rectXoverhead']) || 0; 
    let _rOY = Number(parameters['rectYoverhead']) || 0; 
    let _heightperRow = Number(parameters['HeightPerRow']) || 0; 
    let _OWBack = String(parameters['WindowBack']) || ""; 
    let _SBack = String(parameters['SceneBack']) || ""; 

    let _CwX = Number(parameters['CWindowX']) || 0; 
    let _CwY = Number(parameters['CWindowY']) || 0; 
    let _CwW = Number(parameters['CWindowWidth']) || 0; 
    let _CwH = Number(parameters['CWindowHeight']) || 0; 
    let _CwCol = Number(parameters['CWindowCols']) || 1; 

    let optionList = JSON.parse(parameters['Options']).map(
        function (e) {
            let newObj = JSON.parse(e);
            newObj.optionType = eval(newObj.optionType);
            newObj.typeMin = eval(newObj.typeMin);
            newObj.typeMax = eval(newObj.typeMax);
            newObj.keyStep = eval(newObj.keyStep);
            return newObj;
        }
    ) || [];
    let _categoryData = JSON.parse(parameters['Categories']).map(
        function (e) {
            let newObj = JSON.parse(e);
            return newObj;
        }
    ) || [];

    const kz_Scene_Boot_loadSystemImages = Scene_Boot.prototype.loadSystemImages;
    Scene_Boot.prototype.loadSystemImages = function () {
        kz_Scene_Boot_loadSystemImages.call(this);
        ConfigManager.barBitmap = ImageManager.loadSystem(barBitmap);
        ConfigManager.dialBitmap = ImageManager.loadSystem(dialBitmap);
        ConfigManager.buttonBitmapOnL = ImageManager.loadSystem(buttonBitmapOn);
        ConfigManager.buttonBitmapOffL = ImageManager.loadSystem(buttonBitmapOff);
    };

    const kz_Scene_Options_prototype_create = Scene_Options.prototype.create;
    Scene_Options.prototype.create = function() {
        kz_Scene_Options_prototype_create.call(this);
        this.createCategoryWindow();
        this._optionCategoryWindow.activate();
        this._optionsWindow.deactivate();
    };

    const Scene_Options_prototype_createOptionsWindow = Scene_Options.prototype.createOptionsWindow;
    Scene_Options.prototype.createOptionsWindow = function() {
        const rect = new Rectangle(_wX, _wY, _wW, _wH);
        this._optionsWindow = new Window_Options(rect);
        this._optionsWindow.setHandler("cancel", this.optionCancel.bind(this));
        this.addWindow(this._optionsWindow);
    };

    Scene_Options.prototype.createCategoryWindow = function() {
        const rect = new Rectangle(_CwX, _CwY, _CwW, _CwH);
        this._optionCategoryWindow = new Window_OptionCategory(rect);
        this._optionCategoryWindow.setHandler("ok", this.categoryOk.bind(this));
        this._optionCategoryWindow.setHandler("cancel", this.popScene.bind(this));
        this._optionCategoryWindow.setItemWindow(this._optionsWindow);
        this.addWindow(this._optionCategoryWindow);
    };

    Scene_Options.prototype.categoryOk = function() {
        this._optionsWindow.activate();
    };

    Scene_Options.prototype.optionCancel = function() {
        this._optionCategoryWindow.activate();
    };

    /*
// SceneBackのフェードイン処理を削除
Scene_Options.prototype.createBackground = function() {
    const _SBack = String(parameters['SceneBack']);
    if (_SBack) {
        this._backgroundSprite2 = new Sprite();
        this._backgroundSprite2.bitmap = ImageManager.loadSystem(_SBack);
        this._backgroundSprite2.x = 265;
        this._backgroundSprite2.y = 90;
        this.addChild(this._backgroundSprite2);
    } else {
        Scene_MenuBase.prototype.createBackground.call(this);
    }
};
*/

Scene_Options.prototype.createBackground = function() {
    // デフォルトの背景画像を描画
    Scene_MenuBase.prototype.createBackground.call(this);

    // SceneBackの画像を背景の上に表示
    const sceneBackFile = String(parameters['SceneBack']); // SceneBack画像ファイルを取得
    if (sceneBackFile) {
        this._sceneBackSprite = new Sprite();
        const bitmap = ImageManager.loadSystem(sceneBackFile);

        // 中央に配置し、Z値を指定
        bitmap.addLoadListener(() => {
            this._sceneBackSprite.bitmap = bitmap;
            this._sceneBackSprite.opacity = 255;

            // 中央配置
            this._sceneBackSprite.x = (Graphics.width - bitmap.width) / 2;
            this._sceneBackSprite.y = (Graphics.height - bitmap.height) / 2;

            // Z値の設定
            this._sceneBackSprite.z = 5; // 任意のZ値に変更可能
        });

        // 背景の上にSceneBack画像を追加
        this.addChild(this._sceneBackSprite);
    }
};

// WindowBackのフェードイン処理を削除
Window_Options.prototype.createBackSprite = function () {
    const _OWBack = String(parameters['WindowBack']);
    if (_OWBack) {
        this._backSprite = new Sprite();
        this._backSprite.bitmap = ImageManager.loadSystem(_OWBack);
        this._backSprite.x = _wOX;
        this._backSprite.y = _wOY;
        this.addChildToBack(this._backSprite); // ウィンドウ背景を背面に追加
    }
};

    
    const kz_Window_Options_prototype_initialize = Window_Options.prototype.initialize;
    Window_Options.prototype.initialize = function (rect) {
        this._category = null;
        this._baseSprites = [];
        this._cursorSprites = [];
        this._textSprites = [];
    this._draggingBarSymbol = null;
    this._draggingBarIndex = -1;
        kz_Window_Options_prototype_initialize.call(this, rect);
        if (_OWBack != '') {
            this.setBackgroundType(2);
            this.createBackSprite();
        }
    };
/*
    Scene_Options.prototype.applyFadeAndEaseEffect = function(spriteObject) {
        const fadeInDuration = Number(parameters['fadeInDuration']) || 50;
        const easeInDuration = Number(parameters['easeInDuration']) || 50;
    
        // 初期状態に戻す
        spriteObject.x = spriteObject._originalX || spriteObject.x;
        spriteObject.opacity = 0; // 最初は透明に
    
        // 元の位置を記憶する
        spriteObject._originalX = spriteObject.x;
        spriteObject._easeStartX = spriteObject._originalX + 100; // 開始位置を少し右にずらす
    
        // フェードイン＆イーズインのアニメーション
        spriteObject._fadeInFrames = fadeInDuration / 16.67; // フェードインにかかるフレーム数
        spriteObject._easeInFrames = easeInDuration / 16.67; // イーズインにかかるフレーム数
    
        spriteObject._updateFadingAndEasing = function() {
            // フェードインの処理
            if (this._fadeInFrames > 0) {
                const fadeProgress = (fadeInDuration - this._fadeInFrames * 16.67) / fadeInDuration;
                this.opacity = Math.floor(255 * fadeProgress);
                this._fadeInFrames--;
            }
    
            // イーズインの処理
            if (this._easeInFrames > 0) {
                const easeProgress = (easeInDuration - this._easeInFrames * 16.67) / easeInDuration;
                this.x = this._easeStartX - 50 * easeProgress; // 徐々に元の位置に戻す
                this._easeInFrames--;
            }
        };
    
        const _originalUpdate = spriteObject.update; // 元のupdateメソッドを保持
    
        spriteObject.update = function() {
            if (_originalUpdate) _originalUpdate.call(this); // 元のupdateを呼び出す
            if (this._updateFadingAndEasing) {
                this._updateFadingAndEasing(); // フェードインとイーズインの処理を追加
            }
        };
    };
        
*/




/*

    Window_Base.prototype.loadWindowskin = function() {
        // デフォルトのウィンドウスキンを読み込まないようにする
        this.windowskin = null; // これでウィンドウスキンが非表示になります
    };
    

*/



    
    Window_Options.prototype.setCategory = function (category) {
        if (category == this._category) return;
        this._category = category;
        this.select(0);
        this.refresh();
    }

    Window_Options.prototype.makeCommandList = function() {
        this.clearCommandList(); // コマンドリストをクリアする
        optionList.forEach(e => {
            // 表示条件が満たされているかを確認
            if (!e || !eval(e.condition)) return;
            
            // 条件が合致した項目のみ追加
            if (e.optionCategory != this._category) return;
            this.addCommand(e.name, e.data);
        });
    };

    Window_Options.prototype.commandSymbol = function(index) {
        const command = this._list[index];
        return command ? command.symbol : null;  // シンボルがない場合は null を返す
    };

    Window_Options.prototype.findSymbolFromList = function (symbol) {
        return optionList.find(function (element) {
            return element.data == symbol;
        }, this);
    };

    Window_Options.prototype.getConfigValue = function (symbol) {
        let tResult = eval(symbol);
        if (!tResult) {
            if (this.isVolumeSymbol(symbol)) {
                let t = this.findSymbolFromList(symbol);
                return t.typeMin;
            }
            else {
                return false;
            }
        }
        return tResult;
    };

    Window_Options.prototype.itemHeight = function() {
        return _heightperRow;
    };

    Window_Options.prototype.setConfigValue = function (symbol, volume) {
        let targetValue = volume;
        if (this.isBarSymbol(symbol))
        {
            let t = this.findSymbolFromList(symbol);
            targetValue = Number(targetValue).clamp(t.typeMin, t.typeMax);
        }
        eval(symbol + '=' + targetValue);
    };

    const kz_Window_Options_prototype_changeValue = Window_Options.prototype.changeValue;
    Window_Options.prototype.changeValue = function(symbol, value) {
        let option = this.findSymbolFromList(symbol);
    
        if (this.isBarSymbol(symbol)) {
            // 数値バーの最小値と最大値を取得
            let min = option.typeMin;
            let max = option.typeMax;
    
            // 値が最大値を超えた場合に0にループさせる
            if (value > max) {
                value = min;
            } else if (value < min) {
                value = max;
            }
    
            // 値を設定
            this.setConfigValue(symbol, value);
            this.refresh();
        } else {
            kz_Window_Options_prototype_changeValue.call(this, symbol, value);
        }
    };
    // 変更が入った「瞬間」に ConfigManager を保存する（タイトルに戻っても保持）
(() => {
  const _kz_changeValue = Window_Options.prototype.changeValue;
  Window_Options.prototype.changeValue = function(symbol, value) {
    _kz_changeValue.call(this, symbol, value);

    // ConfigManager.* を変更した場合のみ即保存（無駄な保存を減らす）
    if (typeof symbol === "string" && symbol.startsWith("ConfigManager.")) {
      ConfigManager.save();
    }
  };

  const _kz_processOk = Window_Options.prototype.processOk;
  Window_Options.prototype.processOk = function() {
    _kz_processOk.call(this);

    const symbol = this.commandSymbol(this.index());
    if (typeof symbol === "string" && symbol.startsWith("ConfigManager.")) {
      ConfigManager.save();
    }
  };
})();


    Window_Options.prototype.volumeOffset = function () {
        let symbol = this.currentSymbol();
        let t = this.findSymbolFromList(symbol);
        if (!t) return 1;
        return t.keyStep;
    };

    Window_Options.prototype.removeAllSprites = function () {
        this._baseSprites.forEach(e => this.removeChild(e), this);
        this._cursorSprites.forEach(e => this.removeChild(e), this);
        this._textSprites.forEach(e => this.removeChild(e), this);
    
        // スプライト配列をクリア
        this._baseSprites = [];
        this._cursorSprites = [];
        this._textSprites = [];
    };

    const kz_Window_Options_prototype_refresh = Window_Options.prototype.refresh;
    Window_Options.prototype.refresh = function () {
        this.removeAllSprites(); // 古いスプライトを削除
        kz_Window_Options_prototype_refresh.call(this); // オリジナルのrefresh処理を呼び出す
    
        // スイッチテキストを再描画するための処理
        for (let i = 0; i < this._list.length; i++) {
            let option = this.findSymbolFromList(this.commandSymbol(i));
            if (option && option.showSwitchText === "true") {
                // スイッチテキストの再描画を行う前に古いスプライトを削除
                this.clearOldSprites(this.commandSymbol(i)); // 重複防止のため
    
                // スイッチテキストを再描画
                let rect = this.itemRect(i);
                this.drawOnOffButton(i, rect); // テキストを表示する
            }
        }
    };

    Window_Options.prototype.variableToText = function(variableValue, textMapping) {
        return textMapping[variableValue] || 'Unknown'; // マッピングがない場合は'Unknown'を表示
    };
    
    Window_Options.prototype.convertEvalText = function(text) {
        if (text == null) return "";
        return String(text).replace(/\\EVAL\{([\s\S]*?)\}/g, function(_, code) {
            try {
                const result = eval(code);
                return result === undefined ? "" : String(result);
            } catch (e) {
                console.error("[kzmz_OptionCustomize] \\EVAL error:", code, e);
                return "";
            }
        });
    };

    Window_Options.prototype.drawDragBar = function (index, graphicRect) {
        let symbol = this.commandSymbol(index);
        let t = this.findSymbolFromList(symbol);
        if (!t) return;
    
        this.clearOldSprites(symbol);
    
        let value = (this.getConfigValue(symbol) - t.typeMin) / (t.typeMax - t.typeMin);
        let barBitmapObject = ConfigManager.barBitmap;
        let dialBitmapObject = ConfigManager.dialBitmap;
    
        let baseX = graphicRect.x + (_rOX || 0) - 120;
        let baseY = graphicRect.y + (_rOY || 0);
    
        if (t.showBar === "true") {
            let spriteBar = new Sprite_Options(barBitmapObject, symbol);
            spriteBar.x = baseX;
            spriteBar.y = baseY;
            this._baseSprites.push(spriteBar);
            this.addChild(spriteBar);
    
            let spriteDial = new Sprite_Options(dialBitmapObject, symbol);
            spriteDial.x = baseX + spriteBar.width * value - dialBitmapObject.width / 2;
            spriteDial.y = baseY + (barBitmapObject.height - dialBitmapObject.height) / 2;
            this._cursorSprites.push(spriteDial);
            this.addChild(spriteDial);
        }
    
        if (t.showNumber === "true") {
            let spriteText = new Sprite_Options(new Bitmap(50, 100), symbol);
            spriteText.bitmap.fontFace = $gameSystem.mainFontFace(); // システムフォントを設定
            spriteText.bitmap.fontSize = 32;
            spriteText.x = graphicRect.x + graphicRect.width - 50;
            spriteText.y = graphicRect.y - 10;
            spriteText.bitmap.outlineColor = 'black';  // アウトラインの色を設定
            spriteText.bitmap.outlineWidth = 4;        // アウトラインの幅を設定
            spriteText.bitmap.clear();
            spriteText.bitmap.drawText(this.getConfigValue(symbol), 0, 0, 50, 100, 'center');
            this._textSprites.push(spriteText);
            this.addChild(spriteText);
        }
    
if (t.showText === "true") {
    const w = t.textWidth || 100;
    const h = 100; // 必要ならパラメータ化
    let spriteText = new Sprite_Options(new Bitmap(w, h), symbol);
    spriteText.bitmap.fontFace = $gameSystem.mainFontFace();
    spriteText.bitmap.fontSize = t.textFontSize || 32;

    // 各ブロック（項目）内相対に変更
    const offX = Number(t.textX) || 0;
    const offY = Number(t.textY) || 0;
    spriteText.x = graphicRect.x + offX;
    spriteText.y = graphicRect.y + offY;

    spriteText.bitmap.outlineColor = "black";
    spriteText.bitmap.outlineWidth = 4;
    spriteText.bitmap.clear();
    const map = JSON.parse(t.textMapping || "{}");
    spriteText.bitmap.drawText(
        this.variableToText(this.getConfigValue(symbol), map),
        0, 0, w, h, "center"
    );
    this._textSprites.push(spriteText);
    this.addChild(spriteText);
}
    };
                
    Window_Options.prototype.drawOnOffButton = function (index, graphicRect) {
        let symbol = this.commandSymbol(index);
        let option = this.findSymbolFromList(symbol);
        if (!option) return;
    
        let value = this.getConfigValue(symbol);
    
        // スイッチのテキストを表示する設定が有効か確認
        if (option.showSwitchText === "true") {
            // 古いテキストスプライトを削除してから新しいテキストスプライトを追加
            this.clearOldSprites(symbol);
    
            let switchTextMapping = JSON.parse(option.switchTextMapping || "{}");
            let switchText = value ? switchTextMapping["true"] : switchTextMapping["false"];
    
            let switchTextX = Number(option.switchTextX) || 0;
            let switchTextY = Number(option.switchTextY) || 0;
    
            let switchTextWidth = Number(option.switchTextWidth) || 500;
            let switchTextHeight = Number(option.switchTextHeight) || 80;
            let switchFontSize = Number(option.switchTextFontSize) || 36;
            let switchOutlineWidth = Number(option.switchTextOutlineWidth) || 4;
    
            let spriteText = new Sprite_Options(new Bitmap(switchTextWidth, switchTextHeight), symbol);
            spriteText.bitmap.fontFace = $gameSystem.mainFontFace();
            spriteText.bitmap.fontSize = switchFontSize;
            spriteText.x = graphicRect.x + switchTextX;
            spriteText.y = graphicRect.y + switchTextY;
            spriteText.bitmap.outlineColor = 'black';
            spriteText.bitmap.outlineWidth = switchOutlineWidth;
            spriteText.bitmap.clear();
            spriteText.bitmap.drawText(switchText || (value ? "ON" : "OFF"), 0, 0, switchTextWidth, switchTextHeight, 'center');
            this._textSprites.push(spriteText);
            this.addChild(spriteText);
        } else {
            // 画像表示の場合の処理
            let targetBitmap = value ? ConfigManager.buttonBitmapOnL : ConfigManager.buttonBitmapOffL;
            let targetSprite = this._baseSprites.find(e => e._symbol == symbol);
            let buttonX = Number(option.buttonX) || 0;
            let buttonY = Number(option.buttonY) || 0;
    
            if (targetSprite) {
                targetSprite.bitmap = targetBitmap;
                targetSprite.x = graphicRect.x + buttonX;
                targetSprite.y = graphicRect.y + buttonY;
            } else {
                let newTargetSprite = new Sprite_Options(targetBitmap, symbol);
                newTargetSprite.x = graphicRect.x + buttonX;
                newTargetSprite.y = graphicRect.y + buttonY;
                this._baseSprites.push(newTargetSprite);
                this.addChild(newTargetSprite);
            }
        }
    
   // スイッチの状態に応じて画像を変更する処理
   let targetImage = value ? option.imageOn : option.imageOff;

   // targetImage が undefined でないかをチェックしてエラーを回避
   if (targetImage) {
       if (!this._switchImageSprites) {
           this._switchImageSprites = {};  // スプライトを保持するオブジェクトを作成
       }

       if (!this._switchImageSprites[symbol]) {
           this._switchImageSprites[symbol] = new Sprite();
           this.addChild(this._switchImageSprites[symbol]);
       }

       let sprite = this._switchImageSprites[symbol];
       sprite.bitmap = ImageManager.loadPicture(targetImage);
       sprite.x = graphicRect.x - 20;
       sprite.y = graphicRect.y;
   } else {
       // スイッチ画像が設定されていない場合、エラーをスキップ
   }
    };
    
    Window_Options.prototype.clearSwitchImage = function() {
        // すべてのスイッチ画像スプライトをクリア
        if (this._switchImageSprites) {
            for (let key in this._switchImageSprites) {
                this.removeChild(this._switchImageSprites[key]);
            }
            this._switchImageSprites = null;
        }
    };
    
    Window_Options.prototype.drawItem = function (index) {
        let rect = this.itemRect(index);
        let titleWidth = titleTextWidth;
    
        // 現在のコマンドのsymbolを取得
        let symbol = this.commandSymbol(index);
    
        // OptionDetail構造体からオプション情報を取得
        let option = this.findSymbolFromList(symbol);
        if (!option) {
            // オプションが見つからなければ、処理を中断
            return;
        }
    
        // 表示非表示の条件が合わない場合はスキップ
        if (!eval(option.condition)) {
            return;
        }
    
        // OptionDetailからnameXとnameYを取得
        let nameX = Number(option.nameX) || 0;  // nameのX座標
        let nameY = Number(option.nameY) || 0;  // nameのY座標
    
        this.resetTextColor();
        this.changePaintOpacity(this.isCommandEnabled(index));
    
        // 名前を動的に描画
        this.drawTextEx(this.convertEvalText(option.name).replace("\\n", "\n"), rect.x + nameX, rect.y + nameY, titleWidth);
    
        let newRect = JsonEx.makeDeepCopy(rect);
        newRect.x = rect.x + titleWidth + textOverhead;
        newRect.width = rect.width - titleWidth - textOverhead;
    
        // 画像を表示する処理を追加
        if (option.image) {
            let imageSprite = new Sprite();
            imageSprite.bitmap = ImageManager.loadPicture(option.image);
            imageSprite.x = rect.x + (option.imageX || 0) - 20;  // 画像のX座標
            imageSprite.y = rect.y + (option.imageY || 0);  // 画像のY座標
            this._baseSprites.push(imageSprite); // スプライト配列に追加
            this.addChild(imageSprite);
        }
    
        if (this.isBarSymbol(symbol)) {
            newRect.x += barOverhead;
            newRect.width -= barOverhead;
            this.drawDragBar(index, newRect);
        } else if (!this.isScriptSymbol(symbol) && !this.isNoneSymbol(symbol)) {
            this.drawOnOffButton(index, newRect);
        }
    };        
    Window_Options.prototype.processControlCharacter = function(textState, c) {
        if (c === "\n") {
            this.processNewLine(textState);
        }
        if (c === "\x1b") {
            const code = this.obtainEscapeCode(textState);
            this.processEscapeCharacter(code, textState);
        }
    };
    
    Window_Options.prototype.processNewLine = function(textState) {
        textState.x = textState.startX;
        textState.y += textState.height;
        textState.height = this.calcTextHeight(textState);
    };
    

    Window_Options.prototype.isBarSymbol = function (symbol) {
        let targetOption = this.findSymbolFromList(symbol);
        return targetOption.optionType == 2;
    };

    Window_Options.prototype.isScriptSymbol = function (symbol) {
        let targetOption = this.findSymbolFromList(symbol);
        return targetOption.optionType == 3;
    };

    Window_Options.prototype.isNoneSymbol = function(symbol) {
        const targetOption = this.findSymbolFromList(symbol);
        return targetOption && targetOption.optionType == 4;
    };

    Window_Options.prototype.isVolumeSymbol = function (symbol) {
        return this.isBarSymbol(symbol);
    };
    const enableMouseControl = parameters['enableMouseControl'] === 'true';
/*
Window_Options.prototype.processTouch = function () {
    if (!this.isOpenAndActive()) return;
    if (!enableMouseControl) return; // マウス操作を無効化

    let hitIndex = this.hitIndex();  // タッチ位置にある項目のインデックスを取得
    if (hitIndex >= 0) {
        let symbol = this.commandSymbol(hitIndex);
        if (this.isBarSymbol(symbol)) {
            let touchPos = new Point(TouchInput.x, TouchInput.y);
            const localPos = this.worldTransform.applyInverse(touchPos);
            let value = this.xToValue(symbol, localPos.x);
            this.changeValue(symbol, value);  // 値を更新
            this.clearOldSprites(symbol);
            this.refresh();  // 再描画
        }
    } else if (TouchInput.isCancelled()) {
        this.onTouchCancel();  // キャンセル処理
    }
    Window_Selectable.prototype.processTouch.call(this);
};
*/
Window_Options.prototype.processTouch = function () {
    if (!this.isOpenAndActive()) return;
    if (!enableMouseControl) return;

    const touchPos = new Point(TouchInput.x, TouchInput.y);
    const localPos = this.worldTransform.applyInverse(touchPos);

    // まず標準の「タッチで項目選択」動作は殺さない
    const hitIndex = this.hitIndex();
    if (hitIndex >= 0 && this.index() !== hitIndex) {
        this.select(hitIndex);
    }

    // 1) 押し始めた瞬間に、バー（つまみ）を掴んだらドラッグ開始
    if (TouchInput.isTriggered() && hitIndex >= 0) {
        const symbol = this.commandSymbol(hitIndex);
        if (symbol && this.isBarSymbol(symbol) && this.isBarGrabbed(symbol, localPos.x, localPos.y)) {
            this._draggingBarSymbol = symbol;
            this._draggingBarIndex = hitIndex;
        } else {
            this._draggingBarSymbol = null;
            this._draggingBarIndex = -1;
        }
    }

    // 2) 掴んでいる間だけ、X座標から値を更新（ホバーでは変わらない）
    if (this._draggingBarSymbol && TouchInput.isPressed()) {
        const symbol = this._draggingBarSymbol;
        const value = this.xToValue(symbol, localPos.x);
        this.changeValue(symbol, value);
        this.refresh(); // つまみ位置・数値を更新
    }

    // 3) 離したら終了
    if (this._draggingBarSymbol && TouchInput.isReleased()) {
        this._draggingBarSymbol = null;
        this._draggingBarIndex = -1;
    }

    // キャンセルは従来通り
    if (TouchInput.isCancelled()) {
        this.onTouchCancel();
    }

    Window_Selectable.prototype.processTouch.call(this);
};


    // バーとツマミを再描画するための関数
    Window_Options.prototype.refreshBarAndDial = function(symbol) {
        let spriteBar = this._baseSprites.find(e => e._symbol == symbol);
        let spriteDial = this._cursorSprites.find(e => e._symbol == symbol);
    
        if (spriteBar && spriteDial) {
            // 再描画のために古いスプライトを削除
            this.removeChild(spriteBar);
            this.removeChild(spriteDial);
    
            // 新しいスプライトを描画
            let t = this.findSymbolFromList(symbol);
            let value = (this.getConfigValue(symbol) - t.typeMin) / (t.typeMax - t.typeMin);
            let barBitmapObject = ConfigManager.barBitmap;
            let dialBitmapObject = ConfigManager.dialBitmap;
    
            spriteBar = new Sprite_Options(barBitmapObject, symbol);
            spriteDial = new Sprite_Options(dialBitmapObject, symbol);
    
            let baseX = this.itemRectForText(this.index()).x + _rOX - 120;
            let baseY = this.itemRectForText(this.index()).y + _rOY;
    
            spriteBar.x = baseX;
            spriteBar.y = baseY;
    
            spriteDial.x = baseX + spriteBar.width * value - dialBitmapObject.width / 2;
            spriteDial.y = baseY + (barBitmapObject.height - dialBitmapObject.height) / 2;
    
            this.addChild(spriteBar);
            this.addChild(spriteDial);
        }
    };
    
// オリジナルの processOk メソッドを保持
const kz_Window_Options_prototype_processOk = Window_Options.prototype.processOk;

// processOk メソッドのカスタマイズ
Window_Options.prototype.processOk = function() {
    const index = this.index();
    const symbol = this.commandSymbol(index);
    if (!symbol) return;

    // 「なにもしない」：クリックしても決定キーでも無反応
    if (this.isNoneSymbol(symbol)) {
        return;
    }

    const option = this.findSymbolFromList(symbol);

    if (this.isScriptSymbol(symbol)) {
        eval(symbol);
        SoundManager.playOk();
        return;
    }

    if (option && option.showSwitchText === "true") {
        // テキスト表示スイッチも決定で切替
        const value = this.getConfigValue(symbol);
        this.changeValue(symbol, !value);
        this.refresh();
        SoundManager.playOk();
        return;
    }

    kz_Window_Options_prototype_processOk.call(this);
    SoundManager.playOk();
};




    
    Window_Options.prototype.onTouchCancel = function() {
        this.processCancel();
    };

    Window_Options.prototype.xToValue = function(symbol, x) {
        let sprite = this._baseSprites.find(e => e._symbol == symbol);
        if (!sprite) {
            return 0;  // エラー時のデフォルト値を返す
        }
        let t = this.findSymbolFromList(symbol);
    
        let value = (t.typeMax - t.typeMin) * (x - sprite.x) / sprite.width + t.typeMin;
        value = Math.round(value);
        value = Math.max(t.typeMin, Math.min(value, t.typeMax));  // 値を最小値・最大値の範囲に収める
        return value;
    };
 Window_Options.prototype.isBarGrabbed = function(symbol, localX, localY) {
    // バー本体スプライト
    const bar = this._baseSprites.find(s => s._symbol === symbol);
    if (!bar) return false;

    // つまみスプライト
    const dial = this._cursorSprites.find(s => s._symbol === symbol);

    // 余裕（掴みやすさ）
    const pad = 10;

    // バー範囲
    const bx1 = bar.x - pad;
    const by1 = bar.y - pad;
    const bx2 = bar.x + bar.width + pad;
    const by2 = bar.y + bar.height + pad;

    // つまみ範囲（あれば優先的に掴めるようにする）
    if (dial) {
        const dx1 = dial.x - pad;
        const dy1 = dial.y - pad;
        const dx2 = dial.x + dial.width + pad;
        const dy2 = dial.y + dial.height + pad;

        if (localX >= dx1 && localX <= dx2 && localY >= dy1 && localY <= dy2) {
            return true;
        }
    }

    // バー本体でも掴める
    return (localX >= bx1 && localX <= bx2 && localY >= by1 && localY <= by2);
};
   
    Window_Options.prototype.clearOldSprites = function(symbol) {
        this._baseSprites = this._baseSprites.filter(sprite => {
            if (sprite._symbol === symbol) {
                this.removeChild(sprite); // 古いスプライトを削除
                return false;
            }
            return true;
        });
    
        this._cursorSprites = this._cursorSprites.filter(sprite => {
            if (sprite._symbol === symbol) {
                this.removeChild(sprite); // 古いスプライトを削除
                return false;
            }
            return true;
        });
    
        this._textSprites = this._textSprites.filter(sprite => {
            if (sprite._symbol === symbol) {
                this.removeChild(sprite); // 古いテキストスプライトを削除
                return false;
            }
            return true;
        });
    };


    Window_Options.prototype.processCursorMove = function() {
        // デフォルトのカーソル移動処理を復元
        if (Window_Selectable.prototype.processCursorMove.call(this)) {
            // カーソル移動が発生した場合の処理
            this.refresh(); // 必要ならばリフレッシュ
        }
    };
    
    
    
        
    Window_Options.prototype.drawBackgroundRect = function(rect) {   
    };

    

    function Window_OptionCategory() {
        this.initialize(...arguments);
    }
    
    Window_OptionCategory.prototype = Object.create(Window_Command.prototype);
    Window_OptionCategory.prototype.constructor = Window_OptionCategory;
    
    Window_OptionCategory.prototype.initialize = function(rect) {
        Window_Command.prototype.initialize.call(this, rect);
        this._itemWindow = null;
        if (_OWBack != '') {
            this.setBackgroundType(2);
        }
    };
    
    // カテゴリの列数を設定
    Window_OptionCategory.prototype.maxCols = function() {
        return _CwCol;
    };
    
    // アイテムウィンドウをセット
    Window_OptionCategory.prototype.setItemWindow = function(itemWindow) {
        this._itemWindow = itemWindow;
    };
    
    // テキストのアライメントを中央揃えに設定
    Window_OptionCategory.prototype.itemTextAlign = function() {
        return "center";
    };
    
    // コマンドリストの作成
    Window_OptionCategory.prototype.makeCommandList = function() {
        _categoryData.forEach(e => {
            this.addCommand(e.categoryName, e.categoryId);
        });
    };
    
    // 更新処理
    Window_OptionCategory.prototype.update = function() {
        Window_Command.prototype.update.call(this);
        if (this._itemWindow) {
            const currentCategory = this.currentSymbol();
            if (this._itemWindow._category !== currentCategory) {
                this._itemWindow.clearSwitchImage();  // スイッチ画像をクリア
            }
            this._itemWindow.setCategory(currentCategory);
            
            // Change SceneBack based on the current category
            const categoryData = _categoryData.find(e => e.categoryId === currentCategory);
            if (categoryData && categoryData.sceneBackImage) {
                this.changeSceneBackImage(categoryData.sceneBackImage);
            }
        }
    };

    // Function to change the SceneBack image
Window_OptionCategory.prototype.changeSceneBackImage = function(imageName) {
    if (this._backgroundSprite2) {
        this.removeChild(this._backgroundSprite2); // Remove the old background
    }
    this._backgroundSprite2 = new Sprite();
    this._backgroundSprite2.bitmap = ImageManager.loadSystem(imageName);
        // Adjust position (hardcoded example)
    this._backgroundSprite2.x = 530; // Set X position
    this._backgroundSprite2.y = 20;  // Set Y position

    this.addChild(this._backgroundSprite2); // Add the new background
};
    
    // 背景矩形の描画（空にすることで描画を防ぐ）
    Window_OptionCategory.prototype.drawBackgroundRect = function(rect) {   
    };
    
    // フォントサイズと行間を設定
    Window_OptionCategory.prototype.drawItem = function(index) {
        const rect = this.itemRect(index); // 修正：itemRectForTextではなくitemRectを使用
        this.resetTextColor();
    
        // カテゴリフォントサイズと行間を定義
        const categoryFontSize = 40; // カテゴリのフォントサイズ（必要に応じて変更）
        const categoryLineHeight = 124; // カテゴリの行の高さ（必要に応じて変更）
    
        // フォントサイズを設定
        const originalFontSize = this.contents.fontSize;
        this.contents.fontSize = categoryFontSize;
    
        // テキストを描画
        this.drawText(this.commandName(index), rect.x, rect.y, rect.width, 'center');
    
        // フォントサイズを元に戻す
        this.contents.fontSize = originalFontSize;
    };
    
    // 行の高さを設定
    Window_OptionCategory.prototype.lineHeight = function() {
        return 124; // 行の高さ（必要に応じて変更）
    };

    // すでにどこかで宣言済みなら重複させないこと
// const enableMouseControl = parameters['enableMouseControl'] === 'true';

// カテゴリのマウス（タッチ）入力を無効化
Window_OptionCategory.prototype.processTouch = function () {
  if (!this.isOpenAndActive()) return;
  if (!enableMouseControl) return;           // ← ここで遮断
  Window_Command.prototype.processTouch.call(this);
};

// ホイールでの選択移動も無効化
Window_OptionCategory.prototype.processWheel = function () {
  if (!enableMouseControl) return;           // ← ここで遮断
  Window_Selectable.prototype.processWheel.call(this);
};

    

    Window_Options.prototype.cursorRight = function(wrap) {
        const symbol = this.commandSymbol(this.index());
        const option = this.findSymbolFromList(symbol);
        if (!option) return;
    
        if (this.isNoneSymbol(symbol)) {
            return;
        }
    
        if (this.isBarSymbol(symbol)) {
            // バータイプ（数値）の場合
            const currentValue = this.getConfigValue(symbol);
            const nextValue = currentValue + option.keyStep;
            const clampedValue = nextValue > option.typeMax ? option.typeMin : nextValue;
            this.changeValue(symbol, clampedValue);
        } else if (this.isScriptSymbol(symbol)) {
            // スクリプトシンボルの場合
            eval(symbol);
        } else if (option.optionType === 1) {
            // スイッチ（true/false）の場合
            const currentValue = this.getConfigValue(symbol);
            this.changeValue(symbol, !currentValue); // 値を切り替え
    
            // スプライトを必要な部分だけ更新
            this.updateSwitchSprite(symbol, this.index());
        }
        SoundManager.playOk(); // SEを再生
    };
    
    Window_Options.prototype.cursorLeft = function(wrap) {
        const symbol = this.commandSymbol(this.index());
        const option = this.findSymbolFromList(symbol);
        if (!option) return;
    
        if (this.isNoneSymbol(symbol)) {
            return;
        }
    
        if (this.isBarSymbol(symbol)) {
            // バータイプ（数値）の場合
            const currentValue = this.getConfigValue(symbol);
            const prevValue = currentValue - option.keyStep;
            const clampedValue = prevValue < option.typeMin ? option.typeMax : prevValue;
            this.changeValue(symbol, clampedValue);
        } else if (this.isScriptSymbol(symbol)) {
            // スクリプトシンボルの場合
            eval(symbol);
        } else if (option.optionType === 1) {
            // スイッチ（true/false）の場合
            const currentValue = this.getConfigValue(symbol);
            this.changeValue(symbol, !currentValue); // 値を切り替え
    
            // スプライトを必要な部分だけ更新
            this.updateSwitchSprite(symbol, this.index());
        }
        SoundManager.playOk(); // SEを再生
    };
    
    Window_Options.prototype.updateSwitchSprite = function(symbol, index) {
        const option = this.findSymbolFromList(symbol);
        if (!option) return;
    
        const rect = this.itemRect(index);
    
        // スイッチ画像やテキストを再描画
        if (option.showSwitchText === "true" || option.imageOn || option.imageOff) {
            this.clearOldSprites(symbol); // 古いスプライトのみ削除
            this.drawOnOffButton(index, rect); // 必要な部分だけ再描画
        }
    };
        
    
    Window_OptionCategory.prototype.refreshWindowContents = function() {
        if (this._itemWindow) {
            this._itemWindow.refresh(); // ウィンドウ内容をリフレッシュ
            
            // ウィンドウ位置をリセットしてからフェードイン＆イーズインを適用
            this._itemWindow.x = this._itemWindow._originalX || this._itemWindow.x;
            SceneManager._scene.applyFadeAndEaseEffect(this._itemWindow);
        }
    };
    
    
    
    // 下キー、上キー、OK時はフェードインしないように処理をそのまま
    Window_OptionCategory.prototype.cursorDown = function(wrap) {
        Window_Selectable.prototype.cursorDown.call(this, wrap);
    };
    
    Window_OptionCategory.prototype.cursorUp = function(wrap) {
        Window_Selectable.prototype.cursorUp.call(this, wrap);
    };
    
    Window_OptionCategory.prototype.processOk = function() {
        Window_Selectable.prototype.processOk.call(this);
    };
    



    function Sprite_Options() {
        this.initialize(...arguments);
    }
    
    Sprite_Options.prototype = Object.create(Sprite.prototype);
    Sprite_Options.prototype.constructor = Sprite_Options;

    Sprite_Options.prototype.initialize = function(bitmap, symbol) {
        Sprite.prototype.initialize.call(this, bitmap);
        this._symbol = symbol;
    };

// ConfigManager に新しい項目を追加
ConfigManager.voiceVolume = 100;
ConfigManager.voiceCh0Enabled = true;

const _makeData = ConfigManager.makeData;
ConfigManager.makeData = function() {
    const config = _makeData.call(this);
    config.voiceVolume = this.voiceVolume;
    config.voiceCh0Enabled = this.voiceCh0Enabled;
    return config;
};

const _applyData = ConfigManager.applyData;
ConfigManager.applyData = function(config) {
    _applyData.call(this, config);
    this.voiceVolume = this.readVolume(config, 'voiceVolume');
    this.voiceCh0Enabled = config.hasOwnProperty('voiceCh0Enabled') ? config.voiceCh0Enabled : true;
};

    
  // VariableCommon が入っていない/未定義でも落ちないようにする
  function canSaveCommon() {
    return typeof ConfigManager.saveCommonVariables === "function";
  }

  // 連打防止：変更が続いても一定間隔で1回だけ保存
  let _pending = false;
  let _wait = 0;
  const WAIT_FRAMES = 10; // 約0.16秒(60fps想定)

  function requestSaveCommon() {
    if (!canSaveCommon()) return;
    _pending = true;
    _wait = WAIT_FRAMES;
  }

  const _SceneManager_updateMain = SceneManager.updateMain;
  SceneManager.updateMain = function() {
    _SceneManager_updateMain.call(this);

    if (!_pending) return;
    _wait--;
    if (_wait <= 0) {
      _pending = false;
      ConfigManager.saveCommonVariables(); // 共有変数・共有スイッチを config.rmmzsave に保存
    }
  };

  // オプション変更の入り口をフック
  const _changeValue = Window_Options.prototype.changeValue;
  Window_Options.prototype.changeValue = function(symbol, value) {
    _changeValue.call(this, symbol, value);

    // 「共有変数/共有スイッチに関係する項目が変わった」タイミングで予約
    // ここは必要に応じて条件を絞れる（後述）
    requestSaveCommon();
  };

  const _processOk = Window_Options.prototype.processOk;
  Window_Options.prototype.processOk = function() {
    _processOk.call(this);
    requestSaveCommon();
  };
})();