(() => {
  // Rosedale が立てている Imported フラグ
  if (!window.Imported || !Imported['CHARACTER MOTIONS']) return; // :contentReference[oaicite:1]{index=1}

  const FLAG_KEY = "_needRosedaleEventMotionRefresh";

  function isOnMapScene() {
    return SceneManager._scene instanceof Scene_Map;
  }

  function canTouchMapEventsNow() {
    if (!isOnMapScene()) return false;
    if (!$gameMap || !$dataMap) return false;
    if (!$gameMap._events) return false;
    return true;
  }

  function refreshEventMotionsSafe() {
    if (!canTouchMapEventsNow()) return false;

    const list = $gameMap._events;
    for (const ev of list) {
      if (!ev) continue;
      // ロード直後に event() が null の瞬間があるので必ず防御
      if (typeof ev.event !== "function") continue;
      if (!ev.event()) continue;
      if (typeof ev.refreshMotionData === "function") ev.refreshMotionData();
    }
    return true;
  }

  // スイッチ変化：イベント更新は「マップ上だけ」。それ以外はフラグだけ立てる
  const _refresh = Game_Switches.prototype.refreshCharactersMotionData;
  Game_Switches.prototype.refreshCharactersMotionData = function() {
    _refresh.call(this); // Rosedale本体の更新（プレイヤー/フォロワー）は維持 :contentReference[oaicite:2]{index=2}

    if (!$gameTemp) return;
    if (!refreshEventMotionsSafe()) $gameTemp[FLAG_KEY] = true;
  };

  // マップに戻った直後に1回だけ消化
  const _SceneMap_update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function() {
    _SceneMap_update.call(this);

    if ($gameTemp && $gameTemp[FLAG_KEY]) {
      if (refreshEventMotionsSafe()) $gameTemp[FLAG_KEY] = false;
    }
  };
})();
