/*:
 * @param FreezeSwitchId
 * @type switch
 * @default 1
 */

(() => {
  const pluginName = document.currentScript.src.match(/([^\/]+)\.js$/)[1];
  const params = PluginManager.parameters(pluginName);
  const FREEZE_SWITCH = Number(params.FreezeSwitchId || 0);
  if (!FREEZE_SWITCH) return;

  function patch(sprite) {
    if (!sprite || sprite.__kchPatched) return;
    sprite.__kchPatched = true;

    const original = sprite.updateFrame.bind(sprite);

    sprite.__kchFrameFixed = false;

    sprite.updateFrame = function() {
      const freeze = $gameSwitches.value(FREEZE_SWITCH);
      const bmp = this.bitmap;

      // エディタ中は常に通常動作
      if ($gameTemp?._doodadEditorMode) {
        this.__kchFrameFixed = false;
        return original();
      }

      if (freeze) {
        // bitmap がまだなら何もしない（ready 待ち）
        if (!bmp || !bmp.isReady()) {
          this.__kchFrameFixed = false;
          return;
        }

        // ready になった瞬間 or 初回 freeze
        if (!this.__kchFrameFixed) {
          this._index = 0;
          this._currentCount = 0;
          this.__kchFrameFixed = true;
          return original();
        }

        // 以後は完全スキップ
        return;
      }

      // freeze OFF → 通常復帰
      this.__kchFrameFixed = false;
      return original();
    };
  }

  const _addMapDoodads = Spriteset_Map.prototype.addMapDoodads;
  Spriteset_Map.prototype.addMapDoodads = function() {
    _addMapDoodads.call(this);
    if (Array.isArray(this._doodadSprites)) {
      for (const s of this._doodadSprites) patch(s);
    }
  };

  const _createCharacters = Spriteset_Map.prototype.createCharacters;
  Spriteset_Map.prototype.createCharacters = function() {
    _createCharacters.call(this);
    if (Array.isArray(this._doodadSprites)) {
      for (const s of this._doodadSprites) patch(s);
    }
  };
})();
