/*:
 * @plugindesc 安全にセーブ・ロード画面に移動する関数を提供するプラグイン
 * @author ChatGPT
 */

(function() {

    // MathExt.clamp 定義（プラグイン依存対策）
    var MathExt = MathExt || {};
    MathExt.clamp = MathExt.clamp || function(value, min, max) {
        return Math.min(Math.max(value, min), max);
    };

    // -----------------------------
    // 安全にセーブ画面に移動
    // -----------------------------
    window.safePushSaveScene = function() {
        const scene = SceneManager._scene;
        if (scene && scene._messageWindow) scene._messageWindow.hide();
        $gameMessage.clear();
        SceneManager.push(Scene_Save);
    };

    // -----------------------------
    // 安全にロード画面に移動
    // -----------------------------
    window.safePushLoadScene = function() {
        const scene = SceneManager._scene;
        if (scene && scene._messageWindow) scene._messageWindow.hide();
        $gameMessage.clear();
        SceneManager.push(Scene_Load);
    };

})();
