//=============================================================================
// Trb_TextColor.js
//=============================================================================
//Copyright (c) 2017 Trb
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
//
//twitter https://twitter.com/Trb_surasura
/*:
 * @plugindesc テキストの色を色コードで指定できるようにするプラグイン
 * @author Trb
 * @version 1.00 2017/3/8 初版
 * 
 * @help 制御文字\c[ ]でテキストの色を変更する際、通常は0～31のカラーパレット番号で指定しますが
 * これを#000000～#ffffffの色コードで指定できるようにするプラグインです。
 * 
 * ※色コードというのは、『# + 6桁の16進数』で色を表現するコードのことです。
 * 6桁の16進数の部分は2桁ごとに分かれていて、
 * 最初の2桁が赤の強さ
 * 次の2桁が緑の強さ
 * 最後の2桁が青の強さ
 * になっています。 
 * それぞれ、00が一番低く(その色の成分が0)、ffが最大の値になります。
 * たとえば #ff0000 と書いたら、赤の成分が最大、緑と青は0なので真っ赤な色になります。
 * 詳しくはインターネットで『色コード』で検索して下さい。
 * 
 * <記入例>
 * \c[#123456]
 * というように、[]内に0～31の数字の代わりに色コードを記入するだけです。
 */
(function () {

    var Window_Base_obtainEscapeParam = Window_Base.prototype.obtainEscapeParam;
	Window_Base.prototype.obtainEscapeParam = function(textState) {
		var arr = /^\[\#[0-9A-Fa-f]{6}\]/.exec(textState.text.slice(textState.index));
		if (arr) {
			textState.index += arr[0].length;
			return arr[0].slice(1,8);
		} else {
			return Window_Base_obtainEscapeParam.apply(this,arguments);
		}
	};

    var Window_Base_textColor = Window_Base.prototype.textColor;
    Window_Base.prototype.textColor = function(n) {
        if(typeof n === 'string'){
            return n;
        }else{
            return Window_Base_textColor.apply(this,arguments);
        }
    };

})();