//=============================================================================
// 100CharacterCall.js
//=============================================================================

/*:
 * @target MV
 * @plugindesc 保存データ
 * @help
 * 保存データに関する処理を行うサンプルです。
 */

(() => {
    let CPic = 80;
    let Ccommand = 1;
    let Ccommand2 = 1;
    let Ccommand3 = 21;
    let CSw      = false;
    StationName  = ["夢精駅","射精駅","珍古仏頭井駅","漫個美所濡駅","節句巣台隙駅"];
    const wait   = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    const CharacterPersonality = {
        0: "真面目な",
        1: "素直な",
        2: "無邪気な",
        3: "冷静な",
        4: "天然な",
        5: "勝ち気な",
        6: "おっとりした",
        7: "内気な",
        8: "社交的な",
        9: "大人びた",
        10: "活発な",
        11: "穏やかな",
        12: "負けず嫌いな",
        13: "ミステリアスな",
        14: "冷めた",
        15: "感情豊かな",
        16: "努力家な",
        17: "のうてんきな",
        18: "甘えん坊な",
        19: "強気な"
    };

    const CharacterFamilyName = {
        0:"佐藤", 1:"鈴木", 2:"高橋", 3:"田中", 4:"渡辺",
        5:"伊藤", 6:"山本", 7:"中村", 8:"小林", 9:"加藤",
        10:"吉田", 11:"山田", 12:"佐々木", 13:"山口", 14:"松本",
        15:"井上", 16:"木村", 17:"林", 18:"清水", 19:"森",
        20:"池田", 21:"橋本", 22:"阿部", 23:"山崎", 24:"石川",
        25:"前田", 26:"藤田", 27:"後藤", 28:"小川", 29:"岡田",
        30:"長谷川", 31:"村上", 32:"近藤", 33:"石井", 34:"坂本",
        35:"千葉", 36:"斎藤", 37:"原田", 38:"中島", 39:"野村",
        40:"大野", 41:"青木", 42:"福田", 43:"西村", 44:"三浦",
        45:"藤井", 46:"平野", 47:"島田", 48:"岩田", 49:"内田"
    };

    const CharacterFirstName = {
        0:"さくら", 1:"彩花", 2:"美優", 3:"結衣", 4:"あいり",
        5:"真央",  6:"心春", 7:"優奈", 8:"紗季", 9:"美咲",
        10:"香織", 11:"陽菜", 12:"萌", 13:"茜", 14:"澪",
        15:"ルイ", 16:"ななみ", 17:"凛", 18:"葵", 19:"れいな",
        20:"美琴", 21:"やよい", 22:"柚希", 23:"エリカ", 24:"花音",
        25:"ゆか", 26:"梨沙", 27:"華", 28:"さら", 29:"優花",
        30:"麻衣", 31:"瑞希", 32:"叶絵", 33:"琴音", 34:"ゆうり",
        35:"七海", 36:"遥", 37:"ミライ", 38:"美羽", 39:"千春",
        40:"雪乃", 41:"すず", 42:"真桜", 43:"愛美", 44:"里奈",
        45:"瑞穂", 46:"静香", 47:"怜", 48:"百合", 49:"佳乃"
    };

    window.RarityTable = {
        0: [{r:1, w:80},{r:2, w:20},],
        1: [{r:2, w:70},{r:3, w:25},{r:4, w:5},],
        2: [{r:2, w:35},{r:3, w:50},{r:4, w:15},],
        3: [{r:3, w:20},{r:4, w:60},{r:5, w:20},],
        4: [{r:4, w:50},{r:5, w:50},]
    };

    const Ct = {
        "CB1" : ["選択1",21],
        "CB2" : ["選択2",22],
        "CB3" : ["選択3",23],
        "CB4" : ["選択4",24],
        "CB5" : ["選択5",25],
    }

    const CtKey = {
        21 : ["選択1",21],
        22 : ["選択2",22],
        23 : ["選択3",23],
        24 : ["選択4",24],
        25 : ["選択5",25],
    }

    window.キャラクター図鑑 = async function() {
        SpineChoiceManager.disableHit();
        $gameSwitches.setValue(61, false);
        $gameVariables.setValue(98, 100);
        CSw      = false;
        $gameSwitches.setValue(4,true);
        NrCustomMessage.hide();
        Ccommand = 21;

        $gameScreen.startFadeOut(30);
		await wait(30);
        SpineChoiceManager.forceFinishById("メインUI");

        P消去 = [0,60];
        Spine = "図鑑2";
        SpineChoiceManager.show("図鑑");
        アニメ更新 = [0,CPic,10,"選択1"];

        var ii = 21;
        for (var i = 101; i <= 105; i++) {
            $gameVariables.setValue(i, $gameVariables.value(ii++).length);
        }
        var y = 0;
        Dテキスト = [81, 490, 69 + (95 * y++), 255, "\\OW[0]\\C[15]\\v[101]", 40, "right"];
        Dテキスト = [82, 490, 69 + (94 * y++), 255, "\\OW[0]\\C[15]\\v[102]", 40, "right"];
        Dテキスト = [83, 490, 69 + (93 * y++), 255, "\\OW[0]\\C[15]\\v[103]", 40, "right"];
        Dテキスト = [84, 490, 69 + (92 * y++) + 2, 255, "\\OW[0]\\C[15]\\v[104]", 40, "right"];
        Dテキスト = [85, 490, 69 + (92 * y++) + 2, 255, "\\OW[0]\\C[15]\\v[105]", 40, "right"];

        await wait(30);
        $gameScreen.startFadeIn(30);
		await wait(30);
        $gameScreen.spine(99).setTrackTimeScale(0, 1);
        await wait(15);

        CallBgm("There's_nothing_left");
        アニメ更新 = [0,CPic,0,"待機"];
        $gameVariables.setValue(98, 0);
        SpineChoiceManager.enableHit();   // 入力再許可
        SpineChoiceManager.restore();     // 状態初期化
    }

    window.キャラクター図鑑2 = async function(CallNum) {
        SpineChoiceManager.disableHit();
        var Call = $gameVariables.value(CallNum);
        if (!Call || Call.length === 0) {
            //キャンセル
            await wait(1);
            SpineChoiceManager.restore();
            return;
        }

        アニメ更新 = [0,CPic,0,"000"];
        Ccommand3 = CallNum;
        $gameVariables.setValue(98, 100);

        $gameScreen.startFadeOut(30);
		await wait(30);
        SpineChoiceManager.forceFinishById("図鑑");

        P消去 = [1,81,85];
        Ccommand2 = 0;
        //SpineChoiceManager.show("図鑑2");
        Spine = "図鑑";
        アニメ更新 = [0,CPic,0,"図鑑"];

        $gameVariables.setValue(113, $gameVariables.value(CallNum).length);
        $gameVariables.setValue(112, 1);

        var x = 70;
        Dテキスト = [86, 300, -8, 255, "\\OW[0]\\C[15]\\f[b]\\v[106]", 40, "center"];
        Dテキスト = [87, x, 165, 255, "\\OW[0]\\C[15]\\v[107]", 40, "left"];
        Dテキスト = [88, x, 255, 255, "\\OW[0]\\C[15]\\v[108]", 40, "left"];
        Dテキスト = [89, 175, 393, 255, "\\OW[0]\\C[15]\\v[109]", 35, "left"];
        Dテキスト = [90, x, 438, 255, "\\OW[0]\\C[15]\\v[110]", 35, "left"];
        Dテキスト = [91, 175, 530, 255, "\\OW[0]\\C[15]\\v[111]", 35, "left"];
        Dテキスト = [92, 600, -5, 255, "\\OW[0]\\C[15]\\v[112]/\\v[113]", 35, "right"];

        Spine = "図鑑立ち絵1";
        Spine = "図鑑立ち絵2";
        Spine = "図鑑立ち絵3";
        await wait(5);
        アニメ更新 = [0,96,1,"ふりむき"];
        P表示 = [95,"マスク"];
        var interpreter = new Game_Interpreter();
        interpreter.pluginCommand("SETMASK", ["96", "95"]);
        interpreter.pluginCommand("SETMASK", ["97", "95"]);
        interpreter.pluginCommand("SETMASK", ["98", "95"]);
        await wait(5);
        キャラクター呼び出し(CallNum);

        await wait(10);
        P移動 = [96 , "x", 190];
        await wait(3);
        P移動 = [97 , "x", 190];
        await wait(3);
        P移動 = [98 , "x", 190];
        await wait(3);
        P移動 = [96 , "y", -40];
        await wait(3);
        P移動 = [97 , "y", -40];
        await wait(3);
        P移動 = [98 , "y", -10];
        await wait(10);
        $gameScreen.startFadeIn(30);
		await wait(30);

        $gameVariables.setValue(98, 0);
        SpineChoiceManager.enableHit();
        $gameSwitches.setValue(10, true);
    }
    
    window.キャラクター呼び出し = async function(CallNum) {
        var list = $gameVariables.value(CallNum);
        var Call = list[Ccommand2];

        $gameVariables.setValue(106, Call[1]);
        $gameVariables.setValue(107, Call[2]);
        $gameVariables.setValue(108, Call[3]);
        $gameVariables.setValue(109, Call[4]);
        $gameVariables.setValue(110, Call[5]);
        $gameVariables.setValue(111, Call[7]);

        var CData;
        try {
            CData = JSON.parse(Call[6]);
        } catch (e) {
            CData = [];
        }

        Pフェード = [1,96,98,0,1];
        await wait(5);

        var ChPic = 96;
        if (Call[8] === 1) ChPic = 97;
        else if (Call[8] === 2) ChPic = 98;

        if (Array.isArray(CData)) {
            アニメ更新 = [0,ChPic,0,CData[0]];
            $gameScreen.spine(ChPic).setTrackTimeScale(0,0);
            for (var i = 6; i < CData.length; i++) {
                アニメ更新 = [0,ChPic,i,CData[i]];
            }
        }

        await wait(3);
        Pフェード = [0,ChPic,255,1];
    };

    window.図鑑ページ切り替え = async function(n) {
        const current = $gameVariables.value(112);
        const max = $gameVariables.value(113);
        const next = current + n;

        if (next < 1 || next > max) return;

        Ccommand2 += n;
        $gameVariables.setValue(112, next);
        キャラクター呼び出し(Ccommand3);
        await wait(15);
        SpineChoiceManager.restore();
    };

    window.図鑑選択 = async function(Call) {
        $gameVariables.setValue(98, 100);
        var Anime = Ct[Call];

        アニメ更新 = [0,CPic,10,Anime[0]];
        Ccommand  = Anime[1];

        await wait(1);
        $gameVariables.setValue(98, 0);
    }

    window.図鑑キー実行 = async function(Call) {
        if($gameVariables.value(98) !== 0) return;
        $gameVariables.setValue(98, 100);

        if(Call === 0) {
            //下へ移動
            if(Ccommand < 25) {
                Ccommand++;
            } else {
                Ccommand = 21;
            }
            
            var Anime = CtKey[Ccommand];
            アニメ更新 = [0,CPic,10,Anime[0]];
        } else if(Call === 1) {
            //上へ移動
            if(Ccommand === 21) {
                Ccommand = 25;
            } else {
                Ccommand--;
            }
            
            var Anime = CtKey[Ccommand];
            アニメ更新 = [0,CPic,10,Anime[0]];
        } else if(Call === 2) {
            //実行
            SpineChoiceManager.disableHit();
            キャラクター図鑑2(Ccommand);
        }

        await wait(1);
        $gameVariables.setValue(98, 0);
    }

    window.図鑑実行 = async function() {
        if($gameVariables.value(98) !== 0) {
            return;
        }

        $gameVariables.setValue(98, 100);

        キャラクター図鑑2(Ccommand);
        await wait(1);
        $gameVariables.setValue(98, 0);
    }

    window.図鑑終了 = async function() {
        SpineChoiceManager.disableHit();
        $gameSwitches.setValue(4,true);
        $gameVariables.setValue(98, 100);
        CallSe("sei_ge_albam_page03");
        アニメ更新 = [1,99,0,"1","000"];
        await wait(90);

        $gameScreen.startFadeOut(30);
		await wait(30);
        SpineChoiceManager.forceFinishById("図鑑");
        P消去 = [1,80,99];
        if(!$gameSwitches.value(9)) {
            メイン呼び出し();
            CallBgm("In a rental car");
        } else {
            $gameTemp.reserveCommonEvent(25);
        }
    }

    window.図鑑終了2 = async function() {
        $gameSwitches.setValue(10, false);
        $gameVariables.setValue(98, 100);

        $gameScreen.startFadeOut(30);
		await wait(30);
        var interpreter = new Game_Interpreter();
        interpreter.pluginCommand('REMOVEMASK', ['96']);
        interpreter.pluginCommand('REMOVEMASK', ['97']);
        interpreter.pluginCommand('REMOVEMASK', ['98']);
        P消去 = [1,80,99];
        キャラクター図鑑();
    }

    window.称号呼び出し = async function() {
        SpineChoiceManager.disableHit();
        $gameSwitches.setValue(61, false);
        $gameVariables.setValue(98, 100);
        $gameSwitches.setValue(4,true);
        NrCustomMessage.hide();

        $gameScreen.startFadeOut(30);
		await wait(30);
        P消去 = [0,60];
        Spine = "称号";
        var Anime = "" + $gameVariables.value(41);
        var Tte   = "";
        アニメ更新 = [0,80,0,Anime];

        $gameVariables.setValue(101, $gameVariables.value(45) - $gameVariables.value(44));
        称号テキスト();
    
        Dテキスト = [81, 20, 68, 255, "\\OW[0]\\C[15]\\f[b]\\v[42]", 50, "left"];
        

        await wait(30);
        $gameScreen.startFadeIn(30);
		await wait(30);

        $gameVariables.setValue(98, 0);
        $gameSwitches.setValue(11, true);
    }

    window.称号テキスト = async function() {
        const lv = $gameVariables.value(41);

        const counts = [];
        for (let i = 21; i <= 25; i++) {
            const v = $gameVariables.value(i);
            counts.push(Array.isArray(v) ? v.length : 0);
        }

        const format = n => {
            const v = Math.max(n, 0);
            return (v < 10 ? " " : "") + v;
        };

        var text = "";
        if (lv === 4) {
            text = "最高の称号だ！ ";
        }
        else if (lv === 0) {
            const total = counts.reduce((a, b) => a + b, 0);
            text = `次のレベルまで★1以上があと${format(5 - total)}人 `;
        }
        else if (lv === 1) {
            const total = counts.reduce((a, b) => a + b, 0);
            text = `次のレベルまで★1以上があと${format(10 - total)}人 `;
        }
        else if (lv === 2) {
            const total = counts.slice(1).reduce((a, b) => a + b, 0);
            text = `次のレベルまで★2以上があと${format(15 - total)}人 `;
        }
        else if (lv === 3) {
            const rare3 = counts.slice(2).reduce((a, b) => a + b, 0);
            const rare4 = counts.slice(3).reduce((a, b) => a + b, 0);
            const r3 = format(20 - rare3);
            const r4 = format(10 - rare4);
            text = `次のレベルまで★3以上があと${r3}人 \n★4以上があと${r4}人 `;
        }

        Dテキスト = [82, 345, 35, 255, "\\OW[0]\\C[15]" + text, 28, "right"];

        if (lv === 3) {
            await wait(1);
            P移動 = [82, "y", -33];
        }
    };
    
    window.称号終了 = async function() {
        CallSe("Cancel2");
        $gameSwitches.setValue(11, false);
        $gameSwitches.setValue(4,true);
        $gameVariables.setValue(98, 100);
		await wait(15);

        $gameScreen.startFadeOut(30);
		await wait(30);
        P消去 = [1,80,99];
		メイン呼び出し();
    }







    //キャラクター登録

    window.キャラクター登録 = async function() {
        var data  = $gameVariables.value(120);
        var rare  = data[0];
        var index = 20 + rare; // 例：★1 → 21 保存する変数

        var box = $gameVariables.value(index);

        // まだ未初期化なら配列として初期化
        if (!Array.isArray(box)) {
            box = [];
        }

        // 上限チェック（任意）
        if (box.length >= 1000) {
            console.log("登録できる上限に達しています。");
            return;
        }

        // 登録
        box.push(data);

        $gameVariables.setValue(index, box);
        await wait(4);
        await レベル上昇();
    };

    window.キャラクターデータ作成 = async function() {
        FixedRegion = $gameVariables.value(99);
        var list = RarityTable[FixedRegion];
        let total = 0;
        for (let obj of list) total += obj.w;

        let rnd = Math.random() * total;
        var rarity = list[list.length - 1].r;

        for (let obj of list) {
            rnd -= obj.w;
            if (rnd < 0) {
                rarity = obj.r;
                break;
            }
        }

        var pKey = Math.floor(Math.random() * Object.keys(CharacterPersonality).length);
        var personality = CharacterPersonality[pKey];

        var fKey = Math.floor(Math.random() * Object.keys(CharacterFamilyName).length);
        var family = CharacterFamilyName[fKey];

        var nKey = Math.floor(Math.random() * Object.keys(CharacterFirstName).length);
        var first = CharacterFirstName[nKey];

        var now = new Date();
        var month = now.getMonth() + 1;
        var day   = now.getDate();
        var hour  = now.getHours();
        var min   = now.getMinutes();
        if (min < 10) min = "0" + min;

        var timeText = month + "/" + day + " " + hour + ":" + min;
        var Bmin=0, Bmax=0, Wmin=0, Wmax=0, Hmin=0, Hmax=0;

        if (CharacterNum === 0) { 
            Bmin=78; Bmax=84;
            Wmin=61; Wmax=65;
            Hmin=80; Hmax=90;
        }
        else if (CharacterNum === 1) {
            Bmin=74; Bmax=80;
            Wmin=61; Wmax=65;
            Hmin=80; Hmax=85;
        }
        else if (CharacterNum === 2) {
            Bmin=68; Bmax=74;
            Wmin=61; Wmax=65;
            Hmin=66; Hmax=72;
        }

        function r(min, max) {
            return Math.floor(Math.random() * (max - min + 1)) + min;
        }

        var bodyText = "B" + r(Bmin,Bmax) + " W" + r(Wmin,Wmax) + " H" + r(Hmin,Hmax);

        var text1 = "";
        if (CharacterNum === 0) text1 = personality + "学生";
        else if (CharacterNum === 1) text1 = personality + "ボーイッシュの学生";
        else if (CharacterNum === 2) text1 = personality + "女の子";

        var text2 = StationName[FixedRegion] + "駅から乗車した時に遭遇。";

        var text3 = JSON.stringify(CharacterBox);;
        var text4 = "";
        var text5 = CharacterNum;

        var data = [
            rarity,
            family + " " + first,
            timeText,
            bodyText,
            text1,
            text2,
            text3,
            text4,
            text5
        ];

        $gameVariables.setValue(120, data);
    };

})();