//=============================================================================
// 100CommandCall.js
//=============================================================================

/*:
 * @target MV
 * @plugindesc コマンド土台
 * @help
 * 
 * 
 * 
 * 
 * ピクチャ一覧
 * 0  - 0  
 * 1  - 痴漢背景 / 店員
 * 2  - 電車
 * 3  - 残り時間
 * 10 - 21 立ち絵 / H立ち絵
 * 50 - メニューUI / 痴漢UI / 駅選択
 * 51 - 選択肢
 * 71 - 成功立ち絵
 * 72 - 成功
 * 80 - 図鑑 / 称号
 * 95 - 図鑑立ち絵マスク
 * 96 - 図鑑立ち絵1
 * 97 - 図鑑立ち絵2
 * 98 - 図鑑立ち絵1
 * 99 - アルバム / Hit
 * 100 - 失敗 / 操作方法
 * 
 * 
 * トラック一覧
 * 0  - 待機
 * 1  - カード1
 * 2  - カード2
 * 3  - カード3
 * 4  - カード4
 * 5  - カード5
 * 6  - 
 * 7  - 
 * 8  - 
 * 9  - 
 * 10 - 選択
 */

(() => {
    const wait  = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    Object.defineProperty(window, 'P変更', {
        set(value) {
            const picId = Number(value[0]);
            const newName = String(value[1]);
            const picture = $gameScreen.picture(picId);

            if (!picture) {
                console.warn(`P変更: ピクチャID ${picId} は存在しません`);
                return;
            }

            $gameScreen.showPicture(
                picId,
                newName,
                picture.origin(),
                picture.x(),
                picture.y(),
                picture.scaleX(),
                picture.scaleY(),
                picture.opacity(),
                picture.blendMode()
            );
        },
        configurable: true
    });


	Object.defineProperty(window, 'P表示', {
		set(value) {
			var picId   = Number(value[0]);
			var picName = String(value[1]);
			$gameScreen.showPicture(picId, picName, 0, 0, 0, 100, 100, 255, 0);
		},
		configurable: true
	});

	Object.defineProperty(window, 'P表示2', {
		set(value) {
			var picId   = Number(value[0]);
			var picName = String(value[1]);
			$gameScreen.showPicture(picId, picName, 0, 0, 0, 200, 200, 255, 0);
		},
		configurable: true
	});

	Object.defineProperty(window, 'P表示3', {
		set(value) {
			var picId    = Number(value[0]);
			var picName  = String(value[1]);
			var picX     = Number(value[2]);
			var picY     = Number(value[3]);
            var picScale = Number(value[4]);
            $gameScreen.showPicture(picId, picName, 0, picX, picY, picScale, picScale, 0, 0);
		},
		configurable: true
	});

    Object.defineProperty(window, 'Spine', {
        set(value) {
            const Spinemapping = {
                // [ピクチャ番号, スケルトン名, 拡大率, x, y]
                "背景": [1, "電車", 200, 400, 300],
                "UI": [50, "UI", 200, 0, 0],
                "メインUI": [50, "メインUI", 200, 0, 0],
                "コマンド": [51, "選択肢", 200, 120, 0],
                "失敗": [100, "失敗", 100, 0, 0],
                "成功": [72, "成功", 200, 0, 0],
                "立ち絵1": [10, "立ち絵１", 200, 515, 206],
                "立ち絵2": [10, "1立ち絵", 200, 628, 206],
                "立ち絵3": [10, "2立ち絵", 200, 207, 50],
                "成功立ち絵1": [71, "立ち絵１", 200, 420, 206],
                "成功立ち絵2": [71, "1立ち絵", 200, 420, 206],
                "成功立ち絵3": [71, "2立ち絵", 200, 100, -150],
                "図鑑立ち絵1": [96, "立ち絵１", 200, 420, 206],
                "図鑑立ち絵2": [97, "1立ち絵", 200, 420, 206],
                "図鑑立ち絵3": [98, "2立ち絵", 200, 100, -150],
                "駅選択": [50, "駅選択", 200, 0, 0],
                "Hit": [99, "hit", 200, 400, 300],
                "図鑑": [80, "図鑑", 200, 0, 0],
                "図鑑2": [99, "アルバム", 200, 400, 300],
                "称号": [80, "称号", 200, 0, 0],
                "電車": [2, "液", 100, 0, 0],
                "説明": [100, "操作方法", 100, 0, 0],
                "店員": [1, "店員", 200, 0, 0],
            };

            var NSpine = Spinemapping[value];
            if (!NSpine) return;

            var sPic   = NSpine[0];
            var skName = NSpine[1];
            var NScale = NSpine[2];
            var NXx    = NSpine[3];
            var NYy    = NSpine[4];

            if ($gameScreen.picture(sPic)) $gameScreen.erasePicture(sPic);

            $gameScreen.showPicture(sPic, "", 0, NXx, NYy, NScale, NScale, 255, 0);
            $gameScreen.spine(sPic)
                .setSkeleton(skName)
                .setAnimation(0, "000", "continue", true);
            },
        configurable: true
    });

    Object.defineProperty(window, 'HSpine', {
        set(value) {
			var Spinemapping2 = {
				0: [11, 200, 240, -73, "0Takeoff", "0Back", "0Breast1", "0Breast2", "0climax", "0Hand", "0Hip1", "0Hip2", "0Hip3", "0Nipple"],
				1: [11, 200, 348, -74, "1胸揉み", "1胸揉み2", "1スカート", "1手マン", "1尻揉み"],
				2: [16, 200, 364, -92, "1挿入たくし上げ", "1キス挿入", "1乳首", "1手マン激しい", "1挿入", "1絶頂"],
				3: [11, 200, 240, 50, "2たくし上げ", "2キス", "2挿入", "2尻触り", "2スカート", "2パンツ", "2手マン激しい", "2手マン", "2乳首", "2胸揉み服", "2胸撫で"]
			};

            var map = Spinemapping2[value];
            if (!map) return;

			var PicSt = map[0];
            var Scale = map[1];
            var X = map[2];
            var Y = map[3];

            for (var i = 4; i < map.length; i++) {
                var Pic = PicSt + (i - 4);
                var skName = map[i];

                $gameScreen.showPicture(Pic, "", 0, X, Y, Scale, Scale, 0, 0);
                $gameScreen.spine(Pic)
                    .setSkeleton(skName)
                    .setAnimation(0, "000", "continue", true);
                $gameScreen.spine(Pic).setTrackTimeScale(0, 0);

				if(value === 2) {
					アニメ更新 = [0,Pic,20,"ポール(前面背景レイヤー)"];
					アニメ更新 = [0,Pic,21,"ポール(背面背景レイヤー)"];
				}
            }
        },
        configurable: true
    });


    Object.defineProperty(window, 'アニメ更新', {
        set(value) {
            const wait = ms => new Promise(r => setTimeout(r, ms));

            (async () => {
                var NNh = value[0];

                if (NNh === 0) {
                    var Pic   = value[1];
                    var Trc   = value[2];
                    var Anime = value[3];

                    await wait(1);
                    $gameScreen.spine(Pic).setAnimation(Trc, Anime, 'continue', true);
                } else  if(NNh === 1) {
                    var Pic    = value[1];
                    var Trc    = value[2];
                    var Anime  = value[3];
                    var Anime2 = value[4];

                    await wait(1);
                    $gameScreen.spine(Pic).setAnimation(Trc, [Anime, Anime2], 'sequential', 'continue', true);
                } else {
                    var Pic    = value[1];
                    var Trc    = value[2];
                    var Anime  = value[3];
                    var Anime2 = value[4];
                    var Anime3 = value[5];

                    await wait(1);
                    $gameScreen.spine(Pic).setAnimation(Trc, [Anime, Anime2, Anime3], 'sequential', 'continue', true);                    
                }
            })();
        },
        configurable: true
    });


    Object.defineProperty(window, 'アニメ更新2', {
        set(value) {
            const wait = ms => new Promise(r => setTimeout(r, ms));

            (async () => {
                var NNh = value[0];

                if (NNh === 0) {
                    var Pic   = value[1];
                    var Trc   = value[2];
                    var Anime = value[3];

                    await wait(1);
                    $gameScreen.spine(Pic).setAnimation(Trc, Anime, 'none', true);
                } else  if(NNh === 1) {
                    var Pic    = value[1];
                    var Trc    = value[2];
                    var Anime  = value[3];
                    var Anime2 = value[4];

                    await wait(1);
                    $gameScreen.spine(Pic).setAnimation(Trc, [Anime, Anime2], 'sequential', 'none', true);
                } else {
                    var Pic    = value[1];
                    var Trc    = value[2];
                    var Anime  = value[3];
                    var Anime2 = value[4];
                    var Anime3 = value[5];

                    await wait(1);
                    $gameScreen.spine(Pic).setAnimation(Trc, [Anime, Anime2, Anime3], 'sequential', 'none', true);                    
                }
            })();
        },
        configurable: true
    });

    Object.defineProperty(window, 'Pフェード', {
        set: function(value) {
            var mode    = value[0];
            var startId = value[1];
            var endId, opacity, duration;

            if (mode === 0) {
                opacity  = value[2];
                duration = value.length >= 4 ? value[3] : 60;
                endId = startId;
            } else {
                endId    = value[2];
                opacity  = value[3];
                duration = value.length >= 5 ? value[4] : 60;
            }

            for (var id = startId; id <= endId; id++) {
                var p = $gameScreen.picture(id);
                if (!p) continue;
                $gameScreen.movePicture(
                    id,
                    p.origin(),
                    p.x(),
                    p.y(),
                    p.scaleX(),
                    p.scaleY(),
                    opacity,
                    p.blendMode(),
                    duration
                );
            }
        },
        configurable: true
    });

    Object.defineProperty(window, 'P消去', {
        set(value) {
            if (!Array.isArray(value) || value.length < 2) return;
            const mode = Number(value[0]);
            const startId = Number(value[1]);
            const endId = mode === 0 ? startId : Number(value[2] || startId);
            for (let id = startId; id <= endId; id++) {
                if ($gameScreen.picture(id)) $gameScreen.erasePicture(id);
            }
        },
        configurable: true
    });

    window.CallSe = async function(Call) {
        var se = Call;

        var se = {
            name: se,
            volume: 60,
            pitch: 100,
            pan: 0
        };
        AudioManager.playSe(se);
    }

    window.CallBgm = async function(Call) {
        var bgm = Call;

        var bgm = {
            name: bgm,
            volume: 40,
            pitch: 100,
            pan: 0
        };
        AudioManager.playBgm(bgm);
    }

    window.CallBgs = async function(Call) {
        var bgs = Call;

        var bgs = {
            name: bgs,
            volume: 50,
            pitch: 100,
            pan: 0
        };
        AudioManager.playBgs(bgs);
    }

    window.停止 = async function(種別) {
        let type = 種別;
        let channel = null;

        if (Array.isArray(種別)) {
            type = 種別[0];
            channel = 種別[1];
        }

        switch (type) {
            case "BGM":
                AudioManager.stopBgm();
                break;

            case "BGS":
                AudioManager.stopBgs();
                break;

            case "SE":
                if (AudioManager.stopAllSe) {
                    AudioManager.stopAllSe();
                }
                break;

            case "Voice":
                if (channel !== null) {
                    AudioManager.stopVoice(null, channel);
                } else {
                    AudioManager.stopVoice();
                }
                break;
        }
    }

	Object.defineProperty(window, "P移動", {
		set([id, axis, distance]) {
			const p = $gameScreen.picture(id);
			if (!p) return;
			const x = axis === "x" ? p.x() + distance : p.x();
			const y = axis === "y" ? p.y() + distance : p.y();
			$gameScreen.movePicture(id, p.origin(), x, y, p.scaleX(), p.scaleY(), p.opacity(), p.blendMode(), 1);
		}
	});

    Object.defineProperty(window, 'Dテキスト', {
        set: function(Call) {
            Call = Array.isArray(Call) ? Call : [];

            var picId   = Number(Call[0] != null ? Call[0] : 1);
            var x       = Number(Call[1] != null ? Call[1] : 0);
            var y       = Number(Call[2] != null ? Call[2] : 0);
            var opacity = Number(Call[3] != null ? Call[3] : 255);
            var text    = String(Call[4] != null ? Call[4] : "");
            var size    = Number(Call[5] != null ? Call[5] : 26);
            var align   = /^(left|center|right)$/i.test(Call[6]) ? Call[6].toUpperCase() : "LEFT";

            $gameScreen.dTextSize      = size;
            $gameScreen.dTextAlign     = { LEFT: 0, CENTER: 1, RIGHT: 2 }[align];
            $gameScreen.dTextRealTime  = true;
            if($gameScreen.dTextAlign !== 0) {
                $gameScreen.setDTextPicture("          ", size);
            }
            $gameScreen.setDTextPicture(text, size);
            $gameScreen.showPicture(picId, "", 0, x, y - (size - 5), 100, 100, opacity, 0);
        },
        configurable: true
    });

    window.手動ウェイト = async function(frames) {
        let count = 0;
        while (count < frames) {
            if (TouchInput.isTriggered() || Input.isTriggered('ok')) break;
            count++;
            await new Promise(r => setTimeout(r, 1000/60));
        }
    };

})();