//=============================================================================
// 100LineCall.js
//=============================================================================

/*:
 * @target MV
 * @plugindesc 保存データ
 * @help
 * 保存データに関する処理を行うサンプルです。
 */

(() => {
    MessageTNum = 0;
    const wait       = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    const MessageMapp = {
        //通常
        0 : ["あれ？　帰ってきたの？　帰ってこなくていいのに……。", "冗談じゃねーよ！　うひひ、いや、冗談だよか、\nひゃははは。"],
        1 : ["どうだい？　痴漢の方は？\nエロい話なら聞くぜ？　ぎひひひ。"],
        2 : ["なんだ、まだ逮捕されてねーのか。\n案外やるじゃねーか、うひゃひゃ。"],
        3 : ["くそ、帰ってきやがった。逮捕されるのを\n期待してたのによ、ちっ。"],
        4 : ["今日の俺は機嫌がいい！　だから１００万円くれ！！", "ひゃはは！　嘘じゃねーよ！\nほら、よこせ！"],
        5 : ["おいおい、ま～だ捕まってないのかよ。\nマジなんなん？お前。……引くわ～。"],
        6 : ["お前を見てると俺も痴漢したくなるね～、うひひ。", "でもまあ109回目はないわ～ｗひゃ～はっはっｗ"],
        100 : ["えへへ～、いよいよ修業も大詰めだな。\n準備は万端かい？　うへへ。", "痴漢は相手を気持ちよくさせたら勝ちみたいなもんだ。\nま、それでも捕まる時は捕まるがなｗうひひ。", "焦らずじっくり胆嚢するこったな、ひひひ。\nま、これからも指導してやんよ、金さえ積めば。\nうひひひ～。"]
    }

    const MessageMapp2 = {
        //次の駅解放
        1 : ["やるじゃねーか、死ぬほど認めたくはねーけど\n痴漢王見習いとしては合格だ。", "次の駅でもハッスルしてこいや、ひひひ。"],
        2 : ["ここまでして捕まらないお前は立派な犯罪者だｗ", "せいぜい次の駅でお縄になってこい、それだけが\n俺のメシウマだからよ、ひゃはは。"],
        3 : ["へー、最低のハゲ親父なのにやるじゃん、ひひひ。", "もう次の駅で終止符をうってやる！　ここで捕まらなきゃ\nお前を痴漢王と見なすつもりはない！\nうひゃひゃ。"],
        4 : ["ついにやったな……だがよ、エンディングなんかねーぞ？\n甘えてんじゃねー。", "俺らの戦いはこれからなんだ。いいか？\n忘れんなよ？　エンドレスだ。", "何回もやるといい、痴漢をさ、ふふふ。"],
    }

    const MessageMapp3 = {
        //次の駅解放
        0 : ["何～？痴漢の極意を知りたい～？甘えんじゃねーよ！\nてめえで考えろ！カスが！", "もし知りたかったら金を積むんだな。お前に用意\nできりゃあの話だがな！ひゃはは。"],
        1 : ["てめえもよくやってるじゃねえかよ。うひひ。\nこれは俺からの餞別だ。ほれ、くれてやる。", "1ポイントだよん♪あれ？もっと貰えると思った？", "甘えーーーんだよ！カス！俺はてめえの親じゃねーんだ！！\n貰えるだけありがたいと思いやがれ！うひゃーはっはっは。"],
        2 : ["俺と話をしてる暇があったら痴漢の技でも\n磨きやがれってんだ、このクソ野郎が。うひゃひゃ。", "てめえの顔なんて１秒も見たくねーからさっさと\n電車に乗ってこいや！二度とツラぁ見せるんじゃねーぞ！"],
        3 : ["おい、いいエロ話はねーのか？うひひ。\n今日の俺は非常にムラムラしてるんだ。", "オナネタになる話をしねーと、てめーのチンポ\nもぎとるからな！ひゃーはっはっは。"],
        4 : ["今日はサービスだ！てめえに500ポイントやるよ！\nそして店のもん全部タダで持っていけ！", "て嘘だよ！ばーーーーーーか！！！！！\nひゃーはっはっは！"],
        5 : ["どうだ？痴漢ライフには慣れたか？まあ俺のように\nなるにはまだまだだがな、ひひひ。", "せいぜい108犯の壁を越えてみやがれってんだ。\n超えたら俺様の熱烈なキッスをプレゼントするぜえ？\nうひひひひひひ。"],
    }

    const messageIdPool = {
        0: [0, 1],
        1: [0, 2],
        2: [0, 3],
        3: [0, 4],
        4: [0, 5]
    };

    const messageIdPool2 = {
        0: [0, 2],
        1: [0, 2],
        2: [0, 3],
        3: [0, 4],
        4: [0, 5]
    };

    window.テキスト表示 = async function() {
        MessageTNum = 0;

        if (!$gameSwitches.value(19)) {
            randomId = 100;
            $gameSwitches.setValue(19, true);
        } else {

            if ($gameSwitches.value(20)) {
                randomId = $gameVariables.value(41);
            } else {

                const n = $gameVariables.value(41);
                const pool = messageIdPool[n];
                randomId = pool[Math.floor(Math.random() * pool.length)];
            }
        }

        $gameVariables.setValue(3, randomId);
    };

    window.テキスト表示2 = async function() {
        MessageTNum = 0;

        const n = $gameVariables.value(41);
        const pool = messageIdPool2[n];
        const randomId = pool[Math.floor(Math.random() * pool.length)];
        $gameVariables.setValue(3, randomId);
    };

})();