//=============================================================================
// 100MainCall.js
//=============================================================================

/*:
 * @target MV
 * @plugindesc 保存データ
 * @help
 * 保存データに関する処理を行うサンプルです。
 * イベントシーンのコマンド
 * 
 * 
 * イベント一覧
 * 0  - 
 * 1  - 
 * 2  - 
 * 3  - 
 * 4  - 
 * 5  - 
 * 6  - 
 * 7  - 
 * 8  - 
 * 9  - 
 * 10 - 
 */

(() => {
    let KeyX = 0;
    let KeyY = 0;
    let MineSw = 61;
    TTM = "";
    const wait       = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    const MainKeyMapp = {
        0 : {0:["選択1","メイン帰宅","電車から降りてアジトへ帰ります。"],     1:["選択5","メイン図鑑","これまで痴漢してきた子を閲覧できます。"]},
        1 : {0:["選択2","メイン称号","現在取得している称号を確認します。"],     1:["選択6","メイン説明","痴漢のやり方を説明します。"]},
        2 : {0:["選択3","メインセーブ","ここまでのデータを記録します。"],   1:["選択7","メインロード","記録したデータから再開します。"]},
        3 : {0:["選択4","メインオプション","ゲームの音量などをできます。"],1:["選択8","メイン終了","ゲームを終了します。"]},
    }

    const MainMapp = {
        "noname" : ["000",""],
        "UIB1"   : ["選択1","メイン帰宅",[0,0],"電車から降りてアジトへ帰ります。"],
        "UIB2"   : ["選択2","メイン称号",[1,0],"現在取得している称号を確認します。"],
        "UIB3"   : ["選択3","メインセーブ",[2,0],"ここまでのデータを記録します。"],
        "UIB4"   : ["選択4","メインオプション",[3,0],"ゲームの音量などをできます。"],
        "UIB5"   : ["選択5","メイン図鑑",[0,1],"これまで痴漢してきた子を閲覧できます。"],
        "UIB6"   : ["選択6","メイン説明",[1,1],"痴漢のやり方を説明します。"],
        "UIB7"   : ["選択7","メインロード",[2,1],"記録したデータから再開します。"],
        "UIB8"   : ["選択8","メイン終了",[3,1],"ゲームを終了します。"],
    }

    const status = {
        //図鑑の登録人数
        0 : "初心者の痴漢",      //3人
        1 : "一人前の痴漢",      //10人
        2 : "痴漢のプロ",        //15人
        3 : "痴漢の帝王",        //20人
        4 : "痴漢師匠",          //25 - 30人
    };
    
	window.メイン呼び出し = async function() {
        $gameSwitches.setValue(4,true);
        KeyX = 0;
        KeyY = 0;
        
        $gameScreen.startFadeOut(30);
		await wait(30);

        SpineChoiceManager.show("メインUI");
        SpineChoiceManager.disableHit();
        アニメ更新 = [0,50,10,"選択1"];
        NrCustomMessage.create("電車から降りてアジトへ帰ります。");
        TTM = "電車から降りてアジトへ帰ります。";
        $gameVariables.setValue(42, status[$gameVariables.value(41)]);
        Dテキスト = [60, 43, 83, 255, "\\OW[0]\\C[15]\\f[b]\\v[42]", 50, "left"];

		$gameScreen.startFadeIn(30);
		await wait(30);
        $gameVariables.setValue(58,[KeyY,KeyX]);
        $gameSwitches.setValue(MineSw,true);
        $gameSwitches.setValue(4,false);
        $gameVariables.setValue(98, 0);
        SpineChoiceManager.restore();
	}

	window.メイン選択 = async function(Call) {
        var Anime  = MainMapp[Call][0];
        var Anime2 = MainMapp[Call][2];
        var MText  = MainMapp[Call][3];

        アニメ更新 = [0,50,10,Anime];
        if(Anime !== "000") {
            NrCustomMessage.setText(MText);
            TTM = MText;
            await wait(1);
            $gameVariables.setValue(58,Anime2);
        }
	}

    window.メインキー選択 = async function(Call) {
        var Valxy  = Call;

        if(Valxy === 0) {
            if(KeyX === 0) {
                KeyX = 3;
            } else {
                KeyX--;
            }
        } else if(Valxy === 1) {
            if(KeyY === 0) {
                KeyY = 1;
            } else {
                KeyY = 0;
            }
        } else if(Valxy === 2) {
            if(KeyY === 1) {
                KeyY = 0;
            } else {
                KeyY = 1;
            }
        } else if(Valxy === 3) {
            if(KeyX === 3) {
                KeyX = 0;
            } else {
                KeyX++;
            }
        }

        var Anime = MainKeyMapp[KeyX][KeyY];
        var MText  = Anime[2];
        アニメ更新 = [0,50,10,Anime[0]];
        NrCustomMessage.setText(MText);
        $gameVariables.setValue(58,[KeyY,KeyX]);
    }

    window.メイン実行 = async function(Call) {
        var Select = MainMapp[Call][1];
        if(window[Select]) {
            window[Select](Call);
        }
    }

    window.メインキー実行 = async function() {
        var xy = $gameVariables.value(58);
        if (!Array.isArray(xy) || xy.length !== 2) {
            console.warn("形式不正: 配列でない、または長さが2でない");
            return;
        }

        var x = xy[1];
        var y = xy[0];

        if (!MainKeyMapp[x] || !MainKeyMapp[x][y]) {
            console.warn("マップ未定義: 該当のMainKeyMapp[x][y]が存在しない");
            return;
        }

        var Select = MainKeyMapp[x][y][1];

        if (window[Select]) {
            window[Select]([x, y]);
        } else {
            console.warn("関数未定義:", Select);
        }
    };

    window.メイン帰宅 = async function() {
        NrCustomMessage.destroy();
        $gameSwitches.setValue(4,true);
        SpineChoiceManager.disableHit();
        const choices = ["はい", "いいえ"];
        const message = "アジトへ帰りますか？";
        await $gameMessage.setChoices(choices, 0, -1);
        await $gameMessage.setChoiceCallback(async function(choiceIndex) {
            if (choiceIndex === 0) {
                停止("BGM");
                停止("BGS");
                $gameSwitches.setValue(6, false);
                $gameSelfSwitches.setValue([7, 1, 'A'], false);
                $gameSelfSwitches.setValue([7, 1, 'B'], false);
                await $gameScreen.startFadeOut(30);
                await new Promise(r => setTimeout(r, 500));
                $gameSwitches.setValue(MineSw,false);
                $gameSwitches.setValue(3,false);
                $gameSwitches.setValue(4,false);
                P消去 = [1,2,4];
                P消去 = [0,50];
                P消去 = [0,60];
                NrCustomMessage.destroy();
                $gamePlayer.reserveTransfer(7, 1, 1, 2, 0);
            } else {
                await $gameSwitches.setValue(4,false);
                await SpineChoiceManager.restore();
                await NrCustomMessage.create(TTM);
            }
        });
        $gameMessage.add(message);
    }

    window.メイン図鑑 = async function(Call) {
        SpineChoiceManager.disableHit();
        NrCustomMessage.destroy();
        キャラクター図鑑();
    }

    window.メイン称号 = async function(Call) {
        NrCustomMessage.destroy();
        称号呼び出し();
    }

    window.メイン説明 = async function(Call) {
        SpineChoiceManager.disableHit();
        NrCustomMessage.destroy();
        操作説明();
    }

    window.メインセーブ = async function(Call) {
        NrCustomMessage.destroy();
        $gameSwitches.setValue(4, true);
        const savedXY = $gameVariables.value(58);
        await SceneManager.push(Scene_Save);
        await wait(1);
        while (SceneManager._scene.constructor.name === "Scene_Save") await wait(1);
        await SpineChoiceManager.restore();
        $gameSwitches.setValue(4, false);
        await wait(5);
        await NrCustomMessage.create(TTM);
        await $gameVariables.setValue(58, savedXY);
    };

    window.メインロード = async function(Call) {
        NrCustomMessage.destroy();
        const savedXY = $gameVariables.value(58);
        await SceneManager.push(Scene_Load);
        await wait(1);
        while (SceneManager._scene.constructor.name === "Scene_Load") await wait(1);
        await SpineChoiceManager.restore();
        await wait(5);
        await NrCustomMessage.create(TTM);
        await $gameVariables.setValue(58, savedXY);
    };

    window.メインオプション = async function(Call) {
        NrCustomMessage.destroy();
        const savedXY = $gameVariables.value(58);
        await SceneManager.push(Scene_Options);
        await wait(1);
        while (SceneManager._scene.constructor.name === "Scene_Options") await wait(1);
        await SpineChoiceManager.restore();
        await wait(5);
        await NrCustomMessage.create(TTM);
        await $gameVariables.setValue(58, savedXY);
    };

    window.メイン終了 = async function(Call) {
        NrCustomMessage.destroy();
        const choices = ["はい", "いいえ"];
        const message = "本当に終了しますか？";
        $gameMessage.setChoices(choices, 0, -1);
        $gameMessage.setChoiceCallback(function(choiceIndex) {
            if (choiceIndex === 0) {
                SceneManager.exit();
            } else {
                SpineChoiceManager.restore();
            }
        });
        $gameMessage.add(message);
    }

    window.メインメニュー終了 = async function() {
        停止("BGM");
        NrCustomMessage.destroy();
        $gameSwitches.setValue(4,true);
        $gameScreen.startFadeOut(30);
		await wait(30);

        SpineChoiceManager.cancel();
        P消去 = [0,50];
        P消去 = [0,60];
        $gameSwitches.setValue(MineSw,false);

		$gameScreen.startFadeIn(30);
        await wait(15);
        $gameSwitches.setValue(2,false);
		await wait(15);
        $gameSwitches.setValue(4,false);
        CallBgm("In a rental car");
    }

    window.メインメニュー終了2 = async function() {
        $gameSwitches.setValue(2, false);
        $gameSwitches.setValue(6, false);
        $gameVariables.setValue(98, 100);
        停止("BGM");
        $gameSelfSwitches.setValue([7, 1, 'A'], false);
        $gameSelfSwitches.setValue([7, 1, 'B'], false);
        await $gameScreen.startFadeOut(30);
        await new Promise(r => setTimeout(r, 500));
        SpineChoiceManager.forceFinishById("駅選択");
        P消去 = [1,1,99];
        $gameSwitches.setValue(MineSw,false);
        $gameSwitches.setValue(3,false);
        $gameSwitches.setValue(4,false);
        NrCustomMessage.destroy();
        $gamePlayer.reserveTransfer(7, 1, 1, 2, 0);
    }

    window.在庫確認 = async function() {
        const START_ID = 1;
        const END_ID = 6;

        for (let itemId = START_ID; itemId <= END_ID; itemId++) {
            const item = $dataItems[itemId];
            const amountOwned = $gameParty.numItems(item);
            const stockLeft = StockLimitShop.getStock(0, itemId); // 0 = item type

            if (amountOwned === 0 && stockLeft === 0) {
                StockLimitShop.resetItem(itemId);
            }
        }
    };


    window.操作説明 = async function() {
        ctrlVar = 1;
        
        $gameSwitches.setValue(4, true);
        if(!$gameSwitches.value(9)) {
            savedXY = $gameVariables.value(58);
            NrCustomMessage.destroy();
        }

        停止("BGM");
        $gameScreen.startFadeOut(30);
        await wait(30);

        Spine = "説明";
        アニメ更新 = [0,100,0,"1"];
        $gameVariables.setValue(2, ctrlVar);
        Dテキスト = [101, 670, 557, 255, "\\v[2]/3", 25, "right"];

        await wait(30);
        $gameScreen.startFadeIn(30);
        await wait(30);
        CallBgm("What do you make");
        $gameSwitches.setValue(21, true);
        $gameSwitches.setValue(4, false);
    }

    window.説明進行 = async function() {
        ctrlVar++;

        if(ctrlVar === 4) {
            ctrlVar = 1;
        }

        $gameVariables.setValue(2, ctrlVar);
        var Anime = "" + ctrlVar;
        アニメ更新 = [0,100,0,Anime];
        CallSe("決定");
    }

    window.説明閉じる = async function() {
        const savedXY = $gameVariables.value(58);
        $gameVariables.setValue(98, 100);
        $gameSwitches.setValue(4, true);
        $gameSwitches.setValue(21, false);

        $gameScreen.startFadeOut(30);
        await wait(30);

        P消去 = [1,100,101];

        if(!$gameSwitches.value(9)) {
            await wait(30);
            $gameScreen.startFadeIn(30);
            await wait(30);
            await SpineChoiceManager.restore();
            await wait(5);
            $gameVariables.setValue(58, savedXY);
            NrCustomMessage.create(TTM);
        } else {
            $gameTemp.reserveCommonEvent(25);
        }
    }
})();