//=============================================================================
// 100StCall.js
//=============================================================================

/*:
 * @target MV
 * @plugindesc 保存データ
 * @help
 * 保存データに関する処理を行うサンプルです。
 * イベントシーンのコマンド
 * 
 * 
 * イベント一覧
 * 0  - 待機
 * 1  - 駅
 * 2  - 
 * 3  - 
 * 4  - 
 * 5  - 
 * 6  - 
 * 7  - 
 * 8  - 
 * 9  - 
 * 10 - 選択
 */

(() => {
    Stpic = 50;
    StTPic = 51;
    StNumCall = [0,2,1];
    StNum = 0;
    StationName  = ["夢精駅","射精駅","珍古仏頭井駅","漫個美所濡駅","節句巣台隙駅"];
    StationCall  = 0;
    StationCallM = 0;
    StationRegion = [1,3,2,4,5];
    const wait       = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    const StMainMapp = {
        "noname" : ["000",""],
        "Sa1"   : ["選択1",0],
        "Sa2"   : ["選択2",1],
        "Sa3"   : ["選択3",2],
    }

    const StNumMapp = {
        0   : ["選択1",0],
        1   : ["選択2",1],
        2   : ["選択3",2],
    }

    StMainText = {
        0 : "無人駅。人通りは少なく痴漢には最適。\n しかし、一両編成しかないため痴漢をするには\n 人が少ないかもしれない。",
        1 : "射精駅。人通りは夢精駅よりは多いが、\n それでも痴漢をするには物足りないかも。",
        2 : "なかなかにとかいな駅。電車は三両編成しかな\n いが、痴漢し甲斐がありそうな駅。",
        3 : "四両編成の電車で痴漢をするには最適。\n 複数の獲物がいそうで大興奮できそう。",
        4 : "五両編成と広い範囲で痴漢ができそうな\n 電車。様々な獲物がおり、痴漢ライフの執着\n 駅となりそう。",
    }

	window.駅選択呼び出し = async function() {
        StNum = 2;
        StationCall = 0;

        停止("BGM");
        $gameScreen.startFadeOut(30);
		await wait(30);

        SpineChoiceManager.show("駅選択");
        $gameScreen.dTextRealTime = true;
        $gameScreen.setDTextPicture(" \\OW[0]\\C[15]\\v[80] ", 35);
        $gameScreen.showPicture(StTPic, '', 0, 8, 415, 100, 100, 255, 0);
        var Text  = StMainText[StationCall];
        $gameVariables.setValue(80, Text);

        SpineChoiceManager.disableHit();
        await wait(4);

        if($gameVariables.value(41) > 0) {
            アニメ更新 = [0,Stpic,0,"待機2"];
        } else {
            アニメ更新 = [0,Stpic,0,"待機1"];
        }
        アニメ更新 = [0,Stpic,1,"1"];
        アニメ更新 = [0,Stpic,10,"選択3"];
        駅レベル();

        await wait(30);
        $gameScreen.startFadeIn(30);
        CallBgm("5 cm above ground");
		await wait(30);
        SpineChoiceManager.restore();
    }

	window.駅レベル = async function() {
        StationCallM = $gameVariables.value(41);
    }

	window.駅選択 = async function(Call) {
        var Anime = StMainMapp[Call];

        StNum     = Anime[1];
        if(Call === "Sa3") {
            var TextVal = StationCall + 1;
            Anime = "駅" + TextVal + "マウスオン";
            アニメ更新2 = [0,50,10,Anime];
        } else {
            アニメ更新 = [0,50,10,Anime[0]];
        }
    }

	window.駅選択実行 = async function(Call) {
        var Call = StMainMapp[Call][1];

        if(Call === 0) {
            駅選択左();
        } else if(Call === 1) {
            駅選択右();
        } else if(Call === 2) {
            電車移動();
        }
    }

	window.駅選択左 = async function() {
        var Call = StationCall - 1;
        if(0 > Call) {
            Call = StationCallM;
        }

        StationCall = Call;

        var Anime = "" + (StationCall + 1);
        var Text  = StMainText[StationCall];
        var TextVal = StationCall + 1;
        var Anime2 = "駅" + TextVal + "マウスオン";

        アニメ更新2 = [0,Stpic,10,Anime2];
        アニメ更新  = [0,Stpic,1,Anime];
        $gameVariables.setValue(80, Text);

        await wait(1);
        await SpineChoiceManager.restore();
    }

	window.駅選択右 = async function() {
        var Call = StationCall + 1;
        if(Call > StationCallM) {
            Call = 0;
        }

        StationCall = Call;

        var Anime = "" + (StationCall + 1);
        var Text  = StMainText[StationCall];
        var TextVal = StationCall + 1;
        var Anime2 = "駅" + TextVal + "マウスオン";

        アニメ更新2 = [0,Stpic,10,Anime2];
        アニメ更新 = [0,Stpic,1,Anime];
        $gameVariables.setValue(80, Text);

        await wait(1);
        await SpineChoiceManager.restore();
    }

	window.駅キー実行 = async function(Call) {
        //0:左,1:右,2:ok

        if(Call === 0) {
            if(StationCallM === 0) return;
            CallSe("cursor15_a");
            駅選択実行("Sa1");
        } else if(Call === 1) {
            if(StationCallM === 0) return;
            CallSe("cursor15_a");
            駅選択実行("Sa2");
        } else if(Call === 2) {
            駅選択実行("Sa3");
        }
    }

	window.電車移動 = async function() {
        SpineChoiceManager.disableHit();
        const choices = ["乗車", "やめる"];
        const message = StationName[StationCall] + "から乗車しますか？";
        var Tt = $gameVariables.value(80);
        $gameVariables.setValue(80, message);
        await $gameMessage.setChoices(choices, 0, -1);
        await $gameMessage.setChoiceCallback(async function(choiceIndex) {
            if (choiceIndex === 0) {
                停止("BGM");
                ランダムエンカウント();
                await $gameScreen.startFadeOut(30);
                await new Promise(r => setTimeout(r, 500));
                P消去 = [1,1,51];
                $gamePlayer.reserveTransfer(StationRegion[StationCall], 2, 7, 2, 0);
                await wait(60);
                await 電車実行();
                await wait(5);
                await $gameScreen.startFadeIn(30);
                await $gameSwitches.setValue(6, true);
                await $gameSwitches.setValue(2,false);
                await $gameSwitches.setValue(3,true);
                await $gameSwitches.setValue(9, false);
                await CallBgm("In a rental car");
            } else {
                $gameVariables.setValue(80, Tt);
                await SpineChoiceManager.restore();
            }
        });
        //$gameMessage.add(message);
    }

	window.選択戻る = async function() {
        $gameSwitches.setValue(2, false);
        $gameVariables.setValue(98, 100);
        停止("BGM");
        $gameSelfSwitches.setValue([7, 1, 'A'], false);
        $gameSelfSwitches.setValue([7, 1, 'B'], false);
        await $gameScreen.startFadeOut(30);
        await new Promise(r => setTimeout(r, 500));
        SpineChoiceManager.forceFinishById("駅選択");
        P消去 = [1,1,51];
        $gameSwitches.setValue(MineSw,false);
        $gameSwitches.setValue(3,false);
        $gameSwitches.setValue(4,false);
        P消去 = [0,50];
        P消去 = [0,60];
        NrCustomMessage.destroy();
        $gamePlayer.reserveTransfer(7, 1, 1, 2, 0);
    }

    window.ランダムエンカウント = function() {
        let rate = 0;

        switch (StationCall) {
            case 0:
                rate = 25 + Math.floor(Math.random() * 6);
                $gameVariables.setValue(99, 0);
                break;
            case 1:
                rate = 20 + Math.floor(Math.random() * 6);
                $gameVariables.setValue(99, 1);
                break;
            case 2:
                rate = 15 + Math.floor(Math.random() * 6);
                $gameVariables.setValue(99, 2);
                break;
            case 3:
                rate = 10 + Math.floor(Math.random() * 6);
                $gameVariables.setValue(99, 3);
                break;
            case 4:
                rate = 5 + Math.floor(Math.random() * 6);
                $gameVariables.setValue(99, 4);
                break;
            default:
                rate = 0;
                break;
        }

        $gameVariables.setValue(19, rate);
    }

    window.電車実行 = async function() {
        Spine = "電車";

        let maxTime = 0;
        switch (StationCall) {
            case 0:
                maxTime = 18000;
                break;
            case 1:
                maxTime = 24000;
                break;
            case 2:
                maxTime = 36000;
                break;
            case 3:
                maxTime = 48000;
                break;
            case 4:
                maxTime = 75000;
                break;
            default:
                maxTime = 0;
                break;
        }

        $gameVariables.setValue(18, maxTime);
        $gameVariables.setValue(17, 0);
        var v18 = $gameVariables.value(18);
        var v17 = $gameVariables.value(17);
        var remainTime = Math.ceil(((v18 - v17) / 100) / 60);
        $gameVariables.setValue(16, remainTime);


        アニメ更新 = [0,2,0,"待機1"];
        アニメ更新 = [0,2,1,"1"];
        Dテキスト = [3, 20, 20, 255, "\\OW[0]\\C[0]次の駅まであと　\\v[16]分", 15, "left"];
        Dテキスト = [4, 20, 454, 0, "\\OW[0]\\C[0]次の駅まであと　\\v[16]分", 15, "left"];
        $gameSwitches.setValue(6, true);
        NrSpineGage.forceUpdate("電車");
        電車進行();

        await wait(5);
    }

    window.電車進行 = async function() {
        if($gameSwitches.value(81)) {
            //痴漢中
            var Plus = 10;
        } else {
            //移動中
            var Plus = 25;
        }

        var Val  = $gameVariables.value(17) + Plus;
        $gameVariables.setValue(17, Val);
        var v18 = $gameVariables.value(18);
        var v17 = $gameVariables.value(17);
        var remainTime = Math.ceil(((v18 - v17) / 50) / 60);
        $gameVariables.setValue(16, remainTime);
    }

    const _Game_Player_updateMove = Game_Player.prototype.updateMove;
    Game_Player.prototype.updateMove = function() {
        const wasMoving = this.isMoving();
        _Game_Player_updateMove.call(this);

        // 移動が完了した瞬間に処理を実行
        if (wasMoving && !this.isMoving() && $gameSwitches.value(3)) {
            電車進行();
        }
    };

    window.駅到着 = async function() {
        停止("SE");
        停止("BGM");
        停止("BGS");
        $gameSwitches.setValue(6, false);

        $gameVariables.setValue(98, 100);
        if ($gameSwitches.value(81)) {
            window._痴漢入力中 = false;
            $gameSwitches.setValue(81, false);
            $gameSwitches.setValue(61, false);
            痴漢コマンドリセット();
            ChikanSw  = false;
            ChikanSw2 = false;
            $gameSwitches.setValue(14, false);
            for (var i = 10; i <= 20; i++) {
                $gameScreen.spine(i).setTrackTimeScale(0, 0);
            }
            if($gameScreen.picture(21)) {
                $gameScreen.spine(21).setTrackTimeScale(0, 0);
            }            

            $gameScreen.startFadeOut(30);
            await wait(30);

            $gameSwitches.setValue(14, false);
        } else {
            $gameSwitches.setValue(2, true);
            $gameScreen.startFadeOut(30);
            await wait(30);
        }
        P消去 = [1, 1, 100];

        const message = "電車は次の駅に到着しました。\nお気をつけてお降りください。";
        $gameMessage.add(message);
        await new Promise(resolve => {
            const interval = setInterval(() => {
                if (!$gameMessage.isBusy()) {
                    clearInterval(interval);
                    resolve();
                }
            }, 10);
        });

        $gameSelfSwitches.setValue([7, 1, 'A'], false);
        $gameSelfSwitches.setValue([7, 1, 'B'], false);
        $gameSwitches.setValue(2, false);
        $gameSwitches.setValue(3, false);
        $gameSwitches.setValue(4, false);
        $gamePlayer.reserveTransfer(7, 1, 1, 2, 0);
    };

})();